/**
 * Simplified pattern utilities for MVP
 */

/**
 * Simple pattern detection for MVP
 * Returns true if patterns are available (we always have 2 basic patterns)
 */
export function useSimpleBlockPatterns(clientId, attributes) {
	// For MVP, we always have 2 basic patterns available
	return [
		{
			id: 'layout-2-basic',
			title: 'Layout 2 - Basic Cards',
			description: 'Display users in a card layout with avatar, name, and bio.',
		},
		{
			id: 'layout-1-basic',
			title: 'Layout 1 - Basic List',
			description: 'Display users in a simple list format.',
		}
	];
}

/**
 * Simple block name for patterns
 */
export function useSimpleBlockNameForPatterns(clientId, attributes) {
	return 'wpuf-ud/directory';
}

/**
 * Simple pattern transformation
 */
export function getSimpleTransformedBlocksFromPattern(blocks, attributes) {
	return {
		newBlocks: blocks,
		queryClientIds: [attributes.clientId]
	};
} 