import {__} from '@wordpress/i18n';

const Empty = ({ onCreateNew, title, description, buttonText, onButtonClick, type = 'default' }) => {
    // If type is 'not-found', show a simple message without button
    if (type === 'not-found') {
        return (
            <div className="wpuf-w-full wpuf-flex wpuf-flex-col wpuf-justify-center wpuf-items-center wpuf-h-[calc(100vh-12rem)]">
                <div className="wpuf-w-1/2 wpuf-text-center">
                    <h1 className="wpuf-text-lg wpuf-font-semibold wpuf-font-gray-800">{title || __('No Items Here!', 'wpuf-pro')}</h1>
                    {description && <p className="wpuf-mt-4 wpuf-text-sm wpuf-font-normal wpuf-color-gray-500">{description}</p>}
                </div>
            </div>
        );
    }

    // Default state with images and button (for All tab)
    return (
        <div className="wpuf-w-full wpuf-flex wpuf-flex-col wpuf-justify-center wpuf-items-center wpuf-h-[calc(100vh-12rem)]">
            <div className="wpuf-w-1/2 wpuf-text-center">
                <div className="wpuf-flex wpuf-justify-center wpuf-items-end wpuf-mb-8">
                    <img
                        src={wpuf_ud.asset_url + '/images/thumb-male-1.svg'}
                        alt="WPUF Icon"
                        className="wpuf-w-20 wpuf-h-20"
                    />
                    <img
                        src={wpuf_ud.asset_url + '/images/thumb-male-2.svg'}
                        alt="WPUF Icon"
                        className="wpuf-w-28 wpuf-mx-3"
                    />
                    <img
                        src={wpuf_ud.asset_url + '/images/thumb-male-3.svg'}
                        alt="WPUF Icon"
                        className="wpuf-w-20 wpuf-h-20"
                    />
                </div>
                <h1 className="wpuf-text-lg wpuf-font-semibold wpuf-font-gray-800">{title || __('No directories added yet', 'wpuf-pro')}</h1>
                <p className="wpuf-mt-4 wpuf-text-sm wpuf-font-normal wpuf-color-gray-500">{description || __('Create directories to organize users and manage access.', 'wpuf-pro')}</p>
            </div>
            {(onCreateNew || onButtonClick) && (
                <div className="wpuf-mt-8">
                    <button
                        onClick={onButtonClick || onCreateNew}
                        className="wpuf-btn-primary wpuf-flex">
                        <svg width="20" height="21" viewBox="0 0 20 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M10 5.79321V10.7932M10 10.7932V15.7932M10 10.7932H15M10 10.7932L5 10.7932"
                                  stroke="white" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
                        </svg>
                        <span className="wpuf-ml-2">
                                {buttonText || __('Add New Directory', 'wpuf-pro')}
                            </span>
                    </button>
                </div>
            )}
            <div className="wpuf-mt-7">
                <a
                    href="https://wedevs.com/docs/wp-user-frontend-pro/modules/user-listing-profile/?utm_source=wpuf-ud&utm_medium=wpuf-ud-docs"
                    target="_blank"
                    rel="noopener noreferrer"
                    className="wpuf-flex wpuf-items-center">
                        <span className="wpuf-mr-2 wpuf-text-base wpuf-font-semibold wpuf-text-gray-700">
                            {__('Docs', 'wpuf-pro')}
                        </span>
                    <svg width="20" height="21" viewBox="0 0 20 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M11.25 4.54321L17.5 10.7932M17.5 10.7932L11.25 17.0432M17.5 10.7932H2.5" stroke="#4B5563" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
                    </svg>
                </a>
            </div>
        </div>
    );
}

export default Empty;
