/**
 * WPUF Cover Photo Upload with Cropper.js
 * Uses the generalized profile image upload class
 *
 * @since 4.2.3
 */

(function($) {
    'use strict';

    // Create cover photo upload instance using base class
    // Get nonce from localized script (cover photo uses separate variable)
    const getCoverPhotoNonce = function() {
        return typeof wpuf_ud_cover_photo !== 'undefined' ? wpuf_ud_cover_photo.nonce : '';
    };

    const coverPhotoConfig = {
        type: 'cover-photo',
        aspectRatio: 16 / 9,
        croppedSize: { width: 1920, height: 600 },
        modalTitle: 'Upload Cover Photo',
        fileInputName: 'cover_photo',
        ajaxAction: 'wpuf_upload_cover_photo',
        updateSelector: '.wpuf-cover-photo__image',
        nonceName: 'nonce',
        maxSize: 10 * 1024 * 1024, // 10MB
        prefix: 'wpuf-cover-photo'
    };

    // Initialize when document is ready (after base class is loaded)
    $(document).ready(function() {
        // Ensure base class is loaded
        if (typeof WPUFProfileImageUpload === 'undefined') {
            console.error('WPUFProfileImageUpload base class not found. Make sure profile-image-upload.js is loaded first.');
            return;
        }

        // Set nonce from localized script now that it's available
        coverPhotoConfig.nonce = getCoverPhotoNonce();

        // Initialize cover photo upload instance
        window.wpufCoverPhotoUpload = new WPUFProfileImageUpload(coverPhotoConfig);
    });

    // Global function for opening upload modal
    window.wpufOpenCoverPhotoUpload = function(userId) {
        // If base class not ready, wait for it
        if (typeof WPUFProfileImageUpload === 'undefined') {
            // Wait a bit for scripts to load
            setTimeout(function() {
                if (typeof WPUFProfileImageUpload === 'undefined') {
                    console.error('WPUFProfileImageUpload base class not found. Make sure profile-image-upload.js is loaded first.');
                    return;
                }
                window.wpufOpenCoverPhotoUpload(userId);
            }, 100);
            return;
        }

        // Initialize if not already done
        if (!window.wpufCoverPhotoUpload) {
            // Update nonce before creating instance
            coverPhotoConfig.nonce = getCoverPhotoNonce();
            window.wpufCoverPhotoUpload = new WPUFProfileImageUpload(coverPhotoConfig);
        }

        // Open modal
        if (window.wpufCoverPhotoUpload) {
            window.wpufCoverPhotoUpload.openModal(userId);
        }
    };

})(jQuery);

