<?php
/**
 * Block template for user directory layout-2 (card style)
 *
 * Available variables:
 *
 * @since 4.2.0
 * @var array  $attributes Block attributes
 * @var array  $pagination Pagination data
 * @var string $layout     Layout name
 * @var string $context    Rendering context ('block' or 'shortcode')
 *
 * @var array  $users      Array of WP_User objects
 */
// Ensure we have the required variables
$users      = $users ?? [];
$attributes = $attributes ?? [];
$pagination = $pagination ?? [];
$layout     = $layout ?? 'layout-2';
$context    = $context ?? 'block';

// Extract block-specific attributes
$enable_search      = $attributes['enable_search'] ?? true;
$search_placeholder = $attributes['search_placeholder'] ?? __( 'Search Users', 'wpuf-pro' );
$block_id           = $attributes['blockId'] ?? uniqid( 'wpuf-ud-' );
$page_id            = get_the_ID();


?>

<div class="wpuf-user-listing" data-block-id="<?php echo esc_attr( $block_id ); ?>"
     data-page-id="<?php echo esc_attr( $page_id ); ?>" data-layout="<?php echo esc_attr( $layout ); ?>">

    <ul class="wp-block-post-template is-layout-grid columns-3 wpuf-ud-list wpuf-ud-list-layout-2 wpuf-flow-root">
        <?php if ( ! empty( $users ) ): ?>
            <?php foreach ( $users as $user ): ?>
                <li class="wpuf-user-card">
                    <div class="wpuf-flex wpuf-flex-col wpuf-gap-6 xl:wpuf-flex-row">
                        <div>
                            <?php
                            // Get avatar with larger size for card layout
                            $avatar_size = $attributes['avatarSize'] ?? 256;
                            $avatar_args = [
                                'class' => 'aspect-4/5 wpuf-w-52 wpuf-flex-none wpuf-rounded-2xl wpuf-object-cover',
                            ];
                            $avatar = get_avatar( $user->user_email, $avatar_size, '', $user->display_name, $avatar_args );
                            echo $avatar;
                            ?>
                        </div>

                        <div class="wpuf-flex-auto">
                            <h3 class="text-lg/8 wpuf-font-semibold wpuf-tracking-tight wpuf-text-gray-900">
                                <?php echo esc_html( $user->display_name ); ?>
                            </h3>

                            <p class="text-base/7 wpuf-text-gray-600">
                                <?php echo esc_html( $user->user_login ); ?>
                            </p>

                            <?php if ( ! empty( $user->user_email ) ): ?>
                                <p class="wpuf-mt-6 text-base/7 wpuf-text-gray-600">
                                    <a href="mailto:<?php echo esc_attr( $user->user_email ); ?>"
                                       target="_blank" rel="noopener"
                                       class="wpuf-text-primary hover:wpuf-text-primaryHover">
                                        <?php echo esc_html( $user->user_email ); ?>
                                    </a>
                                </p>
                            <?php endif; ?>

                            <?php
                            $user_bio = get_user_meta( $user->ID, 'description', true );
                            if ( ! empty( $user_bio ) ):
                            ?>
                                <p class="wpuf-mt-6 text-base/7 wpuf-text-gray-600">
                                    <?php echo esc_html( wp_trim_words( $user_bio, 25, '...' ) ); ?>
                                </p>
                            <?php endif; ?>

                            <div class="wpuf-mt-4">
                                <?php
                                // Generate profile URL using pretty URL style
                                $profile_url = '#';
                                if ( ! empty( $profile_url_helper ) && is_callable( $profile_url_helper ) ) {
                                    $profile_url = call_user_func( $profile_url_helper, $user, 'username', $all_data );
                                } else {
                                    $profile_url = wpuf_ud_get_profile_url( $user, $all_data );
                                }
                                ?>
                                <a href="<?php echo esc_url( $profile_url ); ?>"
                                   class="wpuf-btn-primary wpuf-no-underline wpuf-inline-flex wpuf-items-center wpuf-px-4 wpuf-py-2 wpuf-text-sm wpuf-font-medium wpuf-rounded-md">
                                    <?php esc_html_e( 'View Profile', 'wpuf-pro' ); ?>
                                    <span class="wpuf-sr-only">, <?php echo esc_html( $user->display_name ); ?></span>
                                </a>
                            </div>
                        </div>
                    </div>
                </li>
            <?php endforeach; ?>
        <?php else: ?>
            <li class="wpuf-px-6 wpuf-py-24 sm:wpuf-px-6 sm:wpuf-py-32 lg:wpuf-px-8">
                <div class="wpuf-mx-auto wpuf-max-w-2xl wpuf-text-center">
                    <h2 class="text-balance wpuf-text-4xl wpuf-font-semibold wpuf-tracking-tight wpuf-text-gray-900 sm:wpuf-text-5xl">
                        <?php esc_html_e( 'No users found.', 'wpuf-pro' ); ?>
                    </h2>
                </div>
            </li>
        <?php endif; ?>
    </ul>

    <?php if ( ! empty( $pagination ) && $pagination['total_pages'] > 1 ): ?>
        <div class="wpuf-ud-pagination">
            <div class="wpuf-pagination-placeholder">Pagination functionality removed</div>
        </div>
    <?php endif; ?>
</div>
