<?php
/**
 * Sort and Filter Fields Template Part
 *
 * This template renders the sorting and filtering controls for user directory
 * Including: Search By, Sort By, ASC/DESC, and Reset button
 *
 * @since 4.2.0
 */

// Get context and data
$sort_context = isset( $sort_context ) ? $sort_context : 'shortcode';
$block_id = isset( $block_id ) ? $block_id : 'wpuf-directory-' . uniqid();
$page_id = isset( $page_id ) ? $page_id : get_the_ID();

// Get sorting options from data
$orderby = ! empty( $all_data['orderby'] ) ? $all_data['orderby'] : 'id';
$order = ! empty( $all_data['order'] ) ? $all_data['order'] : 'desc';
$enable_frontend_sorting = ! empty( $all_data['enable_frontend_sorting'] ) ? $all_data['enable_frontend_sorting'] : true;

// Get directory ID for dynamic fields
$directory_id = ! empty( $all_data['directory_id'] ) ? $all_data['directory_id'] : null;

// Get available search and sort fields based on directory settings
$available_fields = [];
if ( $directory_id && class_exists( '\WPUF\UserDirectory\ShortCode' ) ) {
    $shortcode_instance = new \WPUF\UserDirectory\ShortCode();
    $available_fields = $shortcode_instance->get_available_fields_for_directory( $directory_id );
}

// Get current search_by parameter from URL
$current_search_by = ! empty( $_GET['search_by'] ) ? sanitize_text_field( $_GET['search_by'] ) : '';

// Get layout-specific colors
$layout = isset( $layout ) ? $layout : 'layout-1';

// Get layout colors
$colors = wpuf_ud_get_layout_colors( $layout );

// Shortcode context - use shortcode-specific template
?>

<!-- Filter Controls -->
<div class="wpuf-filter-controls !wpuf-flex !wpuf-flex-col md:!wpuf-flex-row !wpuf-items-stretch md:!wpuf-items-center !wpuf-gap-2 md:!wpuf-gap-3 !wpuf-w-full md:!wpuf-w-auto">

    <!-- Sort By Dropdown -->
    <div class="wpuf-sort-by-control !wpuf-w-full md:!wpuf-w-auto">
        <select class="wpuf-ud-sort-by !wpuf-w-full md:!wpuf-w-[140px] !wpuf-h-[42px] !wpuf-pr-10 !wpuf-pl-4 !wpuf-py-2 !wpuf-bg-white !wpuf-border !wpuf-border-gray-300 !wpuf-rounded-md !wpuf-text-sm !wpuf-appearance-none !wpuf-bg-[url('data:image/svg+xml;charset=US-ASCII,%3Csvg%20width%3D%2714%27%20height%3D%278%27%20viewBox%3D%270%200%2014%208%27%20xmlns%3D%27http%3A//www.w3.org/2000/svg%27%3E%3Cpath%20d%3D%27M1%201l6%206%206-6%27%20stroke%3D%27%239CA3AF%27%20stroke-width%3D%272%27%20fill%3D%27none%27%20fill-rule%3D%27evenodd%27/%3E%3C/svg%3E')] !wpuf-bg-[position:right_0.75rem_center] !wpuf-bg-[size:14px] !wpuf-bg-no-repeat focus:!wpuf-outline-none focus:!wpuf-ring-2 <?php echo esc_attr( $colors['focus_ring_primary_500'] ); ?>"
                data-block-id="<?php echo esc_attr( $block_id ); ?>"
                data-page-id="<?php echo esc_attr( $page_id ); ?>"
                data-default-value="<?php echo esc_attr( $orderby ); ?>">
            <?php
            // Only show placeholder option if no default is set
            if ( empty( $orderby ) ) : ?>
                <option value=""><?php esc_html_e('Sort By', 'wpuf-pro'); ?></option>
            <?php endif; ?>

            <?php if ( ! empty( $available_fields['core_fields']['order_fields'] ) ) : ?>
                <?php foreach ( $available_fields['core_fields']['order_fields'] as $field ) : ?>
                    <option value="<?php echo esc_attr( $field['value'] ); ?>" <?php selected( $orderby, $field['value'] ); ?>>
                        <?php echo esc_html( $field['label'] ); ?>
                    </option>
                <?php endforeach; ?>
            <?php else : ?>
                <!-- Fallback core fields if dynamic loading fails -->
                <option value="id" <?php selected( $orderby, 'id' ); ?>><?php esc_html_e('User ID', 'wpuf-pro'); ?></option>
                <option value="username" <?php selected( $orderby, 'username' ); ?>><?php esc_html_e('Username', 'wpuf-pro'); ?></option>
                <option value="email" <?php selected( $orderby, 'email' ); ?>><?php esc_html_e('Email', 'wpuf-pro'); ?></option>
                <option value="display_name" <?php selected( $orderby, 'display_name' ); ?>><?php esc_html_e('Display Name', 'wpuf-pro'); ?></option>
                <option value="user_registered" <?php selected( $orderby, 'user_registered' ); ?>><?php esc_html_e('Registration Date', 'wpuf-pro'); ?></option>
            <?php endif; ?>

            <?php if ( ! empty( $available_fields['meta_fields'] ) ) : ?>
                <optgroup label="<?php esc_attr_e('Custom Fields', 'wpuf-pro'); ?>">
                    <?php foreach ( $available_fields['meta_fields'] as $meta_field ) : ?>
                        <option value="<?php echo esc_attr( $meta_field['value'] ); ?>" <?php selected( $orderby, $meta_field['value'] ); ?>>
                            <?php echo esc_html( $meta_field['label'] ); ?>
                        </option>
                    <?php endforeach; ?>
                </optgroup>
            <?php endif; ?>
        </select>
    </div>

    <!-- Sort Order (ASC/DESC) -->
    <div class="wpuf-sort-order-control !wpuf-w-full md:!wpuf-w-auto">
        <select class="wpuf-ud-sort-order !wpuf-w-full md:!wpuf-w-[100px] !wpuf-h-[42px] !wpuf-pr-10 !wpuf-pl-4 !wpuf-py-2 !wpuf-bg-white !wpuf-border !wpuf-border-gray-300 !wpuf-rounded-md !wpuf-text-sm !wpuf-appearance-none !wpuf-bg-[url('data:image/svg+xml;charset=US-ASCII,%3Csvg%20width%3D%2714%27%20height%3D%278%27%20viewBox%3D%270%200%2014%208%27%20xmlns%3D%27http%3A//www.w3.org/2000/svg%27%3E%3Cpath%20d%3D%27M1%201l6%206%206-6%27%20stroke%3D%27%239CA3AF%27%20stroke-width%3D%272%27%20fill%3D%27none%27%20fill-rule%3D%27evenodd%27/%3E%3C/svg%3E')] !wpuf-bg-[position:right_0.75rem_center] !wpuf-bg-[size:14px] !wpuf-bg-no-repeat focus:!wpuf-outline-none focus:!wpuf-ring-2 <?php echo esc_attr( $colors['focus_ring_primary_500'] ); ?>"
                data-block-id="<?php echo esc_attr( $block_id ); ?>"
                data-page-id="<?php echo esc_attr( $page_id ); ?>"
                data-default-value="<?php echo esc_attr( $order ); ?>">
            <option value="asc" <?php selected( $order, 'asc' ); ?>><?php esc_html_e('ASC', 'wpuf-pro'); ?></option>
            <option value="desc" <?php selected( $order, 'desc' ); ?>><?php esc_html_e('DESC', 'wpuf-pro'); ?></option>
        </select>
    </div>

    <!-- Reset Button -->
    <button type="button" class="wpuf-ud-reset-filters !wpuf-w-full md:!wpuf-w-auto !wpuf-h-[42px] !wpuf-px-6 !wpuf-py-2 !<?php echo esc_attr( $colors['primary_600'] ); ?> !wpuf-text-white !wpuf-rounded-md !wpuf-text-sm !wpuf-font-medium <?php echo esc_attr( $colors['hover_primary_700'] ); ?> focus:!wpuf-outline-none focus:!wpuf-ring-2 <?php echo esc_attr( $colors['focus_ring_primary_500'] ); ?> focus:!wpuf-ring-offset-2"
            data-block-id="<?php echo esc_attr( $block_id ); ?>"
            data-page-id="<?php echo esc_attr( $page_id ); ?>">
        <?php esc_html_e('Reset', 'wpuf-pro'); ?>
    </button>

</div>
