<?php
$user_id = $user->ID;
$tab_title = ! empty( $tab_title ) ? esc_html( $tab_title ) : __( 'About', 'wpuf-pro' );

do_action( 'wpuf_user_profile_before_content' );
?>
<div class="wpuf-profile-section">
    <h3 class="profile-tab-heading"><?php echo esc_html( $tab_title ); ?></h3>

    <div class="wpuf-profile-basic-info">
        <?php if ( $user->display_name ) : ?>
        <div class="wpuf-profile-field">
            <strong><?php esc_html_e( 'Display Name', 'wpuf-pro' ); ?>:</strong>
            <span><?php echo esc_html( $user->display_name ); ?></span>
        </div>
        <?php endif; ?>

        <?php if ( $user->user_login ) : ?>
        <div class="wpuf-profile-field">
            <strong><?php esc_html_e( 'Username', 'wpuf-pro' ); ?>:</strong>
            <span><?php echo esc_html( $user->user_login ); ?></span>
        </div>
        <?php endif; ?>

        <?php if ( $user->user_email ) : ?>
        <div class="wpuf-profile-field">
            <strong><?php esc_html_e( 'Email', 'wpuf-pro' ); ?>:</strong>
            <span><?php echo esc_html( $user->user_email ); ?></span>
        </div>
        <?php endif; ?>

        <?php if ( $user->user_url ) : ?>
        <div class="wpuf-profile-field">
            <strong><?php esc_html_e( 'Website', 'wpuf-pro' ); ?>:</strong>
            <span><a href="<?php echo esc_url( $user->user_url ); ?>" target="_blank" rel="noopener noreferrer"><?php echo esc_html( $user->user_url ); ?></a></span>
        </div>
        <?php endif; ?>

        <?php if ( $user->first_name || $user->last_name ) : ?>
        <div class="wpuf-profile-field">
            <strong><?php esc_html_e( 'Name', 'wpuf-pro' ); ?>:</strong>
            <span><?php echo esc_html( trim( $user->first_name . ' ' . $user->last_name ) ); ?></span>
        </div>
        <?php endif; ?>

        <?php
        // Show additional user meta if available
        $social_fields = [ 'facebook', 'twitter', 'linkedin', 'instagram' ];
        foreach ( $social_fields as $social_field ) :
            $value = get_user_meta( $user_id, $social_field, true );
            if ( $value ) :
        ?>
        <div class="wpuf-profile-field">
            <strong><?php echo esc_html( ucfirst( $social_field ) ); ?>:</strong>
            <span><a href="<?php echo esc_url( $value ); ?>" target="_blank" rel="noopener noreferrer"><?php echo esc_html( $value ); ?></a></span>
        </div>
        <?php 
            endif;
        endforeach; 
        ?>

        <?php
        // Show user registration date
        if ( $user->user_registered ) :
        ?>
        <div class="wpuf-profile-field">
            <strong><?php esc_html_e( 'Member Since', 'wpuf-pro' ); ?>:</strong>
            <span><?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $user->user_registered ) ) ); ?></span>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php
do_action( 'wpuf_user_profile_after_content' );