<?php
/**
Plugin Name: User Directory
Plugin URI: https://wedevs.com/products/plugins/wp-user-frontend-pro/user-listing-profile/
Thumbnail Name: wpuf-ul.png
Description: Handle user listing and user profile in frontend
Version: 2.0.0
Author: weDevs
Author URI: https://wedevs.com
License: GPL2
 */

$autoload = __DIR__ . '/vendor/autoload.php';

if ( file_exists( $autoload ) ) {
    require_once $autoload;
} else {
    return;
}

/**
 * User Listing class for WP User Frontend PRO
 *
 * @author weDevs <info@wedevs.com>
 */
class WPUF_User_Listing {
    /**
     * @var \WPUF\UserDirectory\Api
     */
    protected $api;

    /**
     * @var \WPUF\UserDirectory\Blocks
     */
    protected $blocks;

    /**
     * @var \WPUF\UserDirectory\ShortCode
     */
    protected $shortcode;

    private $shortcode_name = 'wpuf_user_listing';
    private $unique_meta;
    private $page_url;
    private $count_word = 10;
    private $avatar_size = 128;
    private $settings;
    private $total;

    /**
     * Instance of self
     *
     * @since 3.4.11
     *
     * @var WPUF_User_Listing
     */
    private static $instance = null;

    /**
     * Container for classes
     *
     * @since 4.2.0
     *
     * @var array
     */
    public $admin;

    public function __construct() {
        $this->define_constants();
        $this->includes_files();

        add_action( 'admin_enqueue_scripts', [ $this, 'userlisting_enqueue_scripts' ] );
    }

    /**
     * Enqueue styles and scripts for user listing page
     *
     * @param string $page
     *
     * @return void
     */
    public function userlisting_enqueue_scripts( $page ) {
        if ( 'user-frontend_page_wpuf-settings' !== $page && 'user-frontend_page_wpuf_userlisting' !== $page ) {
            return;
        }

        wp_enqueue_script( 'jquery-ui-sortable' );
    }

    /**
     * Define constants
     *
     * @return void
     */
    public function define_constants() {
        define( 'WPUF_UD_VERSION', '2.0.0' );
        define( 'WPUF_UD_FILE', __FILE__ );
        define( 'WPUF_UD_ROOT', dirname( __FILE__ ) );
        define( 'WPUF_UD_INCLUDES', WPUF_UD_ROOT . '/includes' );
        define( 'WPUF_UD_VIEWS', WPUF_UD_ROOT . '/includes/views' );
        define( 'WPUF_UD_ROOT_URI', plugins_url( '', __FILE__ ) );
        define( 'WPUF_UD_ASSET_URI', WPUF_UD_ROOT_URI . '/assets' );
        define( 'WPUF_UD_TEMPLATES', WPUF_UD_ROOT . '/templates' );
    }

    /**
     * Include all require files
     *
     * @return void
     */
    public function includes_files() {
        if ( is_admin() ) {
            $this->admin = new WPUF\UserDirectory\Admin();
        }

        $this->api       = new WPUF\UserDirectory\Api();
        $this->blocks    = new WPUF\UserDirectory\Blocks();
        $this->shortcode = new WPUF\UserDirectory\ShortCode();

        // Initialize directory styles
        new WPUF\UserDirectory\DirectoryStyles();

        // Initialize frontend functionality
        if ( ! is_admin() || wp_doing_ajax() ) {
            require_once WPUF_UD_INCLUDES . '/UserTabsFrontend.php';
            require_once WPUF_UD_INCLUDES . '/UserTabsAjaxHandler.php';
            require_once WPUF_UD_INCLUDES . '/Api/ProfileImageUpload.php';
            require_once WPUF_UD_INCLUDES . '/Api/AvatarUpload.php';
            require_once WPUF_UD_INCLUDES . '/Api/CoverPhotoUpload.php';

            // Initialize AJAX handlers
            new WPUF\UserDirectory\UserTabsAjaxHandler();
            new WPUF\UserDirectory\Api\AvatarUpload();
            new WPUF\UserDirectory\Api\CoverPhotoUpload();
        }

        require_once WPUF_UD_ROOT . '/functions/common.php';
        require_once WPUF_UD_ROOT . '/functions/users.php';
        require_once WPUF_UD_ROOT . '/functions/template-helpers.php';
        require_once WPUF_UD_INCLUDES . '/ProfileDataHelper.php';
        require_once WPUF_UD_INCLUDES . '/PrettyUrls.php';
        require_once WPUF_UD_INCLUDES . '/DirectoryStyles.php';

        // Initialize Pretty URLs
        new WPUF\UserDirectory\PrettyUrls();

    }

    /**
     * Init classes
     *
     * @return void
     */
    public function init_classes() {
        if ( is_admin() ) {
            $this->container['admin'] = new WPUF\UserDirectory\Admin();
        }
    }

    /**
     * Magic getter to bypass referencing objects
     *
     * @since 3.4.11
     *
     * @param string $prop
     *
     * @return mixed|void
     */
    public function __get( $prop ) {
        if ( array_key_exists( $prop, $this->container ) ) {
            return $this->container[ $prop ];
        }
    }

    /**
     * Returns a singleton WPUF_User_Listing class
     * Checks for an existing WPUF_User_Listing instance
     * and if it doesn't find one, creates it.
     *
     * @since 3.4.11
     *
     * @return WPUF_User_Listing
     */
    public static function init() {
        if ( self::$instance === null ) {
            self::$instance = new self();
        }

        return self::$instance;
    }
}

/**
 * Return the WPUF_User_Listing instance
 *
 * @return WPUF_User_Listing
 */
function wpuf_user_listing() {
    return WPUF_User_Listing::init();
}

wpuf_user_listing();
