Vue.component('field-dropdown', {
    template: '#tmpl-wpuf-field-dropdown',

    mixins: [
        wpuf_mixins.form_field_mixin
    ],

    props: {
        options: {
            type: Array,
        },
        default_option: {
            type: [String, Boolean],
            default: false,
        },
        show_icon: {
            type: Boolean,
            default: true,
        },
        is_bordered: {
            type: Boolean,
            default: true,
        },
        container_class: {
            type: String,
            default: '',
        },
        placeholder_class: {
            type: String,
            default: '',
        },
        dropdown_class: {
            type: String,
            default: '',
        },
        dropdown_item_class: {
            type: String,
            default: '',
        },
        dropdown_link_class: {
            type: String,
            default: '',
        },
    },

    data: function () {
        return {
            is_open: false,
            selected: '',
        };
    },

    created: function() {
        this.selected = this.default_selected;
    },

    computed: {
        selected_option: function() {
            return this.selected ? this.selected : this.default_option;
        },

        default_selected: function() {
            if ( this.default_option ) {
                return this.default_option;
            }

            return this.options[0] ? this.options[0].value : '';
        }
    },

    methods: {
        selectOption: function(option) {
            this.selected = option;
            this.is_open = false;
        }
    }
});
