<div class="wpuf-fields">
    <div
        v-if="field.inline !== 'yes'"
        class="wpuf-space-y-2">
        <div
            v-if="has_options" v-for="(option, key) in field.options" :key="key"
            class="wpuf-relative wpuf-flex wpuf-items-center">
            <div class="wpuf-flex wpuf-items-center">
                <input
                    type="checkbox"
                    :id="'pricing-checkbox-' + field.name + '-' + key"
                    :name="field.name + '[]'"
                    :value="key"
                    :checked="is_selected(key)"
                    :class="builder_class_names('checkbox')">
                <label :for="'pricing-checkbox-' + field.name + '-' + key">
                    {{ option }}
                    <span v-if="field.show_price_label === 'yes' && field.prices && field.prices[key]" class="wpuf-text-gray-600">
                        - {{ format_price(field.prices[key]) }}
                    </span>
                </label>
            </div>
        </div>
    </div>

    <div
        v-else
        class="wpuf-flex"
    >
        <div
            v-if="has_options" v-for="(option, key) in field.options" :key="key"
            class="wpuf-relative wpuf-flex wpuf-items-center wpuf-mr-4">
            <input
                type="checkbox"
                :id="'pricing-checkbox-' + field.name + '-' + key"
                :name="field.name + '[]'"
                :value="key"
                :checked="is_selected(key)"
                :class="builder_class_names('checkbox')"
                class="!wpuf-mt-[.5px] wpuf-rounded wpuf-border-gray-300 wpuf-text-indigo-600">
            <label :for="'pricing-checkbox-' + field.name + '-' + key">
                {{ option }}
                <span v-if="field.show_price_label === 'yes' && field.prices && field.prices[key]" class="wpuf-text-gray-600">
                    - {{ parseFloat(field.prices[key]).toFixed(2) }}
                </span>
            </label>
        </div>
    </div>

    <p v-if="field.help" class="wpuf-mt-2 wpuf-mb-0 wpuf-text-sm wpuf-text-gray-500" v-html="field.help"></p>
</div>