<div class="wpuf-fields wpuf-repeat-field-builder-container">
    <label
        :for="field.name"
        class="wpuf-option-field-title wpuf-font-sm wpuf-text-gray-700 wpuf-font-medium"
    >
        {{ field.label }} <help-text v-if="field.help_text" :text="field.help_text"></help-text>
    </label>
    <hr class="wpuf-mt-4">
    <!-- Sortable drop zone for inner fields -->
    <ul class="wpuf-repeat-fields-sortable-list wpuf-min-h-16">
        <!-- Empty state when no inner fields -->
        <div v-if="!field.inner_fields || field.inner_fields.length === 0"
             class="wpuf-flex wpuf-flex-col wpuf-items-center wpuf-justify-center wpuf-py-12 wpuf-px-4 wpuf-text-center">
            <svg class="wpuf-w-12 wpuf-h-12 wpuf-text-gray-300 wpuf-mb-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                <path vector-effect="non-scaling-stroke" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 13h6m-3-3v6m-9 1V7a2 2 0 012-2h6l2 2h6a2 2 0 012 2v8a2 2 0 01-2 2H5a2 2 0 01-2-2z" />
            </svg>
            <h3 class="wpuf-text-sm wpuf-font-medium wpuf-text-gray-900 wpuf-mb-2">
                <?php esc_html_e( 'No fields added yet', 'wp-user-frontend' ); ?>
            </h3>
            <p class="wpuf-text-xs wpuf-text-gray-500 wpuf-max-w-sm">
                <?php esc_html_e( 'Drag and drop fields from the sidebar to build your repeatable section.', 'wp-user-frontend' ); ?>
            </p>
        </div>

        <!-- Existing inner fields -->
        <li
            v-for="(innerField, idx) in field.inner_fields"
            :key="innerField.id"
            :repeat-field-index="idx"
            data-source="repeat-field-stage"
            class="!wpuf-m-0 !wpuf-p-0 wpuf-group/repeat-inner hover:wpuf-bg-green-50 wpuf-transition wpuf-duration-150 wpuf-ease-out repeat-field-items wpuf-el wpuf-rounded-t-md"
            :class="[
                innerField.name,
                innerField.css,
                'form-field-' + innerField.template,
                innerField.width ? 'field-size-' + innerField.width : '',
                ('custom_hidden_field' === innerField.template) ? 'hidden-field' : '',
                parseInt(editing_form_id) === parseInt(innerField.id) ? 'wpuf-bg-green-50' : ''
            ]">
            <div class="wpuf-flex wpuf-flex-col md:wpuf-flex-row wpuf-gap-2 wpuf-p-4 wpuf-border-transparent group-hover/repeat-inner:wpuf-border-green-400 wpuf-rounded-t-md wpuf-border-t wpuf-border-r wpuf-border-l wpuf-border-dashed wpuf-border-green-400">
                <div
                    v-if="!(is_full_width(innerField.template) || is_pro_preview(innerField.template))"
                    class="wpuf-w-1/4 wpuf-flex wpuf-items-center">
                    <span v-if="innerField.show_icon === 'yes' && innerField.field_icon && innerField.icon_position === 'left_label'"
                          class="wpuf-field-label-icon wpuf-inline-flex wpuf-items-center wpuf-mr-1">
                          <i :class="[innerField.field_icon, 'wpuf-field-icon']"></i>
                    </span>
                    <label
                           :for="'wpuf-' + (innerField.name ? innerField.name : 'cls')"
                           class="wpuf-block wpuf-text-sm">
                        {{ innerField.label }}
                        <span v-if="innerField.required && 'yes' === innerField.required"
                              class="required">*</span>
                    </label>
                    <span v-if="innerField.show_icon === 'yes' && innerField.field_icon && innerField.icon_position === 'right_label'"
                          class="wpuf-field-label-icon wpuf-inline-flex wpuf-items-center wpuf-ml-2">
                          <i :class="[innerField.field_icon, 'wpuf-field-icon']"></i>
                    </span>
                </div>
                <div
                    :class="[
                     'wpuf-relative wpuf-min-w-0',
                     (is_full_width(innerField.template) || is_pro_preview(innerField.template))
                       ? 'wpuf-w-full'
                       : 'wpuf-w-full md:wpuf-w-3/4'
                   ]">
                    <div class="wpuf-absolute wpuf-w-full wpuf-h-full "></div>
                    <div class="wpuf-relative">
                        <component
                            :is="'form-' + innerField.template"
                            :field="innerField">
                        </component>
                    </div>
                </div>
            </div>
            <div
                class="wpuf-repeat-field-control-buttons wpuf-opacity-0 group-hover/repeat-inner:wpuf-opacity-100 wpuf-rounded-b-lg wpuf-bg-green-600 wpuf-items-center wpuf-transition wpuf-duration-150 wpuf-ease-out wpuf-flex wpuf-justify-center">
                <div class="wpuf-items-center wpuf-text-green-200 wpuf-flex wpuf-justify-evenly">
                    <template v-if="!is_failed_to_validate(innerField.template)">
                        <span>
                            <i class="fa fa-arrows move wpuf-pr-2 wpuf-rounded-l-md hover:!wpuf-cursor-move wpuf-border-r wpuf-border-green-200 wpuf-text-[17px]"></i>
                        </span>
                        <span :class="action_button_classes"
                              class="!wpuf-px-2"
                            @click="open_inner_field_settings(innerField, idx)">
                            <svg class="wpuf-mr-2" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M5.43306 13.9163L6.69485 10.7618C6.89603 10.2589 7.19728 9.802 7.58033 9.41896L14.4995 2.50023C15.3279 1.6718 16.6711 1.6718 17.4995 2.50023C18.3279 3.32865 18.3279 4.6718 17.4995 5.50023L10.5803 12.419C10.1973 12.802 9.74042 13.1033 9.23746 13.3044L6.08299 14.5662C5.67484 14.7295 5.2698 14.3244 5.43306 13.9163Z" fill="#A7F3D0"/>
<path d="M3.5 5.74951C3.5 5.05916 4.05964 4.49951 4.75 4.49951H10C10.4142 4.49951 10.75 4.16373 10.75 3.74951C10.75 3.3353 10.4142 2.99951 10 2.99951H4.75C3.23122 2.99951 2 4.23073 2 5.74951V15.2495C2 16.7683 3.23122 17.9995 4.75 17.9995H14.25C15.7688 17.9995 17 16.7683 17 15.2495V9.99951C17 9.5853 16.6642 9.24951 16.25 9.24951C15.8358 9.24951 15.5 9.5853 15.5 9.99951V15.2495C15.5 15.9399 14.9404 16.4995 14.25 16.4995H4.75C4.05964 16.4995 3.5 15.9399 3.5 15.2495V5.74951Z" fill="#A7F3D0"/>
</svg>
                        </span>
                        <span :class="action_button_classes"
                              class="!wpuf-px-2"
                            @click="clone_inner_field(innerField, idx)">
                            <svg class="wpuf-mr-2" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.75 6.875V5C13.75 3.96447 12.9105 3.125 11.875 3.125H5C3.96447 3.125 3.125 3.96447 3.125 5V11.875C3.125 12.9105 3.96447 13.75 5 13.75H6.875M13.75 6.875H15C16.0355 6.875 16.875 7.71447 16.875 8.75V15C16.875 16.0355 16.0355 16.875 15 16.875H8.75C7.71447 16.875 6.875 16.0355 6.875 15V13.75M13.75 6.875H8.75C7.71447 6.875 6.875 7.71447 6.875 8.75V13.75" stroke="#A7F3D0" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
                        </span>
                    </template>
                    <template v-else>
                        <span :class="action_button_classes">
                            <i class="fa fa-arrows control-button-disabled wpuf--ml-1 wpuf-rounded-l-md"></i>
                        </span>
                        <span :class="action_button_classes">
                            <i class="fa fa-pencil control-button-disabled wpuf--ml-1"></i>
                        </span>
                        <span :class="action_button_classes">
                            <i class="fa fa-clone control-button-disabled wpuf--ml-1"></i>
                        </span>
                    </template>
                    <span :class="action_button_classes" @click="delete_inner_field(idx)">
                        <svg class="wpuf-mr-2" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.2837 7.5L11.9952 15M8.00481 15L7.71635 7.5M16.023 4.82547C16.308 4.86851 16.592 4.91456 16.875 4.96358M16.023 4.82547L15.1332 16.3938C15.058 17.3707 14.2434 18.125 13.2637 18.125H6.73631C5.75655 18.125 4.94198 17.3707 4.86683 16.3938L3.97696 4.82547M16.023 4.82547C15.0677 4.6812 14.1013 4.57071 13.125 4.49527M3.125 4.96358C3.40798 4.91456 3.69198 4.86851 3.97696 4.82547M3.97696 4.82547C4.93231 4.6812 5.89874 4.57071 6.875 4.49527M13.125 4.49527V3.73182C13.125 2.74902 12.3661 1.92853 11.3838 1.8971C10.9244 1.8824 10.463 1.875 10 1.875C9.53696 1.875 9.07565 1.8824 8.61618 1.8971C7.63388 1.92853 6.875 2.74902 6.875 3.73182V4.49527M13.125 4.49527C12.0938 4.41558 11.0516 4.375 10 4.375C8.94836 4.375 7.9062 4.41558 6.875 4.49527" stroke="#A7F3D0" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg>
                    </span>
                </div>
            </div>
        </li>
    </ul>

    <!-- Static + and - icons (no interactivity) -->
    <div class="wpuf-repeat-controls wpuf-p-4">
        <button type="button" class="wpuf-border wpuf-border-gray-100 wpuf-bg-white wpuf-px-[8px] wpuf-py-[2px] wpuf-rounded-[3px]">+</button>
        <button type="button" class="wpuf-border wpuf-border-gray-100 wpuf-bg-white wpuf-px-[8px] wpuf-py-[2px] wpuf-rounded-[3px]">-</button>
    </div>

    <span v-if="field.help" class="wpuf-help" v-html="field.help"></span>
</div>
