// User Avatar Block Registration
// Registers the WPUF User Avatar inner block

import { registerBlockType } from '@wordpress/blocks';
import { __ } from '@wordpress/i18n';

import Edit from './edit';
import Save from './save';
import metadata from './block.json';

import './style.css';

const { name } = metadata;
export { metadata, name };

export const settings = {
    ...metadata,
    title: __('User Avatar', 'wpuf-pro'),
    description: metadata.description,
    icon: 
    <svg width="18" height="18" viewBox="0 0 18 18" fill="#fff" xmlns="http://www.w3.org/2000/svg">
        <path fill="#fff" d="M14.3169 14.9776C13.0997 13.3711 11.171 12.3333 9 12.3333C6.82898 12.3333 4.90035 13.3711 3.68308 14.9776M14.3169 14.9776C15.9631 13.5123 17 11.3772 17 9C17 4.58172 13.4183 1 9 1C4.58172 1 1 4.58172 1 9C1 11.3772 2.03689 13.5123 3.68308 14.9776M14.3169 14.9776C12.9036 16.2357 11.041 17 9 17C6.95896 17 5.09645 16.2357 3.68308 14.9776M11.6667 7C11.6667 8.47276 10.4728 9.66667 9 9.66667C7.52724 9.66667 6.33333 8.47276 6.33333 7C6.33333 5.52724 7.52724 4.33333 9 4.33333C10.4728 4.33333 11.6667 5.52724 11.6667 7Z" stroke="#059669" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
    </svg>,
    category: metadata.category,
    edit: Edit,
    save: Save,
};
