// User Contact Info Block Registration
// Registers the WPUF User Contact Info inner block

import { registerBlockType } from '@wordpress/blocks';
import { __ } from '@wordpress/i18n';

import Edit from './edit';
import Save from './save';
import metadata from './block.json';

import './style.css';

const { name } = metadata;
export { metadata, name };

export const settings = {
    ...metadata,
    title: __('User Contact Info', 'wpuf-pro'),
    description: metadata.description,
    icon: 
    <svg width="22" height="18" viewBox="0 0 22 18" fill="#fff" xmlns="http://www.w3.org/2000/svg">
        <path fill="#fff" d="M20.75 3.75232V14.2523C20.75 15.495 19.7426 16.5023 18.5 16.5023H3.5C2.25736 16.5023 1.25 15.495 1.25 14.2523V3.75232M20.75 3.75232C20.75 2.50968 19.7426 1.50232 18.5 1.50232H3.5C2.25736 1.50232 1.25 2.50968 1.25 3.75232M20.75 3.75232V3.99503C20.75 4.77637 20.3447 5.50176 19.6792 5.91126L12.1792 10.5266C11.4561 10.9717 10.5439 10.9717 9.82078 10.5266L2.32078 5.91126C1.65535 5.50177 1.25 4.77637 1.25 3.99503V3.75232" stroke="#059669" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
    </svg>,
    category: metadata.category,
    edit: Edit,
    save: Save,
};
