// User Cover Photo Block Registration
// Registers the WPUF User Cover Photo inner block

import { registerBlockType } from '@wordpress/blocks';
import { __ } from '@wordpress/i18n';

import Edit from './edit';
import Save from './save';
import metadata from './block.json';

import './style.css';

const { name } = metadata;
export { metadata, name };

export const settings = {
    ...metadata,
    title: __('User Cover Photo', 'wpuf-pro'),
    description: metadata.description,
    icon:
    <svg width="18" height="18" viewBox="0 0 18 18" fill="#fff" xmlns="http://www.w3.org/2000/svg">
        <rect x="1" y="3" width="16" height="12" rx="2" stroke="#059669" strokeWidth="1.5" fill="none"/>
        <circle cx="9" cy="9" r="2" stroke="#059669" strokeWidth="1.5" fill="none"/>
        <path d="M5 13C5 11.3431 6.34315 10 8 10H10C11.6569 10 13 11.3431 13 13" stroke="#059669" strokeWidth="1.5" strokeLinecap="round"/>
    </svg>,
    category: metadata.category,
    edit: Edit,
    save: Save,
};