import { __ } from '@wordpress/i18n';
import { useBlockProps, InnerBlocks, InspectorControls } from '@wordpress/block-editor';
import React from 'react';

/**
 * Internal dependencies
 */
import SimpleInspectorControls from './inspector-controls/simple-controls';

const ALLOWED_BLOCKS = [
	'wpuf-ud/directory-item',
	'core/group',
	'core/button',
];

const TEMPLATE = [
	['wpuf-ud/directory-item', {}],
];

const UserDirectoryContent = ({ attributes, setAttributes }) => {
	const blockProps = useBlockProps();

	return (
		<>
			<InspectorControls>
                <SimpleInspectorControls
					attributes={attributes}
					setAttributes={setAttributes}
				/>
			</InspectorControls>

			<div {...blockProps}>
				<InnerBlocks
					allowedBlocks={ALLOWED_BLOCKS}
					template={TEMPLATE}
					templateLock="all"
					renderAppender={() => null}
				/>
			</div>
		</>
	);
};

export default UserDirectoryContent;
