import { useState } from '@wordpress/element';
import { __ } from '@wordpress/i18n';
import { Placeholder, Button } from '@wordpress/components';
import { Icon } from '@wordpress/components';
import PatternSelectionModal from './pattern-selection';

const UserDirectoryPlaceholder = ({ attributes, setAttributes, clientId }) => {
	const [isModalOpen, setIsModalOpen] = useState(false);

	const openPatternSelection = () => {
		setIsModalOpen(true);
	};

	const closePatternSelection = () => {
		setIsModalOpen(false);
	};

	return (
		<>
			<Placeholder
				icon={<Icon icon="groups" />}
				label={__('User Directory', 'wpuf-pro')}
				instructions={__(
					'Choose a layout to start building your user directory.',
					'wpuf-pro'
				)}
			>
				<div className="wpuf-flex wpuf-gap-2 wpuf-justify-center">
					<Button
						variant="primary"
						onClick={openPatternSelection}
					>
						{__('Choose Layout', 'wpuf-pro')}
					</Button>
				</div>
			</Placeholder>

			{isModalOpen && (
				<PatternSelectionModal
					attributes={attributes}
					setAttributes={setAttributes}
					clientId={clientId}
					onClose={closePatternSelection}
				/>
			)}
		</>
	);
};

export default UserDirectoryPlaceholder;
