// User Profile Container Save Component
// Server-side rendered block with InnerBlocks support

import { InnerBlocks, useBlockProps } from '@wordpress/block-editor';

const Save = () => {
    // Even though this block is server-side rendered, we need to save
    // the InnerBlocks content so it's available to the PHP render function
    const blockProps = useBlockProps.save({
        className: 'wpuf-user-profile'
    });

    return (
        <div {...blockProps}>
            <InnerBlocks.Content />
        </div>
    );
};

export default Save;
