// User Name Edit Component
// Displays and configures user name with various display options

import { __ } from '@wordpress/i18n';
import {
    InnerBlocks,
    useBlockProps
} from '@wordpress/block-editor';
import { Fragment, useEffect } from '@wordpress/element';

const Edit = ({ attributes, setAttributes, context }) => {
    const blockProps = useBlockProps();

    // Hide this block from the list view
    useEffect(() => {
        const hideFromListView = () => {
            // Find all list view rows
            const listViewRows = document.querySelectorAll('.block-editor-list-view-tree tr');
            
            listViewRows.forEach(row => {
                // Check if this row contains "Unmatched" text
                const titleElement = row.querySelector('.block-editor-list-view-block-select-button__title .components-truncate');
                if (titleElement && titleElement.textContent.includes('Unmatched')) {
                    row.style.display = 'none';
                }
            });
        };

        // Run immediately
        hideFromListView();
        
        // Also run when the DOM changes (for dynamic content)
        const observer = new MutationObserver(hideFromListView);
        observer.observe(document.body, { 
            childList: true, 
            subtree: true 
        });

        return () => observer.disconnect();
    }, []);

    return (
        <Fragment>
            <div {...blockProps}>
                <InnerBlocks/>
            </div>
        </Fragment>
    );
};

export default Edit;
