    // Shared utility for getting user data from parent blocks
import { useSelect } from '@wordpress/data';

/**
 * Hook to get user data from parent block attributes
 * @param {string} clientId - The current block's client ID
 * @returns {Object|null} - User object or null if not found
 */
export const useUserFromParent = (clientId) => {
    return useSelect(select => {
        // Get all parent blocks
        const parentIds = select('core/block-editor').getBlockParents(clientId);

        		// Look for user-template or user-profile parent blocks
		for (const parentId of parentIds) {
			const parentBlock = select('core/block-editor').getBlock(parentId);

			if (!parentBlock) continue;

			// Check for user-template block
			if (parentBlock.name === 'wpuf-ud/template') {
                const userObject = parentBlock.attributes.userObject;
                if (userObject) {
                    return userObject;
                }
            }

            // Check for user-profile block
            if (parentBlock.name === 'wpuf-ud/profile') {
                const userObject = parentBlock.attributes.userObject;
                if (userObject) {
                    return userObject;
                }
            }
        }

        return null;
    }, [clientId]);
};
