<?php
namespace AvasElements\Modules\GiveForm\Widgets;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Border;
use \Elementor\Widget_Base;
use AvasElements\TX_Helper;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class GiveForm extends Widget_Base {

    public function get_name() {
        return 'avas-give-form';
    }

    public function get_title() {
        return esc_html__( 'Avas Give Form', 'avas-core' );
    }

    public function get_icon() {
        return 'eicon-form-horizontal';
    }

    // public function get_style_depends() {
        
    //     return ['ep-give-goal'];
    // }

    public function get_categories() {
        return [ 'avas-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'give_form_grid_settings',
            [
                'label' => __('Form Grid', 'avas-core'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_title',
            [
                'label' => __('Show Title', 'avas-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_excerpt',
            [
                'label' => __('Show Excerpt', 'avas-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'excerpt_length',
            [
                'label' => __('Excerpt Length', 'avas-core'),
                'type' => Controls_Manager::NUMBER,
                'default' => 16,
            ]
        );

        $this->add_control(
            'show_goal',
            [
                'label' => __('Show Goal', 'avas-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_featured_image',
            [
                'label' => __('Show Featured Image', 'avas-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => __('Show Pagination', 'avas-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'prefix_class' => 'tx-pagination-show-',
            ]
        );

        $this->add_control(
            'forms_per_page',
            [
                'label'   => __('Forms Per Page', 'avas-core'),
                'type'    => Controls_Manager::NUMBER,
                'default' => '6'
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label' => __('Columns', 'avas-core'),
                'type' => Controls_Manager::SELECT,
                'default'        => '3',
                'tablet_default' => '2',
                'mobile_default' => '1',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-wrap .give-grid' => 'display: grid;
                    grid-template-columns: repeat({{SIZE}}, 1fr);',
                ],
            ]
        );

        $this->add_responsive_control(
            'items_gap',
            [
                'label' => esc_html__('Column Gap', 'avas-core'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-wrap .give-grid' => 'grid-column-gap: {{SIZE}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'items_row_gap',
            [
                'label' => esc_html__('Row Gap', 'avas-core'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-wrap .give-grid' => 'grid-row-gap: {{SIZE}}px;',
                ],
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label'   => __('Order By', 'avas-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'date'             => __('Date Created', 'avas-core'),
                    'title'            => __('Form Title', 'avas-core'),
                    'amount_donated'   => __('Amount Donated', 'avas-core'),
                    'number_donations' => __('Number of Donations', 'avas-core'),
                    'menu_order'       => __('Menu Order', 'avas-core'),
                    'post__in'         => __('Form ID', 'avas-core'),
                    'closest_to_goal'  => __('Closest to Goal', 'avas-core'),
                ],
                'default' => 'date'
            ]
        );

        $this->add_control(
            'order',
            [
                'label'       => __('Order', 'avas-core'),
                'type'        => Controls_Manager::SELECT,
                'options'     => [
                    'DESC' => __('Descending', 'avas-core'),
                    'ASC'  => __('Ascending', 'avas-core')
                ],
                'default' => 'DESC'
            ]
        );

        $this->end_controls_section();

        //Style
        $this->start_controls_section(
            'section_form_grid_style',
            [
                'label' => esc_html__('Items', 'avas-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('tabs_item_style');

        $this->start_controls_tab(
            'tab_item_normal',
            [
                'label' => esc_html__('Normal', 'avas-core'),
            ]
        );

        $this->add_control(
            'tab_item_bg_color',
            [
                'label' => esc_html__('Background Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-wrap .give-card' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'tab_item_border',
                'selector' => '{{WRAPPER}} .tx-give-form .give-wrap .give-card',
            ]
        );

        $this->add_responsive_control(
            'tab_item_border_radius',
            [
                'label' => __('Border Radius', 'avas-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-wrap .give-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                ],
            ]
        );

        $this->add_responsive_control(
            'tab_item_padding',
            [
                'label' => __('Padding', 'avas-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-wrap .give-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tab_item_box_shadow',
                'selector' => '{{WRAPPER}} .tx-give-form .give-wrap .give-card',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_item_hover',
            [
                'label' => esc_html__('Hover', 'avas-core'),
            ]
        );

        $this->add_control(
            'tab_item_bg_hover_color',
            [
                'label' => esc_html__('Background Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-wrap .give-card:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tab_item_hover_border_color',
            [
                'label'     => __('Border Color', 'avas-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-wrap .give-card:hover'  => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'tab_item_border_border!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tab_item_hover_box_shadow',
                'selector' => '{{WRAPPER}} .tx-give-form .give-wrap .give-card:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();


        $this->add_responsive_control(
            'section_content_padding',
            [
                'label' => __('Content Padding', 'avas-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-wrap .give-card__body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before'
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_image_style',
            [
                'label' => esc_html__('Image', 'avas-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_featured_image' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'image_border',
                'selector' => '{{WRAPPER}} .tx-give-form .give-wrap .give-card__media img'
            ]
        );

        $this->add_control(
            'iamge_radius',
            [
                'label'      => esc_html__('Radius', 'avas-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .tx-give-form .give-wrap .give-card__media img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'iamge_padding',
            [
                'label'      => __('Padding', 'avas-core'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .tx-give-form .give-wrap .give-card__media img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'img_shadow',
                'selector' => '{{WRAPPER}} .tx-give-form .give-wrap .give-card__media img'
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__('Title', 'avas-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_title' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-wrap .give-form-grid-content__title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => __('Spacing', 'avas-core'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-wrap .give-form-grid-content__title' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .tx-give-form .give-wrap .give-form-grid-content__title',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_text_style',
            [
                'label' => esc_html__('Text', 'avas-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_excerpt' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => esc_html__('Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-wrap .give-form-grid-content__text' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'text_spacing',
            [
                'label' => __('Spacing', 'avas-core'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-wrap .give-form-grid-content__text' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_typography',
                'selector' => '{{WRAPPER}} .tx-give-form .give-wrap .give-form-grid-content__text',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_goal_style',
            [
                'label' => esc_html__('Goal', 'avas-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_goal' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'income_heading',
            [
                'label' => esc_html__('Income Amount', 'avas-core'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'income_color',
            [
                'label' => esc_html__('Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form span.amount' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'income_spacing',
            [
                'label' => __('Spacing', 'avas-core'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form span.amount' => 'margin-right: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'income_typography',
                'selector' => '{{WRAPPER}} .tx-give-form span.amount',
            ]
        );

        $this->add_control(
            'goal_amount_heading',
            [
                'label' => esc_html__('Goal Amount', 'avas-core'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'goal_amount_color',
            [
                'label' => esc_html__('Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .goal' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'goal_amount_typography',
                'selector' => '{{WRAPPER}} .tx-give-form .goal',
            ]
        );

        $this->add_control(
            'progress_bar_heading',
            [
                'label' => esc_html__('Progress Bar', 'avas-core'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'progress_color',
            [
                'label' => esc_html__('Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-progress-bar>span' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'progress_bg_color',
            [
                'label' => esc_html__('Background Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-progress-bar' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'progress_height',
            [
                'label' => __('Height', 'avas-core'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-progress-bar' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'progress_spacing',
            [
                'label' => __('Spacing', 'avas-core'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-progress-bar' => 'margin-top: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->end_controls_section();

        // Pagination
        $this->start_controls_section(
            'section_pagi_style',
            [
                'label' => esc_html__('Pagination', 'avas-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_pagination' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'pagi_alignment',
            [
                'label'   => esc_html__('Alignment', 'avas-core'),
                'type'    => Controls_Manager::CHOOSE,
                'default' => 'center',
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'avas-core'),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'avas-core'),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'avas-core'),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-page-numbers' => 'text-align: {{VALUE}}',
                ],
            ]
        );

        $this->start_controls_tabs('pagi_style');

        $this->start_controls_tab(
            'pagi_normal',
            [
                'label' => esc_html__('Normal', 'avas-core'),
            ]
        );

        $this->add_control(
            'pagi_color',
            [
                'label' => esc_html__('Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-page-numbers a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pagi_bg_color',
            [
                'label' => esc_html__('Background Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-page-numbers a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'pagi_border',
                'label' => esc_html__('Border', 'avas-core'),
                'selector' => '{{WRAPPER}} .tx-give-form .give-page-numbers a, {{WRAPPER}} .tx-give-form .give-page-numbers span.current',
            ]
        );

        $this->add_responsive_control(
            'pagi_border_radius',
            [
                'label' => __('Border Radius', 'avas-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-page-numbers a, {{WRAPPER}} .tx-give-form .give-page-numbers span.current' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'pagi_padding',
            [
                'label' => __('Padding', 'avas-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-page-numbers a, {{WRAPPER}} .tx-give-form .give-page-numbers span.current' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'pagi_spacing',
            [
                'label' => __('Spacing', 'avas-core'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-page-numbers' => 'margin-top: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'pagi_typography',
                'selector' => '{{WRAPPER}} .tx-give-form .give-page-numbers a, {{WRAPPER}} .give-page-numbers span',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'pagi_hover',
            [
                'label' => esc_html__('Hover', 'avas-core'),
            ]
        );

        $this->add_control(
            'pagi_hover_color',
            [
                'label' => esc_html__('Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-page-numbers a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pagi_bg_hover_color',
            [
                'label' => esc_html__('Background Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-page-numbers a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pagi_hover_border_color',
            [
                'label'     => __('Border Color', 'avas-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-page-numbers a:hover'  => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'pagi_border_border!' => '',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'pagi_active',
            [
                'label' => esc_html__('Active', 'avas-core'),
            ]
        );

        $this->add_control(
            'pagi_active_color',
            [
                'label' => esc_html__('Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-page-numbers span.current' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pagi_bg_active_color',
            [
                'label' => esc_html__('Background Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-page-numbers span.current' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pagi_active_border_color',
            [
                'label'     => __('Border Color', 'avas-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-form .give-page-numbers span.current'  => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'pagi_border_border!' => '',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    private function get_shortcode() {
        $settings = $this->get_settings_for_display();

        $attributes = [
            'forms_per_page'      => $settings['forms_per_page'],
            'orderby'             => $settings['orderby'],
            'order'               => $settings['order'],
            'show_title'          => $settings['show_title'],
            'show_goal'           => $settings['show_goal'],
            'show_excerpt'        => $settings['show_excerpt'],
            'excerpt_length'      => $settings['excerpt_length'],
            'show_featured_image' => $settings['show_featured_image'],
            'display_style'       => 'modal_reveal'
        ];

        $this->add_render_attribute('shortcode', $attributes);

        $shortcode   = [];
        $shortcode[] = sprintf('[give_form_grid %s]', $this->get_render_attribute_string('shortcode'));

        return implode("", $shortcode);
    }

    public function render() {
        if (class_exists('Give')) {

        $this->add_render_attribute('give_wrapper', 'class', 'tx-give-form');

?>

        <div <?php $this->print_render_attribute_string('give_wrapper'); ?>>

            <?php echo do_shortcode($this->get_shortcode()); ?>

        </div>

<?php
    } else { ?>
        <h4><?php echo esc_html__('Please install / activate Give plugin.', 'avas-core'); ?></h4>
 <?php }
}

    public function render_plain_content() {
        echo wp_kses_post($this->get_shortcode());
    }
} // class end