<?php
namespace AvasElements\Modules\GiveGoal\Widgets;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Widget_Base;
use AvasElements\TX_Helper;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class GiveGoal extends Widget_Base {

    public function get_name() {
        return 'avas-give-goal';
    }

    public function get_title() {
        return esc_html__( 'Avas Give Goal', 'avas-core' );
    }

    public function get_icon() {
        return 'eicon-notification';
    }

    public function get_categories() {
        return [ 'avas-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'give_login_settings',
            [
                'label' => esc_html__('Give Goal', 'avas-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'form_id',
            [
                'label' => esc_html__('Form ID', 'avas-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => TX_Helper::get_give_forms_options(),
                'default' => 0
            ]
        );

        $this->add_control(
            'show_text',
            [
                'label' => esc_html__('Show Amount', 'avas-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'show_bar',
            [
                'label' => esc_html__('Show Progress Bar', 'avas-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes'
            ]
        );

        $this->end_controls_section();

        //Style
        $this->start_controls_section(
            'section_income_style',
            [
                'label' => esc_html__('Income Amount', 'avas-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_text' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'income_color',
            [
                'label' => esc_html__('Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-goal span.income' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'income_spacing',
            [
                'label' => esc_html__('Spacing', 'avas-core'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-goal span.income' => 'margin-right: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'income_typography',
                'selector' => '{{WRAPPER}} .tx-give-goal span.income',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_goal_amount_style',
            [
                'label' => esc_html__('Goal Amount', 'avas-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_text' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'goal_amount_color',
            [
                'label' => esc_html__('Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-goal .raised' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'goal_amount_typography',
                'selector' => '{{WRAPPER}} .tx-give-goal .raised',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'sectn_style',
            [
                'label' => esc_html__('Progress Bar', 'avas-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_bar' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'progress_color',
            [
                'label' => esc_html__('Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-goal .give-progress-bar>span' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'progress_bg_color',
            [
                'label' => esc_html__('Background Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-goal .give-progress-bar' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'progress_border_radius',
            [
                'label' => esc_html__('Border Radius', 'avas-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .tx-give-goal .give-progress-bar, {{WRAPPER}} .tx-give-goal .give-progress-bar>span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'progress_height',
            [
                'label' => esc_html__('Height', 'avas-core'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-goal .give-progress-bar' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'progress_spacing',
            [
                'label' => esc_html__('Spacing', 'avas-core'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .tx-give-goal .give-progress-bar' => 'margin-top: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->end_controls_section();
    }


    private function get_shortcode() {
        $settings = $this->get_settings_for_display();

        if (!$settings['form_id']) {
            return esc_html__('Please select a Give Forms From Setting!', 'avas-core');
        }

        $attributes = [
            'id' => $settings['form_id'],
            'show_text' => $settings['show_text'],
            'show_bar' => $settings['show_bar']
        ];

        $this->add_render_attribute('shortcode', $attributes);

        $shortcode   = [];
        $shortcode[] = sprintf('[give_goal %s]', $this->get_render_attribute_string('shortcode'));

        return implode("", $shortcode);
    }

    public function render() {

        if (class_exists('Give')) {

        $this->add_render_attribute('give_wrapper', 'class', 'tx-give-goal');

?>

        <div <?php $this->print_render_attribute_string('give_wrapper'); ?>>

            <?php echo do_shortcode($this->get_shortcode()); ?>

        </div>

<?php
    } else { ?>
        <h4><?php echo esc_html__('Please install / activate Give plugin.', 'avas-core'); ?></h4>
 <?php }
}

    public function render_plain_content() {
        echo wp_kses_post($this->get_shortcode());
    }
} // class end