<?php
namespace AvasElements\Modules\SlickCarousel\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Repeater;
use Elementor\Utils;
use AvasElements\TX_Helper;
// use AvasElements\Swiper_Controls;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class SlickCarousel extends Widget_Base {

    public function get_name() {
        return 'avas-slick-carousel';
    }

    public function get_title() {
        return esc_html__( 'Avas Slick Carousel', 'avas-core' );
    }

    public function get_icon() {
        return 'eicon-posts-carousel';
    }

    public function get_categories() {
        return [ 'avas-elements' ];
    }

    public function get_script_depends() {
        return [ 'tx-slick','tx-slick-carousel' ];
    }

    public function get_style_depends() {
        return [ 'tx-slick','slick-theme','tx-slick-carousel' ];
    }

    protected function register_controls() {
       
        $this->start_controls_section(
            'settings',
            [
                'label' => esc_html__( 'Content', 'avas-core' )
            ]
        );
        $this->add_control(
            'tx_lightbox',
            [
                'label' => esc_html__( 'Lightbox', 'avas-core' ),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'yes',
            ]
        );
        
        $repeater = new Repeater();
        
        $repeater->add_control(
            'user_image', 
            [
                'label' => esc_html__('Image', 'avas-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
            ]
        );
        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'image',
                'default' => 'full',
            ]
        );
        $repeater->add_control(
            'icon_switch',
            [
                'label'        => esc_html__( 'Icon', 'avas-core' ),
                'type'         => Controls_Manager::SWITCHER,
            ]
        );
        $repeater->add_control(
            'ib_select',
            [
                'label' => esc_html__( 'Select Icon or Image', 'avas-core' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'icon' => [
                        'title' => esc_html__( 'Icon', 'avas-core' ),
                        'icon' => 'far fa-smile-beam',
                    ],
                    'image' => [
                        'title' => esc_html__( 'Image', 'avas-core' ),
                        'icon' => 'far fa-image',
                    ]
                ],
                'default' => 'icon',
                'condition' => [
                    'icon_switch' => 'yes'
                ]
            ]
        );
        $repeater->add_control(
            'ib_icon',
            [
                'label' => esc_html__( 'Icon', 'avas-core' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-snowflake',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'ib_select' => 'icon',
                    'icon_switch' => 'yes'
                ]
            ]
        );
        $repeater->add_control(
            'ib_image',
            [
                'label' => esc_html__( 'Image', 'avas-core' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'ib_select' => 'image',
                    'icon_switch' => 'yes'
                ]
            ]
        );
        $repeater->add_control(
            'title', 
            [
                'label' => esc_html__('Title', 'avas-core'),
                'default' => 'Curabitur ligula sapien tincidunt',
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'link_url', 
            [
                'label' => esc_html__('Link URL', 'avas-core'),
                'type'        => Controls_Manager::URL,
                'dynamic'     => [ 'active' => true ],
                'placeholder' => 'http://your-link.com',
                'condition' => [
                    'title!' => ''
                ]
            ]
        );
        $repeater->add_control(
            'description', 
            [
                'label' => esc_html__('Descripton', 'avas-core'),
                'type' => Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Lorem ipsum dolor sit amet consectetur adipiscing elit sed do eiusmod tempor incididunt.', 'avas-core' ),
            ]
        );
        $repeater->add_control(
            'read_more_switch',
            [
                'label'        => esc_html__( 'Read More', 'avas-core' ),
                'type'         => Controls_Manager::SWITCHER,
            ]
        );
        $repeater->add_control(
            'read_more_text',
            [
                'label'       => esc_html__( 'Read More Text', 'avas-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__( 'Read More', 'avas-core' ),
                'placeholder' => esc_html__( 'Enter Text', 'avas-core' ),
                'condition' => [
                    'read_more_switch' => 'yes'
                ]
            ]

        );

        $repeater->add_control(
            'read_more_link',
            [
                'label'     => esc_html__( 'Read More Link', 'avas-core' ),
                'type'      => Controls_Manager::URL,
                'dynamic'   => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'https://your-link.com', 'avas-core' ),
                'default'     => [
                    'url' => '#',
                ],
                'condition' => [
                    'read_more_text!' => ''
                ]
            ]
        );
        $repeater->add_control(
            'read_more_icon',
            [
                'label' => esc_html__( 'Read More Icon', 'avas-core' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'tx_selected_icon',
                'skin'             => 'inline',
                'label_block'      => false,
                'condition' => [
                    'read_more_switch' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'items',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [

                    [
                        'title' => wp_kses_post('Tristique senectus et netus'),
                        'description' => wp_kses_post('Lorem ipsum dolor sit amet consectetur adipiscing elit sed do eiusmod tempor incididunt.', 'avas-core'),
                    ],
                    [
                        'title' => wp_kses_post('Mauris ultricies pulvinar abitant', 'avas-core'),
                        'description' => wp_kses_post('Lorem ipsum dolor sit amet consectetur adipiscing elit sed do eiusmod tempor incididunt.', 'avas-core'),
                    ],
                    [
                        'title' => wp_kses_post('Arcu purus lacinia sed diam', 'avas-core'),
                        'description' => wp_kses_post('Lorem ipsum dolor sit amet consectetur adipiscing elit sed do eiusmod tempor incididunt.', 'avas-core'),
                    ],
                    [
                        'title' => wp_kses_post('Sollicitudin dolor diam vitae', 'avas-core'),
                        'description' => wp_kses_post('Lorem ipsum dolor sit amet consectetur adipiscing elit sed do eiusmod tempor incididunt.', 'avas-core'),
                    ],
                ],

                'title_field' => '{{{ title }}}',
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            'section_carousel_settings',
            [
                'label' => esc_html__('Settings', 'avas-core'),
            ]
        );
        $this->add_control(
            'slidesToShow_desktop',
            [
                'label'     => esc_html__('Column on Desktop ', 'avas-core'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 3,
                
            ]
        );
        $this->add_control(
            'slidesToShow_tablet',
            [
                'label'     => esc_html__('Column on Tablet ', 'avas-core'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 2,
                
            ]
        );
        $this->add_control(
            'slidesToShow_mobile',
            [
                'label'     => esc_html__('Column on Mobile ', 'avas-core'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 1,
                
            ]
        );
        $this->add_control(
            'slidesToScroll',
            [
                'label'     => esc_html__('Slide to Scroll ', 'avas-core'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 1,
                
            ]
        );
        $this->add_control(
            'tx_slick_slide_gap',
            [
                'label'   => esc_html__('Gap', 'avas-core'),
                'type'    => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 20,
                ],
                'range'   => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .slick-slide' => 'padding-left: {{SIZE}}{{UNIT}};',
                    // '{{WRAPPER}} .slick-slide' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label'   => esc_html__('Autoplay', 'avas-core'),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',

            ]
        );
        $this->add_control(
            'autoplaySpeed',
            [
                'label'     => esc_html__('Autoplay Speed', 'avas-core'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 5000,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'infinite',
            [
                'label'   => esc_html__('Loop', 'avas-core'),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',

            ]
        );
        $this->add_control(
            'pauseOnHover',
            [
                'label'   => esc_html__('Pause On Hover', 'avas-core'),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'no',

            ]
        );
        $this->add_control(
            'pauseOnFocus',
            [
                'label'   => esc_html__('Pause On Focus', 'avas-core'),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'no',

            ]
        );
        $this->add_control(
            'centerMode',
            [
                'label'   => esc_html__('Center Mode', 'avas-core'),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',

            ]
        );
        $this->add_control(
            'vertical',
            [
                'label'   => esc_html__('Vertical', 'avas-core'),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'no',

            ]
        );
        $this->add_control(
            'dots',
            [
                'label'   => esc_html__('Dots', 'avas-core'),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',

            ]
        );
        $this->add_control(
            'tx_slick_arrows',
            [
                'label' => esc_html__( 'Arrows', 'avas-core' ),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'default' => 'none',
                'options' => [
                    'inline-block' => [
                        'title' => esc_html__( 'Yes', 'avas-core' ),
                        'icon' => 'eicon-check',
                    ],
                    'none' => [
                        'title' => esc_html__( 'No', 'avas-core' ),
                        'icon' => 'eicon-editor-close',
                    ],
                ],
                'toggle' => false,
                'selectors' => [
                    '{{WRAPPER}} .slick-arrow' =>  'display: {{VALUE}} !important;',
                ],
            ]
        );
        $this->end_controls_section();

        // Style section started
        $this->start_controls_section(
            'styles_section_carousel',
            [
              'label'   => esc_html__( 'Styles', 'avas-core' ),
              'tab'     => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->start_controls_tabs( 'sec_carousel_tabs' );

        $this->start_controls_tab( 'normal',
            [
                'label' => esc_html__( 'Normal', 'avas-core' ),
            ]
        );
       
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'tx_carousel_background',
                'label' => esc_html__( 'Background', 'avas-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .tx-slick-carousel-content',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'tx_carousel_border',
                'label' => esc_html__( 'Border', 'avas-core' ),
                'selector' => '{{WRAPPER}} .tx-slick-carousel-content',
            ]
        );
        $this->add_responsive_control(
            'tx_carousel_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'avas-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tx-slick-carousel-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tx_carousel_padding',
            [
                'label' => esc_html__( 'Padding', 'avas-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tx-slick-carousel-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tx_carousel_margin',
            [
                'label' => esc_html__( 'Margin', 'avas-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tx-slick-carousel-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'tx_carousel_box_shadow',
                'selector' => '{{WRAPPER}} .tx-slick-carousel-content'
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab( 'hover',
            [
                'label' => esc_html__( 'Hover', 'avas-core' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'tx_carousel_hov_background',
                'label' => esc_html__( 'Background', 'avas-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .tx-slick-carousel-content:hover',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'tx_carousel_hov_border',
                'label' => esc_html__( 'Border', 'avas-core' ),
                'selector' => '{{WRAPPER}} .tx-slick-carousel-content:hover',
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'tx_carousel_box_hov_shadow',
                'selector' => '{{WRAPPER}} .tx-slick-carousel-content:hover'
            ]
        );
        $this->add_control(
            'sec_car_background_hover_transition',
            [
                'label' => esc_html__( 'Transition Duration', 'avas-core' ) . ' (s)',
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-slick-carousel-content:hover' => 'transition-duration: {{SIZE}}s',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

        // Image Style section started
        $this->start_controls_section(
            'styles',
            [
              'label'   => esc_html__( 'Image', 'avas-core' ),
              'tab'     => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'img_width',
            [
                'label' => esc_html__( 'Image Size', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-image img' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before'
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_img_border',
                'label' => esc_html__( 'Border', 'avas-core' ),
                'selector' => '{{WRAPPER}} .tx-car-grid-image img',
            ]
        );
        $this->add_responsive_control(
            'img_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'avas-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->start_controls_tabs( 'image_effects' );

        $this->start_controls_tab( 'tx_normal_img',
            [
                'label' => esc_html__( 'Normal', 'avas-core' ),
            ]
        );

        $this->add_control(
            'opacity',
            [
                'label' => esc_html__( 'Opacity', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-image img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'css_filters',
                'selector' => '{{WRAPPER}} .tx-car-grid-image img',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab( 'tx_hover_img',
            [
                'label' => esc_html__( 'Hover', 'avas-core' ),
            ]
        );

        $this->add_control(
            'opacity_hover',
            [
                'label' => esc_html__( 'Opacity', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-slick-carousel-content:hover .tx-car-grid-image img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'css_filters_hover',
                'selector' => '{{WRAPPER}} .tx-slick-carousel-content:hover .tx-car-grid-image img',
            ]
        );

        $this->add_control(
            'background_hover_transition',
            [
                'label' => esc_html__( 'Transition Duration', 'avas-core' ) . ' (s)',
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-slick-carousel-content:hover .tx-car-grid-image img' => 'transition-duration: {{SIZE}}s',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'styles_icon',
            [
              'label'   => esc_html__( 'Icon', 'avas-core' ),
              'tab'     => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__( 'Icon / Image Size', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 300,
                    ],
                ],
                'default' => [
                    'size' => 40,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-icon-wrap i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .tx-car-grid-icon-wrap img' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .tx-car-grid-icon-wrap svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_x',
            [
                'label' => esc_html__( 'Offset X', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ '%', 'px' ],
                'range' => [
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-icon-wrap' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_y',
            [
                'label' => esc_html__( 'Offset Y', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ '%', 'px' ],
                'range' => [
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-icon-wrap' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__( 'Icon Color', 'avas-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-icon-wrap i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tx-car-grid-icon-wrap svg' => 'fill: {{VALUE}};',
                ],
                
            ]
        );
        $this->add_control(
            'icon_hover_color',
            [
                'label'     => esc_html__( 'Icon Hover Color', 'avas-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-slick-carousel-content:hover .tx-car-grid-icon-wrap i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tx-slick-carousel-content:hover .tx-car-grid-icon-wrap svg' => 'fill: {{VALUE}};',
                ],
                
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'styles_content',
            [
              'label'   => esc_html__( 'Content', 'avas-core' ),
              'tab'     => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'alignment',
            [
                'label' => esc_html__( 'Alignment', 'avas-core' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'avas-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'avas-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'avas-core' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'toggle' => false,
                'selectors'         => [
                    '{{WRAPPER}} .tx-slick-carousel-content'   => 'text-align: {{VALUE}};',
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'tx_carousel_cont_background',
                'label' => esc_html__( 'Background', 'avas-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .tx-car-grid-content',
            ]
        );
        $this->add_responsive_control(
            'cont_pad',
            [
                'label' => esc_html__( 'Content Padding', 'avas-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'cont_margin',
            [
                'label' => esc_html__( 'Content Margin', 'avas-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'cont_only_border',
                'label' => esc_html__( 'Content Border', 'avas-core' ),
                'selector' => '{{WRAPPER}} .tx-car-grid-content',
            ]
        );
        $this->add_responsive_control(
            'cont_border_radius',
            [
                'label' => esc_html__( 'Content Border Radius', 'avas-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'content_only_box_shadow',
                'selector' => '{{WRAPPER}} .tx-car-grid-content'
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__( 'Title Color', 'avas-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-title' => 'color: {{VALUE}};',
                ],
                
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'title_hov_color',
            [
                'label'     => esc_html__( 'Title Hover Color', 'avas-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-title:hover' => 'color: {{VALUE}};',
                ],
                
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
              [
                   'name'    => 'title_typography',
                   'selector'  => '{{WRAPPER}} .tx-car-grid-title',
                   
              ]
        );
        $this->add_group_control(
            Group_Control_Text_Stroke::get_type(),
            [
                'name' => 'title_text_stroke',
                'label'     => esc_html__( 'Title Text Stroke', 'avas-core' ),
                'selector' => '{{WRAPPER}} .tx-car-grid-title',
            ]
        );
        $this->add_control(
            'description_color',
            [
                'label'     => esc_html__( 'Descripton Color', 'avas-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-description' => 'color: {{VALUE}};',
                ],
                
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
              [
                   'name'    => 'description_typography',
                   'selector'  => '{{WRAPPER}} .tx-car-grid-description',
                   
              ]
        );
        $this->add_control(
            'readmore_color',
            [
                'label'     => esc_html__( 'Read More Color', 'avas-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-read-more a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tx-car-grid-read-more svg' => 'fill: {{VALUE}};',
                ],
               
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'readmore_hover_color',
            [
                'label'     => esc_html__( 'Read More Hover Color', 'avas-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-read-more a:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tx-car-grid-read-more a:hover svg' => 'fill: {{VALUE}};',
                ],
                
                 
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
              [
                   'name'    => 'readmore_typography',
                   'selector'  => '{{WRAPPER}} .tx-car-grid-read-more a',
                  
              ]
        );
        $this->add_control(
            'readmore_icon_size',
            [
                'label' => esc_html__( 'Read More Icon Size', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-read-more i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .tx-car-grid-read-more svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'read_more_icon_indent',
            [
                'label' => esc_html__( 'Icon Spacing', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-read-more i, {{WRAPPER}} .tx-car-grid-read-more svg' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'readmore_padding',
            [
                'label' => esc_html__( 'Read More Padding', 'avas-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-read-more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                
            ]
        );
        $this->add_responsive_control(
            'readmore_margin',
            [
                'label' => esc_html__( 'Read More Margin', 'avas-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .tx-car-grid-read-more' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                
            ]
        );
        $this->end_controls_section();
    
        
    }
    
    public function render_header() {
        $settings = $this->get_settings_for_display();
        $elementor_vp_lg = get_option('elementor_viewport_lg');
        $elementor_vp_md = get_option('elementor_viewport_md');
        $viewport_lg = !empty($elementor_vp_lg) ? $elementor_vp_lg - 1 : 1023;
        $viewport_md = !empty($elementor_vp_md) ? $elementor_vp_md - 1 : 767;
        $this->add_render_attribute(
            [
                'carousel' => [
                    'class' => 'tx-slick-carousel-wrapper slider',
                    'data-settings' => [
                        wp_json_encode(array_filter([
                            "pauseOnHover"              => ("yes" == $settings["pauseOnHover"]) ? true : false,
                            "pauseOnFocus"              => ("yes" == $settings["pauseOnFocus"]) ? true : false,
                            // "arrows"                    => ($settings["tx_slick_arrows"]) ? true: false,
                            "dots"                      => ("yes" == $settings["dots"]) ? true : false,
                            "centerMode"                => ("yes" == $settings["centerMode"]) ? true : false,
                            "infinite"                  => ("yes" == $settings["infinite"]) ? true : false,
                            "vertical"                  => ("yes" == $settings["vertical"]) ? true : false,
                            // "rtl"                    => ("yes" == $settings["rtl"]) ? true : false,
                            "autoplay"                  => ("yes" == $settings["autoplay"]) ? true : false,
                            "autoplaySpeed"             => $settings["autoplaySpeed"],
                            // "centerPadding"          => $settings["centerPadding"],
                            "slidesToShow_desktop"      => $settings["slidesToShow_desktop"],
                            "slidesToShow_tablet"       => $settings["slidesToShow_tablet"],
                            "slidesToShow_mobile"       => $settings["slidesToShow_mobile"],
                            "slidesToScroll"           => $settings["slidesToScroll"],
                        ]))
                    ]
                ]
            ]
        );
    ?>
        
                <div <?php $this->print_render_attribute_string('carousel'); ?>>
    <?php
    }

    public function render_carosuel() {
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute(
            [
                'tx-wrap' => [
                    'class' => [
                        'centerPadding',
                    ]
                ]
            ]
        );
    ?>
    <?php foreach ( $settings['items'] as $index => $item ) : 
        $target_title = $item['link_url']['is_external'] ? '_blank' : '_self';
        $target_readmore = $item['read_more_link']['is_external'] ? '_blank' : '_self';
        $lightbox = 'tx_lightbox' . $index;
        $image = $item['user_image']['url'];

        $this->add_render_attribute(
            [
                $lightbox => [
                    'data-elementor-open-lightbox' => $settings['tx_lightbox'],
                    'data-elementor-lightbox-slideshow' => $this->get_id(),
                    'href' => $image,
                ]
            ]
        );
        ?>
        <div>

            <?php if(!empty($image)): ?>
                <div class="tx-car-grid-image">
                    <?php if('yes' === $settings['tx_lightbox']) : ?>
                            <a <?php $this->print_render_attribute_string( $lightbox ); ?>>
                                <?php Group_Control_Image_Size::print_attachment_image_html( $item, 'image', 'user_image' ); ?>
                            </a>
                    <?php else: ?>
                            <?php Group_Control_Image_Size::print_attachment_image_html( $item, 'image', 'user_image' ); ?>
                    <?php endif; ?>
                </div><!-- tx-car-grid-image -->
            <?php endif; ?>

            <?php
                    if ( 'icon' === $item['ib_select'] && 'yes' === $item['icon_switch'] ) : ?>
                        <span class="tx-car-grid-icon-wrap">
                            <?php Icons_Manager::render_icon( $item['ib_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </span>
            <?php
                    elseif ( 'image' === $item['ib_select'] && 'yes' === $item['icon_switch'] ) : ?>
                        <span class="tx-car-grid-icon-wrap">
                            <img src="<?php echo esc_attr($item['ib_image']['url']); ?>">
                        </span>
            <?php endif; ?>

            <div class="tx-car-grid-content">
            <?php if ( !empty($item['link_url']['url']) ) : ?>
                <a href="<?php echo esc_url( $item['link_url']['url'] ); ?>" target="<?php echo esc_attr($target_title); ?>"><h4 class="tx-car-grid-title"><?php echo wp_kses_post( $item['title'] ); ?></h4></a>
            <?php else : ?>
                <h4 class="tx-car-grid-title"><?php echo wp_kses_post( $item['title'] ); ?></h4>    
            <?php endif; ?>

                <div class="tx-car-grid-description">
                    <?php echo wp_kses_post( $item['description'] ); ?>
                </div>
                
                <?php if ( !empty($item['read_more_link']['url']) && 'yes' === $item['read_more_switch'] ) : ?>
                    <div class="tx-car-grid-read-more">
                        <a href="<?php echo $item['read_more_link']['url']; ?>" target="<?php echo esc_attr($target_readmore); ?>"><?php echo esc_html( $item['read_more_text'] ); ?><?php Icons_Manager::render_icon( $item['read_more_icon'], [ 'aria-hidden' => 'true' ] ); ?></a>
                    </div>
                <?php endif; ?> 
            </div><!-- tx-car-grid-content -->

        </div><!-- tx-car-grid-content -->
    <?php endforeach; ?>
            </div>
    <?php
    }

    public function render() {
        $this->render_header();
        $this->render_carosuel();
        // $this->render_footer();

       
    }

} // class end