<?php
namespace AvasElements\Modules\Switcher\Widgets;

use Elementor\Widget_Base;
use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use AvasElements\TX_Helper;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Switcher extends Widget_Base {

    public function get_name() {
        return 'avas-switcher';
    }

    public function get_title() {
        return esc_html__( 'Avas Switcher', 'avas-core' );
    }

    public function get_icon() {
        return 'eicon-dual-button';
    }

    public function get_categories() {
        return [ 'avas-elements' ];
    }

    public function get_keywords() {
        return ['switcher', 'tab', 'toggle'];
    }

    public function get_style_depends() {
        return ['tx-switcher'];
    }

    public function get_script_depends() {
        return ['tx-switcher'];
    }

	protected function register_controls()
    {
        $this->start_controls_section(
            'tx_switcher_content_section',
            [
                'label' => esc_html__( 'Content', 'avas-core' )
            ]
        );

        $this->start_controls_tabs( 'tx_switcher_content_tabs' );

            $this->start_controls_tab( 'tx_switcher_content_primary', [ 'label' => esc_html__( 'Switch A', 'avas-core' ) ] );

                $this->add_control(
                    'tx_switcher_content_primary_heading',
                    [
                        'label'       => esc_html__( 'Title', 'avas-core' ),
                        'type'        => Controls_Manager::TEXT,
                        'label_block' => true,
                        'default'     => esc_html__( 'Switch A', 'avas-core' )
                    ]
                );

                $this->add_control(
                    'tx_switcher_primary_content_type',
                    [
                        'label'   => esc_html__( 'Content Type', 'avas-core' ),
                        'type'    => Controls_Manager::SELECT,
                        'default' => 'content',
                        'options' => [
                            'content'       => esc_html__( 'Content', 'avas-core' ),
                            'save_template' => esc_html__( 'Elementor Template', 'avas-core' )
                        ]
                    ]
                );

                $this->add_control(
                    'tx_switcher_primary_content_save_template',
                    [
                        'label'     => esc_html__( 'Select Template', 'avas-core' ),
                        'type'      => Controls_Manager::SELECT,
                        'options'   => TX_Helper::get_saved_template( ['page','section','container'] ),
                        'default'   => '-1',
                        'condition' => [
                            'tx_switcher_primary_content_type' => 'save_template'
                        ]
                    ]
                );

                $this->add_control(
                    'tx_switcher_content_primary_content',
                    [
                        'label'       => esc_html__( 'Content', 'avas-core' ),
                        'type'        => Controls_Manager::WYSIWYG,
                        'default'     => esc_html__( 'Lorem ipsum dolor sit amet consectetur adipiscing elit sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam quis nostrud exercitation ullamco laboris nisi ut aliquip exea commodo consequat..', 'avas-core' ),
                        'condition'   => [
                            'tx_switcher_primary_content_type' => 'content'
                        ]
                    ]
                );

            $this->end_controls_tab();

            $this->start_controls_tab( 'tx_switcher_content_secondary', [ 'label' => esc_html__('Switch B', 'avas-core') ] );

                $this->add_control(
                    'tx_switcher_content_secondary_heading',
                    [
                        'label'       => esc_html__( 'Switch B', 'avas-core' ),
                        'type'        => Controls_Manager::TEXT,
                        'label_block' => true,
                        'default'     => esc_html__( 'Switch B', 'avas-core' )
                    ]
                );

                $this->add_control(
                    'tx_switcher_secondary_content_type',
                    [
                        'label'   => esc_html__( 'Content Type', 'avas-core' ),
                        'type'    => Controls_Manager::SELECT,
                        'default' => 'content',
                        'options' => [
                            'content'       => esc_html__( 'Content', 'avas-core' ),
                            'save_template' => esc_html__( 'Elementor Template', 'avas-core' )
                        ]
                    ]
                );

                $this->add_control(
                    'tx_switcher_secondary_content_save_template',
                    [
                        'label'     => esc_html__( 'Select Template', 'avas-core' ),
                        'type'      => Controls_Manager::SELECT,
                        'options'   => TX_Helper::get_saved_template( ['page','section','container'] ),
                        'default'   => '-1',
                        'condition' => [
                            'tx_switcher_secondary_content_type' => 'save_template'
                        ]
                    ]
                );

                $this->add_control(
                    'tx_switcher_content_secondary_content',
                    [
                        'label'       => esc_html__( 'Content', 'avas-core' ),
                        'type'        => Controls_Manager::WYSIWYG,
                        'default'     => esc_html__( 'Semper risus in hendrerit gravida rutrum quisque non tellus celerisque varius morbi enim nunc faucibus a pellentesque sit amet. Accumsan in nisl nisi scelerisque eu ultrices vitae auctor euea.', 'avas-core' ),
                        'condition'   => [
                            'tx_switcher_secondary_content_type' => 'content'
                        ]
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        /**
         * Content Switcher Style
         */
        $this->start_controls_section(
            'tx_switcher_content_heading_style',
            [
                'label' => esc_html__( 'Switcher Heading', 'avas-core' ),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'tx_switcher_content_heading_allignment',
            [
                'label'   => esc_html__( 'Alignment', 'avas-core' ),
                'type'    => Controls_Manager::CHOOSE,
                'default' => 'tx_switecher_center',
                'toggle'  => false,
                'options' => [
                    'tx_switecher_left'   => [
                        'title'        => esc_html__( 'Left', 'avas-core' ),
                        'icon'         => 'eicon-text-align-left'
                    ],
                    'tx_switecher_center' => [
                        'title'        => esc_html__( 'Center', 'avas-core' ),
                        'icon'         => 'eicon-text-align-center'
                    ],
                    'tx_switecher_right'  => [
                        'title'        => esc_html__( 'Right', 'avas-core' ),
                        'icon'         => 'eicon-text-align-right'
                    ],
                    'tx_switecher_justify'  => [
                        'title'        => esc_html__( 'justify', 'avas-core' ),
                        'icon'         => 'eicon-text-align-right'
                    ]
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'tx_switcher_content_heading_background',
                'label' => esc_html__( 'Background', 'avas-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .tx-content-switcher-toggle-inner',
            ]
        );

        $this->add_responsive_control(
            'tx_switcher_content_heading_padding',
            [
                'label'        => esc_html__( 'Padding', 'avas-core' ),
                'type'         => Controls_Manager::DIMENSIONS,
                'size_units'   => [ 'px', '%' ],
                'default'      => [
                    'top'      => '30',
                    'right'    => '0',
                    'bottom'   => '30',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => false
                ],
                'selectors'    => [
                    '{{WRAPPER}} .tx-content-switcher-toggle-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'tx_switcher_content_heading_border',
                'selector' => '{{WRAPPER}} .tx-content-switcher-toggle-inner'
            ]
        );

        $this->add_responsive_control(
            'tx_switcher_content_heading_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'avas-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors'  => [
                    '{{WRAPPER}} .tx-content-switcher-toggle-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );
        
        $this->add_responsive_control(
            'tx_switcher_content_heading_spacing',
            [
                'label'       => esc_html__( 'Heading Spacing', 'avas-core' ),
                'type'        => Controls_Manager::SLIDER,
                'size_units'  => [ 'px', '%' ],
                'range'       => [
                    'px'      => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'default'     => [
                    'unit'    => 'px',
                    'size'    => 20
                ],
                'selectors'   => [
                    '{{WRAPPER}} .tx-content-switcher-toggle-label-1' => 'margin-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .tx-content-switcher-toggle-label-2' => 'margin-left: {{SIZE}}{{UNIT}};'
                ]
            ]
        );
        
        $this->add_responsive_control(
            'tx_switcher_content_heading_bottom_spacing',
            [
                'label'       => esc_html__( 'Bottom Spacing', 'avas-core' ),
                'type'        => Controls_Manager::SLIDER,
                'size_units'  => [ 'px' ],
                'range'       => [
                    'px'      => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'default'     => [
                    'unit'    => 'px',
                    'size'    => 0
                ],
                'selectors'   => [
                    '{{WRAPPER}} .tx-content-switcher-toggle-inner' => 'margin-bottom: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'tx_switcher_content_heading_typography',
                'selector' => '{{WRAPPER}} .tx-content-switcher-toggle-label-1, {{WRAPPER}} .tx-content-switcher-toggle-label-2'
            ]
        );
        
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'tx_switcher_content_heading_shadow',
                'selector' => '{{WRAPPER}} .tx-content-switcher-toggle-inner'
            ]
        );
        
        $this->start_controls_tabs('tx_switcher_content_heading_bottom_tabs');

            $this->start_controls_tab('tx_switcher_content_heading_primary', [ 'label' => esc_html__( 'Primary Heading', 'avas-core' ) ] );

                $this->add_control(
                    'tx_switcher_content_heading_primary_color',
                    [
                        'label'     => esc_html__( 'Text Color', 'avas-core' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .tx-content-switcher-toggle-label-1' => 'color: {{VALUE}};'
                        ]
                    ]
                );
                
            $this->end_controls_tab();

            $this->start_controls_tab('tx_switcher_content_heading_secondary', [ 'label' => esc_html__('Secondary Heading', 'avas-core') ] );

                $this->add_control(
                    'tx_switcher_content_heading_secondary_color',
                    [
                        'label'     => esc_html__( 'Text Color', 'avas-core' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .tx-content-switcher-toggle-label-2' => 'color: {{VALUE}};'
                        ]
                    ]
                );
                
            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        /**
         * Content Switcher Style
         */
        $this->start_controls_section(
            'tx_switcher_content_switch_style',
            [
                'label' => esc_html__( 'Switch Style', 'avas-core' ),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'tx_switcher_content_switch',
            [
                'label'     => esc_html__( 'Switch Background', 'avas-core' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $this->add_responsive_control(
            'tx_switcher_content_switch_width',
            [
                'label'       => esc_html__( 'Width', 'avas-core' ),
                'type'        => Controls_Manager::SLIDER,
                'size_units'  => [ 'px' ],
                'range'       => [
                    'px'      => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'default'     => [
                    'unit'    => 'px',
                    'size'    => 70
                ],
                'selectors'   => [
                    '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .tx-content-switcher-toggle-switch-label' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} input:checked + .tx-content-switcher-toggle-switch-slider:before' => '-webkit-transform: translate( calc( {{SIZE}}{{UNIT}} - {{tx_switcher_content_switch_control_width.size}}{{tx_switcher_content_switch_control_width.unit}} ) , -50%); -ms-transform: translate(calc( {{SIZE}}{{UNIT}} - {{tx_switcher_content_switch_control_width.size}}{{tx_switcher_content_switch_control_width.unit}} ), -50%);transform: translate(calc( {{SIZE}}{{UNIT}} - {{tx_switcher_content_switch_control_width.size}}{{tx_switcher_content_switch_control_width.unit}} ), -50%);'
                ]
            ]
        );
        
        $this->add_responsive_control(
            'tx_switcher_content_switch_height',
            [
                'label'       => esc_html__( 'Height', 'avas-core' ),
                'type'        => Controls_Manager::SLIDER,
                'size_units'  => [ 'px' ],
                'range'       => [
                    'px'      => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'default'     => [
                    'unit'    => 'px',
                    'size'    => 30
                ],
                'selectors'   => [
                    '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider, 
                    {{WRAPPER}} .tx-content-switcher-toggle-switch, 
                    {{WRAPPER}} .tx-content-switcher-toggle-switch-label' => 'height: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'tx_switcher_content_switch_radius',
            [
                'label'      => esc_html__( 'Switch Border Radius', 'avas-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default'    => [
                    'top'    => '30',
                    'right'  => '30',
                    'bottom' => '30',
                    'left'   => '30',
                    'unit'   => 'px'
                ],
                'selectors'  => [
                    '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'tx_switcher_content_switch_shadow',
                'selector' => '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider'
            ]
        );

        $this->start_controls_tabs('tx_switcher_content_switch_tabs');

            $this->start_controls_tab('tx_switcher_content_switch_off', [ 'label' => esc_html__( 'Switch OFF', 'avas-core') ] );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'tx_switcher_content_switch_off_bg_color',
                        'label' => esc_html__( 'Background', 'avas-core' ),
                        'types' => [ 'classic', 'gradient' ],
                        'fields_options'  => [
                            'background'  => [
                                'default' => 'classic'
                            ],
                        ],
                        'selector' => '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider',
                    ]
                );

                $this->add_control(
                    'tx_switcher_content_switch_off_border_style',
                    [
                        'label' => esc_html__( 'Switch Border Style', 'avas-core' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'none',
                        'options' => [
                            'none'   => esc_html__( 'None', 'avas-core' ),
                            'solid'  => esc_html__( 'Solid', 'avas-core' ),
                            'dashed' => esc_html__( 'Dashed', 'avas-core' ),
                            'dotted' => esc_html__( 'Dotted', 'avas-core' ),
                            'double' => esc_html__( 'Double', 'avas-core' ),
                        ],
                        'selectors'   => [
                            '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider' => 'border-style: {{VALUE}};'
                        ]
                    ]
                );
        
                $this->add_responsive_control(
                    'tx_switcher_content_switch_off_border_width',
                    [
                        'label'       => esc_html__( 'Switch Border Width', 'avas-core' ),
                        'type'        => Controls_Manager::SLIDER,
                        'size_units'  => [ 'px' ],
                        'range'       => [
                            'px'      => [
                                'min' => 0,
                                'max' => 10
                            ]
                        ],
                        'default'     => [
                            'unit'    => 'px',
                            'size'    => 0
                        ],
                        'selectors'   => [
                            '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider' => 'border-width: {{SIZE}}{{UNIT}};'
                        ],
                        'condition' => [
                            'tx_switcher_content_switch_off_border_style!' => 'none'
                        ]
                    ]
                );
        
                $this->add_control(
                    'tx_switcher_content_switch_off_border_color',
                    [
                        'label'     => esc_html__( 'Switch Border color', 'avas-core' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider' => 'border-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'tx_switcher_content_switch_off_border_style!' => 'none'
                        ]
                    ]
                );
                
            $this->end_controls_tab();

            $this->start_controls_tab('tx_switcher_content_switch_on', [ 'label' => esc_html__( 'Switch ON', 'avas-core') ] );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'tx_switcher_content_switch_on_bg_color',
                        'label' => esc_html__( 'Background', 'avas-core' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} input:checked + .tx-content-switcher-toggle-switch-slider',
                    ]
                );

                $this->add_control(
                    'tx_switcher_content_switch_on_border_style',
                    [
                        'label' => esc_html__( 'Switch Border Style', 'avas-core' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'none',
                        'options' => [
                            'none' => esc_html__( 'None', 'avas-core' ),
                            'solid'  => esc_html__( 'Solid', 'avas-core' ),
                            'dashed' => esc_html__( 'Dashed', 'avas-core' ),
                            'dotted' => esc_html__( 'Dotted', 'avas-core' ),
                            'double' => esc_html__( 'Double', 'avas-core' ),
                        ],
                        'selectors'   => [
                            '{{WRAPPER}} input:checked + .tx-content-switcher-toggle-switch-slider' => 'border-style: {{VALUE}};'
                        ]
                    ]
                );
        
                $this->add_responsive_control(
                    'tx_switcher_content_switch_on_border_width',
                    [
                        'label'       => esc_html__( 'Switch Border Width', 'avas-core' ),
                        'type'        => Controls_Manager::SLIDER,
                        'size_units'  => [ 'px' ],
                        'range'       => [
                            'px'      => [
                                'min' => 0,
                                'max' => 10
                            ]
                        ],
                        'default'     => [
                            'unit'    => 'px',
                            'size'    => 0
                        ],
                        'selectors'   => [
                            '{{WRAPPER}} input:checked + .tx-content-switcher-toggle-switch-slider' => 'border-width: {{SIZE}}{{UNIT}};'
                        ],
                        'condition' => [
                            'tx_switcher_content_switch_on_border_style!' => 'none'
                        ]
                    ]
                );
        
                $this->add_control(
                    'tx_switcher_content_switch_on_border_color',
                    [
                        'label'     => esc_html__( 'Switch Border color', 'avas-core' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} input:checked + .tx-content-switcher-toggle-switch-slider' => 'border-color: {{VALUE}};'
                        ],
                        'condition' => [
                            'tx_switcher_content_switch_on_border_style!' => 'none'
                        ]
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();
        
        $this->add_control(
            'tx_switcher_content_switch_control',
            [
                'label'     => esc_html__( 'Switch Control', 'avas-core' ),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );
        
        $this->add_responsive_control(
            'tx_switcher_content_switch_control_spacing_with_border',
            [
                'label'       => esc_html__( 'Left & Right Spacing', 'avas-core' ),
                'type'        => Controls_Manager::SLIDER,
                'size_units'  => [ 'px' ],
                'range'       => [
                    'px'      => [
                        'min' => 0,
                        'max' => 20
                    ]
                ],
                'default'     => [
                    'unit'    => 'px',
                    'size'    => 5
                ],
                'selectors'   => [
                    '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider:before'                 => 'margin-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} input:checked + .tx-content-switcher-toggle-switch-slider:before' => 'margin-left: calc( -{{SIZE}}{{UNIT}} - ( {{tx_switcher_content_switch_on_border_width.size}}{{tx_switcher_content_switch_on_border_width.unit}} * 2 ) ) ;',
                    '{{WRAPPER}} input:checked + .tx-content-switcher-toggle-switch-slider:before' => 'margin-left: calc( -{{SIZE}}{{UNIT}} - ( {{tx_switcher_content_switch_off_border_width.size}}{{tx_switcher_content_switch_off_border_width.unit}} * 2 ) ) ;'
                ],
                'condition' => [
                    'tx_switcher_content_switch_off_border_style!' => 'none',
                    'tx_switcher_content_switch_on_border_style!' => 'none',
                ]
            ]
        );

        $this->add_responsive_control(
            'tx_switcher_content_switch_control_spacing_without_border',
            [
                'label'       => esc_html__( 'Left & Right Spacing', 'avas-core' ),
                'type'        => Controls_Manager::SLIDER,
                'size_units'  => [ 'px' ],
                'range'       => [
                    'px'      => [
                        'min' => 0,
                        'max' => 20
                    ]
                ],
                'default'     => [
                    'unit'    => 'px',
                    'size'    => 5
                ],
                'selectors'   => [
                    '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider:before'                 => 'margin-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} input:checked + .tx-content-switcher-toggle-switch-slider:before' => 'margin-left: -{{SIZE}}{{UNIT}} ;',
                ],
                'condition' => [
                    'tx_switcher_content_switch_off_border_style' => 'none',
                    'tx_switcher_content_switch_on_border_style' => 'none'
                ]
            ]
        );

        $this->add_responsive_control(
            'tx_switcher_content_switch_control_radius',
            [
                'label'      => esc_html__( 'Switch Control Border Radius', 'avas-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default'    => [
                    'top'    => '30',
                    'right'  => '30',
                    'bottom' => '30',
                    'left'   => '30',
                    'unit'   => 'px'
                ],
                'selectors'  => [
                    '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->start_controls_tabs( 'tx_switcher_content_switch_control_tabs' );

            $this->start_controls_tab( 'tx_switcher_content_switch_control_off', [ 'label' => esc_html__( 'Switch Control OFF', 'avas-core' ) ] );

                $this->add_responsive_control(
                    'tx_switcher_content_switch_control_width',
                    [
                        'label'       => esc_html__( 'Width', 'avas-core' ),
                        'type'        => Controls_Manager::SLIDER,
                        'size_units'  => [ 'px' ],
                        'range'       => [
                            'px'      => [
                                'min' => 0,
                                'max' => 50
                            ]
                        ],
                        'default'     => [
                            'unit'    => 'px',
                            'size'    => 27
                        ],
                        'selectors'   => [
                            '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider:before' => 'width: {{SIZE}}{{UNIT}};'
                        ]
                    ]
                );
                
                $this->add_responsive_control(
                    'tx_switcher_content_switch_control_height',
                    [
                        'label'       => esc_html__( 'Height', 'avas-core' ),
                        'type'        => Controls_Manager::SLIDER,
                        'size_units'  => [ 'px' ],
                        'range'       => [
                            'px'      => [
                                'min' => 0,
                                'max' => 50
                            ]
                        ],
                        'default'     => [
                            'unit'    => 'px',
                            'size'    => 27
                        ],
                        'selectors'   => [
                            '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider:before' => 'height: {{SIZE}}{{UNIT}};'
                        ]
                    ]
                );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'tx_switcher_content_switch_off_switch_control_color',
                        'label' => esc_html__( 'Background', 'avas-core' ),
                        'types' => [ 'classic', 'gradient' ],
                        'fields_options'  => [
                            'background'  => [
                                'default' => 'classic'
                            ],
                            'color'       => [
                                'default' => '#ffffff',
                            ]
                        ],
                        'selector' => '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider:before',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name'     => 'tx_switcher_content_switch_off_control_border',
                        'selector' => '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider:before'
                    ]
                );

                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name'     => 'tx_switcher_content_switch_on_control_shadow',
                        'selector' => '{{WRAPPER}} .tx-content-switcher-toggle-switch-slider:before'
                    ]
                );
                
            $this->end_controls_tab();

            $this->start_controls_tab( 'tx_switcher_content_switch_control_on', [ 'label' => esc_html__( 'Switch Control ON', 'avas-core' ) ] );

                $this->add_responsive_control(
                    'tx_switcher_content_switch_on_control_width',
                    [
                        'label'       => esc_html__( 'Width', 'avas-core' ),
                        'type'        => Controls_Manager::SLIDER,
                        'size_units'  => [ 'px' ],
                        'range'       => [
                            'px'      => [
                                'min' => 0,
                                'max' => 50
                            ]
                        ],
                        'default'     => [
                            'unit'    => 'px',
                            'size'    => 27
                        ],
                        'selectors'   => [
                            '{{WRAPPER}} input:checked + .tx-content-switcher-toggle-switch-slider:before' => 'width: {{SIZE}}{{UNIT}};'
                        ]
                    ]
                );
                
                $this->add_responsive_control(
                    'tx_switcher_content_switch_on_control_height',
                    [
                        'label'       => esc_html__( 'Height', 'avas-core' ),
                        'type'        => Controls_Manager::SLIDER,
                        'size_units'  => [ 'px' ],
                        'range'       => [
                            'px'      => [
                                'min' => 0,
                                'max' => 50
                            ]
                        ],
                        'default'     => [
                            'unit'    => 'px',
                            'size'    => 27
                        ],
                        'selectors'   => [
                            '{{WRAPPER}} input:checked + .tx-content-switcher-toggle-switch-slider:before' => 'height: {{SIZE}}{{UNIT}};'
                        ]
                    ]
                );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'tx_switcher_content_switch_on_switch_control_color',
                        'label' => esc_html__( 'Background', 'avas-core' ),
                        'types' => [ 'classic', 'gradient' ],
                        'fields_options'  => [
                            'background'  => [
                                'default' => 'classic'
                            ],
                            'color'       => [
                                'default' => '#ffffff',
                            ]
                        ],
                        'selector' => '{{WRAPPER}} input:checked + .tx-content-switcher-toggle-switch-slider:before',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name'     => 'tx_switcher_content_switch_on_control_border',
                        'selector' => '{{WRAPPER}} input:checked + .tx-content-switcher-toggle-switch-slider:before'
                    ]
                );

                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name'     => 'tx_switcher_content_switch_off_control_shadow',
                        'selector' => '{{WRAPPER}} input:checked + .tx-content-switcher-toggle-switch-slider:before'
                    ]
                );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        /**
         * Content Switcher Content
         */
        $this->start_controls_section(
            'tx_switcher_content_main_contant_style',
            [
                'label' => esc_html__( 'Switcher Content', 'avas-core' ),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'tx_switcher_main_contant_background',
                'label'    => esc_html__( 'Background', 'avas-core' ),
                'types'    => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .tx-content-switcher-content-wrap'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'tx_switcher_main_contant_typography',
                'selector' => '{{WRAPPER}} .tx-content-switcher-content-wrap'
            ]
        );
        
        $this->add_control(
            'tx_switcher_main_contant_text_color',
            [
                'label'     => esc_html__( 'Text Color', 'avas-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-content-switcher-content-wrap' => 'color: {{VALUE}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'tx_switcher_main_contant_padding',
            [
                'label'        => esc_html__( 'Padding', 'avas-core' ),
                'type'         => Controls_Manager::DIMENSIONS,
                'size_units'   => [ 'px', '%' ],
                'default'      => [
                    'top'      => '20',
                    'right'    => '20',
                    'bottom'   => '20',
                    'left'     => '20',
                    'unit'     => 'px'
                ],
                'selectors'    => [
                    '{{WRAPPER}} .tx-content-switcher-content-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'tx_switcher_main_contant_border',
                'selector' => '{{WRAPPER}} .tx-content-switcher-content-wrap'
            ]
        );
        
        $this->add_responsive_control(
            'tx_switcher_main_contant_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'avas-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors'  => [
                    '{{WRAPPER}} .tx-content-switcher-content-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'tx_switcher_main_contant_shadow',
                'selector' => '{{WRAPPER}} .tx-content-switcher-content-wrap'
            ]
        );

        $this->end_controls_section();
    }

    

    protected function render() {
        $settings = $this->get_settings_for_display();
        $id          = $this->get_id();
        $input_id    = 'tx-switcher-input-' . $id;
        $label_a_id  = 'tx-switcher-label-a-' . $id;
        $label_b_id  = 'tx-switcher-label-b-' . $id;
        $aria_label  = sprintf(
            esc_html__('Toggle between %1$s and %2$s', 'avas-core'),
            $settings['tx_switcher_content_primary_heading'],
            $settings['tx_switcher_content_secondary_heading']
        );
        ?>
        <div class="tx-content-switcher-wrapper">
            <div class="tx-content-switcher-toggle <?php echo esc_attr( $settings['tx_switcher_content_heading_allignment'] ); ?>">
                <div class="tx-content-switcher-toggle-inner">

                    <div class="tx-content-switcher-toggle-label-1" id="<?php echo esc_attr($label_a_id); ?>">
                        <?php echo esc_html( $settings['tx_switcher_content_primary_heading'] ); ?>
                    </div>

                    <div class="tx-content-switcher-toggle-switch">
                        <input
                          class="input"
                          type="checkbox"
                          id="<?php echo esc_attr($input_id); ?>"
                          role="switch"
                          aria-checked="false"
                          aria-labelledby="<?php echo esc_attr($label_a_id . ' ' . $label_b_id); ?>"
                          aria-label="<?php echo esc_attr($aria_label); ?>"
                        />
                        <label class="tx-content-switcher-toggle-switch-label" for="<?php echo esc_attr($input_id); ?>">
                          <span class="tx-content-switcher-toggle-switch-slider" aria-hidden="true"></span>
                          <span class="tx-sr-only"><?php echo esc_html($aria_label); ?></span>
                        </label>
                    </div>


                    <div class="tx-content-switcher-toggle-label-2" id="<?php echo esc_attr($label_b_id); ?>">
                        <?php echo esc_html( $settings['tx_switcher_content_secondary_heading'] ); ?>
                    </div>
                </div>
            </div>
            <div class="tx-content-switcher-content-wrap">
                <div class="tx-content-switcher-primary-wrap">
                    <?php if( 'content' === $settings['tx_switcher_primary_content_type'] ) : ?>
                        <?php echo wp_kses_post( $settings['tx_switcher_content_primary_content'] ); ?>
                    <?php endif; ?>
                    <?php if( 'save_template' === $settings['tx_switcher_primary_content_type'] ) : ?>
                        <?php echo Plugin::$instance->frontend->get_builder_content_for_display( wp_kses_post( $settings['tx_switcher_primary_content_save_template'] ) ); ?>
                    <?php endif; ?>
                </div>
                <div class="tx-content-switcher-secondary-wrap">
                    <?php if( 'content' === $settings['tx_switcher_secondary_content_type'] ) : ?>
                        <?php echo wp_kses_post( $settings['tx_switcher_content_secondary_content'] ); ?>
                    <?php endif; ?>
                    <?php if( 'save_template' === $settings['tx_switcher_secondary_content_type'] ) : ?>
                        <?php echo Plugin::$instance->frontend->get_builder_content_for_display( wp_kses_post( $settings['tx_switcher_secondary_content_save_template'] ) ); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
    }
}