!( function( $, elementor ) {

	'use strict';

	var initScrollUpExtension = function() {
	    
		var $scrollUpButtons = $('.tx-scroll-up-ext-btn');

	    if ( ! $scrollUpButtons.length ) {
	    	return;
	    }

	    $scrollUpButtons.each(function() {
	    	var $scrollUp = $(this);
	    	
	    	// Check if we're in Elementor edit mode
		    var isEditMode = typeof elementorFrontend !== 'undefined' && elementorFrontend.isEditMode();

		    // Always show button in edit mode
		    if (isEditMode) {
		    	$scrollUp.addClass("tx-scroll-up-ext-show tx-editor-mode");
		    	return; // Don't attach scroll events in edit mode
		    }

		    // Throttle scroll event for better performance
		    var scrollTimeout;
		    var isVisible = false;

			$(window).on('scroll', function() {
				if (scrollTimeout) {
					return;
				}
				
				scrollTimeout = setTimeout(function() {
					var threshold = $scrollUp.data('threshold') || 300;
					var shouldShow = $(window).scrollTop() > threshold;
					
					if (shouldShow && !isVisible) {
						$scrollUp.addClass("tx-scroll-up-ext-show");
						isVisible = true;
					} else if (!shouldShow && isVisible) {
						$scrollUp.removeClass("tx-scroll-up-ext-show");
						isVisible = false;
					}
					
					scrollTimeout = null;
				}, 100);
			});

		    $scrollUp.on('click', function(event){
		    	event.preventDefault();
		    	$('html, body').animate({
	                scrollTop: 0
	            }, 400);
	            return false;
		    });

		    // Keyboard accessibility
		    $scrollUp.on('keydown', function(event) {
		    	if (event.key === 'Enter' || event.key === ' ') {
		    		event.preventDefault();
		    		$(this).trigger('click');
		    	}
		    });
	    });

	};

	// Initialize on page load
	$(window).on('load', function() {
		initScrollUpExtension();
	});

	// Re-initialize in Elementor editor
	if ( typeof elementorFrontend !== 'undefined' ) {
		jQuery(window).on('elementor/frontend/init', function() {
			elementorFrontend.hooks.addAction( 'frontend/element_ready/global', function() {
				initScrollUpExtension();
			});
		});
	}

}( jQuery, window.elementorFrontend ) );