<?php
/**
* 
* @package tx
* @author theme-x
* @link https://x-theme.com/
* ===================
* 	Functions file
* ===================
*/

/* ---------------------------------------------------------
  Shortcode support for contact form 7
------------------------------------------------------------ */
function tx_shortcodes_in_cf7( $form ) {
$form = do_shortcode( $form );
return $form;
}
add_filter( 'wpcf7_form_elements', 'tx_shortcodes_in_cf7' );

// Enabled Shortcode for widget
add_filter('widget_text', 'do_shortcode');


/* ---------------------------------------------------------
  remove welcome screen after activate plugin
------------------------------------------------------------ */
add_action( 'admin_init', function() {
  if ( did_action( 'elementor/loaded' ) ) {
    remove_action( 'admin_init', [ \Elementor\Plugin::$instance->admin, 'maybe_redirect_to_getting_started' ] );
  }

  // Kill the rev slider welcome redirect transient
    if ( get_transient('_revslider_welcome_screen_activation_redirect') ) {
        delete_transient('_revslider_welcome_screen_activation_redirect');
    }

}, 1 );


/* ---------------------------------------------------------
  remove Activate Demo Mode in pluigin
------------------------------------------------------------ */
    function tx_DemoModeLink() { 
        if ( class_exists('ReduxFrameworkPlugin') ) {
            remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2 );
        }
        if ( class_exists('ReduxFrameworkPlugin') ) {
            remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );    
        }
    }
    add_action('init', 'tx_DemoModeLink');

/* ---------------------------------------------------------
  remove Redux menu from admin > Settings > Redux
------------------------------------------------------------ */
  add_action( 'admin_menu', 'tx_remove_submenu_page', 999 );
  function tx_remove_submenu_page() {
    remove_submenu_page( 'options-general.php', 'redux-framework');
  }

/* ---------------------------------------------------------
  Title Limit
------------------------------------------------------------ */

/**
 * Echo a trimmed, safe post title.
 *
 * @param int      $n    Max characters.
 * @param int|null $post Post ID (optional).
 */
function tx_title( $n = 50, $post = null ) {
    $post = get_post( $post );
    if ( ! $post ) {
        return;
    }

    $n     = absint( $n );
    $title = get_the_title( $post );

    // Trim safely (handles HTML entities/UTF-8) and append ellipsis if trimmed.
    $trimmed = wp_html_excerpt( wp_strip_all_tags( $title ), $n, '…' );

    echo esc_html( $trimmed ); // Escape on output (HTML context).
}

/* ---------------------------------------------------------
  video embed for video post format
------------------------------------------------------------ */

if(!function_exists('tx_post_video_link')) :
  add_action( 'tx_post_video_link', 'tx_post_video_link' );
  function tx_post_video_link() {
    global $post;
    $post_video_link = get_post_meta( $post->ID, 'post_link', true );
    if(!empty($post_video_link)) :
    global $wp_embed;
    $post_embed = $wp_embed->run_shortcode('[embed width="1140"]'.$post_video_link.'[/embed]');
    echo wp_kses_post($post_embed);
    endif;
  }
endif;

/* ---------------------------------------------------------
  video embed for portfolio post type
------------------------------------------------------------ */
if(!function_exists('tx_portfolio_video_link')) :
  add_action( 'tx_portfolio_video_link', 'tx_portfolio_video_link' );
  function tx_portfolio_video_link() {
    global $post;
    $post_video_link = get_post_meta( $post->ID, 'port_vid_link', true );
    if(!empty($post_video_link)) :
    global $wp_embed;
    $post_embed = $wp_embed->run_shortcode('[embed width="1140"]'.$post_video_link.'[/embed]');
    echo wp_kses_post($post_embed);
    endif;
  }
endif;

/* ---------------------------------------------------------
  Theme update notice
------------------------------------------------------------ */
function tx_theme_update_notice() {

  empty(wp_get_theme()->parent()) ? $vers = wp_get_theme()->Version : $vers = wp_get_theme()->parent()->Version;

  if($vers < 6.3) :
 ?>
  <script>
    jQuery(document).ready(function($){'use strict';      
      alert("<?php echo esc_html__('To work the theme properly please update the theme and clear cache from everywhere such as browser, cache plugin, CDN, etc.', 'avas-core'); ?>");
    });
  </script>
<?php 
  endif;
}
add_action('admin_head', 'tx_theme_update_notice');

/* ---------------------------------------------------------
  Remove Query Strings From Static Resources
------------------------------------------------------------ */
if(!function_exists('tx_remove_script_version')) :
  function tx_remove_script_version( $src ) {
    $parts = explode( '?ver', $src );
          return $parts[0];
  }
endif;

if(!function_exists('tx_emove_query_strings')) :
  function tx_emove_query_strings() {
    global $tx;
    if( isset($tx['remove_query_strings']) ) :
      if($tx['remove_query_strings'] == 1) :
        add_filter( 'script_loader_src', 'tx_remove_script_version', 15, 1 );
        add_filter( 'style_loader_src', 'tx_remove_script_version', 15, 1 );
      endif;
    endif;
  }
  add_action( 'init', 'tx_emove_query_strings' );

endif;

/* ---------------------------------------------------------
    Disable emojis in WordPress
------------------------------------------------------------ */
if(!function_exists('tx_disable_emojis')) :
add_action( 'init', 'tx_disable_emojis' );
function tx_disable_emojis() {
  global $tx;
  if( isset($tx['remove_wordpress_emoji']) ) :
    if($tx['remove_wordpress_emoji'] == 1) :
      remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
      remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
      remove_action( 'wp_print_styles', 'wp_enqueue_emoji_styles' );
      remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
      remove_action( 'admin_print_styles', 'wp_enqueue_emoji_styles' );
      remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );
      remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
      add_filter( 'tiny_mce_plugins', 'disable_emojis_tinymce' );
    endif;
  endif;
}
endif;

if(!function_exists('disable_emojis_tinymce')) :
function disable_emojis_tinymce( $plugins ) {
  if ( is_array( $plugins ) ) {
    return array_diff( $plugins, array( 'wpemoji' ) );
  } else {
    return array();
  }
}
endif;

// Polylang plugin support
if ( class_exists( 'Polylang' ) ) {
  function tx_polylang_register_string( $translated_text, $text, $domain ) {
    if ( function_exists( 'pll_register_string' ) ) {
      if ( $domain == 'avas-core' ) {
          pll_register_string( 'avas-core', $text, 'Avas Core' );
        }
      }
      return $translated_text;
  }
  add_filter( 'gettext', 'tx_polylang_register_string', 10, 3 );
}


/* ---------------------------------------------------------
  WPML Elementor widgets support
------------------------------------------------------------ */
add_filter('wpml_elementor_widgets_to_translate', function ($widgets) {

    if (!class_exists('\Elementor\Plugin')) {
        return $widgets; // Exit if Elementor is not installed
    }

    $elementor = \Elementor\Plugin::instance();
    $widget_manager = $elementor->widgets_manager;

    foreach ($widget_manager->get_widget_types() as $widget) {
        if (strpos($widget->get_name(), 'avas-') !== false) { // Target only 'avas-' widgets

            $widget_name = $widget->get_name();
            $widget_fields = [];
            $repeater_fields = [];

            foreach ($widget->get_controls() as $control_id => $control) {
                if (!empty($control['type'])) {
                    $editor_type = 'LINE'; // Default WPML editor type

                    // Map WPML editor type based on control type
                    if (in_array($control['type'], ['textarea', 'wysiwyg'])) {
                        $editor_type = 'VISUAL';
                    } elseif (in_array($control['type'], ['url', 'media'])) {
                        $editor_type = 'LINK';
                    }

                    // Handle Repeater Fields
                    if ($control['type'] === 'repeater' && !empty($control['fields'])) {
                        $repeater_fields[$control_id] = [
                            'fields' => [],
                        ];

                        foreach ($control['fields'] as $repeater_field) {
                            if (!empty($repeater_field['name']) && !empty($repeater_field['type'])) {
                                $repeater_editor_type = 'LINE';

                                if (in_array($repeater_field['type'], ['textarea', 'wysiwyg'])) {
                                    $repeater_editor_type = 'VISUAL';
                                } elseif (in_array($repeater_field['type'], ['url', 'media'])) {
                                    $repeater_editor_type = 'LINK';
                                }

                                $repeater_fields[$control_id]['fields'][] = [
                                    'field'       => $repeater_field['name'],
                                    'type'        => 'String',
                                    'editor_type' => $repeater_editor_type,
                                ];
                            }
                        }
                    } else {
                        // Add normal widget fields
                        $widget_fields[] = [
                            'field'       => $control_id,
                            'type'        => 'String',
                            'editor_type' => $editor_type,
                        ];
                    }
                }
            }

            // Register widget with WPML, including repeaters
            if (!empty($widget_fields) || !empty($repeater_fields)) {
                $widgets[$widget_name] = [
                    'conditions' => ['widgetType' => $widget_name],
                    'fields'     => $widget_fields,
                ];

                if (!empty($repeater_fields)) {
                    $widgets[$widget_name]['fields-in-item'] = [];

                    foreach ($repeater_fields as $repeater_id => $repeater_data) {
                        $widgets[$widget_name]['fields-in-item'][] = [
                            'items_of' => $repeater_id,
                            'fields'   => $repeater_data['fields'],
                        ];
                    }
                }
            }
        }
    }

    return $widgets;
});



/* ---------------------------------------------------------
  EOF
------------------------------------------------------------ */

