<?php

namespace AvasElements\Modules\BackTop;

use AvasElements\Base\Module_Base;
use Elementor\Controls_Manager;
use Elementor\Element_Base;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Icons_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class Module extends Module_Base {

    public function __construct() {

        // Register controls
        // add_action( 'elementor/element/container/section_layout/after_section_end', [ $this, 'register_controls' ], 10 );
        // add_action( 'elementor/element/section/section_advanced/after_section_end', [ $this, 'register_controls' ], 10 );
        add_action( 'elementor/element/common/section_custom_css_pro/after_section_end', [ $this, 'register_controls' ], 10 );
        
        // Render output
        add_action( 'elementor/frontend/container/before_render', [ $this, 'before_render' ], 10 );
        add_action( 'elementor/frontend/section/before_render', [ $this, 'before_render' ], 10 );
        add_action( 'elementor/frontend/widget/before_render', [ $this, 'before_render' ], 10 );

        // add_action('elementor/element/common/section_advanced/after_section_end', [$this,'register_controls'], 10, 2);
        // add_action('elementor/element/container/section_advanced/after_section_end', [$this,'register_controls'], 10, 2);
        add_action('elementor/element/section/section_advanced/after_section_end', [$this,'register_controls'], 10, 2);
       
        add_action('elementor/element/column/section_advanced/after_section_end',  [$this,'register_controls'], 10, 2);
        add_action('elementor/element/container/section_layout/after_section_end', [$this,'register_controls'], 10, 2);
        add_action('elementor/element/common/_section_style/after_section_end', [$this,'register_controls'], 10, 2);
        
        // Enqueue scripts and styles
        // add_action('wp_enqueue_scripts', [$this,'register_assets']);


        // Always register + enqueue for site and editor preview
        add_action('wp_enqueue_scripts',                  [$this, 'register_assets'], 20);
        add_action('elementor/frontend/after_enqueue_styles', [$this, 'register_assets'], 20);
        add_action('elementor/preview/enqueue_styles',    [$this, 'register_assets'], 20);
        add_action('elementor/preview/enqueue_scripts',   [$this, 'register_assets'], 20);


       



    }

    public function get_name() {
		return 'avas-back-top';
	}

	public function get_style_depends() {
        return [ 'tx-back-top' ];
    }
    public function get_script_depends() {
        return ['tx-back-top'];
    }

    public function register_assets() {
        wp_register_style( 'tx-back-top', TX_PLUGIN_URL . '/assets/css/modules/back-top/back-top.min.css' );
        wp_register_script( 'tx-back-top', TX_PLUGIN_URL . '/assets/js/modules/back-top/back-top.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
        wp_enqueue_style('tx-back-top');
        wp_enqueue_script('tx-back-top');

    }

    public function register_controls( $element ) {
        
        $element->start_controls_section(
            'tx_scroll_up_section',
            [
                'label' => esc_html__( 'Avas Scroll Up', 'avas-core' ),
                'tab'   => Controls_Manager::TAB_ADVANCED,
            ]
        );

        $element->add_control(
            'tx_scroll_up_enable',
            [
                'label'        => esc_html__( 'Enable Scroll Up Button', 'avas-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Yes', 'avas-core' ),
                'label_off'    => esc_html__( 'No', 'avas-core' ),
                'return_value' => 'yes',
                'default'      => '',
            ]
        );

        $element->add_control(
            'tx_scroll_up_text',
            [
                'label'       => esc_html__( 'Button Text', 'avas-core' ),
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [ 'active' => true ],
                'default'     => esc_html__( 'Scroll Up', 'avas-core' ),
                'condition'   => [
                    'tx_scroll_up_enable' => 'yes',
                ],
            ]
        );

        $element->add_control(
            'tx_scroll_up_icon',
            [
                'label'       => esc_html__( 'Button Icon', 'avas-core' ),
                'type'        => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-angle-up',
                    'library' => 'fa-solid',
                ],
                'skin' => 'inline',
                'label_block' => false,
                'condition'   => [
                    'tx_scroll_up_enable' => 'yes',
                ],
            ]
        );

        $element->add_control(
            'tx_scroll_up_icon_align',
            [
                'label'   => esc_html__( 'Icon Position', 'avas-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'right',
                'options' => [
                    'left'  => esc_html__( 'Before', 'avas-core' ),
                    'right' => esc_html__( 'After', 'avas-core' ),
                ],
                'condition' => [
                    'tx_scroll_up_enable' => 'yes',
                    'tx_scroll_up_icon[value]!' => '',
                ],
            ]
        );

        $element->add_responsive_control(
            'tx_scroll_up_icon_size',
            [
                'label'   => esc_html__( 'Icon Size', 'avas-core' ),
                'type'    => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 100,
                    ],
                ],
                'condition' => [
                    'tx_scroll_up_enable' => 'yes',
                    'tx_scroll_up_icon[value]!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-scroll-up-ext-btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .tx-scroll-up-ext-btn svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $element->add_responsive_control(
            'tx_scroll_up_icon_indent',
            [
                'label'   => esc_html__( 'Icon Spacing', 'avas-core' ),
                'type'    => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 8,
                ],
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                ],
                'condition' => [
                    'tx_scroll_up_enable' => 'yes',
                    'tx_scroll_up_icon[value]!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-scroll-up-ext-btn .tx-scroll-up-ext-icon-right' => is_rtl() ? 'margin-right: {{SIZE}}{{UNIT}};' : 'margin-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .tx-scroll-up-ext-btn .tx-scroll-up-ext-icon-left'  => is_rtl() ? 'margin-left: {{SIZE}}{{UNIT}};' : 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $element->add_control(
            'tx_scroll_up_threshold',
            [
                'label' => esc_html__( 'Scroll Threshold (px)', 'avas-core' ),
                'type' => Controls_Manager::NUMBER,
                'default' => 300,
                'min' => 0,
                'max' => 2000,
                'description' => esc_html__( 'Show button after scrolling this many pixels', 'avas-core' ),
                'condition'   => [
                    'tx_scroll_up_enable' => 'yes',
                ],
            ]
        );

        $element->add_responsive_control(
            'tx_scroll_up_position',
            [
                'label' => esc_html__( 'Position', 'avas-core' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'tx-nav-top' => [
                        'title' => esc_html__( 'Top', 'avas-core' ),
                        'icon' => 'eicon-v-align-top',
                    ],
                    'tx-nav-middle' => [
                        'title' => esc_html__( 'Middle', 'avas-core' ),
                        'icon' => 'eicon-v-align-middle',
                    ],
                    'tx-nav-bottom' => [
                        'title' => esc_html__( 'Bottom', 'avas-core' ),
                        'icon' => 'eicon-v-align-bottom',
                    ],
                ],
                'toggle' => false,
                'default' => 'tx-nav-bottom',
                'condition'   => [
                    'tx_scroll_up_enable' => 'yes',
                ],
            ]
        );

        $element->add_responsive_control(
            'tx_scroll_up_alignment',
            [
                'label' => esc_html__( 'Alignment', 'avas-core' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'tx-nav-left' => [
                        'title' => esc_html__( 'Left', 'avas-core' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'tx-nav-center' => [
                        'title' => esc_html__( 'Center', 'avas-core' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'tx-nav-right' => [
                        'title' => esc_html__( 'Right', 'avas-core' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'toggle' => false,
                'default' => 'tx-nav-right',
                'condition'   => [
                    'tx_scroll_up_enable' => 'yes',
                ],
            ]
        );

        $element->add_responsive_control(
            'tx_scroll_up_spacing_y',
            [
                'label' => esc_html__( 'Offset Y', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'default' => [
                    'size' => 30,
                ],
                'range' => [
                    'px' => [
                        'max' => 200,
                    ],
                ],
                'condition' => [
                    'tx_scroll_up_enable' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-scroll-up-ext-wrap.tx-nav-top' => 'top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .tx-scroll-up-ext-wrap.tx-nav-bottom' => 'bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $element->add_responsive_control(
            'tx_scroll_up_spacing_x',
            [
                'label' => esc_html__( 'Offset X', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'default' => [
                    'size' => 30,
                ],
                'range' => [
                    'px' => [
                        'max' => 200,
                    ],
                ],
                'condition' => [
                    'tx_scroll_up_enable' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-scroll-up-ext-wrap.tx-nav-left' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .tx-scroll-up-ext-wrap.tx-nav-right' => 'right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $element->add_responsive_control(
            'tx_scroll_up_zindex',
            [
                'label'     => esc_html__('Z-Index', 'avas-core'),
                'type'      => Controls_Manager::NUMBER,
                'min' => -1000,
                'max' => 9999,
                'default' => 999,
                'condition'   => [
                    'tx_scroll_up_enable' => 'yes',
                ],
                'selectors'  => [
                    '{{WRAPPER}} .tx-scroll-up-ext-wrap' => 'z-index: {{VALUE}};',
                ],
            ]
        );

        $element->end_controls_section();

        // Style Section
        $element->start_controls_section(
            'tx_scroll_up_style_section',
            [
                'label' => esc_html__( 'Avas Scroll Up Style', 'avas-core' ),
                'tab'   => Controls_Manager::TAB_ADVANCED,
                'condition'   => [
                    'tx_scroll_up_enable' => 'yes',
                ],
            ]
        );

        $element->start_controls_tabs( 'tx_scroll_up_style_tabs' );

        $element->start_controls_tab(
            'tx_scroll_up_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'avas-core' ),
            ]
        );

        $element->add_control(
            'tx_scroll_up_color',
            [
                'label'     => esc_html__( 'Color', 'avas-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-scroll-up-ext-btn' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tx-scroll-up-ext-btn svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'tx_scroll_up_background',
                'label' => esc_html__( 'Background', 'avas-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .tx-scroll-up-ext-btn',
            ]
        );

        $element->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'tx_scroll_up_border',
                'label'       => esc_html__( 'Border', 'avas-core' ),
                'selector'    => '{{WRAPPER}} .tx-scroll-up-ext-btn',
                'separator'   => 'before',
            ]
        );

        $element->add_responsive_control(
            'tx_scroll_up_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'avas-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .tx-scroll-up-ext-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $element->add_responsive_control(
            'tx_scroll_up_padding',
            [
                'label'      => esc_html__( 'Padding', 'avas-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .tx-scroll-up-ext-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'tx_scroll_up_typography',
                'label'    => esc_html__( 'Typography', 'avas-core' ),
                'selector' => '{{WRAPPER}} .tx-scroll-up-ext-btn',
            ]
        );

        $element->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'tx_scroll_up_box_shadow',
                'selector' => '{{WRAPPER}} .tx-scroll-up-ext-btn',
            ]
        );

        $element->end_controls_tab();

        $element->start_controls_tab(
            'tx_scroll_up_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'avas-core' ),
            ]
        );

        $element->add_control(
            'tx_scroll_up_hover_color',
            [
                'label'     => esc_html__( 'Color', 'avas-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-scroll-up-ext-btn:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tx-scroll-up-ext-btn:hover svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'tx_scroll_up_hover_background',
                'label' => esc_html__( 'Background', 'avas-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .tx-scroll-up-ext-btn:hover',
            ]
        );

        $element->add_control(
            'tx_scroll_up_hover_border_color',
            [
                'label'     => esc_html__( 'Border Color', 'avas-core' ),
                'type'      => Controls_Manager::COLOR,
                'condition' => [
                    'tx_scroll_up_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-scroll-up-ext-btn:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'tx_scroll_up_hover_box_shadow',
                'selector' => '{{WRAPPER}} .tx-scroll-up-ext-btn:hover',
            ]
        );

        $element->end_controls_tab();

        $element->end_controls_tabs();

        $element->end_controls_section();
    }

    public function before_render( $element ) {
        $settings = $element->get_settings_for_display();

        if ( isset( $settings['tx_scroll_up_enable'] ) && 'yes' === $settings['tx_scroll_up_enable'] ) {
            
            $position = isset( $settings['tx_scroll_up_position'] ) ? $settings['tx_scroll_up_position'] : 'tx-nav-bottom';
            $alignment = isset( $settings['tx_scroll_up_alignment'] ) ? $settings['tx_scroll_up_alignment'] : 'tx-nav-right';
            $threshold = isset( $settings['tx_scroll_up_threshold'] ) ? $settings['tx_scroll_up_threshold'] : 300;
            
            ?>
            <div class="tx-scroll-up-ext-wrap <?php echo esc_attr( $position . ' ' . $alignment ); ?>">
                <button class="tx-scroll-up-ext-btn" 
                        aria-label="<?php echo esc_attr__('Scroll to top', 'avas-core'); ?>"
                        data-threshold="<?php echo esc_attr( $threshold ); ?>">
                    <span class="tx-scroll-up-ext-content">
                        <?php if ( ! empty( $settings['tx_scroll_up_icon']['value'] ) ) : ?>
                        <span class="tx-scroll-up-ext-icon-<?php echo esc_attr( $settings['tx_scroll_up_icon_align'] ); ?>">
                            <?php Icons_Manager::render_icon( $settings['tx_scroll_up_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </span>
                        <?php endif; ?>
                        <?php if ( ! empty( $settings['tx_scroll_up_text'] ) ) : ?>
                        <span class="tx-scroll-up-ext-text"><?php echo esc_html( $settings['tx_scroll_up_text'] ); ?></span>
                        <?php endif; ?>
                    </span>
                </button>
            </div>
            <?php
        }
    }

}
