<?php
namespace AvasElements\Modules\HighlightText\Widgets;

use elementor\Widget_Base;
use elementor\Controls_Manager;
use elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HighlightText extends Widget_Base {

	public function get_name() {
		return 'avas-highlight-text';
	}

	public function get_title() {
		return esc_html__( 'Avas Highlight Text', 'avas-core' );
	}

	public function get_icon() {
		return 'eicon-text';
	}

	public function get_categories() {
		return [ 'avas-elements' ];
	}

	public function get_keywords() {
		return [ 'highlight', 'text', 'scrolling text' ];
	}

	public function get_style_depends() { 
		return [ 'tx-highlight-text' ]; 
	}
	public function get_script_depends() {
		return [ 'tx-highlight-text']; 
	}

	protected function register_controls() {

    $this->start_controls_section(
    	'tx_highlight_text_content',
    	[
    		'label'=>esc_html__('Content','avas-core')
    	]
    );
    $this->add_control('tx_highlight_text',
    	[
	      'label'=>esc_html__('Text','avas-core'),
	      'type'=>Controls_Manager::TEXTAREA,
	      'dynamic' => [
						'active' => true,
					],
	      'default'=>"We believe in pushing digital boundaries and exploring new creative horizons. You can trust our experienced team to guide you through every stage of the process and bring your vision to life."
	    ]
		);
    $this->add_control('tx_highlight_color',
    	[
	      'label'=>esc_html__('Highlight Color','avas-core'),
	      'type'=>Controls_Manager::COLOR,
	      'default'=>'#111111'
	    ]
		);
    $this->add_control('tx_muted_color',
    	[
	      'label'=>esc_html__('Muted Color','avas-core'),
	      'type'=>Controls_Manager::COLOR,
	      'default'=>'rgba(182,182,182,0.25)'
	    ]
		);
    $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'tx_highlight_text_typography',
				'selector'  => '{{WRAPPER}} .tx-highlight-text',
			]
		);
		$this->add_responsive_control(
            'tx_highlight_animation_speed',
            [
                'label' => esc_html__( 'Speed', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_unit' => [ 's' ],        
                'range' => [
                    's' => [
                        'step' => 0.1,
                        'max' => 1,
                    ],

                ],
                'default' => [
                    'unit' => 's',
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-highlight-text-fill' => 'transition: background-size {{SIZE}}{{UNIT}} ease-out;',
                ],       

            ]
    );
    $this->end_controls_section();
  }

  protected function render() {
    $s = $this->get_settings_for_display();
    $html = nl2br( wp_kses_post( $s['tx_highlight_text'] ) );
    printf(
      '<div class="tx-highlight-text" style="--tx-active:%1$s;--tx-muted:%2$s">%3$s</div>',
      esc_attr($s['tx_highlight_color'] ?: '#111'),
      esc_attr($s['tx_muted_color'] ?: 'rgba(182,182,182,.25)'),
      $html
    );
  }
}