<?php
namespace AvasElements\Modules\ServiceList\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use elementor\Icons_Manager;
use Elementor\Utils;
use elementor\Group_Control_Border;
use elementor\Group_Control_Background;
use elementor\Group_Control_Box_Shadow;
use AvasElements\TX_Helper;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ServiceList extends Widget_Base {

    public function get_name() {
        return 'avas-service-list';
    }

    public function get_title() {
        return esc_html__( 'Avas Service List', 'avas-core' );
    }

    public function get_icon() {
        return 'eicon-editor-list-ol';
    }

    public function get_style_depends() {
        return ['tx-service-list'];
    }

    public function get_categories() {
        return [ 'avas-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'tx_sl_settings',
            [
                'label' => esc_html__( 'Settings', 'avas-core' )
            ]
        );

        $this->add_control(
          'tx_sl_source',
            [
            'label'         => esc_html__( 'Source', 'avas-core' ),
                'type'          => Controls_Manager::SELECT,
                'default'       => 'custom',
                'label_block'   => false,
                'options'       => [
                    'custom'    => esc_html__( 'Custom', 'avas-core' ),
                    'dynamic'   => esc_html__( 'Dynamic', 'avas-core' ),
                ],
            ]
        );
        $this->add_control(
            'post_type',
            [
                'label' => esc_html__( 'Post Type', 'avas-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => TX_Helper::get_all_post_types(),
                'default' => 'post',
                'condition' => [
                    'tx_sl_source' => 'dynamic'
                ]

            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'image',
                'default' => 'tx-m-thumb',
                'condition' => [
                    'tx_sl_source' => 'dynamic'
                ]

            ]
        );
        $this->add_control(
            'tax_query',
            [
                'label' => esc_html__( 'Categories', 'avas-core' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => TX_Helper::get_all_categories(),
               'condition' => [
                    'tx_sl_source' => 'dynamic'
                ]
            ]
        );
        $this->add_control(
            'number_of_posts',
            [
                'label' => esc_html__( 'Number of Posts', 'avas-core' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '4',
                'condition' => [
                    'tx_sl_source' => 'dynamic'
                ]
            ]
        );
        $this->add_control(
            'offset',
            [
                'label' => esc_html__( 'Offset', 'avas-core' ),
                'type' => Controls_Manager::NUMBER,
                'condition' => [
                    'tx_sl_source' => 'dynamic'
                ]
            ]
        );
        $this->add_control(
            'order',
            [
                'label' => esc_html__('Order', 'avas-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'ASC' => esc_html__('Ascending', 'avas-core'),
                    'DESC' => esc_html__('Descending', 'avas-core'),
                ),
                'default' => 'DESC',
                'condition' => [
                    'tx_sl_source' => 'dynamic'
                ]
            ]
        );
        $this->add_control(
            'post_sortby',
            [
                'label'     => esc_html__( 'Post sort by', 'avas-core' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'latestpost'      => esc_html__( 'Latest posts', 'avas-core' ),
                        'popularposts'    => esc_html__( 'Popular posts', 'avas-core' ),
                        'mostdiscussed'    => esc_html__( 'Most discussed', 'avas-core' ),
                    ],
                    'condition' => [
                    'tx_sl_source' => 'dynamic'
                ],
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('Order By', 'avas-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'none' => esc_html__('No order', 'avas-core'),
                    'ID' => esc_html__('Post ID', 'avas-core'),
                    'author' => esc_html__('Author', 'avas-core'),
                    'title' => esc_html__('Title', 'avas-core'),
                    'date' => esc_html__('Published date', 'avas-core'),
                    'modified' => esc_html__('Modified date', 'avas-core'),
                    'parent' => esc_html__('By parent', 'avas-core'),
                    'rand' => esc_html__('Random order', 'avas-core'),
                    'comment_count' => esc_html__('Comment count', 'avas-core'),
                    'menu_order' => esc_html__('Menu order', 'avas-core'),
                    'post__in' => esc_html__('By include order', 'avas-core'),
                ),
                'default' => 'date',
                'condition' => [
                    'tx_sl_source' => 'dynamic',
                    'post_sortby' => ['latestpost'],
                ]
            ]
        );
        $this->add_control(
            'sl_date_dynamic',
            [
                'label' => esc_html__( 'Show Date?', 'avas-core' ),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
                 'condition' => [
                    'tx_sl_source' => 'dynamic'
                ]
            ]
        );
        $this->add_control(
            'sl_icon_dynamic',
            [
                'label' => esc_html__( 'Icon', 'avas-core' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-arrow-right',
                    'library' => 'solid',
                ],
                'condition' => [
                    'tx_sl_source' => 'dynamic'
                ]
            ]
        );

        $repeater = new Repeater();
        
        $repeater->add_control(
            'tx_sl_title', 
            [
                'label' => esc_html__('Title', 'avas-core'),
                'default' => esc_html__('Tristique sapien accum','avas-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'tx_sl_title_link',
            [
                'label' => esc_html__('Title Link URL', 'avas-core'),
                'type'        => Controls_Manager::URL,
                'dynamic'     => [ 'active' => true ],
                'placeholder' => 'http://your-site.com',
            ]
        );
        $repeater->add_control(
            'tx_sl_subtitle', 
            [
                'label' => esc_html__('Subtitle', 'avas-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Ligula ultrices','avas-core'),
            ]
        );
        $repeater->add_control(
            'tx_sl_image',
            [
                'library' => 'image',
                'label' => esc_html__('Image.', 'avas-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                    ],
                'label_block' => true,
            ]

        );
        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'image',
                'default' => 'full',
            ]
        );
        $repeater->add_control(
            'tx_sl_desc', 
            [
                'type' => Controls_Manager::WYSIWYG,
                "label" => esc_html__("Text", 'avas-core'),
                "default" => esc_html__("Lorem ipsum dolor sit amet consectetur adipiscing elit sed do eiusmod tempor incididunt ut labore et dolore magna aliquat enim ad minim veniam quis.", 'avas-core'),
                'show_label' => true,
            ]
        );

        $repeater->add_control(
            'sl_icon',
            [
                'label' => esc_html__( 'Icon', 'avas-core' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-arrow-right',
                    'library' => 'solid',
                ],
            ]
        );

        $repeater->add_control(
            'sl_icon_link',
            [
                'label' => esc_html__('Icon Link URL', 'avas-core'),
                'type'        => Controls_Manager::URL,
                'dynamic'     => [ 'active' => true ],
                'placeholder' => 'http://your-site.com',
            ]
        );

        $this->add_control(
            'features',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'condition' => [
                    'tx_sl_source' => 'custom'
                ],
                'default' => [
                    [
                        'tx_sl_title' => 'Design',
                        'tx_sl_subtitle' => '01.',
                        'tx_sl_desc' => 'Lorem ipsum dolor sit amet consectetur adipiscing elit sed do eiusmod tempor incididunt ut labore et dolore magna aliquat enim ad minim veniam quis.',
                    ],
                    [
                        'tx_sl_title' => 'Marketing',
                        'tx_sl_subtitle' => '02.',
                        'tx_sl_desc' => 'Nostrud exercitation ullamco laboris nisi ut aliquip avas-core ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse.',
                    ],
                    [
                        'tx_sl_title' => 'Website',
                        'tx_sl_subtitle' => '03.',
                        'tx_sl_desc' => 'Cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim.',
                    ],
                    [
                        'tx_sl_title' => 'Branding',
                        'tx_sl_subtitle' => '04.',
                        'tx_sl_desc' => 'Suspendisse potenti Phasellus euismod libero in neque molestie et elementum libero maximus. Etiam in enim vestibulum suscipit sem quis molestie nibh.',
                    ],
                ],

                'title_field' => '{{{tx_sl_title}}}',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'sl_style',
            [
                'label' => esc_html__('Styles', 'avas-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'sl_column_gap',
            [
                'label' => esc_html__( 'Gap', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    '%' => [
                        'max' => 100,
                    ],
                    'px' => [
                        'max' => 1500,
                    ],
                ],
                'size_units' => ['%', 'px'],
                'default' => [
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-text-content' => 'grid-column-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sl_title_width',
            [
                'label' => esc_html__( 'Title Width', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    '%' => [
                        'max' => 100,
                    ],
                    'px' => [
                        'max' => 1500,
                    ],
                ],
                'size_units' => ['%', 'px'],
                'default' => [
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-title' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sl_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'avas-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-text-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sl_padding',
            [
                'label' => esc_html__( 'Padding', 'avas-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-text-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sl_margin',
            [
                'label' => esc_html__( 'Margin', 'avas-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-text-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sl_image_size',
            [
                'label' => esc_html__( 'Image Size', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    '%' => [
                        'max' => 100,
                    ],
                    'px' => [
                        'max' => 1500,
                    ],
                ],
                'size_units' => ['%', 'px'],
                'default' => [
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-image-content' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before'
            ]
        );
        $this->add_responsive_control(
            'sl_image_spacing',
            [
                'label' => esc_html__( 'Image Spacing', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    '%' => [
                        'max' => 100,
                    ],
                    'px' => [
                        'max' => 1500,
                    ],
                ],
                'size_units' => ['%', 'px'],
                'default' => [
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-image-content' => 'right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sl_icon_size',
            [
                'label' => esc_html__( 'Icon Size', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 150,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .tx-serv-list-icon svg' => 'width: {{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}}',
                ],
                'separator' => 'before'
            ]
        );
        $this->add_responsive_control(
            'sl_icon_rotate',
            [
                'label' => esc_html__( 'Icon Rotate', 'avas-core' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'deg' => [
                        'min' => -360,
                        'max' => 360,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-icon i, {{WRAPPER}} .tx-serv-list-icon svg' => 'transform: rotate({{SIZE}}{{UNIT}});',
                    
                ],
            ]
        );
        $this->add_responsive_control(
            'sl_icon_padding',
            [
                'label' => esc_html__( 'Icon Padding', 'avas-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'sl_icon_border',
                'selector'    =>    '{{WRAPPER}} .tx-serv-list-icon'
            ]
        );
        $this->add_responsive_control(
            'sl_icon_border_radius',
            [
                'label' => esc_html__( 'Icon Border Radius', 'avas-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'after'
            ]
        );
        $this->start_controls_tabs( 'sl_style_tabs' );
        $this->start_controls_tab(
            'sl_normal',
            [
                'label' => esc_html__( 'Normal', 'avas-core' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'sl_bg',
                'selector'  => '{{WRAPPER}} .tx-serv-list-text-content',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'sl_border',
                'selector'    =>    '{{WRAPPER}} .tx-serv-list-text-content'
            ]
        );
        
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'sl_shadow',
                'selector' => '{{WRAPPER}} .tx-serv-list-text-content'
            ]
        );

        $this->add_control(
            'sl_title_color',
            [
                'label' => esc_html__('Title Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-title' => 'color: {{VALUE}};',
                ],
                'separator' => 'before'
            ]
        );
        

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sl_title_typography',
                'selector' => '{{WRAPPER}} .tx-serv-list-title',
            ]
        );
        $this->add_control(
            'sl_subtitle_color',
            [
                'label' => esc_html__('Sub Title', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-subtitle' => 'color: {{VALUE}};',
                ],
                'separator' => 'before',
                'condition' => [
                    'tx_sl_source' => 'custom'
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sl_subtitle_typography',
                'selector' => '{{WRAPPER}} .tx-serv-list-subtitle',
                'condition' => [
                    'tx_sl_source' => 'custom'
                ]
            ]
        );
        $this->add_control(
            'sl_date_color',
            [
                'label' => esc_html__('Date Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-subtitle' => 'color: {{VALUE}};',
                ],
                'separator' => 'before',
                'condition' => [
                    'tx_sl_source' => 'dynamic',
                    'sl_date_dynamic' => 'yes'
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sl_date_typography',
                'selector' => '{{WRAPPER}} .tx-serv-list-subtitle',
                'condition' => [
                    'tx_sl_source' => 'dynamic'
                ]
            ]
        );
        $this->add_control(
            'sl_desc_color',
            [
                'label' => esc_html__('Description Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-desc' => 'color: {{VALUE}};',
                ],
                'separator' => 'before'
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sl_desc_typography',
                'selector' => '{{WRAPPER}} .tx-serv-list-desc',
            ]
        );
        $this->add_control(
            'sl_icon_color',
            [
                'label' => esc_html__('Icon Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tx-serv-list-icon svg' => 'fill: {{VALUE}};',
                ],
                'separator' => 'before'
            ]
        );
        $this->add_control(
            'sl_icon_bg_color',
            [
                'label' => esc_html__('Icon Background Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'sl_icon_brd_color',
            [
                'label' => esc_html__('Icon Border Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-icon' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'sl_hover',
            [
                'label' => esc_html__( 'Hover', 'avas-core' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'sl_hov_bg',
                'selector'  => '{{WRAPPER}} .tx-serv-list-wrapper:hover .tx-serv-list-text-content',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'sl_hov_border',
                'selector'    =>    '{{WRAPPER}} .tx-serv-list-wrapper:hover .tx-serv-list-text-content'
            ]
        );
        
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'sl_hov_shadow',
                'selector' => '{{WRAPPER}} .tx-serv-list-wrapper:hover .tx-serv-list-text-content'
            ]
        );

        $this->add_control(
            'sl_title_hov_color',
            [
                'label' => esc_html__('Title Hover Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-title:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'sl_icon_hov_color',
            [
                'label' => esc_html__('Icon Hover Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} a.tx-serv-list-icon:hover, {{WRAPPER}} .tx-serv-list-icon:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} a.tx-serv-list-icon svg:hover, {{WRAPPER}} .tx-serv-list-icon svg:hover' => 'fill: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'sl_icon_bg_hov_color',
            [
                'label' => esc_html__('Icon Background Hover Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-serv-list-icon:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'sl_icon_bord_hov_color',
            [
                'label' => esc_html__('Icon Border Hover Color', 'avas-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} a.tx-serv-list-icon:hover, {{WRAPPER}} .tx-serv-list-icon:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
        $showposts = '';
        $query_args = TX_Helper::setup_query_args($settings, $showposts);
        $post_query = new \WP_Query( $query_args );

        $read_more_label = function($title){
            return esc_attr( sprintf( __( 'Read more about %s', 'avas-core' ), wp_strip_all_tags($title) ) );
        };
        $visit_label = function($title){
            return esc_attr( sprintf( __( 'Visit %s', 'avas-core' ), wp_strip_all_tags($title) ) );
        };
        ?>

        <?php if( $settings['tx_sl_source'] == 'dynamic' ) : ?>
        <div class="tx-serv-list-container">
            <?php
            if ($post_query->have_posts()) : 
                while ($post_query->have_posts()) : $post_query->the_post();
            ?>

            <div class="tx-serv-list-wrapper">
                <div class="tx-serv-list-image-content">
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="zoom-thumb featured-thumb">
                        <a href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title() ); ?>" aria-label="<?php echo $read_more_label( get_the_title() ); ?>">
                            <img src="<?php echo wp_get_attachment_image_url(get_post_thumbnail_id(), $settings['image_size'])?>" alt="<?php echo esc_attr( get_the_title() ); ?>">
                        </a>
                        </div><!-- zoom-thumb featured-thumb -->
                    <?php endif; ?>
                </div><!-- tx-serv-list-image-content -->

                <div class="tx-serv-list-text-content">
                    <?php if ( isset( $settings['sl_date_dynamic'] ) && 'yes' === $settings['sl_date_dynamic'] ) : ?>
                        <h3 class="tx-serv-list-subtitle"><?php echo get_the_date(); ?></h3>
                    <?php endif; ?>
                    <h2 class="tx-serv-list-title"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo the_title(); ?></a></h2>
                    <div class="tx-serv-list-desc"><?php echo the_excerpt();?></div>
                    <div class="tx-serv-list-icon"><a href="<?php echo esc_url( get_permalink() ); ?>" aria-label="<?php echo $read_more_label( get_the_title() ); ?>"><?php Icons_Manager::render_icon( $settings['sl_icon_dynamic'], [ 'aria-hidden' => 'true' ] ); ?></a></div>
                </div><!-- tx-serv-list-text-content -->
            </div><!-- tx-serv-list-wrapper -->
        <?php endwhile;
             wp_reset_postdata();
            endif;
        ?>
        </div><!-- tx-serv-list-container -->
        <?php endif; ?>

        <?php if( $settings['tx_sl_source'] == 'custom'  ) : ?>
        <div class="tx-serv-list-container">
            <?php foreach ($settings['features'] as $feature): 
                $target = $feature['tx_sl_title_link']['is_external'] ? '_blank' : '_self';
                $target_icon = $feature['sl_icon_link']['is_external'] ? '_blank' : '_self';
                $title_text = $feature['tx_sl_title'];
                $label_for_title = $visit_label( $title_text );
            ?>

                <div class="tx-serv-list-wrapper">
                    <div class="tx-serv-list-image-content">
                        <?php if (!empty($feature['tx_sl_image'])) :
                            echo Group_Control_Image_Size::get_attachment_image_html( $feature, 'image', 'tx_sl_image' );
                        endif; ?>
                    </div><!-- tx-serv-list-image-content -->

                    <div class="tx-serv-list-text-content">
                        <?php if(!empty($feature['tx_sl_subtitle'])): ?>
                            <h3 class="tx-serv-list-subtitle"><?php echo esc_html($feature['tx_sl_subtitle']) ?></h3>
                        <?php endif; ?>
                        <?php if(!empty($feature['tx_sl_title_link']['url'])) : ?>
                        <h2 class="tx-serv-list-title"><a href="<?php echo esc_url( $feature['tx_sl_title_link']['url'] ); ?>" target="<?php echo esc_attr($target); ?>" aria-label="<?php echo $label_for_title; ?>"><?php echo esc_html($feature['tx_sl_title']); ?></a></h2>
                        <?php else: ?>
                        <h2 class="tx-serv-list-title"><?php echo esc_html($feature['tx_sl_title']); ?></h2>
                        <?php endif; ?>
                        <?php if(!empty($feature['tx_sl_desc'])): ?>
                            <div class="tx-serv-list-desc"><?php echo $this->parse_text_editor($feature['tx_sl_desc']); ?></div>
                        <?php endif; ?>
                        <?php if(!empty($feature['sl_icon_link']['url'])) : ?>
                            <a href="<?php echo esc_url( $feature['sl_icon_link']['url'] ); ?>" target="<?php echo esc_attr($target_icon); ?>" aria-label="<?php echo $visit_label( $title_text ); ?>">
                            <div class="tx-serv-list-icon"><?php Icons_Manager::render_icon( $feature['sl_icon'], [ 'aria-hidden' => 'true' ] ); ?></div>
                            </a>
                        <?php else: ?>
                            <div class="tx-serv-list-icon"><?php Icons_Manager::render_icon( $feature['sl_icon'], [ 'aria-hidden' => 'true' ] ); ?></div>
                        <?php endif; ?>
                    </div><!-- tx-serv-list-text-content -->
                </div><!-- tx-serv-list-wrapper -->

            <?php endforeach; ?>
        </div><!-- tx-serv-list-container -->
        <?php endif; ?>


<?php   } // render()
} // class 
