(function ($) {
  // Run once on every Owl instance you use
$('.owl-carousel')
  // fire on all the key Owl lifecycle events
  .on('initialized.owl.carousel refreshed.owl.carousel changed.owl.carousel translated.owl.carousel', function () {
    var $wrap = $(this);

    // 1) NAV BUTTONS
    $wrap.find('.owl-nav button').each(function () {
      var $btn = $(this);
      // Remove any bad or redundant roles
      $btn.removeAttr('role');

      // Ensure button semantics & labels
      $btn.attr('type', 'button'); // avoid form submits
      if ($btn.hasClass('owl-prev')) $btn.attr('aria-label', 'Previous slide');
      if ($btn.hasClass('owl-next')) $btn.attr('aria-label', 'Next slide');

      // Hide decorative icons from AT
      $btn.find('i, svg').attr({'aria-hidden': 'true', 'focusable': 'false'});

      // Also strip stray roles from icon wrappers if any
      $btn.find('[role]').removeAttr('role');
    });

    // Keep aria-disabled in sync with Owl's disabled state
    $wrap.find('.owl-prev').attr('aria-disabled', $wrap.find('.owl-prev').hasClass('disabled'));
    $wrap.find('.owl-next').attr('aria-disabled', $wrap.find('.owl-next').hasClass('disabled'));

    // 2) DOTS
    $wrap.find('.owl-dots button').each(function (i) {
      $(this)
        .removeAttr('role')         // ensure it's just a button
        .attr('type', 'button')
        .attr('aria-label', 'Go to slide ' + (i + 1));
    });
    // Mark current dot
    $wrap.find('.owl-dots .active button').attr('aria-current', 'true')
      .end().find('.owl-dots :not(.active) button').removeAttr('aria-current');
  });
})(jQuery);