!(function($){
	'use strict';

	var widgetCircleProgressBar = function( $scope, $ ) {
		var cpb = $scope.find('.tx-circle-progress-bar');

		if ( cpb.length > 0 ) {
			cpb.each(function() {
				var $el = $(this);

				// Avoid duplicate
				if ($el.data('started')) return;

				$el.data('started', false);

				// Init
				$el.asPieProgress({
					namespace: 'pie_progress'
				});

				function triggerIfVisible() {
					if ($el.data('started')) return;

					var rect = $el[0].getBoundingClientRect();
					var isVisible = rect.top < window.innerHeight && rect.bottom > 0;

					if (isVisible) {
						$el.data('started', true);
						$el.asPieProgress('start');
					}
				}

				$(window).on('scroll resize load', triggerIfVisible);
				triggerIfVisible();
			});
		}
	};

	$( window ).on( 'elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/avas-circle-progress-bar.default', widgetCircleProgressBar );
	});

})( jQuery );