!( function( $, elementor ) {

	'use strict';

	var widgetScrollUp = function( $scope, $ ) {
	    
		var $scrollUp = $scope.find('.tx-scroll-up-btn');

	    if ( ! $scrollUp.length ) {
	    	return;
	    }

	    // Check if we're in Elementor edit mode
	    var isEditMode = elementorFrontend.isEditMode();

	    // Always show button in edit mode
	    if (isEditMode) {
	    	$scrollUp.addClass("tx-scroll-up tx-editor-mode");
	    	return; // Don't attach scroll events in edit mode
	    }

	    // Throttle scroll event for better performance
	    var scrollTimeout;
	    var isVisible = false;

		$(window).on('scroll', function() {
			if (scrollTimeout) {
				return;
			}
			
			scrollTimeout = setTimeout(function() {
				var threshold = $scrollUp.data('threshold') || 300;
				var shouldShow = $(window).scrollTop() > threshold;
				
				if (shouldShow && !isVisible) {
					$scrollUp.addClass("tx-scroll-up");
					isVisible = true;
				} else if (!shouldShow && isVisible) {
					$scrollUp.removeClass("tx-scroll-up");
					isVisible = false;
				}
				
				scrollTimeout = null;
			}, 100);
		});

	    $scrollUp.on('click', function(event){
	    	event.preventDefault();
	    	$('html, body').animate({
                scrollTop: 0
            }, 400);
            return false;
	    });

	    // Keyboard accessibility
	    $scrollUp.on('keydown', function(event) {
	    	if (event.key === 'Enter' || event.key === ' ') {
	    		event.preventDefault();
	    		$(this).trigger('click');
	    	}
	    });

	};

	jQuery(window).on('elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/avas-scroll-up.default', widgetScrollUp );
	});

}( jQuery, window.elementorFrontend ) );