<?php
namespace AvasElements;
use AvasElements\TX_Helper;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TX_Load {

	private static $_instance;

	private $_modules_manager;

	public static function elementor() {
		return \Elementor\Plugin::$instance;
	}

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}
	
	private function _includes() {
		require TX_PLUGIN_PATH . 'inc/modules-manager.php';
		require TX_PLUGIN_PATH . 'inc/helper.php';
		require TX_PLUGIN_PATH . 'inc/icons.php';
		require TX_PLUGIN_PATH . 'inc/swiper.php';
		require TX_PLUGIN_PATH . 'inc/tx-ajax-search.php';
		
	}

	public function autoload( $class ) {
		if ( 0 !== strpos( $class, __NAMESPACE__ ) ) {
			return;
		}

		$has_class_alias = isset( $this->classes_aliases[ $class ] );

		// Backward Compatibility: Save old class name for set an alias after the new class is loaded
		if ( $has_class_alias ) {
			$class_alias_name = $this->classes_aliases[ $class ];
			$class_to_load = $class_alias_name;
		} else {
			$class_to_load = $class;
		}

		if ( ! class_exists( $class_to_load ) ) {
			$filename = strtolower(
				preg_replace(
					[ '/^' . __NAMESPACE__ . '\\\/', '/([a-z])([A-Z])/', '/_/', '/\\\/' ],
					[ '', '$1-$2', '-', DIRECTORY_SEPARATOR ],
					$class_to_load
				)
			);
			$filename = TX_PLUGIN_PATH . $filename . '.php';

			if ( is_readable( $filename ) ) {
				include( $filename );
			}
		}

		if ( $has_class_alias ) {
			class_alias( $class_alias_name, $class );
		}
	}

	public function elementor_init() {
		$this->_modules_manager = new ModuleManager();

		// Add element category in panel
		$category = \Elementor\Plugin::instance();
		$category->elements_manager->add_category(
			'avas-elements', // category name
			[
				'title' => esc_html__( 'Avas Widgets', 'avas-core' ), 
				'icon' => 'eicon-navigator',
			],
			1
		);
	}

	private function setup_hooks() {
		add_action( 'elementor/init', [ $this, 'elementor_init' ] );

		// Register Widget Styles
		add_action( 'elementor/frontend/after_enqueue_styles', [ $this, 'widget_styles' ] );
		
		// Register Widget Scripts
		add_action( 'elementor/frontend/before_register_scripts', [ $this, 'widget_scripts' ] );

	}

	public function widget_styles() {

		wp_register_style( 'animation', TX_PLUGIN_URL . '/assets/css/animation.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-accordion', TX_PLUGIN_URL . '/assets/css/widgets/accordion/accordion.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'vegas', TX_PLUGIN_URL . '/assets/css/vegas.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-slick', TX_PLUGIN_URL . '/assets/css/widgets/slick-carousel/slick.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'slick-theme', TX_PLUGIN_URL . '/assets/css/widgets/slick-carousel/slick-theme.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-banner', TX_PLUGIN_URL . '/assets/css/widgets/banner/banner.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-image-swap', TX_PLUGIN_URL . '/assets/css/widgets/image-swap/image-swap.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-info-link', TX_PLUGIN_URL . '/assets/css/widgets/info-link/info-link.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-progress-bar', TX_PLUGIN_URL . '/assets/css/widgets/progress-bar/progress-bar.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-circle-text', TX_PLUGIN_URL . '/assets/css/widgets/circle-text/circle-text.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'PrismJS', TX_PLUGIN_URL . '/assets/css/widgets/source-code/prism.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-offer-banner', TX_PLUGIN_URL . '/assets/css/widgets/ar-product-viewer/ar-product-viewer.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-source-code', TX_PLUGIN_URL . '/assets/css/widgets/source-code/source-code.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-mailchimp', TX_PLUGIN_URL . '/assets/css/widgets/mailchimp/mailchimp.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-scroll-up', TX_PLUGIN_URL . '/assets/css/widgets/scroll-up/scroll-up.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-slider', TX_PLUGIN_URL . '/assets/css/widgets/slider/slider.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-sticky-section', TX_PLUGIN_URL . '/assets/css/widgets/sticky-section/sticky-section.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-switcher', TX_PLUGIN_URL . '/assets/css/widgets/switcher/switcher.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-post-slider', TX_PLUGIN_URL . '/assets/css/widgets/post-slider/post-slider.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-search-plus', TX_PLUGIN_URL . '/assets/css/widgets/search-plus/search-plus.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-table', TX_PLUGIN_URL . '/assets/css/widgets/table/table.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-popup', TX_PLUGIN_URL . '/assets/css/widgets/popup/popup.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-timeline', TX_PLUGIN_URL . '/assets/css/widgets/timeline/timeline.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-testimonial', TX_PLUGIN_URL . '/assets/css/widgets/testimonial/testimonial.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-team-alter', TX_PLUGIN_URL . '/assets/css/widgets/team-alter/team-alter.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-portfolio-plus', TX_PLUGIN_URL . '/assets/css/widgets/portfolio-plus/portfolio-plus.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-price-table', TX_PLUGIN_URL . '/assets/css/widgets/price-table/price-table.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-price-menu', TX_PLUGIN_URL . '/assets/css/widgets/price-menu/price-menu.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-post-masonry-grid', TX_PLUGIN_URL . '/assets/css/widgets/post-masonry-grid/post-masonry-grid.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-post-list', TX_PLUGIN_URL . '/assets/css/widgets/post-list/post-list.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-post-grid', TX_PLUGIN_URL . '/assets/css/widgets/post-grid/post-grid.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-post-alter', TX_PLUGIN_URL . '/assets/css/widgets/post-alter/post-alter.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-onepage-nav', TX_PLUGIN_URL . '/assets/css/widgets/onepage-nav/onepage-nav.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-instagram', TX_PLUGIN_URL . '/assets/css/widgets/instagram/instagram.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-image-hover', TX_PLUGIN_URL . '/assets/css/widgets/image-hover/image-hover.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-image-comparison', TX_PLUGIN_URL . '/assets/css/widgets/image-comparison/image-comparison.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-icon-box', TX_PLUGIN_URL . '/assets/css/widgets/icon-box/icon-box.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-hotspot', TX_PLUGIN_URL . '/assets/css/widgets/hotspot/hotspot.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-gravity-form', TX_PLUGIN_URL . '/assets/css/widgets/gravity-form/gravity-form.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-gallery', TX_PLUGIN_URL . '/assets/css/widgets/gallery/gallery.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-flipster', TX_PLUGIN_URL . '/assets/css/widgets/flipster/flipster.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-flipbox', TX_PLUGIN_URL . '/assets/css/widgets/flipbox/flipbox.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-features', TX_PLUGIN_URL . '/assets/css/widgets/features/features.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-events-calendar', TX_PLUGIN_URL . '/assets/css/widgets/events-calendar/events-calendar.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-dual-button', TX_PLUGIN_URL . '/assets/css/widgets/dual-button/dual-button.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-animated-shape', TX_PLUGIN_URL . '/assets/css/widgets/animated-shape/animated-shape.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-button', TX_PLUGIN_URL . '/assets/css/widgets/button/button.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-call-to-action', TX_PLUGIN_URL . '/assets/css/widgets/call-to-action/call-to-action.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-circle-info', TX_PLUGIN_URL . '/assets/css/widgets/circle-info/circle-info.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-circle-progress-bar', TX_PLUGIN_URL . '/assets/css/widgets/circle-progress-bar/circle-progress-bar.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-counter', TX_PLUGIN_URL . '/assets/css/widgets/counter/counter.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-coupon', TX_PLUGIN_URL . '/assets/css/widgets/coupon/coupon.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-chart', TX_PLUGIN_URL . '/assets/css/widgets/chart/chart.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-countdown', TX_PLUGIN_URL . '/assets/css/widgets/countdown/countdown.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-image-box', TX_PLUGIN_URL . '/assets/css/widgets/image-box/image-box.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-logo', TX_PLUGIN_URL . '/assets/css/widgets/logo/logo.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-marquee', TX_PLUGIN_URL . '/assets/css/widgets/marquee/marquee.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-news-ticker', TX_PLUGIN_URL . '/assets/css/widgets/news-ticker/news-ticker.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-services', TX_PLUGIN_URL . '/assets/css/widgets/services/services.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-service-list', TX_PLUGIN_URL . '/assets/css/widgets/service-list/service-list.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-background-clip-text', TX_PLUGIN_URL . '/assets/css/widgets/background-clip-text/background-clip-text.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-courses', TX_PLUGIN_URL . '/assets/css/widgets/courses/courses.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-post-carousel', TX_PLUGIN_URL . '/assets/css/widgets/post-carousel/post-carousel.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-sprite-spin', TX_PLUGIN_URL . '/assets/css/widgets/sprite-spin/sprite-spin.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-menu', TX_PLUGIN_URL . '/assets/css/widgets/menu/menu.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-heading', TX_PLUGIN_URL . '/assets/css/widgets/heading/heading.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-background-slider', TX_PLUGIN_URL . '/assets/css/widgets/background-slider/background-slider.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-breadcrumbs', TX_PLUGIN_URL . '/assets/css/widgets/breadcrumbs/breadcrumbs.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-profile', TX_PLUGIN_URL . '/assets/css/widgets/profile/profile.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'avas-woocommerce', TX_PLUGIN_URL . '/assets/css/widgets/woocommerce/woocommerce.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-teams', TX_PLUGIN_URL . '/assets/css/widgets/team/team.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-image-slide', TX_PLUGIN_URL . '/assets/css/widgets/image-slide/image-slide.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-carousel-grid', TX_PLUGIN_URL . '/assets/css/widgets/carousel/carousel-grid.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-image-scrolling', TX_PLUGIN_URL . '/assets/css/widgets/image-scrolling/image-scrolling.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-post-tiled', TX_PLUGIN_URL . '/assets/css/widgets/post-tiled/post-tiled.min.css', [], TX_PLUGIN_VERSION );
		wp_register_style( 'tx-highlight-text', TX_PLUGIN_URL . '/assets/css/widgets/highlight-text/highlight-text.min.css', [], TX_PLUGIN_VERSION );
		
	}

	public function widget_scripts() {

		wp_register_script( 'tx-accordion', TX_PLUGIN_URL . '/assets/js/widgets/accordion/accordion.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'animated-heading', TX_PLUGIN_URL . '/assets/js/widgets/animated-heading/animated-heading.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'typed', TX_PLUGIN_URL . '/assets/js/widgets/animated-heading/typed.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'morphext', TX_PLUGIN_URL . '/assets/js/widgets/animated-heading/morphext.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-chart', TX_PLUGIN_URL . '/assets/js/widgets/chart/tx-chart.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'chart', TX_PLUGIN_URL . '/assets/js/widgets/chart/chart.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'circle-progress-bar', TX_PLUGIN_URL . '/assets/js/widgets/circle-progress-bar/circle-progress-bar.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-circle-text', TX_PLUGIN_URL . '/assets/js/widgets/circle-text/circle-text.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'asPieProgress', TX_PLUGIN_URL . '/assets/js/widgets/circle-progress-bar/jquery-asPieProgress.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-countdown', TX_PLUGIN_URL . '/assets/js/widgets/countdown/tx-countdown.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'countdown', TX_PLUGIN_URL . '/assets/js/widgets/countdown/countdown.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-counter', TX_PLUGIN_URL . '/assets/js/widgets/counter/counter.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'coupon', TX_PLUGIN_URL . '/assets/js/widgets/coupon/coupon.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'flipster', TX_PLUGIN_URL . '/assets/js/widgets/flipster/jquery.flipster.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'gallery', TX_PLUGIN_URL . '/assets/js/widgets/gallery/gallery.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'hotspot', TX_PLUGIN_URL . '/assets/js/widgets/hotspot/hotspot.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-image-comparison', TX_PLUGIN_URL . '/assets/js/widgets/image-comparison/image-comparison.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'image-comparison', TX_PLUGIN_URL . '/assets/js/widgets/image-comparison/image-compare-viewer.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'image-slide', TX_PLUGIN_URL . '/assets/js/widgets/image-slide/image-slide.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-image-swap', TX_PLUGIN_URL . '/assets/js/widgets/image-swap/image-swap.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-info-link', TX_PLUGIN_URL . '/assets/js/widgets/info-link/info-link.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'infiniteslidev2', TX_PLUGIN_URL . '/assets/js/widgets/image-slide/infiniteslidev2.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'instagram', TX_PLUGIN_URL . '/assets/js/widgets/instagram/instagram.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'instafeed', TX_PLUGIN_URL . '/assets/js/widgets/instagram/instafeed.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'lity', TX_PLUGIN_URL . '/assets/js/widgets/popup/lity.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-lottie', TX_PLUGIN_URL . '/assets/js/widgets/lottie/tx-lottie.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'lottie', TX_PLUGIN_URL . '/assets/js/widgets/lottie/lottie.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'infinite-scroll', TX_PLUGIN_URL . '/assets/js/widgets/post-masonry-grid/infinite-scroll.pkgd.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-post-masonry-grid', TX_PLUGIN_URL . '/assets/js/widgets/post-masonry-grid/post-masonry-grid.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'avas-timeline', TX_PLUGIN_URL . '/assets/js/widgets/timeline/timeline.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'carousel-widgets', TX_PLUGIN_URL . '/assets/js/carousel-widgets.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'imagesloaded', TX_PLUGIN_URL . '/assets/js/imagesloaded.pkgd.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-wrapper-link', TX_PLUGIN_URL . '/assets/js/widgets/wrapper-link/wrapper-link.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'vegas', TX_PLUGIN_URL . '/assets/js/vegas.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'spritespin', TX_PLUGIN_URL . '/assets/js/widgets/sprite-spin/spritespin.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'spritespin-widget', TX_PLUGIN_URL . '/assets/js/widgets/sprite-spin/spritespin-widget.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-circle-info', TX_PLUGIN_URL . '/assets/js/widgets/circle-info/tx-circle-info.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'slick', TX_PLUGIN_URL . '/assets/js/slick.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'PrismJS', TX_PLUGIN_URL . '/assets/js/widgets/source-code/prism.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-source-code', TX_PLUGIN_URL . '/assets/js/widgets/source-code/source-code.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-lightzoom', TX_PLUGIN_URL . '/assets/js/widgets/image-magnifier/lightzoom.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-scroll-up', TX_PLUGIN_URL . '/assets/js/widgets/scroll-up/scroll-up.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-slider', TX_PLUGIN_URL . '/assets/js/widgets/slider/slider.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-post-slider', TX_PLUGIN_URL . '/assets/js/widgets/post-slider/post-slider.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-sticky-section', TX_PLUGIN_URL . '/assets/js/widgets/sticky-section/sticky-section.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-switcher', TX_PLUGIN_URL . '/assets/js/widgets/switcher/switcher.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-table', TX_PLUGIN_URL . '/assets/js/widgets/table/table.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'wow', TX_PLUGIN_URL . '/assets/js/widgets/progress-bar/wow.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-progressbar', TX_PLUGIN_URL . '/assets/js/widgets/progress-bar/progress-bar.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-carousel', TX_PLUGIN_URL . '/assets/js/tx-carousel.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-slick', TX_PLUGIN_URL . '/assets/js/widgets/slick-carousel/slick.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-search-plus', TX_PLUGIN_URL . '/assets/js/widgets/search-plus/search-plus.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-slick-carousel', TX_PLUGIN_URL . '/assets/js/widgets/slick-carousel/tx-slick-carousel.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-conditions', TX_PLUGIN_URL . '/assets/js/widgets/conditions/conditions.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-owl-btn', TX_PLUGIN_URL . '/assets/js/owl-btn.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		wp_register_script( 'tx-highlight-text', TX_PLUGIN_URL . '/assets/js/widgets/highlight-text/highlight-text.min.js', ['jquery'], TX_PLUGIN_VERSION, true );
		
		
		// localize for coupon widgete
      	wp_localize_script( 'coupon', 'txCopied', [
      		esc_html__('Copied!', 'avas-core')
      	]);

      wp_localize_script( 'tx-search-plus', 'TXSearchPlus', [
		   'ajaxurl' => admin_url( 'admin-ajax.php' ),
		   'nonce'   => wp_create_nonce( 'tx-search-plus' ),
		] );
		
	}

	private function __construct() {
		
		spl_autoload_register( [ $this, 'autoload' ] );
		
		$this->_includes();
		
		$this->setup_hooks();

		add_action( 'elementor/controls/register', [$this, 'register_select2_control']);
		add_action( 'wp_ajax_tx_select2_search_post', [ $this, 'select2_ajax_posts_filter_autocomplete' ] );
		add_action( 'wp_ajax_tx_select2_get_title', [ $this, 'select2_ajax_get_posts_value_titles' ] );
	}


	public function register_select2_control( $controls_manager ) {

		require TX_PLUGIN_PATH . 'controls/select2.php';
    	$controls_manager->register( new \Select2() );

	}


	/**
	 * Select2 Ajax Posts Filter Autocomplete
	 * Fetch post/taxonomy data and render in Elementor control select2 ajax search box
	 *
	 * @access public
	 * @return void
	 * @since 6.4
	 */
	public function select2_ajax_posts_filter_autocomplete() {
		$post_type   = 'post';
		$source_name = 'post_type';

		if ( ! empty( $_POST['post_type'] ) ) {
			$post_type = sanitize_text_field( $_POST['post_type'] );
		}

		if ( ! empty( $_POST['source_name'] ) ) {
			$source_name = sanitize_text_field( $_POST['source_name'] );
		}

		$search  = ! empty( $_POST['term'] ) ? sanitize_text_field( $_POST['term'] ) : '';
		$results = $post_list = [];
		switch ( $source_name ) {
			case 'taxonomy':
				$args = [
					'hide_empty' => false,
					'orderby'    => 'name',
					'order'      => 'ASC',
					'search'     => $search,
					'number'     => '5',
				];

				if ( $post_type !== 'all' ) {
					$args['taxonomy'] = $post_type;
				}

				$post_list = wp_list_pluck( get_terms( $args ), 'name', 'term_id' );
				break;
			case 'user':
				if ( ! current_user_can( 'list_users' ) ) {
					$post_list = [];
					break;
				}

				$users = [];

				foreach ( get_users( [ 'search' => "*{$search}*" ] ) as $user ) {
					$user_id           = $user->ID;
					$user_name         = $user->display_name;
					$users[ $user_id ] = $user_name;
				}

				$post_list = $users;
				break;
			default:
				$post_list = TX_Helper::get_query_post_list( $post_type, 10, $search );
		}

		if ( ! empty( $post_list ) ) {
			foreach ( $post_list as $key => $item ) {
				$results[] = [ 'text' => $item, 'id' => $key ];
			}
		}

		wp_send_json( [ 'results' => $results ] );
	}

	/**
	 * Select2 Ajax Get Posts Value Titles
	 * get selected value to show elementor editor panel in select2 ajax search box
	 *
	 * @access public
	 * @return void
	 * @since 6.4
	 */
	public function select2_ajax_get_posts_value_titles() {

		if ( empty( $_POST['id'] ) ) {
			wp_send_json_error( [] );
		}

		if ( empty( array_filter( $_POST['id'] ) ) ) {
			wp_send_json_error( [] );
		}
		$ids         = array_map( 'intval', $_POST['id'] );
		$source_name = ! empty( $_POST['source_name'] ) ? sanitize_text_field( $_POST['source_name'] ) : '';

		switch ( $source_name ) {
			case 'taxonomy':
				$args = [
					'hide_empty' => false,
					'orderby'    => 'name',
					'order'      => 'ASC',
					'include'    => implode( ',', $ids ),
				];

				if ( $_POST['post_type'] !== 'all' ) {
					$args['taxonomy'] = sanitize_text_field( $_POST['post_type'] );
				}

				$response = wp_list_pluck( get_terms( $args ), 'name', 'term_id' );
				break;
			case 'user':
				$users = [];

				foreach ( get_users( [ 'include' => $ids ] ) as $user ) {
					$user_id           = $user->ID;
					$user_name         = $user->display_name;
					$users[ $user_id ] = $user_name;
				}

				$response = $users;
				break;
			default:
				$post_info = get_posts( [
					'post_type' => sanitize_text_field( $_POST['post_type'] ),
					'include'   => implode( ',', $ids )
				] );
				$response  = wp_list_pluck( $post_info, 'post_title', 'ID' );
		}

		if ( ! empty( $response ) ) {
			wp_send_json_success( [ 'results' => $response ] );
		} else {
			wp_send_json_error( [] );
		}
	}



}

TX_Load::instance();
