<?php

namespace AvasElements\Modules\AnimatedBorder;

use Elementor\Controls_Manager;
use AvasElements\Base\Module_Base;
use Elementor\Element_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class Module extends Module_Base {

    public function __construct() {

        add_action('wp_enqueue_scripts', [$this,'register_assets']);
        add_action('elementor/element/common/section_advanced/after_section_end', [$this,'register_controls'], 10, 2);
        add_action('elementor/element/container/section_advanced/after_section_end', [$this,'register_controls'], 10, 2);
        add_action('elementor/element/section/section_advanced/after_section_end', [$this,'register_controls'], 10, 2);
        add_action('elementor/element/column/section_advanced/after_section_end',  [$this,'register_controls'], 10, 2);
        add_action('elementor/element/container/section_layout/after_section_end', [$this,'register_controls'], 10, 2); 
        add_action('elementor/element/common/_section_style/after_section_end', [$this,'register_controls'], 10, 2);
    
    }

    public function get_name() {
		return 'avas-animated-border';
	}

	public function get_style_depends() {
        return ['tx-animated-border'];
    }

    public function register_assets() {
        wp_register_style( 'tx-animated-border', TX_PLUGIN_URL . '/assets/css/modules/animated-border/animated-border.min.css', [], TX_PLUGIN_VERSION );
        wp_enqueue_style('tx-animated-border');
    }

    public function register_controls( $element, $section_id ) {
        
		$element->start_controls_section(
		  'tx_mgb_section',
		  ['label' => esc_html__('Avas Animated Border', 'avas-core'),'tab' => Controls_Manager::TAB_ADVANCED]
		);

		$element->add_control('tx_mgb_enable', [
		  'label' => esc_html__('Enable','avas-core'),
		  'type' => Controls_Manager::SWITCHER,
		  'return_value' => 'yes',
		  'render_type'  => 'ui',   
		  'prefix_class' => 'tx-mgb--',     // wrapper gets: tx-mgb--yes
		]);

		$element->add_control('tx_mgb_bg', [
		  'label'       => esc_html__('Inner Background','avas-core'),
		  'type'        => Controls_Manager::COLOR,
		  'selectors'   => ['{{WRAPPER}}.tx-mgb--yes' => 'background-color: {{VALUE}};'],
		  'render_type' => 'ui',
		  'condition'   => ['tx_mgb_enable' => 'yes'],
		]);

		$element->add_control('tx_mgb_c1', [
		  'label' => esc_html__('Gradient Color 1','avas-core'),
		  'type'  => Controls_Manager::COLOR,
		  'default' => '#7c4dff',
		  'selectors'   => ['{{WRAPPER}}' => '--tx-c1: {{VALUE}};'],
		  'render_type' => 'ui',
		  'condition'   => ['tx_mgb_enable' => 'yes'],
		]);

		$element->add_control('tx_mgb_c2', [
		  'label' => esc_html__('Gradient Color 2','avas-core'),
		  'type'  => Controls_Manager::COLOR,
		  'default' => '#00c2ff',
		  'selectors'   => ['{{WRAPPER}}' => '--tx-c2: {{VALUE}};'],
		  'render_type' => 'ui',
		  'condition'   => ['tx_mgb_enable' => 'yes'],
		]);

		$element->add_control('tx_mgb_c3', [
		  'label' => esc_html__('Gradient Color 3','avas-core'),
		  'type'  => Controls_Manager::COLOR,
		  'default' => '#00e5a8',
		  'selectors'   => ['{{WRAPPER}}' => '--tx-c3: {{VALUE}};'],
		  'render_type' => 'ui',
		  'condition'   => ['tx_mgb_enable' => 'yes'],
		]);

		$element->add_control('tx_mgb_bw', [
		  'label' => esc_html__('Border Thickness','avas-core'),
		  'type'  => Controls_Manager::SLIDER,
		  'range' => ['px'=>['min'=>0,'max'=>40]],
		  'default' => ['size'=>2,'unit'=>'px'],
		  'selectors'   => ['{{WRAPPER}}' => '--tx-bw: {{SIZE}}{{UNIT}};'],
		  'render_type' => 'ui',
		  'condition'   => ['tx_mgb_enable' => 'yes'],
		]);

		$element->add_control('tx_mgb_radius', [
		  'label'       => esc_html__('Border Radius','avas-core'),
		  'type'        => Controls_Manager::SLIDER,
		  'range'       => ['px'=>['min'=>0,'max'=>200]],
		  'default'     => ['size'=>16,'unit'=>'px'],
		  'selectors'   => [
		    '{{WRAPPER}}' => '--tx-radius: {{SIZE}}{{UNIT}};',  // var used by both wrapper and ::after
		  ],
		  'render_type' => 'ui',
		  'condition'   => ['tx_mgb_enable' => 'yes'],
		]);

		$element->add_control('tx_mgb_speed', [
		  'label' => esc_html__('Rotation Speed (s)','avas-core'),
		  'type'  => Controls_Manager::SLIDER,
		  'range' => ['px'=>['min'=>0,'max'=>30]],
		  'default' => ['size'=>3],
		  'selectors'   => ['{{WRAPPER}}' => '--tx-speed: {{SIZE}}s;'],
		  'render_type' => 'ui',
		  'description' => esc_html__('Set 0 to stop animation.','avas-core'),
		  'condition'   => ['tx_mgb_enable' => 'yes'],
		]);

		$element->add_control('tx_mgb_reverse', [
		  'label'        => esc_html__('Reverse Direction','avas-core'),
		  'type'         => Controls_Manager::SWITCHER,
		  'return_value' => 'yes',
		  'selectors'    => ['{{WRAPPER}}.tx-mgb--yes::before' => 'animation-direction: reverse;'],
		  'render_type'  => 'ui',
		  'condition'    => ['tx_mgb_enable' => 'yes'],
		]);

		$element->add_control('tx_mgb_pause', [
		  'label'        => esc_html__('Pause on Hover','avas-core'),
		  'type'         => Controls_Manager::SWITCHER,
		  'return_value' => 'yes',
		  'selectors'    => ['{{WRAPPER}}.tx-mgb--yes:hover::before' => 'animation-play-state: paused;'],
		  'render_type'  => 'ui',
		  'condition'    => ['tx_mgb_enable' => 'yes'],
		]);

		$element->end_controls_section();
    }

}
