<?php
/**
 * Custom meta fields | Fields
 *
 * @package Betheme
 * @author Muffin group
 * @link https://muffingroup.com
 */

if( ! defined( 'ABSPATH' ) ){
	exit; // Exit if accessed directly
}

if( ! class_exists('Mfn_Builder_Fields') )
{
  class Mfn_Builder_Fields {

		private $options;

    private $sliders;
    private $animations;

    private $section;
    private $wrap;
    private $items;

    private $advanced;

    private $vb;

    /**
      * Constructor
    */

    public function __construct( $vb = false, $limited = false ) {

			// BeBlocks get items only

			if( 'items' == $limited ) {

        $this->sliders = array(
          'layer' => Mfn_Builder_Helper::get_sliders('layer'),
          'rev' => Mfn_Builder_Helper::get_sliders('rev'),
        );

				$this->options = Mfn_Builder_Helper::get_options();

				$this->set_items();

				return;

			}

			// Default constructor

    	$this->vb = $vb;

			$this->sliders = array(
        'layer' => Mfn_Builder_Helper::get_sliders('layer'),
        'rev' => Mfn_Builder_Helper::get_sliders('rev'),
      );

      $this->options = Mfn_Builder_Helper::get_options();

      $this->set_animations();

      $this->set_advanced();

      $this->set_section();
      $this->set_wrap();
      $this->set_items();

      if( ! $this->vb ){
				$this->get_advanced( $limited );
			}

    }

    /**
     * SET advanced fields
     */

    public function get_advanced( $limited = false ) {

 			if( 'admin' == $limited && mfn_opts_get('builder-blocks') ) {

 				$items_exclude = array('placeholder');

 				foreach ($this->items as $i=>$it) {
 	    		foreach($this->advanced as $adv) {
 	    			if( !in_array($i, $items_exclude) ) {
 	    				$this->items[$i]['attr'][] = $adv;
 	    			}
 	    		}
 	    	}

 			}

 			return $this->advanced;

    }

    /**
     * GET section fields
     */

    public function get_section(){

      return $this->section;

    }

    /**
     * GET wrap fields
     */

    public function get_wrap(){

      return $this->wrap;

    }

    /**
     * GET items
     */

    public function get_items(){

      return $this->items;

    }

    /**
     * GET item fields
     */

    public function get_item_fields( $item_type ){

      return $this->items[$item_type];

    }

		/**
		 * GET entrance animations
		 */

		public function get_animations(){

			return $this->animations;

		}

		/**
		 * GET placeholder image
		 */

		public function get_placeholder(){
			return get_theme_file_uri( '/muffin-options/svg/placeholders/image.svg' );
		}

		/**
		 * GET column editor
		 */

		public function get_column_editor(){

			$column_editor = 'textarea'; // codemirror

			if( $this->options['column-visual'] ){
				$column_editor = 'visual';
			}

			return $column_editor;

		}

    /**
     * SET section fields
   	 */

    private function set_section(){

  		$this->section = array(

  			/**
  			 * HEADER additional fields
  			 */

				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
				),

				array(
					'type' => 'header',
					'class' => 'visible-header-builder',
					'title' => __('Header options', 'mfn-opts'),
				),

				array(
  				'id' => 'scroll-visibility',
  				'type' => 'switch',
  				'class' => 'visible-header-builder',
  				'title' => __('Scroll visibility', 'mfn-opts'),
  				'desc' => __('Sections hidden on the scroll should be at the top of the header. It takes effect with fixed type of Header', 'mfn-opts'),
  				'options' => array(
  					'show' => __('Default', 'mfn-opts'),
  					'hide' => __('Hide', 'mfn-opts'),
  				),
  				'std' => 'show'
  			),

				array(
  				'id' => 'closeable',
  				'attr_id' => 'closable-field',
  				'type' => 'switch',
  				'class' => 'visible-header-builder',
  				'title' => __('Closeable', 'mfn-opts'),
  				'options' => array(
  					'0' => __('Disabled', 'mfn-opts'),
  					'1' => __('Enabled', 'mfn-opts'),
  				),
  				'std' => '0'
  			),

  			array(
  				'id' => 'closeable-time',
  				'condition' => array( 'id' => 'closable-field', 'opt' => 'is', 'val' => '1' ),
  				'type' => 'text',
  				'class' => 'visible-header-builder narrow',
  				'title' => __('Show again after', 'mfn-opts'),
  				'desc' => __('How many days should it stay hidden after closing?', 'mfn-opts'),
  				'std' => '0',
  				'after' => 'days',
					'param' => 'number',
					'preview' => 'number',
  			),

  			array(
  				'id' => 'closeable-x',
  				'condition' => array( 'id' => 'closable-field', 'opt' => 'is', 'val' => '1' ),
  				'type' => 'switch',
  				'title' => __('Close button position', 'mfn-opts'),
  				'std' => 'left',
  				'options' => array(
  					'left' => __('Left', 'mfn-opts'),
  					'right' => __('Right', 'mfn-opts'),
  				),
  			),

  			array(
					'old_id' => 'style:.mcb-section-mfnuidelement .close-closeable-section .icon:color',
					'id' => 'css_closeable_icon_color',
					'selector' => '.mcb-section-mfnuidelement .close-closeable-section .icon',
					'style' => 'color',
					'condition' => array( 'id' => 'closable-field', 'opt' => 'is', 'val' => '1' ),
					'type' => 'color',
					'title' => __('Close icon color', 'mfn-opts'),
				),

  			array(
  				'id' => 'title',
  				'class' => 'hidden-header-builder',
  				'type' => 'text',
  				'title' => __('Title', 'mfn-opts'),
  				'desc' => __('Label in admin panel only', 'mfn-opts'),
  			),

  			array(
  				'type' => 'header',
  				'class' => 'hidden-header-builder',
					'title' => __('Type', 'mfn-opts'),
				),

  			array(
  				'id' => 'type',
  				'attr_id' => 'section_type',
  				'class' => 'hidden-header-builder mfn-loop-switcher',
  				'type' => 'switch',
  				're_render' => true,
  				'title' => __('Type', 'mfn-opts'),
  				'desc' => __('Query loop displays section&apos;s content in designed loop', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'query' => __('Query loop', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			/* query type */

  			array(
  				'id' => 'query_type',
  				'attr_id' => 'query_type',
  				're_render' => true,
  				'class' => 'hidden-header-builder hidden-archive-template-builder',
  				'condition' => array( 'id' => 'section_type', 'opt' => 'is', 'val' => 'query' ),
  				'type' => 'select',
  				'title' => __('Query type', 'mfn-opts'),
  				'options' => array(
  					'' => __('Select', 'mfn-opts'),
  					'posts' => __('Posts', 'mfn-opts'),
  					'terms' => __('Terms', 'mfn-opts')
  				),
  				'std' => ''
  			),

  			/* posts query builder */

  			array(
  				'id' => 'query_post_type',
  				'attr_id' => 'query_post_type',
  				'class' => 'hidden-header-builder hidden-archive-template-builder',
  				're_render' => true,
  				're_render_sidebar' => true,
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'select',
  				'title' => __('Post type', 'mfn-opts'),
  				'mfn_options' => 'post_types',
  				/*'options' => array(
  					'' => __('- Select -', 'mfn-opts'),
  					'post' => __('Post', 'mfn-opts'),
  					'page' => __('Page', 'mfn-opts'),
  					'portfolio' => __('Portfolio', 'mfn-opts'),
  					'offer' => __('Offer', 'mfn-opts'),
  					'client' => __('Clients', 'mfn-opts'),
  					'slide' => __('Slides', 'mfn-opts'),
  					'product' => __('Product', 'mfn-opts'),
  					'testimonial' => __('Testimonial', 'mfn-opts'),
  				),*/
  				'std' => ''
  			),

  			array(
					'id' => 'query_post_type_{mfn.current_post_type}',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'isnt', 'val' => '' ),
					're_render' => true,
					'type' => 'multiselect',
					'class' => 'hidden-archive-template-builder',
					'title' => __('Taxonomies included', 'mfn-opts'),
   				'post_tax' => true,
				),
				array(
					'id' => 'query_post_type_{mfn.current_post_type}_exclude',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'isnt', 'val' => '' ),
					're_render' => true,
					'type' => 'multiselect',
					'class' => 'hidden-archive-template-builder',
					'title' => __('Taxonomies excluded', 'mfn-opts'),
   				'post_tax' => true,
				),

				array(
					'id' => 'query_post_type_product_order',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'product' ),
					're_render' => true,
					'type' => 'select',
					'title' => __('Display', 'mfn-opts'),
					'desc' => __('This option turns off standard order settings', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'on_sale' => __('On sale', 'mfn-opts'),
						'best_selling' => __('Best selling', 'mfn-opts'),
						'top_rated' => __('Top rated', 'mfn-opts'),
					),
					'std' => '',
				),

  			array(
  				'id' => 'query_post_orderby',
  				'class' => 'hidden-header-builder',
  				're_render' => true,
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'select',
  				'title' => __('Order by', 'mfn-opts'),
  				'options' => array(
  					'' => __('None', 'mfn-opts'),
  					'ID' => __('ID', 'mfn-opts'),
  					'date' => __('Date', 'mfn-opts'),
  					'modified' => __('Modified', 'mfn-opts'),
  					'menu_order' => __('Menu order', 'mfn-opts'),
  					'title' => __('Title', 'mfn-opts'),
  					'rand' => __('Rand', 'mfn-opts'),
  				),
  				'std' => 'date'
  			),

  			array(
  				'id' => 'query_post_order',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'select',
  				'title' => __('Order', 'mfn-opts'),
  				'options' => array(
  					'ASC' => __('Ascending', 'mfn-opts'),
  					'DESC' => __('Descending', 'mfn-opts'),
  				),
  				'std' => 'DESC'
  			),

  			array(
  				'id' => 'query_post_per_page',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'text',
  				'title' => __('Limit', 'mfn-opts'),
  				'desc' => __('By default limit from Admin > Settings > Reading > Blog pages show at most', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '0',
					'mfn_options' => 'per_page',
  			),

  			array(
  				'id' => 'query_post_offset',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'text',
  				'title' => __('Offset', 'mfn-opts'),
  				'desc' => __('This option omits provided quantity of posts (from the beginning)', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '0',
  			),

  			array(
  				'id' => 'query_post_pagination',
  				'attr_id' => 'query_post_pagination',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'select',
  				'title' => __('Pagination', 'mfn-opts'),
  				'options' => array(
  					'' => __('Hidden', 'mfn-opts'),
  					'numbers' => __('Numbers + links', 'mfn-opts'),
  					'dots' => __('Dots + links', 'mfn-opts'),
  					'prevnext' => __('Prev / Next links', 'mfn-opts'),
  					'loadmore' => __('Load more', 'mfn-opts'),
  					'infiniteload' => __('Infinite load', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			/* terms query builder */

  			array(
  				'id' => 'query_terms_taxonomy',
  				'attr_id' => 'query_terms_taxonomy',
  				're_render' => true,
  				're_render_sidebar' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Taxonomy', 'mfn-opts'),
  				'mfn_options' => 'taxonomies',
  				/*'options' => array(
  					'' => __('- Select -', 'mfn-opts'),
  					'category' => __('Post category', 'mfn-opts'),
  					'post_tag' => __('Post tag', 'mfn-opts'),
  					'portfolio_types' => __('Portfolio category', 'mfn-opts'),
  					'offer_types' => __('Offer category', 'mfn-opts'),
  					'testimonial_types' => __('Testimonial category', 'mfn-opts'),
  					'product_cat' => __('Product category', 'mfn-opts'),
  				),*/
  				'std' => 'category'
  			),

  			array(
  				'id' => 'query_terms_includes_{mfn.current_tax}',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'isnt', 'val' => '' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to include', 'mfn-opts'),
  				//'options' => mfn_get_categories('post_tag'),
   				'tax_cpt' => true,
  			),

  			array(
  				'id' => 'query_terms_excludes_{mfn.current_tax}',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'isnt', 'val' => '' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
   				'tax_cpt' => true,
  			),






  			array(
  				'id' => 'query_terms_child_of_product_cat',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'product_cat' ),
  				're_render' => true,
  				'type' => 'select',
  				'title' => __('Child of', 'mfn-opts'),
					'mfn_taxonomies' => 'product_cat',
					'opt_append' => array(
						'0-current' => 'Current'
					),
  			),

  			array(
  				'id' => 'query_terms_orderby',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Order by', 'mfn-opts'),
  				'options' => array(
  					'' => __('None', 'mfn-opts'),
  					'term_order' => __('Term order', 'mfn-opts'),
  					'term_id' => __('ID', 'mfn-opts'),
  					'name' => __('Name', 'mfn-opts'),
  					'count' => __('Count', 'mfn-opts'),
  				),
  				'std' => 'ID'
  			),

  			array(
  				'id' => 'query_terms_order',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Order', 'mfn-opts'),
  				'options' => array(
  					'ASC' => __('Ascending', 'mfn-opts'),
  					'DESC' => __('Descending', 'mfn-opts'),
  				),
  				'std' => 'ASC'
  			),

  			array(
  				'id' => 'query_terms_hide_empty',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Hide empty', 'mfn-opts'),
  				'options' => array(
  					'' => __('False', 'mfn-opts'),
  					'1' => __('True', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_terms_number',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'text',
  				'title' => __('Limit', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '0',
  			),

  			/* END posts query builder */

  			array(
  				'type' => 'header',
  				'class' => 'hidden-header-builder',
					'title' => __('Style', 'mfn-opts'),
				),

				array(
  				'class' => 'hidden-header-builder',
  				'id' => 'style',
  				'type' => 'checkbox_pseudo',
  				'title' => __('Style', 'mfn-opts'),
  				'desc' => __('<strong>Notice!</strong> Options grayed out and marked with OLD tag are deprecated and will be removed in the future. Please use <a href="https://support.muffingroup.com/documentation/muffin-live-builder/positioning/" target="_blank">Positioning</a> instead.', 'mfn-opts'),
  				'options' => mfna_section_style(),
  			),

				// shape dividers

				array(
					'type' => 'header',
					'class' => 'hidden-header-builder',
					'title' => __('Shape divider', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '<div class="mfn-form-row hidden-header-builder mfn-sidebar-fields-tabs mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Top</a></li><li><a href="#hover" data-tab="hover">Bottom</a></li></ul><div class="mfn-sft mfn-sft-normal">',
				),

				array(
					'id' => 'shape_divider_type_top',
					'class' => 'hidden-header-builder',
					'attr_id' => 'shape_divider_type_top',
					'type' => 'select',
					'title' => __('Type', 'mfn-opts'),
					'options' => Mfn_Builder_Helper::get_shape_divider('options'),
					'std' => 0,
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-top svg:--mfn-shape-divider',
					'id' => 'css_shape_divider_top_color',
					'selector' => '.mcb-section-mfnuidelement .mfn-shape-divider-top svg',
					'style' => '--mfn-shape-divider',
					'class' => 'hidden-header-builder',
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
					'condition' => array( 'id' => 'shape_divider_type_top', 'opt' => 'isnt', 'val' => 0 ),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-top svg:width',
					'id' => 'css_shape_divider_top_width',
					'selector' => '.mcb-section-mfnuidelement .mfn-shape-divider-top svg',
					'style' => 'width',
					'class' => 'hidden-header-builder',
					'type' => 'sliderbar',
					'title' => __('Width %', 'mfn-opts'),
					'param' => array(
						'min' => '100',
						'max' => '300',
						'step' => '1',
						'unit' => '%',
					),
					'condition' => array( 'id' => 'shape_divider_type_top', 'opt' => 'isnt', 'val' => 0 ),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-top svg:height',
					'id' => 'css_shape_divider_top_height',
					'selector' => '.mcb-section-mfnuidelement .mfn-shape-divider-top svg',
					'style' => 'height',
					'type' => 'sliderbar',
					'title' => __('Height px', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '500',
						'step' => '1',
						'unit' => 'px',
					),
					'condition' => array( 'id' => 'shape_divider_type_top', 'opt' => 'isnt', 'val' => 0 ),
					'responsive' => true,
					'class' => 'hidden-header-builder',
				),

				array(
					'id' => 'shape_divider_flip_top',
					'type' => 'switch',
					'class' => 'hidden-header-builder',
					'title' => __('Flip', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
					'condition' => array( 'id' => 'shape_divider_type_top', 'opt' => 'isnt', 'val' => 0 ),
				),

				array(
					'id' => 'shape_divider_invert_top',
					'type' => 'switch',
					'class' => 'hidden-header-builder',
					'title' => __('Invert', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
					'condition' => array( 'id' => 'shape_divider_type_top', 'opt' => 'is', 'val' => Mfn_Builder_Helper::get_shape_divider('invert') ),
				),

				array(
					'id' => 'shape_divider_bring_front_top',
					'type' => 'switch',
					'class' => 'hidden-header-builder',
					'title' => __('Bring to front', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
					'condition' => array( 'id' => 'shape_divider_type_top', 'opt' => 'isnt', 'val' => 0 ),
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'class' => 'hidden-header-builder',
					'id' => 'shape_divider_type_bottom',
					'attr_id' => 'shape_divider_type_bottom',
					'type' => 'select',
					'title' => __('Type', 'mfn-opts'),
					'options' => Mfn_Builder_Helper::get_shape_divider('options'),
					'std' => 0,
				),

				array(
					'class' => 'hidden-header-builder',
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-bottom svg:--mfn-shape-divider',
					'id' => 'css_shape_divider_bottom_color',
					'selector' => '.mcb-section-mfnuidelement .mfn-shape-divider-bottom svg',
					'style' => '--mfn-shape-divider',
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
					'std' => '',
					'condition' => array( 'id' => 'shape_divider_type_bottom', 'opt' => 'isnt', 'val' => 0 ),
				),

				array(
					'class' => 'hidden-header-builder',
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-bottom svg:width',
					'id' => 'css_shape_divider_bottom_width',
					'selector' => '.mcb-section-mfnuidelement .mfn-shape-divider-bottom svg',
					'style' => 'width',
					'type' => 'sliderbar',
					'title' => __('Width %', 'mfn-opts'),
					'param' => array(
						'min' => '100',
						'max' => '300',
						'step' => '1',
						'unit' => '%',
					),
					'condition' => array( 'id' => 'shape_divider_type_bottom', 'opt' => 'isnt', 'val' => 0 ),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-bottom svg:height',
					'id' => 'css_shape_divider_bottom_height',
					'selector' => '.mcb-section-mfnuidelement .mfn-shape-divider-bottom svg',
					'style' => 'height',
					'type' => 'sliderbar',
					'title' => __('Height px', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '500',
						'step' => '1',
						'unit' => 'px',
					),
					'condition' => array( 'id' => 'shape_divider_type_bottom', 'opt' => 'isnt', 'val' => 0 ),
					'responsive' => true,
					'class' => 'hidden-header-builder',
				),



				array(
					'id' => 'shape_divider_flip_bottom',
					'type' => 'switch',
					'class' => 'hidden-header-builder',
					'title' => __('Flip', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
					'condition' => array( 'id' => 'shape_divider_type_bottom', 'opt' => 'isnt', 'val' => 0 ),
				),

				array(
					'id' => 'shape_divider_invert_bottom',
					'type' => 'switch',
					'class' => 'hidden-header-builder',
					'title' => __('Invert', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
					'condition' => array( 'id' => 'shape_divider_type_bottom', 'opt' => 'is', 'val' => Mfn_Builder_Helper::get_shape_divider('invert') ),
				),

				array(
					'id' => 'shape_divider_bring_front_bottom',
					'type' => 'switch',
					'class' => 'hidden-header-builder',
					'title' => __('Bring to front', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
					'condition' => array( 'id' => 'shape_divider_type_bottom', 'opt' => 'isnt', 'val' => 0 ),
				),


				array(
					'type' => 'html',
					'html' => '</div></div>',
				),

  			// decoration

  			array(
  				'type' => 'header',
  				'class' => 'hidden-header-builder',
  				'title' => __('Background decoration', 'mfn-opts'),
  			),

  			array(
  				'class' => 'hidden-header-builder',
  				'id' => 'divider',
  				'type' => 'select',
  				'title' => __('Pattern', 'mfn-opts'),
  				'desc' => __('Please select background color in Advanced tab<br />Does <b>not</b> work with parallax and some section styles', 'mfn-opts'),
  				'options' => array(
  					'' => __('None', 'mfn-opts'),
  					'circle up' => __('Circle up', 'mfn-opts'),
  					'square up' => __('Square up', 'mfn-opts'),
  					'triangle up' => __('Triangle up', 'mfn-opts'),
  					'triple-triangle up' => __('Triple triangle up', 'mfn-opts'),
  					'circle down' => __('Circle down', 'mfn-opts'),
  					'square down' => __('Square down', 'mfn-opts'),
  					'triangle down' => __('Triangle down', 'mfn-opts'),
  					'triple-triangle down' => __('Triple triangle down', 'mfn-opts'),
  				),
  			),

  			array(
  				'class' => 'hidden-header-builder',
  				'id' => 'decor_top',
  				'type' => 'upload',
  				'title' => __('Image top', 'mfn-opts'),
  				'desc' => __('for images from <b> Media library</b><br/>Recommended width: 1920px', 'mfn-opts'),
  			),

  			array(
  				'class' => 'hidden-header-builder',
  				'id' => 'decor_bottom',
  				'type' => 'upload',
  				'title' => __('Image bottom', 'mfn-opts'),
					'desc' => __('for images from <b> Media library</b><br/>Recommended width: 1920px', 'mfn-opts'),
  			),

  			// options

  			array(
  				'type' => 'header',
  				'class' => 'hidden-header-builder',
  				'title' => __('Options', 'mfn-opts'),
  			),

				array(
					'class' => 'hidden-header-builder',
  				'id' => 'navigation',
  				'type' => 'select',
  				'title' => __('Navigation', 'mfn-opts'),
  				'options' => array(
  					'' => __('None', 'mfn-opts'),
  					'arrows' => __('Arrows', 'mfn-opts'),
  				),
  			),

				// hidden attributes

  			array(
  				'id' => 'hide',
  				'type' => 'text',
  				'title' => __('Hide', 'mfn-opts'),
  				'row_class' => 'hidden',
  				'class' => 'mfn-hidden-form-row',
  			),

  			array(
  				'id' => 'collapse',
  				'type' => 'text',
  				'title' => __('Collapse', 'mfn-opts'),
  				'row_class' => 'hidden',
  				'class' => 'mfn-hidden-form-row',
  			),

				// deprecated

  			array(
  				'type' => 'header',
  				'class' => 'mfn-deprecated',
  				'title' => __('Deprecated', 'mfn-opts'),
  			),

  			array(
  				'id' => 'bg_color',
  				'type' => 'color',
  				'class' => 'mfn-deprecated',
  				'title' => __('Background color', 'mfn-opts'),
  				'alpha' => true,
  			),

  			array(
  				'id' => 'bg_image',
  				'class' => 'mfn-deprecated',
  				'type' => 'upload',
  				'title' => __('Background image', 'mfn-opts'),
  				'desc' => __('Recommended image size <b>1920px x 1080px</b>', 'mfn-opts'),
  			),

  			array(
  				'id' => 'bg_position',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Background position', 'mfn-opts'),
  				'desc' => __('iOS does <b>not</b> support background-position: fixed<br/>For parallax required background image size is at least 1920px x 1080px', 'mfn-opts'),
  				'options' => mfna_bg_position(),
  			),

  			array(
  				'id' => 'bg_size',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Background size', 'mfn-opts'),
  				'desc' => __('Does <b>not</b> work with position fixed or parallax', 'mfn-opts'),
  				'options' => mfna_bg_size(),
  			),

  			array(
  				'id' => 'padding_top',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Padding top', 'mfn-opts'),
  				'after' => 'px',
  			),

  			array(
  				'id' => 'padding_bottom',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Padding bottom', 'mfn-opts'),
  				'after' => 'px',
  			),

  			array(
  				'id' => 'padding_horizontal',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Padding left & right', 'mfn-opts'),
  				'desc' => __('Use <b>px</b> or <b>%</b>', 'mfn-opts'),
  			),

  			array(
  				'id' => 'visibility',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Responsive visibility', 'mfn-opts'),
  				'options' => array(
  					'' => __('- Default -', 'mfn-opts'),
  					'hide-desktop' => __('Hide on Desktop | 960px +', 'mfn-opts'),			// 960 +
  					'hide-tablet' => __('Hide on Tablet | 768px - 959px', 'mfn-opts'),		// 768 - 959
  					'hide-mobile' => __('Hide on Mobile | - 768px', 'mfn-opts'),			// - 768
  					'hide-desktop hide-tablet' => __('Hide on Desktop & Tablet', 'mfn-opts'),
  					'hide-desktop hide-mobile' => __('Hide on Desktop & Mobile', 'mfn-opts'),
  					'hide-tablet hide-mobile' => __('Hide on Tablet & Mobile', 'mfn-opts'),
  				),
  			),

  			array(
  				'id' => 'class',
  				'class' => 'mfn-deprecated',
  				'type' => 'pills',
  				'title' => __('Section classes', 'mfn-opts'),
  			),

  			array(
  				'id' => 'section_id',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Section ID', 'mfn-opts'),
  				'desc' => __('Use this option to create One Page sites<br />Example: Your <b>Section ID</b> is <b>offer</b> and you want to open this section, please use link: <b>your-url/#offer</b>', 'mfn-opts'),
					'param' => 'id',
  			),

				array(
					'type' => 'helper',
					'class' => 'mfn-deprecated',
					'title' => __('Need help', 'mfn-opts'),
					'link' => 'https://support.muffingroup.com/faq/what-deprecated-in-the-bebuilder-means/',
				),

  			array(
					'type' => 'html',
					'html' => '</div>', // end: modalbox-card
				),

				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-card-style">',
				),


				array(
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Container', 'mfn-opts'),
				),

				array(
  				'id' => 'query_display',
  				'attr_id' => 'query_display',
  				'class' => 'mfn-toggled',
  				're_render' => true,
  				'type' => 'switch',
  				'title' => __('Display', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'slider' => __('Slider', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_columns',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'narrow mfn-toggled',
  				'responsive' => true,
  				'type' => 'text',
  				're_render' => true,
  				'title' => __('Columns', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '1',
  			),

  			array(
  				'id' => 'query_slider_infinity',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Infinite loop', 'mfn-opts'),
  				'options' => array(
  					'' => __('Off', 'mfn-opts'),
  					'1' => __('On', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_autoplay',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'default_unit' => '',
					'class' => 'mfn-toggled',
					'title' => __('Autoplay speed', 'mfn-opts'),
					'desc' => __('Leave empty to disallow autoplay', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '15000',
						'step' => '100',
						'unit' => '',
					)
  			),

  			array(
  				'id' => 'query_slider_speed',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'default_unit' => '',
					'class' => 'mfn-toggled',
					'title' => __('Animation speed', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '5000',
						'step' => '10',
						'unit' => '',
					)
  			),

  			array(
  				'id' => 'query_slider_animation',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'select',
  				'title' => __('Animation type', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'fade' => __('Fade', 'mfn-opts'),
  					'cards' => __('Cards', 'mfn-opts'),
  					'flip' => __('Flip', 'mfn-opts'),
  					'cube' => __('Cube', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_arrows',
  				'attr_id' => 'query_slider_arrows',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				're_render' => true,
  				'title' => __('Arrows', 'mfn-opts'),
  				'options' => array(
  					'0' => __('Hide', 'mfn-opts'),
  					'1' => __('Show', 'mfn-opts'),
  				),
  				'std' => '0'
  			),

  			array(
  				'id' => 'query_slider_arrows_style',
  				'attr_id' => 'query_slider_arrows_style',
  				'condition' => array( 'id' => 'query_slider_arrows', 'opt' => 'is', 'val' => '1' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				're_render' => true,
  				'title' => __('Arrows style', 'mfn-opts'),
  				'options' => array(
  					'' => __('Standard', 'mfn-opts'),
  					'overlay' => __('Overlay', 'mfn-opts'),
  					'custom' => __('Custom', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_arrows_visibility',
  				'iconinfo' => 'https://support.muffingroup.com/video-tutorials/section-responsive-visibility/',
  				'condition' => array( 'id' => 'query_slider_arrows', 'opt' => 'is', 'val' => '1' ),
  				'type' => 'switch',
  				'invert' => true,
  				'version' => 'multiple',
  				'class' => 'mfn-toggled',
  				'title' => __('Arrows visibility', 'mfn-opts'),
  				'active_tooltip' => array(
  					'arrows-hide-desktop' => __('Show on Desktop', 'mfn-opts'),
  					'arrows-hide-laptop' => __('Show on Laptop', 'mfn-opts'),
  					'arrows-hide-tablet' => __('Show on Tablet', 'mfn-opts'),
  					'arrows-hide-mobile' => __('Show on Mobile', 'mfn-opts'),
  				),
  				'options' => array(
  					'arrows-hide-desktop' => __('Hide on Desktop', 'mfn-opts'),			// 960 +
  					'arrows-hide-laptop' => __('Hide on Laptop', 'mfn-opts'),
  					'arrows-hide-tablet' => __('Hide on Tablet', 'mfn-opts'),		// 768 - 959
  					'arrows-hide-mobile' => __('Hide on Mobile', 'mfn-opts'),			// - 768
  				),
  				'visual_options' => array(
  					'arrows-hide-desktop' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M4.94,5H17.06a.93.93,0,0,1,.94.91v7.18a.93.93,0,0,1-.94.91H4.94A.93.93,0,0,1,4,13.09V5.91A.93.93,0,0,1,4.94,5Z"/><path class="cls-1" d="M7,17h8"/><path class="cls-2" d="M13,15.51a1.58,1.58,0,0,0,.7,1.26L14,17H8l.3-.23A1.58,1.58,0,0,0,9,15.51V14h4Z"/></svg>',			// 960 +
  					'arrows-hide-laptop' => '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"viewBox="0 0 22 22" style="enable-background:new 0 0 22 22;" xml:space="preserve"> <style type="text/css"> .st0{fill:none;stroke:currentColor;stroke-width:1.5;stroke-linecap:round;stroke-linejoin:round;} </style> <path class="st0" d="M5,15V6.9C5,6.4,5.4,5.9,5.9,6h10.1c0.5,0,0.9,0.4,0.9,0.9V15"/> <path class="st0" d="M4,17h14"/> </svg>',		// 768 - 959
  					'arrows-hide-tablet' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}</style></defs><path class="cls-1" d="M7,15.83V7.17A1.21,1.21,0,0,1,8.25,6h5.5A1.21,1.21,0,0,1,15,7.17v8.66A1.21,1.21,0,0,1,13.75,17H8.25A1.21,1.21,0,0,1,7,15.83Z"/></svg>',		// 768 - 959
  					'arrows-hide-mobile' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M8,15.82V8.18A1.08,1.08,0,0,1,8.94,7h4.12A1.08,1.08,0,0,1,14,8.18v7.64A1.08,1.08,0,0,1,13.06,17H8.94A1.08,1.08,0,0,1,8,15.82Z"/><circle class="cls-2" cx="11" cy="14" r="1"/></svg>',			// - 768
  				),
  			),

  			array(
  				'id' => 'query_slider_dots',
  				'attr_id' => 'query_slider_dots',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				're_render' => true,
  				'title' => __('Dots', 'mfn-opts'),
  				'options' => array(
  					'0' => __('Hide', 'mfn-opts'),
  					'1' => __('Show', 'mfn-opts'),
  				),
  				'std' => '0'
  			),

  			array(
  				'id' => 'query_slider_dots_style',
  				'attr_id' => 'query_slider_dots_style',
  				'condition' => array( 'id' => 'query_slider_dots', 'opt' => 'is', 'val' => '1' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				're_render' => true,
  				'title' => __('Dots style', 'mfn-opts'),
  				'options' => array(
  					'' => __('Standard', 'mfn-opts'),
  					'overlay' => __('Overlay', 'mfn-opts'),
  					'custom' => __('Custom', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_dots_count',
  				'condition' => array( 'id' => 'query_slider_dots', 'opt' => 'is', 'val' => '1' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				're_render' => true,
  				'title' => __('Dots count', 'mfn-opts'),
  				'options' => array(
  					'' => __('Standard', 'mfn-opts'),
  					'dynamic' => __('Dynamic', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_dots_visibility',
  				'iconinfo' => 'https://support.muffingroup.com/video-tutorials/section-responsive-visibility/',
  				'condition' => array( 'id' => 'query_slider_dots', 'opt' => 'is', 'val' => '1' ),
  				'type' => 'switch',
  				'invert' => true,
  				'version' => 'multiple',
  				'class' => 'mfn-toggled',
  				'title' => __('Dots visibility', 'mfn-opts'),
  				'active_tooltip' => array(
  					'dots-hide-desktop' => __('Show on Desktop', 'mfn-opts'),
  					'dots-hide-laptop' => __('Show on Laptop', 'mfn-opts'),
  					'dots-hide-tablet' => __('Show on Tablet', 'mfn-opts'),
  					'dots-hide-mobile' => __('Show on Mobile', 'mfn-opts'),
  				),
  				'options' => array(
  					'dots-hide-desktop' => __('Hide on Desktop', 'mfn-opts'),			// 960 +
  					'dots-hide-laptop' => __('Hide on Laptop', 'mfn-opts'),
  					'dots-hide-tablet' => __('Hide on Tablet', 'mfn-opts'),		// 768 - 959
  					'dots-hide-mobile' => __('Hide on Mobile', 'mfn-opts'),			// - 768
  				),
  				'visual_options' => array(
  					'dots-hide-desktop' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M4.94,5H17.06a.93.93,0,0,1,.94.91v7.18a.93.93,0,0,1-.94.91H4.94A.93.93,0,0,1,4,13.09V5.91A.93.93,0,0,1,4.94,5Z"/><path class="cls-1" d="M7,17h8"/><path class="cls-2" d="M13,15.51a1.58,1.58,0,0,0,.7,1.26L14,17H8l.3-.23A1.58,1.58,0,0,0,9,15.51V14h4Z"/></svg>',			// 960 +
  					'dots-hide-laptop' => '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"viewBox="0 0 22 22" style="enable-background:new 0 0 22 22;" xml:space="preserve"> <style type="text/css"> .st0{fill:none;stroke:currentColor;stroke-width:1.5;stroke-linecap:round;stroke-linejoin:round;} </style> <path class="st0" d="M5,15V6.9C5,6.4,5.4,5.9,5.9,6h10.1c0.5,0,0.9,0.4,0.9,0.9V15"/> <path class="st0" d="M4,17h14"/> </svg>',		// 768 - 959
  					'dots-hide-tablet' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}</style></defs><path class="cls-1" d="M7,15.83V7.17A1.21,1.21,0,0,1,8.25,6h5.5A1.21,1.21,0,0,1,15,7.17v8.66A1.21,1.21,0,0,1,13.75,17H8.25A1.21,1.21,0,0,1,7,15.83Z"/></svg>',		// 768 - 959
  					'dots-hide-mobile' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M8,15.82V8.18A1.08,1.08,0,0,1,8.94,7h4.12A1.08,1.08,0,0,1,14,8.18v7.64A1.08,1.08,0,0,1,13.06,17H8.94A1.08,1.08,0,0,1,8,15.82Z"/><circle class="cls-2" cx="11" cy="14" r="1"/></svg>',			// - 768
  				),
  			),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:transformtranslatex',
					'id' => 'css_queryloop_slider_pagination_transformtranslatex',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination',
					'style' => 'transformtranslatex',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Translate(X)', 'mfn-opts'),
					'param' => array(
						'min' => '-100',
						'max' => '100',
						'step' => '1',
						'unit' => '%',
					)
				),

  			array(
  				'id' => 'query_slider_mousewheel',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Mousewheel', 'mfn-opts'),
  				'options' => array(
  					'' => __('Disabled', 'mfn-opts'),
  					'1' => __('Enabled', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_centered',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				're_render' => true,
  				'type' => 'switch',
  				'title' => __('Center mode', 'mfn-opts'),
  				'options' => array(
  					'' => __('Disabled', 'mfn-opts'),
  					//'1' => __('Center', 'mfn-opts'),
  					'2' => __('Wrapper offset', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_linear',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				're_render' => true,
  				'type' => 'switch',
  				'title' => __('Linear mode', 'mfn-opts'),
  				'desc' => __('Linear mode skips setting the number of columns and autoplay speed', 'mfn-opts'),
  				'options' => array(
  					'' => __('Disabled', 'mfn-opts'),
  					'1' => __('Enabled', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_display_style',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'isnt', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				// 're_render' => true,
  				'type' => 'switch',
  				'title' => __('Style', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'masonry' => __('Masonry', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper.mfn-ql-item-default:width',
					'id' => 'css_queryloop_item_width',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper.mfn-ql-item-default',
					'style' => 'width',
					'condition' => array( 'id' => 'query_display', 'opt' => 'isnt', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'default_unit' => 'px',
					'responsive' => true,
					'class' => 'mfn-toggled query_item_default_width sliderbar-units',
					'title' => __('Item width', 'mfn-opts'),
					'units' => array(
						'px' 	=> array('min' => 0, 'max' => 1920, 'step' => 1),
						'%' 	=> array('min' => 0, 'max' => 100, 'step' => 0.1),
						'vw' 	=> array('min' => 0, 'max' => 100, 'step' => 0.1),
					),
				),

  			array(
  				'type' => 'header',
  				'class' => 'toggled_header',
					'title' => __('Item', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:min-height',
					'id' => 'css_queryloop_item_min_height',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'min-height',
					'type' => 'text',
					'default_unit' => 'px',
					'title' => __('Min height', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:align-content',
					'id' => 'css_queryloop_item_align_content',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'align-content',
					'type' => 'switch',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Vertical align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => __('Top', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Bottom', 'mfn-opts'),
					],
				),






				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:justify-content',
					'id' => 'css_queryloop_item_justify_content',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'justify-content',
					'type' => 'select',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Horizontal align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
					],
				),



				array(
					'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Spacing', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:padding',
					'id' => 'css_queryloop_item_padding',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'padding',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:margin',
					'id' => 'css_queryloop_item_margin',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'margin',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),

  			array(
  				'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Border', 'mfn-opts'),
				),

  			array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:border-style',
					'id' => 'css_queryloop_item_border_style',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'border-style',
					'attr_id' => 'border_style_ql',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Border style', 'mfn-opts'),
					'options' => [
						'none' => __('None', 'mfn-opts'),
						'solid' => __('Solid', 'mfn-opts'),
						'dashed' => __('Dashed', 'mfn-opts'),
						'dotted' => __('Dotted', 'mfn-opts'),
						'double' => __('Double', 'mfn-opts'),
					],
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:border-color',
					'id' => 'css_queryloop_item_border_color',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'border-color',
					'condition' => array( 'id' => 'border_style_ql', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:border-width',
					'id' => 'css_queryloop_item_border_width',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'border-width',
  				'condition' => array( 'id' => 'border_style_ql', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:border-radius',
					'id' => 'css_queryloop_item_border_radius',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'border-radius',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),

  			array(
		  		'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:box-shadow',
					'id' => 'css_queryloop_item_box_shadow',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'box-shadow',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),

  			array(
  				'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

  			array(
					'id' => 'background_switcher_ql',
					'attr_id' => 'background_switcher_ql',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher mfn-toggled disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:gradient',
  				'id' => 'css_query_loop_item_gradient',
   				'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
   				'style' => 'gradient',
  				'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
  			),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:background-color',
					'id' => 'css_queryloop_item_bg_color',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'background-color',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background color', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:background-image',
					'id' => 'css_queryloop_item_bg_image',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'background-image',
  				'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'responsive' => true,
  				'class' => 'mfn-toggled',
  				'title' => __('Image', 'mfn-opts'),
  			),



  			array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:background-repeat',
					'id' => 'css_queryloop_item_bg_repeat',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'background-repeat',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'class' => 'mfn-toggled',
					'responsive' => true,
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),


				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:background-position',
					'id' => 'css_queryloop_item_bg_position',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'background-position',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'class' => 'mfn-toggled',
					'responsive' => true,
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),


				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:background-attachment',
					'id' => 'css_queryloop_item_bg_attachment',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'background-attachment',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'class' => 'mfn-toggled',
					'responsive' => true,
					'title' => __('Attachment', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:background-size',
					'id' => 'css_queryloop_item_bg_size',
					'selector' => '.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper',
					'style' => 'background-size',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'class' => 'mfn-toggled',
					'responsive' => true,
					'type' => 'select',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),

				array(
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Slider dots', 'mfn-opts'),
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:top',
					'id' => 'css_queryloop_slider_pagination_top',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination',
					'style' => 'top',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled dots-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:bottom',
					'id' => 'css_queryloop_slider_pagination_bottom',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination',
					'style' => 'bottom',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled dots-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:left',
					'id' => 'css_queryloop_slider_pagination_left',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination',
					'style' => 'left',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
						'responsive' => true,
					'class' => 'mfn-toggled dots-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:right',
					'id' => 'css_queryloop_slider_pagination_right',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination',
					'style' => 'right',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled dots-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination:--mfn-swiper-pagination-spacing',
					'id' => 'css_queryloop_slider_pagination_spacing',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination',
					'style' => '--mfn-swiper-pagination-spacing',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Offset', 'mfn-opts'),
					'desc' => __('Works with Standard and Overlay pagination mode', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),



				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-width',
					'id' => 'css_queryloop_slider_pagination_bullet_width',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet',
					'style' => '--mfn-swiper-pagination-bullet-width',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Width', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-height',
					'id' => 'css_queryloop_slider_pagination_bullet_height',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet',
					'style' => '--mfn-swiper-pagination-bullet-height',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Height', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet:border-radius',
					'id' => 'css_queryloop_slider_pagination_bullet_border_radius',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet',
					'style' => 'border-radius',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Border radius', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet:opacity',
					'id' => 'css_queryloop_slider_pagination_bullet_opacity',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet',
					'style' => 'opacity',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Opacity', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '1',
						'step' => '0.01',
					),
					'std' => '0',
				),

				array(
					'type' => 'html',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination .swiper-pagination-bullet:--swiper-pagination-bullet-inactive-color',
					'id' => 'css_queryloop_slider_pagination_bullet_inactive_color',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination .swiper-pagination-bullet',
					'style' => '--swiper-pagination-bullet-inactive-color',
					'type' => 'color',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'class' => 'mfn-toggled',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination .swiper-pagination-bullet-active:--mfn-swiper-pagination-bullet-active-color',
					'id' => 'css_queryloop_slider_pagination_bullet_active_color',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination .swiper-pagination-bullet-active',
					'style' => '--mfn-swiper-pagination-bullet-active-color',
					'type' => 'color',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'class' => 'mfn-toggled',
					'title' => __('Active color', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div></div>',
				),

				array(
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Arrows', 'mfn-opts'),
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
				),

				array(
					'type' => 'subheader',
  				'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Prev arrow custom style', 'mfn-opts'),
				),

  			array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:top',
					'id' => 'css_queryloop_slider_arrow_prev_top',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow',
					'style' => 'top',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:bottom',
					'id' => 'css_queryloop_slider_arrow_prev_bottom',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow',
					'style' => 'bottom',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:left',
					'id' => 'css_queryloop_slider_arrow_prev_left',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow',
					'style' => 'left',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:right',
					'id' => 'css_queryloop_slider_arrow_prev_right',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow',
					'style' => 'right',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),

				array(
					'type' => 'subheader',
  				'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Next arrow custom style', 'mfn-opts'),
				),

  			array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:top',
					'id' => 'css_queryloop_slider_arrow_next_top',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow',
					'style' => 'top',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:bottom',
					'id' => 'css_queryloop_slider_arrow_next_bottom',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow',
					'style' => 'bottom',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:left',
					'id' => 'css_queryloop_slider_arrow_next_left',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow',
					'style' => 'left',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:right',
					'id' => 'css_queryloop_slider_arrow_next_right',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow',
					'style' => 'right',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .mfn-swiper-arrow:transformtranslatey',
					'id' => 'css_queryloop_slider_arrow_transformtranslatey',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .mfn-swiper-arrow',
					'style' => 'transformtranslatey',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Translate(Y)', 'mfn-opts'),
					'desc' => __('Moves navigation arrows along the Y-axis by the percent height', 'mfn-opts'),
					'default_unit' => '%',
					'after' => '%',
					'param' => array(
						'min' => '-100',
						'max' => '100',
						'step' => '1',
						'unit' => '%',
					)
				),

				array(
					'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'title' => __('Custom arrows', 'mfn-opts'),
				),

				array(
					'id' => 'query_display_slider_arrow_prev',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'icon',
					'class' => 'mfn-toggled',
					'title' => __('Prev arrow', 'mfn-opts'),
					'preview' => 'icon',
					'std' => 'icon-left-open-big'
				),

				array(
					'id' => 'query_display_slider_arrow_next',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'icon',
					'class' => 'mfn-toggled',
					'title' => __('Next arrow', 'mfn-opts'),
					'preview' => 'icon',
					'std' => 'icon-right-open-big'
				),

				array(
					'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'title' => __('Size', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:--mfn-swiper-arrow-width',
					'id' => 'css_queryloop_slider_arrow_width',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow',
					'style' => '--mfn-swiper-arrow-width',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Width', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:--mfn-swiper-arrow-height',
					'id' => 'css_queryloop_slider_arrow_height',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow',
					'style' => '--mfn-swiper-arrow-height',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Height', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow i:--mfn-swiper-arrow-size',
					'id' => 'css_queryloop_slider_arrow_icon_size',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow i',
					'style' => '--mfn-swiper-arrow-size',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Size', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:--mfn-swiper-arrow-spacing',
					'id' => 'css_queryloop_slider_arrow_spacing',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow',
					'style' => '--mfn-swiper-arrow-spacing',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Offset', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '-300',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),



				array(
					'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Border', 'mfn-opts'),
				),

  			array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:border-style',
					'id' => 'css_queryloop_slider_arrow_border_style',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow',
					'style' => 'border-style',
					'attr_id' => 'border_style_qlarr',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Border style', 'mfn-opts'),
					'options' => [
						'none' => __('None', 'mfn-opts'),
						'solid' => __('Solid', 'mfn-opts'),
						'dashed' => __('Dashed', 'mfn-opts'),
						'dotted' => __('Dotted', 'mfn-opts'),
						'double' => __('Double', 'mfn-opts'),
					],
				),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:border-width',
					'id' => 'css_queryloop_slider_arrow_border_width',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow',
					'style' => 'border-width',
  				'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:border-radius',
					'id' => 'css_queryloop_slider_arrow_border_radius',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow',
					'style' => 'border-radius',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),

  			array(
  				'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:box-shadow',
					'id' => 'css_queryloop_slider_arrow_box_shadow',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow',
					'style' => 'box-shadow',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'class' => 'mfn-toggled',
  			),

				array(
					'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:--swiper-navigation-color',
					'id' => 'css_queryloop_slider_arrow_navigation_color',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow',
					'style' => '--swiper-navigation-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:background-color',
					'id' => 'css_queryloop_slider_arrow_bg',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow',
					'style' => 'background-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:border-color',
					'id' => 'css_queryloop_slider_arrow_border_color',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow',
					'style' => 'border-color',
					'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow|hover:--swiper-navigation-color',
					'id' => 'css_queryloop_slider_arrow_color_hover',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:hover',
					'style' => '--swiper-navigation-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow|hover:background-color',
					'id' => 'css_queryloop_slider_arrow_bg_hover',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:hover',
					'style' => 'background-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow|hover:border-color',
					'id' => 'css_queryloop_slider_arrow_border_color_hover',
					'selector' => '.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:hover',
					'style' => 'border-color',
					'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div></div>',
				),














				array(
  				'type' => 'header',
  				'condition' => array( 'id' => 'query_post_pagination', 'opt' => 'isnt', 'val' => '' ),
  				'class' => 'toggled_header',
					'title' => __('Pagination', 'mfn-opts'),
				),

				array(
					'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Container', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination:background-color',
					'id' => 'css_queryloop_pagination_bg',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination',
					'style' => 'background-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination:padding',
					'id' => 'css_queryloop_pagination_padding',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination',
					'style' => 'padding',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),



				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination:margin',
					'id' => 'css_queryloop_pagination_margin',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination',
					'style' => 'margin',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),



				array(
					'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Items', 'mfn-opts'),
				),



				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers:gap',
					'id' => 'css_queryloop_pagination_numbers_gap',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers',
					'style' => 'gap',
					'type' => 'sliderbar',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Gap', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '50',
						'step' => '1',
						'unit' => 'px',
					)
				),



				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers li .page-numbers:min-width',
					'id' => 'css_queryloop_pagination_numbers_min_width',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers li .page-numbers',
					'style' => 'min-width',
					'type' => 'sliderbar',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Min width', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '200',
						'step' => '1',
						'unit' => 'px',
					)
				),



				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers .page-numbers:padding',
					'id' => 'css_queryloop_pagination_numbers_padding',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers .page-numbers',
					'style' => 'padding',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),


  			array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers .page-numbers:border-style',
					'id' => 'css_queryloop_pagination_numbers_border_style',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers .page-numbers',
					'style' => 'border-style',
					'attr_id' => 'border_style_pag',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Border style', 'mfn-opts'),
					'options' => [
						'none' => __('None', 'mfn-opts'),
						'solid' => __('Solid', 'mfn-opts'),
						'dashed' => __('Dashed', 'mfn-opts'),
						'dotted' => __('Dotted', 'mfn-opts'),
						'double' => __('Double', 'mfn-opts'),
					],
				),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers .page-numbers:border-width',
					'id' => 'css_queryloop_pagination_numbers_border_width',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers .page-numbers',
					'style' => 'border-width',
  				'condition' => array( 'id' => 'border_style_pag', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),



  			array(
  				'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers .page-numbers:border-radius',
					'id' => 'css_queryloop_pagination_numbers_border_radius',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers .page-numbers',
					'style' => 'border-radius',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),


				array(
					'type' => 'html',
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers li .page-numbers:--mfn-pagination-items-color',
					'id' => 'css_queryloop_pagination_numbers_color',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers li .page-numbers',
					'style' => '--mfn-pagination-items-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers li .page-numbers:background-color',
					'id' => 'css_queryloop_pagination_numbers_bg',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers li .page-numbers',
					'style' => 'background-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers .page-numbers:border-color',
					'id' => 'css_queryloop_pagination_numbers_border_color',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers .page-numbers',
					'style' => 'border-color',
					'condition' => array( 'id' => 'border_style_pag', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers a.page-numbers|hover:--mfn-pagination-items-color',
					'id' => 'css_queryloop_pagination_numbers_color_hover',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers a.page-numbers:hover',
					'style' => '--mfn-pagination-items-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers a.page-numbers|hover:background-color',
					'id' => 'css_queryloop_pagination_numbers_bg_hover',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers a.page-numbers:hover',
					'style' => 'background-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers .page-numbers|hover:border-color',
					'id' => 'css_queryloop_pagination_numbers_border_color_hover',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers .page-numbers:hover',
					'style' => 'border-color',
					'condition' => array( 'id' => 'border_style_pag', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-active">',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers li .current:--mfn-pagination-items-color',
					'id' => 'css_queryloop_pagination_numbers_color_active',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers li .current',
					'style' => '--mfn-pagination-items-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers li .current:background-color',
					'id' => 'css_queryloop_pagination_numbers_bg_active',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers li .current',
					'style' => 'background-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers li .current:border-color',
					'id' => 'css_queryloop_pagination_numbers_border_color_active',
					'selector' => '.mcb-section-mfnuidelement .mfn-query-pagination ul.page-numbers li .current',
					'style' => 'border-color',
					'condition' => array( 'id' => 'border_style_pag', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

        array(
					'type' => 'html',
					'html' => '</div></div>',
				),

  			array(
					'type' => 'html',
					'html' => '</div>', // end: modalbox-card
				),

				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-card-advanced">',
				),

				array(
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Dimensions', 'mfn-opts'),
				),

				array(
					'id' => 'width_switcher',
					'attr_id' => 'sect_width_switcher',
					'type' => 'select',
					'class' => 'mfn-toggled mfn-layout-modifier',
					'title' => __('Width', 'mfn-opts'),
					'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'full' 		=> __('Full width', 'mfn-opts'),
  					'custom' 	=> __('Custom', 'mfn-opts'),
  				),
  				'std' => '',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement.custom-width .section_wrapper:max-width',
					'id' => 'css_advanced_max_width',
					'selector' => '.mcb-section-mfnuidelement.custom-width .section_wrapper',
					'style' => 'max-width',
					'condition' => array( 'id' => 'sect_width_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'type' => 'text',
					'default_unit' => 'px',
					'class' => 'mfn-toggled narrow mfn-slider-input mfn-layout-modifier',
					'title' => __('Custom width', 'mfn-opts')
				),

				array(
					'id' => 'height_switcher',
					'attr_id' => 'sect_height_switcher',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Height', 'mfn-opts'),
					'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'full-screen' => __('Full screen', 'mfn-opts'),
  					'custom' 	=> __('Custom', 'mfn-opts'),
  				),
  				'std' => '',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement:height',
					'id' => 'css_advanced_height',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'height',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'sect_height_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => true,
					'class' => 'mfn-toggled narrow mfn-slider-input',
					'title' => __('Custom height', 'mfn-opts')
				),

  			array(
  				'type' => 'header',
  				'class' => 'toggled_header',
					'title' => __('Spacing', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement:padding',
					'id' => 'css_advanced_padding',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'padding',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),


				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement:margin',
					'id' => 'css_advanced_margin',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'margin',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),


  			array(
  				'type' => 'header',
  				'class' => 'toggled_header hide_if_ql-slider',
					'title' => __('Positioning', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .section_wrapper:align-content',
					'id' => 'css_advanced_align_content',
					'selector' => '.mcb-section-mfnuidelement .section_wrapper',
					'style' => 'align-content',
					'type' => 'radio_img',
					'alias' => 'section-flex-align-content',
					'responsive' => true,
					'class' => 'form-content-full-width small mfn-toggled',
					'title' => __('Section content position', 'mfn-opts'),
					'options' => array(
						'' => 'Default',
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
					),
					'std' => '',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .section_wrapper:align-items',
					'id' => 'css_advanced_align_items',
					'selector' => '.mcb-section-mfnuidelement .section_wrapper',
					'style' => 'align-items',
					'type' => 'radio_img',
					'alias' => 'section-flex-align',
					'responsive' => true,
					'class' => 'form-content-full-width small mfn-toggled adv_align-items_section',
					'title' => __('Wraps vertical spacing', 'mfn-opts'),
					'options' => array(
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
					),
					'std' => '',
				),


				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .section_wrapper:justify-content',
					'id' => 'css_advanced_justify_content',
					'selector' => '.mcb-section-mfnuidelement .section_wrapper',
					'style' => 'justify-content',
					'type' => 'radio_img',
					'alias' => 'section-flex-justify',
					'responsive' => true,
					'class' => 'form-content-full-width small mfn-toggled',
					'title' => __('Horizontal align', 'mfn-opts'),
					'options' => [
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
					],
					'std' => '',
				),


				array(
					'type' => 'helper',
					'class' => 'mfn-toggled',
					'title' => __('Need help', 'mfn-opts'),
					'link' => 'https://support.muffingroup.com/documentation/bebuilder/positioning/#section',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement:z-index',
					'id' => 'css_advanced_z_index',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'z-index',
					'type' => 'text',
					'title' => __('Z-index', 'mfn-opts'),
					'param' => 'number',
					'class' => 'narrow mfn-toggled',
					'preview' => 'number',
				),

  			array(
  				'type' => 'header',
  				'class' => 'toggled_header',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li class="visible-header-builder"><a href="#scroll" data-tab="scroll">Scroll</a></li></ul><div class="mfn-sft mfn-sft-normal">',
				),

				array(
					'id' => 'background_switcher',
					'attr_id' => 'background_switcher',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'video' => __('Video', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'video' 	=> '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement:gradient',
  				'id' => 'css_advanced_gradient',
   				'selector' => '.mcb-section-mfnuidelement',
   				'style' => 'gradient',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
  			),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement:background-color',
					'id' => 'css_advanced_background_color',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'background-color',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement:background-image',
					'id' => 'css_advanced_background_image',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'background-image',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => true,

  			),

				array(
  				'id' => 'bg_video_mp4',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'video' ),
  				'class' => 'hidden-header-builder',
  				'type' => 'upload',
  				'title' => __('Video MP4', 'mfn-opts'),
  				'desc' => __('Image will be used as placeholder before video loads and on mobile devices', 'mfn-opts'),
  				'data' => 'video',
  			),

				array(
  				'id' => 'bg_video_dots',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'video' ),
  				'class' => 'hidden-header-builder',
  				'type' => 'switch',
  				'title' => __('Video dotted overlay', 'mfn-opts'),
  				'desc' => __('It hides the pixelation of lower-resolution video but slightly darkens it', 'mfn-opts'),
          'options' => array(
            'hide' => __('Hide', 'mfn-opts'),
            '' => __('Show', 'mfn-opts'),
          ),
          'std' => '',
  			),

  			array(
					'old_id' => 'style:.mcb-section-mfnuidelement:background-repeat',
					'id' => 'css_advanced_background_repeat',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'background-repeat',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,

					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),



				array(
					'old_id' => 'style:.mcb-section-mfnuidelement:background-position',
					'id' => 'css_advanced_background_position',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'background-position',
					'attr_id' => 'bgposopt_rwd',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,
					'class' => 'bgposopt',
					'title' => __('Position', 'mfn-opts'),
					'desc' => __('Doesn\'t work with Attachment / Parallax', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
				),


				array(
					'old_id' => 'style:.mcb-section-mfnuidelement:background-position_v2',
					'id' => 'css_advanced_background_position_v2',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'background-position_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'bgposopt_rwd', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background position', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled mfn-custom-bg-pos',
				),


				array(
					'old_id' => 'style:.mcb-section-mfnuidelement:background-attachment',
					'id' => 'css_advanced_background_attachment',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'background-attachment',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,
					'desc' => __('Parallax doesn\'t work with responsive options', 'mfn-opts'),
					'title' => __('Attachment', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),



				array(
					'old_id' => 'style:.mcb-section-mfnuidelement:background-size',
					'id' => 'css_advanced_background_size',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'background-size',
					'attr_id' => 'custombgsize',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,
					'class' => 'custombgsize custom-background-size-section',
					'title' => __('Size', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'auto' => __('Auto', 'mfn-opts'),
						'contain' => __('Contain', 'mfn-opts'),
						'cover' => __('Cover', 'mfn-opts'),
						'cover-ultrawide' => __('Cover, on ultrawide screens only > 1920px', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
					//'options' => mfna_bg_size()
				),




				array(
					'old_id' => 'style:.mcb-section-mfnuidelement:background-size_v2',
					'id' => 'css_advanced_background_size_v2',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'background-size_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'custombgsize', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background size', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled mfn-custom-bg-size',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement:backdrop-filter',
					'id' => 'css_backdrop_filter',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'backdrop-filter',
					'type' => 'backdrop_filter',
					'label_tools' => true,
					'class' => 'mfn-toggled toggle_fields',
					'title' => __('Backdrop filter', 'mfn-opts'),
				),



				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement:transition',
					'id' => 'css_advanced_transition',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'transition',
					'type' => 'sliderbar',
					'title' => __('Transition duration', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '3',
						'step' => '0.1',
						'unit' => 's',
					)
				),

				array(
					'id' => 'background_switcher_hover',
					'attr_id' => 'background_switcher_hover',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement|hover:gradient',
  				'id' => 'css_advanced_gradient_hover',
   				'selector' => '.mcb-section-mfnuidelement:hover',
   				'style' => 'gradient',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
  			),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement|hover:background-color',
					'id' => 'css_advanced_background_color_hover',
					'selector' => '.mcb-section-mfnuidelement:hover',
					'style' => 'background-color',
					'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement|hover:background-image',
					'id' => 'css_advanced_background_image_hover',
					'selector' => '.mcb-section-mfnuidelement:hover',
					'style' => 'background-image',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => true,

  			),

  			array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-scroll">',
				),

				array(
					'old_id' => 'style:.mfn-header-tmpl .mcb-section-mfnuidelement:transition',
					'id' => 'css_advanced_header_transition',
					'selector' => '.mfn-header-tmpl .mcb-section-mfnuidelement',
					'style' => 'transition',
					'type' => 'sliderbar',
					'style_prefix' => 'background ',
					'title' => __('Transition duration', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '3',
						'step' => '0.1',
						'unit' => 's',
					)
				),

				array(
					'id' => 'background_switcher_scroll',
					'attr_id' => 'background_switcher_scroll',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
  				'old_id' => 'style:.mfn-header-scrolled .mfn-header-tmpl .mcb-section-mfnuidelement:gradient',
  				'id' => 'css_header_scrolled_gradient',
   				'selector' => '.mfn-header-scrolled .mfn-header-tmpl .mcb-section-mfnuidelement',
   				'style' => 'gradient',
  				'condition' => array( 'id' => 'background_switcher_scroll', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
  			),

				array(
					'old_id' => 'style:.mfn-header-scrolled .mfn-header-tmpl .mcb-section-mfnuidelement:background-color',
					'id' => 'css_advanced_scrolled_header_background_color',
					'selector' => '.mfn-header-scrolled .mfn-header-tmpl .mcb-section-mfnuidelement',
					'style' => 'background-color',
					'condition' => array( 'id' => 'background_switcher_scroll', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mfn-header-scrolled .mfn-header-tmpl .mcb-section-mfnuidelement:background-image',
					'id' => 'css_advanced_scrolled_header_background_image',
					'selector' => '.mfn-header-scrolled .mfn-header-tmpl .mcb-section-mfnuidelement',
					'style' => 'background-image',
  				'condition' => array( 'id' => 'background_switcher_scroll', 'opt' => 'is', 'val' => 'default' ),
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => true,

  			),

				array(
					'type' => 'html',
					'html' => '</div></div>', // end: mfn-sidebar-fields-tabs
				),

				// Background Overlay

				array(
					'type' => 'header',
  				'class' => 'toggled_header',
					'title' => __('Background overlay', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:opacity',
					'id' => 'css_advanced_background_overlay_opacity',
					'selector' => '.mcb-section-mfnuidelement .mcb-background-overlay',
					'style' => 'opacity',
					'type' => 'sliderbar',
					'title' => __('Opacity', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '1',
						'step' => '0.01',
					),
					'std' => '0',
				),

				array(
					'id' => 'background_overlay_switcher',
					'attr_id' => 'background_overlay_switcher',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:gradient',
  				'id' => 'css_advanced_overlay_gradient',
					'selector' => '.mcb-section-mfnuidelement .mcb-background-overlay',
					'style' => 'gradient',
  				'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
  			),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-color',
					'id' => 'css_advanced_background_overlay_background_color',
					'selector' => '.mcb-section-mfnuidelement .mcb-background-overlay',
					'style' => 'background-color',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-image',
					'id' => 'css_advanced_background_overlay_background_image',
					'selector' => '.mcb-section-mfnuidelement .mcb-background-overlay',
					'style' => 'background-image',
  				'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => true,

  			),



				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-repeat',
					'id' => 'css_advanced_background_overlay_background_repeat',
					'selector' => '.mcb-section-mfnuidelement .mcb-background-overlay',
					'style' => 'background-repeat',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),



				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-position',
					'id' => 'css_advanced_background_overlay_background_position',
					'selector' => '.mcb-section-mfnuidelement .mcb-background-overlay',
					'style' => 'background-position',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),



				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-attachment',
					'id' => 'css_advanced_background_overlay_background_attachment',
					'selector' => '.mcb-section-mfnuidelement .mcb-background-overlay',
					'style' => 'background-attachment',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,
					'title' => __('Attachment', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),



				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-size',
					'id' => 'css_advanced_background_overlay_background_size',
					'selector' => '.mcb-section-mfnuidelement .mcb-background-overlay',
					'style' => 'background-size',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),


				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:filter',
					'id' => 'css_advanced_background_overlay_filter',
					'selector' => '.mcb-section-mfnuidelement .mcb-background-overlay',
					'style' => 'filter',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'css_filters',
					'label_tools' => true,
					'class' => 'mfn-toggled toggle_fields',
					'title' => __('CSS Filters', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:transition',
					'id' => 'css_advanced_background_overlay_transition',
					'selector' => '.mcb-section-mfnuidelement .mcb-background-overlay',
					'style' => 'transition',
					'type' => 'sliderbar',
					'title' => __('Transition duration', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '3',
						'step' => '0.1',
						'unit' => 's',
					)
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement|hover .mcb-background-overlay:opacity',
					'id' => 'css_advanced_background_overlay_opacity_hover',
					'selector' => '.mcb-section-mfnuidelement:hover .mcb-background-overlay',
					'style' => 'opacity',
					'type' => 'sliderbar',
					'title' => __('Opacity', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '1',
						'step' => '0.01',
					),
					//'std' => '1',
				),

				array(
					'id' => 'background_switcher_hover',
					'attr_id' => 'background_switcher_hover',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
						'default' => __('Default', 'mfn-opts'),
						'gradient' 	=> __('Gradient', 'mfn-opts'),
					),
					'visual_options' => array(
						'default' => '',
						'gradient' 	=> '',
					),
					'std' => 'default',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement|hover .mcb-background-overlay:gradient',
					'id' => 'css_advanced_overlay_gradient_hover',
					'selector' => '.mcb-section-mfnuidelement:hover .mcb-background-overlay',
					'style' => 'gradient',
					'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
					'type' => 'gradient',
					'title' => __('Gradient', 'mfn-opts'),
					'class' => 'mfn-toggled',
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement|hover .mcb-background-overlay:background-color',
					'id' => 'css_advanced_background_overlay_background_color_hover',
					'selector' => '.mcb-section-mfnuidelement:hover .mcb-background-overlay',
					'style' => 'background-color',
					'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement|hover .mcb-background-overlay:background-image',
					'id' => 'css_advanced_background_overlay_background_image_hover',
					'selector' => '.mcb-section-mfnuidelement:hover .mcb-background-overlay',
					'style' => 'background-image',
					'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'upload',
					'title' => __('Image', 'mfn-opts'),
					'responsive' => true,

				),

				array(
					'type' => 'html',
					'html' => '</div></div>', // end: mfn-sidebar-fields-tabs
				),

				array(
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Border', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement:border-style',
					'id' => 'css_advanced_border_style',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'border-style',
					'attr_id' => 'border_style_sect',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Border style', 'mfn-opts'),
					'options' => [
						'none' => __('None', 'mfn-opts'),
						'solid' => __('Solid', 'mfn-opts'),
						'dashed' => __('Dashed', 'mfn-opts'),
						'dotted' => __('Dotted', 'mfn-opts'),
						'double' => __('Double', 'mfn-opts'),
					],
				),

				array(
					'old_id' => 'style:.mcb-section-mfnuidelement:border-color',
					'id' => 'css_advanced_border_color',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'border-color',
					'condition' => array( 'id' => 'border_style_sect', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement:border-width',
					'id' => 'css_advanced_border_width',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'border-width',
  				'condition' => array( 'id' => 'border_style_sect', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),


				array(
  				'old_id' => 'style:.mcb-section-mfnuidelement:border-radius',
					'id' => 'css_advanced_border_radius',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'border-radius',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),



  			array(
  				'old_id' => 'style:.mcb-section-mfnuidelement:box-shadow',
					'id' => 'css_advanced_box_shadow',
					'selector' => '.mcb-section-mfnuidelement',
					'style' => 'box-shadow',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),




  			array(
  				'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Responsive', 'mfn-opts'),
				),

				array(
  				'id' => 'visibility',
  				'iconinfo' => 'https://support.muffingroup.com/video-tutorials/section-responsive-visibility/',
  				'type' => 'switch',
  				'invert' => true,
  				'version' => 'multiple',
  				'class' => 'mfn-toggled',
  				'title' => __('Responsive visibility', 'mfn-opts'),
  				'active_tooltip' => array(
  					'hide-desktop' => __('Show on Desktop', 'mfn-opts'),
  					'hide-laptop' => __('Show on Laptop', 'mfn-opts'),
  					'hide-tablet' => __('Show on Tablet', 'mfn-opts'),
  					'hide-mobile' => __('Show on Mobile', 'mfn-opts'),
  				),
  				'options' => array(
  					'hide-desktop' => __('Hide on Desktop', 'mfn-opts'),			// 960 +
  					'hide-laptop' => __('Hide on Laptop', 'mfn-opts'),
  					'hide-tablet' => __('Hide on Tablet', 'mfn-opts'),		// 768 - 959
  					'hide-mobile' => __('Hide on Mobile', 'mfn-opts'),			// - 768
  				),
  				'visual_options' => array(
  					'hide-desktop' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M4.94,5H17.06a.93.93,0,0,1,.94.91v7.18a.93.93,0,0,1-.94.91H4.94A.93.93,0,0,1,4,13.09V5.91A.93.93,0,0,1,4.94,5Z"/><path class="cls-1" d="M7,17h8"/><path class="cls-2" d="M13,15.51a1.58,1.58,0,0,0,.7,1.26L14,17H8l.3-.23A1.58,1.58,0,0,0,9,15.51V14h4Z"/></svg>',			// 960 +
  					'hide-laptop' => '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"viewBox="0 0 22 22" style="enable-background:new 0 0 22 22;" xml:space="preserve"> <style type="text/css"> .st0{fill:none;stroke:currentColor;stroke-width:1.5;stroke-linecap:round;stroke-linejoin:round;} </style> <path class="st0" d="M5,15V6.9C5,6.4,5.4,5.9,5.9,6h10.1c0.5,0,0.9,0.4,0.9,0.9V15"/> <path class="st0" d="M4,17h14"/> </svg>',		// 768 - 959
  					'hide-tablet' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}</style></defs><path class="cls-1" d="M7,15.83V7.17A1.21,1.21,0,0,1,8.25,6h5.5A1.21,1.21,0,0,1,15,7.17v8.66A1.21,1.21,0,0,1,13.75,17H8.25A1.21,1.21,0,0,1,7,15.83Z"/></svg>',		// 768 - 959
  					'hide-mobile' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M8,15.82V8.18A1.08,1.08,0,0,1,8.94,7h4.12A1.08,1.08,0,0,1,14,8.18v7.64A1.08,1.08,0,0,1,13.06,17H8.94A1.08,1.08,0,0,1,8,15.82Z"/><circle class="cls-2" cx="11" cy="14" r="1"/></svg>',			// - 768
  				),
  			),

  			array(
  				'id' => 'reverse_order',
  				'class' => 'mfn-toggled hide_if_ql',
  				'type' => 'switch',
  				'iconinfo' => 'https://support.muffingroup.com/how-to/how-to-reverse-the-order-of-elements-on-mobile/',
  				'title' => __('Order on mobile', 'mfn-opts'),
					'options' => [
						0 => __('Default', 'mfn-opts'),
						1 => __('Reverse rows', 'mfn-opts'),
						2 => __('Reverse columns', 'mfn-opts'),
					],
					'std' => 0,
  			),

  			// Conditions

				array(
					'form' => 'advanced',
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Conditional logic', 'mfn-opts'),
				),

				array(
					'form' => 'advanced',
  				'id' => 'conditional_logic',
  				'class' => 'mfn-toggled',
  				'type' => 'logic',
  				'title' => __('Conditional logic', 'mfn-opts'),
  			),

  			// Extras

				array(
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Extras', 'mfn-opts'),
				),

				array(
  				'id' => 'css_advanced_overflow',
  				'selector' => '.mcb-section-mfnuidelement',
					'style' => 'overflow',
  				'type' => 'switch',
  				'class' => 'mfn-toggled',
  				'title' => __('Overflow', 'mfn-opts'),
  				'desc' => __('Changing this option will hide the toolbar. To access its options, open the Navigator (Ctrl/Cmd + I)', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'auto' => __('Auto', 'mfn-opts'),
  					'hidden' => __('Hidden', 'mfn-opts'),
  				),
  				'std' => ''
  			),

				array(
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Custom', 'mfn-opts'),
				),

				array(
  				'id' => 'classes',
  				'class' => 'mfn-toggled',
  				'type' => 'pills',
  				'title' => __('Classes', 'mfn-opts'),
  			),

  			array(
  				'id' => 'custom_id',
  				'class' => 'mfn-toggled',
  				'type' => 'text',
  				'title' => __('ID', 'mfn-opts'),
  			),

  			array(
  				'id' => 'custom_css',
  				'class' => 'mfn-toggled',
  				'type' => 'textarea',
  				'title' => __('Additional CSS', 'mfn-opts'),
  			),

			  array(
			  	'type' => 'header',
					'id' => 'global_sections',
					'class' => 'toggled_header global_sections',
					'title' => __('Global Section', 'mfn-opts'),
				),

				array(
					'id' => 'global_sections_select',
					'attr_id' => 'global_sections_select',
					'class' => 'mfn-toggled global_sections',
					'type' => 'select',
					'title' => __('Select template', 'mfn-opts'),
					'std' => '',
					'js_options' => 'global_sections',
					'php_options' => mfna_templates('section'),
				),

  			array(
					'type' => 'html',
					'html' => '</div>', // end: modalbox-card
				)

  		);

  	}

    /**
     * SET wrap fields
   	 */

    private function set_wrap()
  	{
  		$this->wrap = array(

  			/**
  			 * HEADER additional fields
  			* */

				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
				),

				// options

				array(
					'type'  => 'header',
					'class' => 'hidden-header-builder',
					'title' => __('Options', 'mfn-opts'),
				),

  			array(
  				'id' => 'grid',
  				'attr_id' => 'wrap_grid',
  				'class' => 'hidden-header-builder',
  				'type' => 'switch',
  				'title' => __('Display', 'mfn-opts'),
  				'desc' => __('In the Grid model, the widths of columns are determined by the Column Size. The elements’ margins are set to zero.', 'mfn-opts'),
  				'options' => array(
  					'' => __('Flexbox', 'mfn-opts'),
  					'grid' => __('Grid', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'grid_columns_switcher',
  				'attr_id' => 'grid_columns_switcher',
  				'condition' => array( 'id' => 'wrap_grid', 'opt' => 'is', 'val' => 'grid' ),
  				'class' => 'hidden-header-builder',
  				'type' => 'switch',
  				'title' => __('Columns', 'mfn-opts'),
  				'options' => array(
  					'' => __('Defined', 'mfn-opts'),
  					'custom' => __('Custom', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'css_grid_columns',
  				'selector' => '.mcb-section .mcb-wrap-grid.mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'grid-template-columns',
  				'attr_id' => 'grid_columns',
  				'responsive' => true,
  				'required' => true,
  				'condition' => array( 'AND', array('id' => 'wrap_grid', 'opt' => 'is', 'val' => 'grid'), array('id' => 'grid_columns_switcher', 'opt' => 'is', 'val' => '') ),
  				'class' => 'hidden-header-builder mfn-grid-columns-switcher',
  				'type' => 'switch',
  				'title' => __('Columns', 'mfn-opts'),
  				'options' => array(
  					'1fr' => __('1', 'mfn-opts'),
  					'repeat(2, 1fr)' => __('2', 'mfn-opts'),
  					'repeat(3, 1fr)' => __('3', 'mfn-opts'),
  					'repeat(4, 1fr)' => __('4', 'mfn-opts'),
  					'repeat(5, 1fr)' => __('5', 'mfn-opts'),
  					'repeat(6, 1fr)' => __('6', 'mfn-opts'),
  				),
  				'std' => 'repeat(3, 1fr)'
  			),

  			array(
  				'id' => 'css_grid_columns_custom',
  				'selector' => '.mcb-section .mcb-wrap-grid.mcb-wrap-grid-col-custom.mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'grid-template-columns',
  				'responsive' => true,
  				'condition' => array( 'AND', array('id' => 'wrap_grid', 'opt' => 'is', 'val' => 'grid'), array('id' => 'grid_columns_switcher', 'opt' => 'is', 'val' => 'custom' ) ),
  				'class' => 'hidden-header-builder',
  				'type' => 'text',
  				'title' => __('Grid template columns', 'mfn-opts'),
  				'desc' => __('Defines the number and width of columns in a CSS Grid layout e.g. <code>repeat(3, 1fr)</code>, <code>300px 1fr 400px</code>'),
  				'std' => ''
  			),

  			array(
  				'id' => 'css_grid_columns_gap',
  				'selector' => '.mcb-section .mcb-wrap-grid.mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'column-gap',
  				'responsive' => true,
  				'condition' => array( 'id' => 'wrap_grid', 'opt' => 'is', 'val' => 'grid' ),
  				'class' => 'hidden-header-builder',
  				'type' => 'text',
  				'default_unit' => 'px',
  				'title' => __('Column gap', 'mfn-opts'),
  				'js_std' => '0px'
  			),

  			array(
  				'id' => 'css_grid_rows_gap',
  				'selector' => '.mcb-section .mcb-wrap-grid.mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'row-gap',
  				'responsive' => true,
  				'condition' => array( 'id' => 'wrap_grid', 'opt' => 'is', 'val' => 'grid' ),
  				'class' => 'hidden-header-builder',
  				'type' => 'text',
  				'default_unit' => 'px',
  				'title' => __('Row gap', 'mfn-opts'),
  				'js_std' => '0px'
  			),

  			array(
  				'id' => 'sticky',
  				'attr_id' => 'wrap_sticky_rwd',
  				'class' => 'hidden-header-builder mfn-hidden-nested-wrap',
  				'type' => 'switch',
  				'responsive' => true,
  				'title' => __('Sticky', 'mfn-opts'),
  				'desc' => __('Does <b>not</b> work with Move up and Parallax', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
  			),

  			array(
  				'id' => 'sticky_offset',
					'condition' => array( 'id' => 'wrap_sticky_rwd', 'opt' => 'is', 'val' => '1' ),
					'type' => 'sliderbar',
					'class' => 'hidden-header-builder mfn-hidden-nested-wrap',
					'responsive' => true,
					'title' => __('Sticky offset', 'mfn-opts'),
					'desc' => __('Offset from top during scrolling', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '1000',
						'step' => '1',
						'unit' => '',
					)
  			),

  			array(
					'id' => 'info',
					'class' => 'visible-header-builder mfn-alert',
					'type' => 'info',
					'title' => __('This element has no attributes. Please check <b>advanced</b> tab for more customisation options.', 'mfn-opts'),
				),

  			array(
  				'id' => 'type',
  				're_render' => true,
  				'attr_id' => 'wrap_type',
  				'class' => 'hidden-header-builder mfn-loop-switcher',
  				'type' => 'switch',
  				'title' => __('Type', 'mfn-opts'),
  				'desc' => __('Query loop displays wrap&apos;s content in designed loop', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'query' => __('Query loop', 'mfn-opts'),
  				),
  				'std' => ''
  			),


  			/* query type */

  			array(
  				'id' => 'query_type',
  				're_render' => true,
  				'attr_id' => 'query_type',
  				'class' => 'hidden-header-builder hidden-archive-template-builder',
  				'condition' => array( 'id' => 'wrap_type', 'opt' => 'is', 'val' => 'query' ),
  				'type' => 'select',
  				'title' => __('Query type', 'mfn-opts'),
  				'options' => array(
  					'' => __('Select', 'mfn-opts'),
  					'posts' => __('Posts', 'mfn-opts'),
  					'terms' => __('Terms', 'mfn-opts')
  				),
  				'std' => ''
  			),

  			/* posts query builder */

  			array(
  				'id' => 'query_post_type',
  				're_render' => true,
  				're_render_sidebar' => true,
  				'attr_id' => 'query_post_type',
  				'class' => 'hidden-header-builder hidden-archive-template-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'select',
  				'title' => __('Post type', 'mfn-opts'),
  				'mfn_options' => 'post_types',
  				/*
  				'options' => array(
  					'' => __('- Select -', 'mfn-opts'),
  					'post' => __('Post', 'mfn-opts'),
  					'page' => __('Page', 'mfn-opts'),
  					'portfolio' => __('Portfolio', 'mfn-opts'),
  					'offer' => __('Offer', 'mfn-opts'),
  					'client' => __('Clients', 'mfn-opts'),
  					'slide' => __('Slides', 'mfn-opts'),
  					'product' => __('Product', 'mfn-opts'),
  					'testimonial' => __('Testimonial', 'mfn-opts'),
  				),*/
  				'std' => 'post'
  			),

  			array(
					'id' => 'query_post_type_{mfn.current_post_type}',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'isnt', 'val' => '' ),
					're_render' => true,
					'class' => 'hidden-archive-template-builder',
					'type' => 'multiselect',
					'title' => __('Taxonomies included', 'mfn-opts'),
   				'post_tax' => true,
				),

				array(
					'id' => 'query_post_type_{mfn.current_post_type}_exclude',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'isnt', 'val' => '' ),
					're_render' => true,
					'class' => 'hidden-archive-template-builder',
					'type' => 'multiselect',
					'title' => __('Taxonomies excluded', 'mfn-opts'),
   				'post_tax' => true,
				),

				array(
					'id' => 'query_post_type_product_order',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'product' ),
					're_render' => true,
					'type' => 'select',
					'desc' => __('This option turns off standard order settings', 'mfn-opts'),
					'title' => __('Display', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'on_sale' => __('On sale', 'mfn-opts'),
						'best_selling' => __('Best selling', 'mfn-opts'),
						'top_rated' => __('Top rated', 'mfn-opts'),
					),
					'std' => '',
				),

  			array(
  				'id' => 'query_post_orderby',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'select',
  				'title' => __('Order by', 'mfn-opts'),
  				'options' => array(
  					'' => __('None', 'mfn-opts'),
  					'ID' => __('ID', 'mfn-opts'),
  					'date' => __('Date', 'mfn-opts'),
  					'modified' => __('Modified', 'mfn-opts'),
  					'menu_order' => __('Menu order', 'mfn-opts'),
  					'title' => __('Title', 'mfn-opts'),
  					'rand' => __('Rand', 'mfn-opts'),
  				),
  				'std' => 'date'
  			),

  			array(
  				'id' => 'query_post_order',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'select',
  				'title' => __('Order', 'mfn-opts'),
  				'options' => array(
  					'ASC' => __('Ascending', 'mfn-opts'),
  					'DESC' => __('Descending', 'mfn-opts'),
  				),
  				'std' => 'DESC'
  			),

  			array(
  				'id' => 'query_post_per_page',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'text',
  				'title' => __('Limit', 'mfn-opts'),
  				'desc' => __('By default limit from Admin > Settings > Reading > Blog pages show at most', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '0',
					'mfn_options' => 'per_page',
  			),

  			array(
  				'id' => 'query_post_offset',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'text',
  				'title' => __('Offset', 'mfn-opts'),
  				'desc' => __('This option omits provided quantity of posts (from the beginning)', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '0',
  			),

  			/*array(
  				'id' => 'query_post_pagination',
  				'attr_id' => 'query_post_pagination',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'select',
  				'title' => __('Pagination', 'mfn-opts'),
  				'options' => array(
  					'' => __('Hidden', 'mfn-opts'),
  					'numbers' => __('Numbers + links', 'mfn-opts'),
  					'dots' => __('Dots + links', 'mfn-opts'),
  					'prevnext' => __('Prev / Next links', 'mfn-opts'),
  					'loadmore' => __('Load more', 'mfn-opts'),
  					'infiniteload' => __('Infinite load', 'mfn-opts'),
  				),
  				'std' => ''
  			),*/

  			/* terms query builder */

  			array(
  				'id' => 'query_terms_taxonomy',
  				'attr_id' => 'query_terms_taxonomy',
  				're_render' => true,
  				're_render_sidebar' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Taxonomy', 'mfn-opts'),
  				'mfn_options' => 'taxonomies',
  				/*'options' => array(
  					'' => __('- Select -', 'mfn-opts'),
  					'category' => __('Post category', 'mfn-opts'),
  					'post_tag' => __('Post tag', 'mfn-opts'),
  					'portfolio_types' => __('Portfolio category', 'mfn-opts'),
  					'offer_types' => __('Offer category', 'mfn-opts'),
  					'product_cat' => __('Product category', 'mfn-opts'),
  					'testimonial_types' => __('Testimonial category', 'mfn-opts'),
  				),*/
  				'std' => 'category'
  			),




  			array(
  				'id' => 'query_terms_includes_{mfn.current_tax}',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'isnt', 'val' => '' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to include', 'mfn-opts'),
  				//'options' => mfn_get_categories('post_tag'),
   				'tax_cpt' => true,
  			),

  			array(
  				'id' => 'query_terms_excludes_{mfn.current_tax}',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'isnt', 'val' => '' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
   				'tax_cpt' => true,
  			),









  			array(
  				'id' => 'query_terms_child_of_product_cat',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'product_cat' ),
  				're_render' => true,
  				'type' => 'select',
  				'title' => __('Child of', 'mfn-opts'),
					'mfn_taxonomies' => 'product_cat',
					'opt_append' => array(
						'0-current' => 'Current'
					),
  			),

  			array(
  				'id' => 'query_terms_orderby',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Order by', 'mfn-opts'),
  				'options' => array(
  					'' => __('None', 'mfn-opts'),
  					'term_order' => __('Term order', 'mfn-opts'),
  					'term_id' => __('ID', 'mfn-opts'),
  					'name' => __('Name', 'mfn-opts'),
  					'count' => __('Count', 'mfn-opts'),
  				),
  				'std' => 'ID'
  			),

  			array(
  				'id' => 'query_terms_order',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Order', 'mfn-opts'),
  				'options' => array(
  					'ASC' => __('Ascending', 'mfn-opts'),
  					'DESC' => __('Descending', 'mfn-opts'),
  				),
  				'std' => 'ASC'
  			),

  			array(
  				'id' => 'query_terms_hide_empty',
  				'class' => 'hidden-header-builder',
  				're_render' => true,
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Hide empty', 'mfn-opts'),
  				'options' => array(
  					'' => __('False', 'mfn-opts'),
  					'1' => __('True', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_terms_number',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'text',
  				'title' => __('Limit', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '0',
  			),





				// deprecated

				array(
					'type' => 'header',
					'class' => 'hidden-header-builder mfn-deprecated',
					'title' => __('Deprecated', 'mfn-opts'),
				),

				array(
  				'id' => 'bg_color',
  				'class' => 'mfn-deprecated',
  				'type' => 'color',
  				'title' => __('Background color', 'mfn-opts'),
  				'alpha' => true,
  			),

  			array(
  				'id' => 'bg_image',
  				'class' => 'mfn-deprecated',
  				'type' => 'upload',
  				'title' => __('Background image', 'mfn-opts'),
  				'desc' => __('Recommended image width <b>320px - 1920px</b> depending on size of the wrap', 'mfn-opts'),
  			),

  			array(
  				'id' => 'bg_position',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Background position', 'mfn-opts'),
					'desc' => __('iOS does <b>not</b> support background-position: fixed<br/>For parallax required background image size is at least 1920px x 1080px', 'mfn-opts'),
  				'options' => mfna_bg_position(),
  			),

  			array(
  				'id' => 'bg_size',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Background size', 'mfn-opts'),
					'desc' => __('Does <b>not</b> work with position fixed or parallax', 'mfn-opts'),
  				'options' => mfna_bg_size(),
  			),

  			array(
  				'id' => 'move_up',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Move up', 'mfn-opts'),
  				'desc' => __('Move this wrap to overflow on previous section. Does <b>not</b> work with parallax', 'mfn-opts'),
  				'after' => 'px',
  			),

  			array(
  				'id' => 'padding',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Padding', 'mfn-opts'),
  				'desc' => __('Use value with <b>px</b> or <b>%</b><br />Example: 20px or 20px 10px 20px 10px or 20px 1%', 'mfn-opts'),
  			),

  			array(
  				'id' => 'column_margin',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Elements margin bottom', 'mfn-opts'),
  				'options' => array(
  					'' => __('- Default -', 'mfn-opts'),
  					'0px' => '0px',
  					'10px' => '10px',
  					'20px' => '20px',
  					'30px' => '30px',
  					'40px' => '40px',
  					'50px' => '50px',
  				),
  			),

				array(
  				'id' => 'vertical_align',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Elements vertical align', 'mfn-opts'),
  				'desc' => __('for Section style: <b>Equal height of wraps</b>', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'top' => __('Top', 'mfn-opts'),
  					'middle' => __('Middle', 'mfn-opts'),
  					'bottom' => __('Bottom', 'mfn-opts'),
  				),
  			),

				array(
					'id' => 'class',
					'type' => 'pills',
					'title' => __('Wrap classes', 'mfn-opts'),
					'class' => 'mfn-deprecated',
				),

				array(
					'id' => 'style',
					'type' => 'textarea',
					'title' => __('Wrap inline CSS', 'mfn-opts'),
					'desc' => __('Example: <b>border: 1px solid #999;</b>', 'mfn-opts'),
					'class' => 'mfn-deprecated',
				),

				array(
					'type' => 'helper',
					'class' => 'mfn-deprecated',
					'title' => __('Need help', 'mfn-opts'),
					'link' => 'https://support.muffingroup.com/faq/what-deprecated-in-the-bebuilder-means/',
				),

				array(
					'type' => 'html',
					'html' => '</div>',
				),















				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-card-style">',
				),


				array(
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Container', 'mfn-opts'),
				),

				array(
  				'id' => 'query_display',
  				'attr_id' => 'query_display',
  				're_render' => true,
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Display', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'slider' => __('Slider', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_columns',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'narrow mfn-toggled',
  				'responsive' => true,
  				're_render' => true,
  				'type' => 'text',
  				'title' => __('Columns', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '1',
  			),


  			array(
  				'id' => 'query_slider_infinity',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Infinite loop', 'mfn-opts'),
  				'options' => array(
  					'' => __('Off', 'mfn-opts'),
  					'1' => __('On', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_autoplay',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'default_unit' => '',
					'class' => 'mfn-toggled',
					'title' => __('Autoplay speed', 'mfn-opts'),
					'desc' => __('Leave empty to disallow autoplay', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '15000',
						'step' => '100',
						'unit' => '',
					)
  			),

  			array(
  				'id' => 'query_slider_speed',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'default_unit' => '',
					'class' => 'mfn-toggled',
					'title' => __('Animation speed', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '5000',
						'step' => '10',
						'unit' => '',
					)
  			),

  			array(
  				'id' => 'query_slider_animation',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'select',
  				'title' => __('Animation type', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'fade' => __('Fade', 'mfn-opts'),
  					'cards' => __('Cards', 'mfn-opts'),
  					'flip' => __('Flip', 'mfn-opts'),
  					'cube' => __('Cube', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_arrows',
  				'attr_id' => 'query_slider_arrows',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				're_render' => true,
  				'type' => 'switch',
  				'title' => __('Arrows', 'mfn-opts'),
  				'options' => array(
  					'0' => __('Hide', 'mfn-opts'),
  					'1' => __('Show', 'mfn-opts'),
  				),
  				'std' => '0'
  			),

  			array(
  				'id' => 'query_slider_arrows_style',
  				'attr_id' => 'query_slider_arrows_style',
  				'condition' => array( 'id' => 'query_slider_arrows', 'opt' => 'is', 'val' => '1' ),
  				'class' => 'mfn-toggled',
  				're_render' => true,
  				'type' => 'switch',
  				'title' => __('Arrows style', 'mfn-opts'),
  				'options' => array(
  					'' => __('Standard', 'mfn-opts'),
  					'overlay' => __('Overlay', 'mfn-opts'),
  					'custom' => __('Custom', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_arrows_visibility',
  				'iconinfo' => 'https://support.muffingroup.com/video-tutorials/section-responsive-visibility/',
  				'condition' => array( 'id' => 'query_slider_arrows', 'opt' => 'is', 'val' => '1' ),
  				'type' => 'switch',
  				'invert' => true,
  				'version' => 'multiple',
  				'class' => 'mfn-toggled',
  				'title' => __('Arrows visibility', 'mfn-opts'),
  				'active_tooltip' => array(
  					'arrows-hide-desktop' => __('Show on Desktop', 'mfn-opts'),
  					'arrows-hide-laptop' => __('Show on Laptop', 'mfn-opts'),
  					'arrows-hide-tablet' => __('Show on Tablet', 'mfn-opts'),
  					'arrows-hide-mobile' => __('Show on Mobile', 'mfn-opts'),
  				),
  				'options' => array(
  					'arrows-hide-desktop' => __('Hide on Desktop', 'mfn-opts'),			// 960 +
  					'arrows-hide-laptop' => __('Hide on Laptop', 'mfn-opts'),
  					'arrows-hide-tablet' => __('Hide on Tablet', 'mfn-opts'),		// 768 - 959
  					'arrows-hide-mobile' => __('Hide on Mobile', 'mfn-opts'),			// - 768
  				),
  				'visual_options' => array(
  					'arrows-hide-desktop' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M4.94,5H17.06a.93.93,0,0,1,.94.91v7.18a.93.93,0,0,1-.94.91H4.94A.93.93,0,0,1,4,13.09V5.91A.93.93,0,0,1,4.94,5Z"/><path class="cls-1" d="M7,17h8"/><path class="cls-2" d="M13,15.51a1.58,1.58,0,0,0,.7,1.26L14,17H8l.3-.23A1.58,1.58,0,0,0,9,15.51V14h4Z"/></svg>',			// 960 +
  					'arrows-hide-laptop' => '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"viewBox="0 0 22 22" style="enable-background:new 0 0 22 22;" xml:space="preserve"> <style type="text/css"> .st0{fill:none;stroke:currentColor;stroke-width:1.5;stroke-linecap:round;stroke-linejoin:round;} </style> <path class="st0" d="M5,15V6.9C5,6.4,5.4,5.9,5.9,6h10.1c0.5,0,0.9,0.4,0.9,0.9V15"/> <path class="st0" d="M4,17h14"/> </svg>',		// 768 - 959
  					'arrows-hide-tablet' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}</style></defs><path class="cls-1" d="M7,15.83V7.17A1.21,1.21,0,0,1,8.25,6h5.5A1.21,1.21,0,0,1,15,7.17v8.66A1.21,1.21,0,0,1,13.75,17H8.25A1.21,1.21,0,0,1,7,15.83Z"/></svg>',		// 768 - 959
  					'arrows-hide-mobile' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M8,15.82V8.18A1.08,1.08,0,0,1,8.94,7h4.12A1.08,1.08,0,0,1,14,8.18v7.64A1.08,1.08,0,0,1,13.06,17H8.94A1.08,1.08,0,0,1,8,15.82Z"/><circle class="cls-2" cx="11" cy="14" r="1"/></svg>',			// - 768
  				),
  			),

  			array(
  				'id' => 'query_slider_dots',
  				'attr_id' => 'query_slider_dots',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				're_render' => true,
  				'type' => 'switch',
  				'title' => __('Dots', 'mfn-opts'),
  				'options' => array(
  					'0' => __('Hide', 'mfn-opts'),
  					'1' => __('Show', 'mfn-opts'),
  				),
  				'std' => '0'
  			),

  			array(
  				'id' => 'query_slider_dots_style',
  				'attr_id' => 'query_slider_dots_style',
  				'condition' => array( 'id' => 'query_slider_dots', 'opt' => 'is', 'val' => '1' ),
  				'class' => 'mfn-toggled',
  				're_render' => true,
  				'type' => 'switch',
  				'title' => __('Dots style', 'mfn-opts'),
  				'options' => array(
  					'' => __('Standard', 'mfn-opts'),
  					'overlay' => __('Overlay', 'mfn-opts'),
  					'custom' => __('Custom', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_dots_count',
  				'condition' => array( 'id' => 'query_slider_dots', 'opt' => 'is', 'val' => '1' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				're_render' => true,
  				'title' => __('Dots count', 'mfn-opts'),
  				'options' => array(
  					'' => __('Standard', 'mfn-opts'),
  					'dynamic' => __('Dynamic', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_dots_visibility',
  				'iconinfo' => 'https://support.muffingroup.com/video-tutorials/section-responsive-visibility/',
  				'condition' => array( 'id' => 'query_slider_dots', 'opt' => 'is', 'val' => '1' ),
  				'type' => 'switch',
  				'invert' => true,
  				'version' => 'multiple',
  				'class' => 'mfn-toggled',
  				'title' => __('Dots visibility', 'mfn-opts'),
  				'active_tooltip' => array(
  					'dots-hide-desktop' => __('Show on Desktop', 'mfn-opts'),
  					'dots-hide-laptop' => __('Show on Laptop', 'mfn-opts'),
  					'dots-hide-tablet' => __('Show on Tablet', 'mfn-opts'),
  					'dots-hide-mobile' => __('Show on Mobile', 'mfn-opts'),
  				),
  				'options' => array(
  					'dots-hide-desktop' => __('Hide on Desktop', 'mfn-opts'),			// 960 +
  					'dots-hide-laptop' => __('Hide on Laptop', 'mfn-opts'),
  					'dots-hide-tablet' => __('Hide on Tablet', 'mfn-opts'),		// 768 - 959
  					'dots-hide-mobile' => __('Hide on Mobile', 'mfn-opts'),			// - 768
  				),
  				'visual_options' => array(
  					'dots-hide-desktop' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M4.94,5H17.06a.93.93,0,0,1,.94.91v7.18a.93.93,0,0,1-.94.91H4.94A.93.93,0,0,1,4,13.09V5.91A.93.93,0,0,1,4.94,5Z"/><path class="cls-1" d="M7,17h8"/><path class="cls-2" d="M13,15.51a1.58,1.58,0,0,0,.7,1.26L14,17H8l.3-.23A1.58,1.58,0,0,0,9,15.51V14h4Z"/></svg>',			// 960 +
  					'dots-hide-laptop' => '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"viewBox="0 0 22 22" style="enable-background:new 0 0 22 22;" xml:space="preserve"> <style type="text/css"> .st0{fill:none;stroke:currentColor;stroke-width:1.5;stroke-linecap:round;stroke-linejoin:round;} </style> <path class="st0" d="M5,15V6.9C5,6.4,5.4,5.9,5.9,6h10.1c0.5,0,0.9,0.4,0.9,0.9V15"/> <path class="st0" d="M4,17h14"/> </svg>',		// 768 - 959
  					'dots-hide-tablet' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}</style></defs><path class="cls-1" d="M7,15.83V7.17A1.21,1.21,0,0,1,8.25,6h5.5A1.21,1.21,0,0,1,15,7.17v8.66A1.21,1.21,0,0,1,13.75,17H8.25A1.21,1.21,0,0,1,7,15.83Z"/></svg>',		// 768 - 959
  					'dots-hide-mobile' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M8,15.82V8.18A1.08,1.08,0,0,1,8.94,7h4.12A1.08,1.08,0,0,1,14,8.18v7.64A1.08,1.08,0,0,1,13.06,17H8.94A1.08,1.08,0,0,1,8,15.82Z"/><circle class="cls-2" cx="11" cy="14" r="1"/></svg>',			// - 768
  				),
  			),

  			array(
  				'id' => 'query_slider_mousewheel',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Mousewheel', 'mfn-opts'),
  				'options' => array(
  					'' => __('Disabled', 'mfn-opts'),
  					'1' => __('Enabled', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_linear',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				're_render' => true,
  				'type' => 'switch',
  				'title' => __('Linear mode', 'mfn-opts'),
  				'desc' => __('Linear mode skips setting the number of columns and autoplay speed', 'mfn-opts'),
  				'options' => array(
  					'' => __('Disabled', 'mfn-opts'),
  					'1' => __('Enabled', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_display_style',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'isnt', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Style', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'masonry' => __('Masonry', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper.mfn-ql-item-default:width',
					'id' => 'css_queryloop_item_width',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper.mfn-ql-item-default',
					'style' => 'width',
					'condition' => array( 'id' => 'query_display', 'opt' => 'isnt', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'default_unit' => 'px',
					'responsive' => true,
					'class' => 'mfn-toggled query_item_default_width sliderbar-units',
					'title' => __('Item width', 'mfn-opts'),
					'units' => array(
						'px' 	=> array('min' => 0, 'max' => 1920, 'step' => 1),
						'%' 	=> array('min' => 0, 'max' => 100, 'step' => 0.1),
						'vw' 	=> array('min' => 0, 'max' => 100, 'step' => 0.1),
					),
				),

  			array(
  				'type' => 'header',
  				'class' => 'toggled_header',
					'title' => __('Item', 'mfn-opts'),
				),


				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:min-height',
					'id' => 'css_queryloop_item_min_height',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'min-height',
					'type' => 'text',
					'default_unit' => 'px',
					'title' => __('Min height', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:align-content',
					'id' => 'css_queryloop_item_align_content',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'align-content',
					'type' => 'switch',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Vertical align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => __('Top', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Bottom', 'mfn-opts'),
					],
				),


				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:justify-content',
					'id' => 'css_queryloop_item_justify_content',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'justify-content',
					'type' => 'select',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Horizontal align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
					],
				),





				array(
					'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Spacing', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:padding',
					'id' => 'css_queryloop_item_padding',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'padding',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),



				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:margin',
					'id' => 'css_queryloop_item_margin',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'margin',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),









  			array(
  				'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Border', 'mfn-opts'),
				),

  			array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:border-style',
					'id' => 'css_queryloop_item_border_style',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'border-style',
					'attr_id' => 'border_style_ql',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Border style', 'mfn-opts'),
					'options' => [
						'none' => __('None', 'mfn-opts'),
						'solid' => __('Solid', 'mfn-opts'),
						'dashed' => __('Dashed', 'mfn-opts'),
						'dotted' => __('Dotted', 'mfn-opts'),
						'double' => __('Double', 'mfn-opts'),
					],
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:border-color',
					'id' => 'css_queryloop_item_border_color',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'border-color',
					'condition' => array( 'id' => 'border_style_ql', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:border-width',
					'id' => 'css_queryloop_item_border_width',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'border-width',
  				'condition' => array( 'id' => 'border_style_ql', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),



				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:border-radius',
					'id' => 'css_queryloop_item_border_radius',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'border-radius',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),



  			array(
		  		'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:box-shadow',
					'id' => 'css_queryloop_item_box_shadow',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'box-shadow',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),



  			array(
  				'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

  			array(
					'id' => 'background_switcher_ql',
					'attr_id' => 'background_switcher_ql',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher mfn-toggled disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:gradient',
  				'id' => 'css_query_loop_item_gradient',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'gradient',
  				'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
  			),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:background-color',
					'id' => 'css_queryloop_item_bg_color',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'background-color',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background color', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:background-image',
					'id' => 'css_queryloop_item_bg_image',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'background-image',
  				'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
  				'class' => 'mfn-toggled',
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'responsive' => true,
  				'title' => __('Image', 'mfn-opts'),
  			),


  			array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:background-repeat',
					'id' => 'css_queryloop_item_bg_repeat',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'background-repeat',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'class' => 'mfn-toggled',
					'responsive' => true,
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:background-position',
					'id' => 'css_queryloop_item_bg_position',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'background-position',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),



				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:background-attachment',
					'id' => 'css_queryloop_item_bg_attachment',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'background-attachment',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'class' => 'mfn-toggled',
					'responsive' => true,
					'title' => __('Attachment', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),



				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper:background-size',
					'id' => 'css_queryloop_item_bg_size',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner .mfn-queryloop-item-wrapper',
					'style' => 'background-size',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'responsive' => true,
					'class' => 'mfn-toggled',
					'type' => 'select',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),


				array(
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Pagination', 'mfn-opts'),
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:top',
					'id' => 'css_queryloop_slider_pagination_top',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination',
					'style' => 'top',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled dots-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:bottom',
					'id' => 'css_queryloop_slider_pagination_bottom',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination',
					'style' => 'bottom',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled dots-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:left',
					'id' => 'css_queryloop_slider_pagination_left',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination',
					'style' => 'left',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
						'responsive' => true,
					'class' => 'mfn-toggled dots-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:right',
					'id' => 'css_queryloop_slider_pagination_right',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination',
					'style' => 'right',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled dots-custom-style',
				),




				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination:--mfn-swiper-pagination-spacing',
					'id' => 'css_queryloop_slider_pagination_spacing',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination',
					'style' => '--mfn-swiper-pagination-spacing',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Offset', 'mfn-opts'),
					'desc' => __('Works with Standard and Overlay pagination mode', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),



				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination .swiper-pagination-bullet:--swiper-pagination-bullet-inactive-color',
					'id' => 'css_queryloop_slider_pagination_bullet_inactive_color',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination .swiper-pagination-bullet',
					'style' => '--swiper-pagination-bullet-inactive-color',
					'type' => 'color',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'class' => 'mfn-toggled',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination .swiper-pagination-bullet-active:--mfn-swiper-pagination-bullet-active-color',
					'id' => 'css_queryloop_slider_pagination_bullet_active_color',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination .swiper-pagination-bullet-active',
					'style' => '--mfn-swiper-pagination-bullet-active-color',
					'type' => 'color',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'class' => 'mfn-toggled',
					'title' => __('Active color', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-width',
					'id' => 'css_queryloop_slider_pagination_bullet_width',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet',
					'style' => '--mfn-swiper-pagination-bullet-width',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Width', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),



				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-height',
					'id' => 'css_queryloop_slider_pagination_bullet_height',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet',
					'style' => '--mfn-swiper-pagination-bullet-height',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Height', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),



				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet:border-radius',
					'id' => 'css_queryloop_slider_pagination_bullet_border_radius',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet',
					'style' => 'border-radius',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Border radius', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet:opacity',
					'id' => 'css_queryloop_slider_pagination_bullet_opacity',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet',
					'style' => 'opacity',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Opacity', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '1',
						'step' => '0.01',
					),
					'std' => '0',
				),








				array(
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Arrows', 'mfn-opts'),
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
				),

				array(
					'type' => 'subheader',
  				'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Prev arrow custom style', 'mfn-opts'),
				),

  			array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:top',
					'id' => 'css_queryloop_slider_arrow_prev_top',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow',
					'style' => 'top',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:bottom',
					'id' => 'css_queryloop_slider_arrow_prev_bottom',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow',
					'style' => 'bottom',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:left',
					'id' => 'css_queryloop_slider_arrow_prev_left',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow',
					'style' => 'left',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:right',
					'id' => 'css_queryloop_slider_arrow_prev_right',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow',
					'style' => 'right',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),






				array(
					'type' => 'subheader',
  				'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Next arrow custom style', 'mfn-opts'),
				),

  			array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:top',
					'id' => 'css_queryloop_slider_arrow_next_top',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow',
					'style' => 'top',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:bottom',
					'id' => 'css_queryloop_slider_arrow_next_bottom',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow',
					'style' => 'bottom',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:left',
					'id' => 'css_queryloop_slider_arrow_next_left',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow',
					'style' => 'left',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
						'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:right',
					'id' => 'css_queryloop_slider_arrow_next_right',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow',
					'style' => 'right',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled arrows-custom-style',
				),





				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mfn-swiper-arrow:transformtranslatey',
					'id' => 'css_queryloop_slider_arrow_transformtranslatey',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mfn-swiper-arrow',
					'style' => 'transformtranslatey',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Translate(Y)', 'mfn-opts'),
					'desc' => __('Moves navigation arrows along the Y-axis by the percent height', 'mfn-opts'),
					'after' => '%',
					'param' => array(
						'min' => '-100',
						'max' => '100',
						'step' => '1',
						'unit' => '%',
					)
				),

				array(
					'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'title' => __('Custom arrows', 'mfn-opts'),
				),

				array(
					'id' => 'query_display_slider_arrow_prev',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'icon',
					'class' => 'mfn-toggled',
					'title' => __('Prev arrow', 'mfn-opts'),
					'preview' => 'icon',
					'std' => 'icon-left-open-big'
				),

				array(
					'id' => 'query_display_slider_arrow_next',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'icon',
					'class' => 'mfn-toggled',
					'title' => __('Next arrow', 'mfn-opts'),
					'preview' => 'icon',
					'std' => 'icon-right-open-big'
				),

				array(
					'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'title' => __('Size', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:--mfn-swiper-arrow-width',
					'id' => 'css_queryloop_slider_arrow_width',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow',
					'style' => '--mfn-swiper-arrow-width',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => true,
					'after' => 'px',
					'class' => 'mfn-toggled',
					'title' => __('Width', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:--mfn-swiper-arrow-height',
					'id' => 'css_queryloop_slider_arrow_height',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow',
					'style' => '--mfn-swiper-arrow-height',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => true,
					'after' => 'px',
					'class' => 'mfn-toggled',
					'title' => __('Height', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow i:--mfn-swiper-arrow-size',
					'id' => 'css_queryloop_slider_arrow_icon_size',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow i',
					'style' => '--mfn-swiper-arrow-size',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Size', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:--mfn-swiper-arrow-spacing',
					'id' => 'css_queryloop_slider_arrow_spacing',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow',
					'style' => '--mfn-swiper-arrow-spacing',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => true,
					'class' => 'mfn-toggled',
					'title' => __('Offset', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '-300',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'title' => __('Border', 'mfn-opts'),
				),

  			array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:border-style',
					'id' => 'css_queryloop_slider_arrow_border_style',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow',
					'style' => 'border-style',
					'attr_id' => 'border_style_qlarr',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Border style', 'mfn-opts'),
					'options' => [
						'none' => __('None', 'mfn-opts'),
						'solid' => __('Solid', 'mfn-opts'),
						'dashed' => __('Dashed', 'mfn-opts'),
						'dotted' => __('Dotted', 'mfn-opts'),
						'double' => __('Double', 'mfn-opts'),
					],
				),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:border-width',
					'id' => 'css_queryloop_slider_arrow_border_width',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow',
					'style' => 'border-width',
  				'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),



				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:border-radius',
					'id' => 'css_queryloop_slider_arrow_border_radius',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow',
					'style' => 'border-radius',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),



  			array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:box-shadow',
					'id' => 'css_queryloop_slider_arrowbox_shadow',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow',
					'style' => 'box-shadow',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'class' => 'mfn-toggled',
  			),

				array(
					'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'title' => __('Color', 'mfn-opts'),
				),


				array(
					'type' => 'html',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:--swiper-navigation-color',
					'id' => 'css_queryloop_slider_arrow_navigation_color',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow',
					'style' => '--swiper-navigation-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:background-color',
					'id' => 'css_queryloop_slider_arrow_bg_color',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow',
					'style' => 'background-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:border-color',
					'id' => 'css_queryloop_slider_arrow_border_color',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow',
					'style' => 'border-color',
					'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow|hover:--swiper-navigation-color',
					'id' => 'css_queryloop_slider_arrow_navigation_color_hover',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:hover',
					'style' => '--swiper-navigation-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow|hover:background-color',
					'id' => 'css_queryloop_slider_arrow_background_color_hover',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:hover',
					'style' => 'background-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow|hover:border-color',
					'id' => 'css_queryloop_slider_arrow_border_color_hover',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:hover',
					'style' => 'border-color',
					'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div></div>',
				),


  			array(
					'type' => 'html',
					'html' => '</div>', // end: modalbox-card
				),























				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-card-advanced">',
				),

				array(
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Dimensions', 'mfn-opts'),
				),

				array(
					'id' => 'width_switcher',
					'attr_id' => 'wrap_width_switcher',
					'type' => 'select',
					'class' => 'mfn-toggled mfn-layout-modifier',
					'title' => __('Width', 'mfn-opts'),
					'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'custom' 	=> __('Custom', 'mfn-opts'),
  				),
  				'std' => '',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:flex',
					'id' => 'css_advanced_flex',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement',
					'style' => 'width',
					'type' => 'text',
					'condition' => array( 'id' => 'wrap_width_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => true,
					'default_unit' => 'px',
					'class' => 'mfn-toggled advanced_flex mfn-slider-input mfn-layout-modifier',
					'title' => __('Width', 'mfn-opts'),
					'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
				),

				array(
					'id' => 'height_switcher',
					'attr_id' => 'wrap_height_switcher',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Height', 'mfn-opts'),
					'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'custom' 	=> __('Custom', 'mfn-opts'),
  				),
  				'std' => '',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:height',
					'id' => 'css_advanced_height',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'height',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'wrap_height_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => true,
					'class' => 'mfn-toggled adv_height_wrap mfn-slider-input',
					'title' => __('Height', 'mfn-opts')
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:min-height',
					'id' => 'css_advanced_min_height',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'min-height',
					'type' => 'text',
					'default_unit' => 'px',
					'responsive' => true,
					'class' => 'mfn-toggled mfn-slider-input',
					'title' => __('Min height', 'mfn-opts')
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:flex-grow',
					'id' => 'css_advanced_flex_grow',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement',
					'style' => 'flex-grow',
					'type' => 'select',
					'condition' => array( 'id' => 'wrap_width_switcher', 'opt' => 'is', 'val' => '' ),
					'class' => 'mfn-toggled visible-header-builder',
					'responsive' => true,
					'title' => __('Fit container', 'mfn-opts'),
					'options' => array(
						'unset' => __('Default', 'mfn-opts'),
  					'1' => __('Fit', 'mfn-opts'),
  				),
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:flex-wrap',
					'id' => 'css_advanced_flex_wrap',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'flex-wrap',
					'type' => 'select',
					'class' => 'mfn-toggled visible-header-builder',
					'responsive' => true,
					'title' => __('Wrap elements', 'mfn-opts'),
					'options' => array(
						'nowrap' => __('Nowrap', 'mfn-opts'),
  					'wrap' => __('Wrap', 'mfn-opts'),
  				),
				),

  			array(
  				'type' => 'header',
  				'class' => 'toggled_header',
					'title' => __('Spacing', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:padding',
					'id' => 'css_advanced_padding',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'padding',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:margin',
					'id' => 'css_advanced_margin',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'margin',
  				'version' => 'separated-fields',
  				'type' => 'dimensions',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled advanced_margin',
  			),

  			array(
  				'type' => 'header',
  				'class' => 'toggled_header hide_if_ql-slider',
					'title' => __('Positioning', 'mfn-opts'),
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:align-self',
					'id' => 'css_advanced_align_self',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement',
					'style' => 'align-self',
					'condition' => array( 'id' => 'wrap_sticky_rwd', 'opt' => 'isnt', 'val' => '1' ),
					'type' => 'radio_img',
					'alias' => 'flex-align-self',
					'responsive' => true,
					'class' => 'form-content-full-width small mfn-toggled adv_alignself_wrap',
					'title' => __('Wrap position', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
					),
					'std' => '',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:align-content',
					'id' => 'css_advanced_align_content',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'condition' => array( 'id' => 'wrap_grid', 'opt' => 'is', 'val' => '' ),
					'style' => 'align-content',
					'type' => 'radio_img',
					'alias' => 'flex-align-content',
					'responsive' => true,
					'class' => 'form-content-full-width small mfn-toggled',
					'title' => __('Wrap content position', 'mfn-opts'),
					'desc' => __('Works with <b>Stretch</b> only', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
						'space-between' => 'Space between',
						'space-around' => 'Space around',
						'space-evenly' => 'Space evenly'
					),
					'std' => '',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:align-items',
					'id' => 'css_advanced_align_items',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'align-items',
					'type' => 'radio_img',
					'alias' => 'flex-align-items',
					'class' => 'form-content-full-width small mfn-toggled',
					'responsive' => true,
					'title' => __('Elements vertical align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch columns',
					],
					'std' => '',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:justify-content',
					'id' => 'css_advanced_justify_content',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'justify-content',
					'type' => 'radio_img',
					'alias' => 'flex-justify',
					'class' => 'small mfn-toggled',
					'responsive' => true,
					'title' => __('Elements horizontal align', 'mfn-opts'),
					'desc' => __('Works with flexbox and custom grid template columns', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
					],
					'std' => '',
				),

				array(
					'type' => 'helper',
					'class' => 'mfn-toggled',
					'title' => __('Need help', 'mfn-opts'),
					'link' => 'https://support.muffingroup.com/documentation/bebuilder/positioning/#wrap',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:z-index',
					'id' => 'css_advanced_z_index',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement',
					'style' => 'z-index',
					'type' => 'text',
					'title' => __('Z-index', 'mfn-opts'),
					'param' => 'number',
					'class' => 'narrow mfn-toggled',
					'preview' => 'number',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:order',
					'id' => 'css_advanced_order',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement',
					'style' => 'order',
					'type' => 'text',
					'title' => __('Order', 'mfn-opts'),
					'param' => 'number',
					'class' => 'narrow mfn-toggled',
					'responsive' => true,
					'preview' => 'number',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:position',
					'id' => 'css_advanced_position',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'position',
					'attr_id' => 'wrap_position',
					'type' => 'select',
					'class' => 'mfn-toggled custom-element-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'relative' => __('Offset', 'mfn-opts'),
					],
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:top',
					'id' => 'css_advanced_top',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'top',
					'type' => 'text',
					'default_unit' => 'px',
					'responsive' => true,
					'condition' => array( 'id' => 'wrap_position', 'opt' => 'isnt', 'val' => '' ),
					'title' => __('Top', 'mfn-opts'),
					'class' => 'mfn-toggled custom-abs-offset-values',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:bottom',
					'id' => 'css_advanced_bottom',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'bottom',
					'type' => 'text',
					'default_unit' => 'px',
					'responsive' => true,
					'condition' => array( 'id' => 'wrap_position', 'opt' => 'isnt', 'val' => '' ),
					'title' => __('Bottom', 'mfn-opts'),
					'class' => 'mfn-toggled custom-abs-offset-values',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:left',
					'id' => 'css_advanced_left',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'left',
					'type' => 'text',
					'default_unit' => 'px',
					'responsive' => true,
					'condition' => array( 'id' => 'wrap_position', 'opt' => 'isnt', 'val' => '' ),
					'title' => __('Left', 'mfn-opts'),
					'class' => 'mfn-toggled custom-abs-offset-values',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:right',
					'id' => 'css_advanced_right',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'right',
					'type' => 'text',
					'default_unit' => 'px',
					'responsive' => true,
					'condition' => array( 'id' => 'wrap_position', 'opt' => 'isnt', 'val' => '' ),
					'title' => __('Right', 'mfn-opts'),
					'class' => 'mfn-toggled custom-abs-offset-values',
				),




  			array(
  				'type' => 'header',
  				'class' => 'toggled_header',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
				),

				array(
					'id' => 'background_switcher',
					'attr_id' => 'background_switcher',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:background-color',
					'id' => 'css_advanced_background_color',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'background-color',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:gradient',
  				'id' => 'css_advanced_gradient',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'gradient',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
  			),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:background-image',
					'id' => 'css_advanced_background_image',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'background-image',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => true,

  			),



  			array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:background-repeat',
					'id' => 'css_advanced_background_repeat',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'background-repeat',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,

					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),



				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:background-position',
					'id' => 'css_advanced_background_position',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'background-position',
					'attr_id' => 'bgposopt_rwd',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,
					'class' => 'bgposopt',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
				),



				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:background-position_v2',
					'id' => 'css_advanced_background_position_v2',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'background-position_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'bgposopt_rwd', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background position', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled mfn-custom-bg-pos',
				),





























				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:background-attachment',
					'id' => 'css_advanced_background_attachment',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'background-attachment',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,
					'desc' => __('Parallax doesn\'t work with responsive options', 'mfn-opts'),
					'title' => __('Attachment', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),




				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:background-size',
					'id' => 'css_advanced_background_size',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'background-size',
					'attr_id' => 'custombgsize_rwd',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,
					'class' => 'custombgsize',
					'title' => __('Size', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'auto' => __('Auto', 'mfn-opts'),
						'contain' => __('Contain', 'mfn-opts'),
						'cover' => __('Cover', 'mfn-opts'),
						'cover-ultrawide' => __('Cover, on ultrawide screens only > 1920px', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
					//'options' => mfna_bg_size()
				),





				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:background-size_v2',
					'id' => 'css_advanced_background_size_v2',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'background-size_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'custombgsize_rwd', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background size', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled mfn-custom-bg-size',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:backdrop-filter',
					'id' => 'css_backdrop_filter',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'backdrop-filter',
					'type' => 'backdrop_filter',
					'label_tools' => true,
					'class' => 'mfn-toggled toggle_fields',
					'title' => __('Backdrop filter', 'mfn-opts'),
					'desc' => __('Doesn\'t work with animations', 'mfn-opts'),
				),



				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:transition',
					'id' => 'css_advanced_transition',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'transition',
					'type' => 'sliderbar',
					'title' => __('Transition duration', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '3',
						'step' => '0.1',
						'unit' => 's',
					)
				),

				array(
					'id' => 'background_switcher_hover',
					'attr_id' => 'background_switcher_hover',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner|hover:background-color',
					'id' => 'css_advanced_background_color_hover',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:hover',
					'style' => 'background-color',
					'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner|hover:gradient',
  				'id' => 'css_advanced_gradient_hover',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:hover',
					'style' => 'gradient',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
  			),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner|hover:background-image',
					'id' => 'css_advanced_background_image_hover',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:hover',
					'style' => 'background-image',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => true,

  			),



				array(
					'type' => 'html',
					'html' => '</div></div>',
				),

				// Background Overlay WRAP

				array(
  				'type' => 'header',
  				'class' => 'toggled_header',
					'title' => __('Background Overlay', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay:opacity',
					'id' => 'css_advanced_background_overlay_opacity',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay',
					'style' => 'opacity',
					'type' => 'sliderbar',
					'title' => __('Opacity', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '1',
						'step' => '0.01',
					),
					'std' => '0',
				),

				array(
					'id' => 'background_overlay_switcher',
					'attr_id' => 'background_overlay_switcher',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay:background-color',
					'id' => 'css_advanced_background_overlay_background_color',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay',
					'style' => 'background-color',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay:gradient',
  				'id' => 'css_advanced_overlay_gradient',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay',
					'style' => 'gradient',
  				'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
  			),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay:background-image',
					'id' => 'css_advanced_background_overlay_background_image',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay',
					'style' => 'background-image',
  				'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => true,

  			),



  			array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay:background-repeat',
					'id' => 'css_advanced_background_overlay_background_repeat',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay',
					'style' => 'background-repeat',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,

					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),



				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay:background-position',
					'id' => 'css_advanced_background_overlay_background_position',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay',
					'style' => 'background-position',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,

					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),


				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay:background-attachment',
					'id' => 'css_advanced_background_overlay_background_attachment',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay',
					'style' => 'background-attachment',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,

					'title' => __('Attachment', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),



				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay:background-size',
					'id' => 'css_advanced_background_overlay_background_size',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay',
					'style' => 'background-size',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => true,

					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),



				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay:filter',
					'id' => 'css_advanced_background_overlay_filter',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay',
					'style' => 'filter',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'css_filters',
					'label_tools' => true,
					'class' => 'mfn-toggled toggle_fields',
					'title' => __('CSS Filters', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay:transition',
					'id' => 'css_advanced_background_overlay_transition',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner > .mcb-wrap-background-overlay',
					'style' => 'transition',
					'type' => 'sliderbar',
					'title' => __('Transition duration', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '3',
						'step' => '0.1',
						'unit' => 's',
					)
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner|hover > .mcb-wrap-background-overlay:opacity',
					'id' => 'css_advanced_background_overlay_opacity_hover',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:hover > .mcb-wrap-background-overlay',
					'style' => 'opacity',
					'type' => 'sliderbar',
					'title' => __('Opacity', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '1',
						'step' => '0.01',
					),
					//'std' => '1',
				),

				array(
					'id' => 'background_switcher_hover',
					'attr_id' => 'background_switcher_hover',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner|hover > .mcb-wrap-background-overlay:background-color',
					'id' => 'css_advanced_background_overlay_background_color_hover',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:hover > .mcb-wrap-background-overlay',
					'style' => 'background-color',
					'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner|hover > .mcb-wrap-background-overlay:gradient',
  				'id' => 'css_advanced_overlay_gradient_hover',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner|hover > .mcb-wrap-background-overlay',
					'style' => 'gradient',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
  			),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner|hover > .mcb-wrap-background-overlay:background-image',
					'id' => 'css_advanced_background_overlay_background_image_hover',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:hover > .mcb-wrap-background-overlay',
					'style' => 'background-image',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => true,

  			),

				array(
					'type' => 'html',
					'html' => '</div></div>',
				),

				array(
					'type' => 'header',
					'class' => 'toggled_header',
						'title' => __('Border', 'mfn-opts'),
					),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:border-style',
					'id' => 'css_advanced_border_style',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'border-style',
					'attr_id' => 'border_style_wrap',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Border style', 'mfn-opts'),
					'options' => [
						'none' => __('None', 'mfn-opts'),
						'solid' => __('Solid', 'mfn-opts'),
						'dashed' => __('Dashed', 'mfn-opts'),
						'dotted' => __('Dotted', 'mfn-opts'),
						'double' => __('Double', 'mfn-opts'),
					],
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:border-color',
					'id' => 'css_advanced_border_color',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'border-color',
					'condition' => array( 'id' => 'border_style_wrap', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:border-width',
					'id' => 'css_advanced_border_width',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'border-width',
  				'condition' => array( 'id' => 'border_style_wrap', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),



				array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:border-radius',
					'id' => 'css_advanced_border_radius',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'border-radius',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),



  			array(
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner:box-shadow',
					'id' => 'css_advanced_box_shadow',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'box-shadow',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'responsive' => true,
					'class' => 'mfn-toggled',
  			),



				array(
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Responsive', 'mfn-opts'),
				),

				array(
  				'id' => 'visibility',
  				'iconinfo' => 'https://support.muffingroup.com/video-tutorials/section-responsive-visibility/',
  				'type' => 'switch',
  				'invert' => true,
  				'version' => 'multiple',
  				'class' => 'mfn-toggled',
  				'title' => __('Responsive visibility', 'mfn-opts'),
  				'options' => array(
  					'hide-desktop' => __('Hide on Desktop', 'mfn-opts'),
  					'hide-laptop' => __('Hide on Laptop', 'mfn-opts'),			// 960 +
  					'hide-tablet' => __('Hide on Tablet', 'mfn-opts'),		// 768 - 959
  					'hide-mobile' => __('Hide on Mobile', 'mfn-opts'),			// - 768
  				),
  				'active_tooltip' => array(
  					'hide-desktop' => __('Show on Desktop', 'mfn-opts'),
  					'hide-laptop' => __('Show on Laptop', 'mfn-opts'),
  					'hide-tablet' => __('Show on Tablet', 'mfn-opts'),
  					'hide-mobile' => __('Show on Mobile', 'mfn-opts'),
  				),
  				'visual_options' => array(
  					'hide-desktop' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M4.94,5H17.06a.93.93,0,0,1,.94.91v7.18a.93.93,0,0,1-.94.91H4.94A.93.93,0,0,1,4,13.09V5.91A.93.93,0,0,1,4.94,5Z"/><path class="cls-1" d="M7,17h8"/><path class="cls-2" d="M13,15.51a1.58,1.58,0,0,0,.7,1.26L14,17H8l.3-.23A1.58,1.58,0,0,0,9,15.51V14h4Z"/></svg>',			// 960 +
  					'hide-laptop' => '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"viewBox="0 0 22 22" style="enable-background:new 0 0 22 22;" xml:space="preserve"> <style type="text/css"> .st0{fill:none;stroke:currentColor;stroke-width:1.5;stroke-linecap:round;stroke-linejoin:round;} </style> <path class="st0" d="M5,15V6.9C5,6.4,5.4,5.9,5.9,6h10.1c0.5,0,0.9,0.4,0.9,0.9V15"/> <path class="st0" d="M4,17h14"/> </svg>',		// 768 - 959
  					'hide-tablet' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}</style></defs><path class="cls-1" d="M7,15.83V7.17A1.21,1.21,0,0,1,8.25,6h5.5A1.21,1.21,0,0,1,15,7.17v8.66A1.21,1.21,0,0,1,13.75,17H8.25A1.21,1.21,0,0,1,7,15.83Z"/></svg>',		// 768 - 959
  					'hide-mobile' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M8,15.82V8.18A1.08,1.08,0,0,1,8.94,7h4.12A1.08,1.08,0,0,1,14,8.18v7.64A1.08,1.08,0,0,1,13.06,17H8.94A1.08,1.08,0,0,1,8,15.82Z"/><circle class="cls-2" cx="11" cy="14" r="1"/></svg>',			// - 768
  				),
  			),

  			array(
  				'id' => 'reverse_order',
  				'class' => 'mfn-toggled hide_if_ql',
  				'type' => 'switch',
  				'iconinfo' => 'https://support.muffingroup.com/how-to/how-to-reverse-the-order-of-elements-on-mobile/',
  				'title' => __('Order on mobile', 'mfn-opts'),
					'options' => [
						0 => __('Default', 'mfn-opts'),
						1 => __('Reverse rows', 'mfn-opts'),
						2 => __('Reverse columns', 'mfn-opts'),
					],
					'std' => 0,
  			),

  			array(
					'type' => 'subheader',
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Custom', 'mfn-opts'),
				),

				array(
  				'id' => 'custom-responsive',
  				'attr_id' => 'custom-responsive',
  				'type' => 'switch',
  				'class' => 'mfn-toggled',
  				'title' => __('Custom visibility', 'mfn-opts'),
  				'options' => array(
  					'hide' => __('Hide under', 'mfn-opts'),
  					'show' => __('Show under', 'mfn-opts'),
  				),
  				'std' => 'hide'
  			),

				array(
  				'condition' => array( 'id' => 'custom-responsive', 'opt' => 'is', 'val' => 'hide' ),
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:hide_under_custom',
					'id' => 'css_advanced_hide_under',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement',
					'style' => 'hide_under_custom',
  				'type' => 'sliderbar',
  				'class' => 'mfn-toggled responsive-custom-visibility',
					'title' => __('Hide under', 'mfn-opts'),
					'param' => array(
						'min' => '400',
						'max' => '1920',
						'step' => '1',
						'unit' => 'px',
					),
  			),

  			array(
  				'condition' => array( 'id' => 'custom-responsive', 'opt' => 'is', 'val' => 'show' ),
  				'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:show_under_custom',
					'id' => 'css_advanced_show_under',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement',
					'style' => 'show_under_custom',
  				'type' => 'sliderbar',
  				'title' => __('Show under', 'mfn-opts'),
					'class' => 'mfn-toggled responsive-custom-visibility',
					'param' => array(
						'min' => '400',
						'max' => '1920',
						'step' => '1',
						'unit' => 'px',
					),
  			),

  			// Conditions

				array(
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Conditional logic', 'mfn-opts'),
				),

				array(
  				'id' => 'conditional_logic',
  				'class' => 'mfn-toggled',
  				'type' => 'logic',
  				'title' => __('Conditional logic', 'mfn-opts'),
  			),


  			// Extras

				array(
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Extras', 'mfn-opts'),
				),

				array(
  				'id' => 'css_advanced_overflow',
  				'selector' => '.mcb-section .mcb-wrap-mfnuidelement > .mcb-wrap-inner',
					'style' => 'overflow',
  				'type' => 'switch',
  				'class' => 'mfn-toggled',
  				'title' => __('Overflow', 'mfn-opts'),
  				'desc' => __('Changing this option will hide the toolbar. To access its options, open the Navigator (Ctrl/Cmd + I)', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'auto' => __('Auto', 'mfn-opts'),
  					'hidden' => __('Hidden', 'mfn-opts'),
  				),
  				'std' => ''
  			),

				array(
					'type' => 'header',
					'class' => 'toggled_header',
					'title' => __('Custom', 'mfn-opts'),
				),

				array(
  				'id' => 'classes',
  				'class' => 'mfn-toggled',
  				'type' => 'pills',
  				'title' => __('Classes', 'mfn-opts'),
  			),

  			array(
  				'id' => 'custom_id',
  				'class' => 'mfn-toggled',
  				'type' => 'text',
  				'title' => __('ID', 'mfn-opts'),
  			),

  			array(
  				'id' => 'custom_css',
  				'class' => 'mfn-toggled',
  				'type' => 'textarea',
  				'title' => __('Additional CSS', 'mfn-opts'),
  			),

				// animation

				array(
					'class' => 'toggled_header',
					'type' => 'header',
					'title' => __('Animation', 'mfn-opts'),
				),

				array(
					'id' => 'animate',
					'attr_id' => 'wrap-animate',
					'type' => 'select',
					'title' => __('Animation', 'mfn-opts'),
					'desc' => __('Entrance animation', 'mfn-opts'),
					'class' => 'mfn-toggled',
					'options' => $this->get_animations(),
				),

				array(
					'old_id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:animation-delay',
					'id' => 'css_advanced_animation_delay',
					'selector' => '.mcb-section .mcb-wrap-mfnuidelement',
					'style' => 'animation-delay',
					'condition' => array( 'id' => 'wrap-animate', 'opt' => 'isnt', 'val' => '' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Animation delay', 'mfn-opts'),
					'after' => 'ms',
					'param' => array(
						'min' => '0',
						'max' => '3000',
						'step' => '1',
						'unit' => 'ms'
					),
				),

				// global wraps

			array(
				'id' => 'global_wraps',
				'type' => 'header',
				'class' => 'toggled_header global_wraps mfn-hidden-nested-wrap',
				'title' => __('Global Wraps', 'mfn-opts'),
			),

			array(
				'id' => 'global_wraps_select',
				'attr_id' => 'global_wraps_select',
				'class' => 'mfn-toggled mfn-hidden-nested-wrap',
				'type' => 'select',
				'title' => __('Select template', 'mfn-opts'),
				'std' => '',
				'js_options' => 'global_wraps',
				'php_options' => mfna_templates('wrap'),
			),

			array(
				'type' => 'html',
				'html' => '</div>',
			),


  		);

  	}

    /**
     * SET items and their fields
   	 */

   	private function set_items(){

   		$this->items = array(

		// thank you ----------------------------------------------------

   			'thankyou_overview' => array(
   				'type' => 'thankyou_overview',
   				'title' => __('Order overview', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'thanks',
   				'attr' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere active">',
						),

						array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Confirmation', 'mfn-opts'),
   					),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_notice_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-thankyou-order-received',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_notice_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-thankyou-order-received',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_notice_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-thankyou-order-received',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

   					array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_notice_icon_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-thankyou-order-received:before',
							'style' => '--mfn-woo-themecolor',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_notice_icon_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-thankyou-order-received:before',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_notice_icon_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-thankyou-order-received',
							'style' => '--mfn-woo-thanks-notice-icon-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Wrapper size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '300',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'css_notice_icon_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-thankyou-order-received',
							'style' => '--mfn-woo-thanks-notice-icon-font-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '300',
								'step' => '1',
								'unit' => 'px',
							)
						),

   					array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Text', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_notice_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-thankyou-order-received',
							'style' => '--mfn-woo-themecolor',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_notice_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-thankyou-order-received',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Details', 'mfn-opts'),
   					),

   					array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_overview_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.order_details',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_overview_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.order_details',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_overview_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.order_details',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Items', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_overview_item_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.order_details li',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_overview_item_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.order_details li',
							'style' => '--mfn-woo-border',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Headings', 'mfn-opts'),
   					),

						array(
							'id' => 'css_overview_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.order_details li',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_overview_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.order_details li',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Values', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_overview_val_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.order_details li strong',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_overview_val_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.order_details li strong',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Payment info', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_overview_payment_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-thanks-overview-payment',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_overview_payment_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-thanks-overview-payment',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_overview_payment_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-thanks-overview-payment',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),


						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				)

   			),

   			// thank you ----------------------------------------------------

   			'thankyou_order' => array(
   				'type' => 'thankyou_order',
   				'title' => __('Order details', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'thanks',
   				'attr' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere active">',
						),


						array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_order_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-order-details',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_order_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-order-details',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_order_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-order-details',
							'style' => 'border-style',
							'attr_id' => 'border_thanks_order_details',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_order_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-order-details',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_thanks_order_details', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'css_order_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-order-details',
							'style' => 'border-color',
							'type' => 'color',
							'condition' => array( 'id' => 'border_thanks_order_details', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'css_order_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-order-details',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-radius',
		  			),


						array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Heading', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_order_heading_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-order-details .woocommerce-order-details__title',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'id' => 'css_order_heading_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-order-details .woocommerce-order-details__title',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_order_heading_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-order-details .woocommerce-order-details__title',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_order_heading_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-order-details .woocommerce-order-details__title',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Table', 'mfn-opts'),
   					),

   					array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Head', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_table_head_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table thead th',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_table_head_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table thead th',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_table_head_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table thead th',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

   					array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Body', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_table_body_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table td',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'id' => 'css_table_body_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table td',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

   					array(
							'id' => 'css_table_body_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table',
							'style' => '--mfn-woo-border',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

   					array(
							'id' => 'css_table_body_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table td, .mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table tfoot th',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Product name', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_table_product_name_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table .woocommerce-table__product-name a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'id' => 'css_table_product_name_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table .woocommerce-table__product-name a',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Variations', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_table_variations_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table .woocommerce-table__product-name ul li',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'id' => 'css_table_variations_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table .woocommerce-table__product-name ul li',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Quantity', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_table_product_quantity_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table .product-name .product-quantity',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_table_product_quantity_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table .product-name .product-quantity',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),


   					array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Labels', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_table_labels_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table tfoot th',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'id' => 'css_table_labels_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table tfoot th',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),





   					array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Total', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_table_price_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table tfoot tr:last-child .woocommerce-Price-amount',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'id' => 'css_table_price_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table tfoot tr:last-child .woocommerce-Price-amount',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),





						array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Customer', 'mfn-opts'),
   					),

   					array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_customer_box_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-customer-details .woocommerce-column',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_customer_box_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-customer-details .woocommerce-column',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_customer_box_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-customer-details .woocommerce-column',
							'style' => 'width',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '15',
								'max' => '50',
								'step' => '1',
								'unit' => '%',
							)
						),

		  			array(
							'id' => 'css_customer_box_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-customer-details .woocommerce-column',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_customer_box_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-customer-details .woocommerce-column',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Heading', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_customer_heading_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-customer-details h2',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'id' => 'css_customer_heading_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-customer-details h2',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_customer_heading_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-customer-details h2',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Address', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_customer_address_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-customer-details address',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'id' => 'css_customer_address_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-customer-details address',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_customer_address_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-customer-details address',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Icon', 'mfn-opts'),
   					),

						array(
							'id' => 'css_customer_address_icon_visibility',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-customer-details address:before',
							'style' => 'display',
							'type' => 'switch',
							'attr_id' => 'cstmr_address_icon_visibility_rwd',
							'title' => __('Visibility', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Show', 'mfn-opts'),
								'none' => __('Hide', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'css_customer_address_icon_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-customer-details address:before',
							'style' => 'color',
							'type' => 'color',
							'condition' => array( 'id' => 'cstmr_address_icon_visibility_rwd', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_customer_address_icon_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-customer-details address:before',
							'style' => '--mfn-woo-border',
							'type' => 'color',
							'condition' => array( 'id' => 'cstmr_address_icon_visibility_rwd', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				)

   			),


   			// checkout ----------------------------------------------------

   			'checkout' => array(
   				'type' => 'checkout',
   				'title' => __('Checkout', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'checkout',
   				'attr' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'id' => 'layout',
							'type' => 'select',
							'title' => __('Your order', 'mfn-opts'),
							'options' => [
								'' => __('On the right', 'mfn-opts'),
								'default' => __('Bottom', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),


						array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Form', 'mfn-opts'),
   					),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Labels', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_label_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .form-row label',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_label_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .form-row label',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_label_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .form-row label',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Inputs', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_inputs_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .input-text, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form select, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form textarea, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .select2-selection',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_inputs_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .input-text, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form select, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form textarea, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .select2-selection',
							'style' => 'border-style',
							'attr_id' => 'border_checkout_inputs',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_inputs_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .input-text, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form select, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form textarea, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .select2-selection',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_checkout_inputs', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
							'id' => 'css_inputs_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .input-text, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form select, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form textarea, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .select2-selection',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-radius',
		  			),


   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Focus</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'css_inputs_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .input-text, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form select, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form textarea, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .select2-selection .select2-selection__rendered',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_inputs_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .input-text, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form select, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form textarea, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .select2-selection',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_inputs_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .input-text, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form select, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form textarea, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .select2-selection',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_checkout_inputs', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'css_inputs_placeholder_color',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input::placeholder, .mcb-section .mcb-wrap .mcb-item-mfnuidelement form textarea::placeholder',
   						'style' => 'color',
   						'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Placeholder color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'css_inputs_color_focus',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .input-text:focus, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form select:focus, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form textarea:focus',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_inputs_bg_focus',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .input-text:focus, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form select:focus, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form textarea:focus',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_inputs_border_color_focus',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .input-text:focus, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form select:focus, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form textarea:focus',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_checkout_inputs', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'css_inputs_placeholder_color_focus',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input:focus::placeholder, .mcb-section .mcb-wrap .mcb-item-mfnuidelement form textarea:focus::placeholder',
   						'style' => 'color',
   						'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Placeholder color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),







						array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Billing details', 'mfn-opts'),
   					),

   					array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Heading', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_billing_heading_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-billing-fields h3',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

   					array(
							'id' => 'css_billing_heading_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-billing-fields h3',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_billing_heading_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-billing-fields h3',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_billing_heading_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-billing-fields h3',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),




		  			array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Summary', 'mfn-opts'),
   					),

   					array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_summary_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement',
							'style' => '--mfn-woo-bg-box',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

   					array(
							'id' => 'css_summary_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement',
							'style' => '--mfn-woo-border-radius-box',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'id' => 'css_summary_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce .woocommerce-checkout-review-order',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_summary_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce .woocommerce-checkout-review-order',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Heading', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_summary_heading_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form #order_review #order_review_heading',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

   					array(
							'id' => 'css_summary_heading_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form .woocommerce-checkout-review-order h4',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_summary_heading_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form .woocommerce-checkout-review-order h4',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_summary_heading_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form .woocommerce-checkout-review-order h4',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Table', 'mfn-opts'),
   					),

		  			array(
							'id' => 'css_summary_table_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table th, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce table.shop_table td',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_summary_table_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table th, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce table.shop_table td',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_summary_table_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table th, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce table.shop_table td',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Products', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_summary_table_variations_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table th, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce table.shop_table dd',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'id' => 'css_summary_table_variations_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce table.shop_table dd',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Variations border color', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Quantity', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_summary_table_product_quantity_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table .product-name .product-quantity',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_summary_table_product_quantity_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table .product-name .product-quantity',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Price', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_summary_table_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table tr.order-total .woocommerce-Price-amount',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_summary_table_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table tr.order-total .woocommerce-Price-amount',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Payment', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_summary_payment_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form #payment ul.payment_methods li, .mcb-section .mcb-wrap .mcb-item-mfnuidelement form #payment ul.payment_methods li div.payment_box',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_summary_payment_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form #payment ul.payment_methods li, .mcb-section .mcb-wrap .mcb-item-mfnuidelement form #payment ul.payment_methods li div.payment_box',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),


   					array(
							'id' => 'css_summary_payment_label_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form #payment ul.payment_methods li label',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Label typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_summary_payment_label_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form #payment ul.payment_methods li label',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Label color', 'mfn-opts'),
						),


						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'css_summary_payment_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form #payment ul.payment_methods li',
							'style' => '--mfn-woo-border',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'css_summary_payment_border_color_active',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form #payment ul.payment_methods li.active-payment',
							'style' => '--mfn-woo-border-themecolor',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'css_summary_payment_icon_color_active',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form #payment ul.payment_methods li.wc_payment_method .mfn-payment-check',
							'style' => '--mfn-woo-bg-themecolor',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Icon color', 'mfn-opts'),
						),


						array(
							'type' => 'html',
							'html' => '</div></div>',
						),





						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Return to cart', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_summary_return_shop_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woo-cart-link',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

   					array(
							'id' => 'css_summary_return_shop_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woo-cart-link',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_summary_return_shop_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woo-cart-link',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),





   					array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Shipping', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_shipping_switcher_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form .woocommerce-shipping-fields h3 span',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_shipping_switcher_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form .woocommerce-shipping-fields h3 span',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_shipping_switcher_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form .woocommerce-shipping-fields h3',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'css_shipping_switcher_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-shipping-fields h3#ship-to-different-address',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_shipping_switcher_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-shipping-fields h3#ship-to-different-address',
							'style' => 'border-style',
							'attr_id' => 'border_checkout_shipping_switcher',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_shipping_switcher_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-shipping-fields h3#ship-to-different-address',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_checkout_shipping_switcher', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'css_shipping_switcher_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-shipping-fields h3#ship-to-different-address',
							'condition' => array( 'id' => 'border_checkout_shipping_switcher', 'opt' => 'isnt', 'val' => 'none' ),
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'css_shipping_switcher_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-shipping-fields h3#ship-to-different-address',
							'style' => '--mfn-woo-border-radius-box',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'id' => 'css_shipping_switcher_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-shipping-fields h3#ship-to-different-address',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Button', 'mfn-opts'),
   					),


						array(
							'id' => 'css_button_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_button_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_button_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button',
							'style' => 'border-style',
							'attr_id' => 'border_style_button',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_button_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
							'id' => 'css_button_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'id' => 'css_button_transition',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button',
							'style' => 'transition',
							'type' => 'sliderbar',
							'class' => 'mfn-toggled',
							'title' => __('Transition duration', 'mfn-opts'),
							'param' => array(
								'min' => '0',
								'max' => '3',
								'step' => '0.1',
								'unit' => 's',
							)
						),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'css_button_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'css_button_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button',
							'style' => 'background-color',
							'condition' => array( 'id' => 'background_switcher_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_gradient',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_switcher_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'css_button_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'css_button_background_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button:hover, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button:before',
							'style' => 'background',
							'condition' => array( 'id' => 'background_switcher_hover_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_gradient_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button:hover, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce form .button:before',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),









   					array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Coupon code', 'mfn-opts'),
   					),

   					array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Switcher', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_coupon_switcher_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-form-coupon-toggle .woocommerce-info',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_coupon_switcher_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-form-coupon-toggle .woocommerce-info',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_coupon_switcher_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-form-coupon-toggle .woocommerce-info',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'css_coupon_switcher_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-form-coupon-toggle .woocommerce-info',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_coupon_switcher_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-form-coupon-toggle .woocommerce-info',
							'style' => 'border-style',
							'attr_id' => 'border_checkout_coupon_switcher',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_coupon_switcher_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-form-coupon-toggle .woocommerce-info',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_checkout_coupon_switcher', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'css_coupon_switcher_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-form-coupon-toggle .woocommerce-info',
							'condition' => array( 'id' => 'border_checkout_coupon_switcher', 'opt' => 'isnt', 'val' => 'none' ),
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'css_coupon_switcher_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-form-coupon-toggle .woocommerce-info',
							'style' => '--mfn-woo-border-radius-box',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'id' => 'css_coupon_switcher_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-form-coupon-toggle .woocommerce-info',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'css_coupon_switcher_link_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-form-coupon-toggle .woocommerce-info a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'css_coupon_switcher_link_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-form-coupon-toggle .woocommerce-info a:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				)

   			),



























   			// cart table ----------------------------------------------------

   			'cart_table' => array(
   				'type' => 'cart_table',
   				'title' => __('Cart table', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'cart',
   				'attr' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'type' => 'header',
							'title' => __('Labels', 'mfn-opts'),
						),

						array(
   						'id' => 'update_cart_label',
   						'type' => 'text',
   						'title' => __('Update cart button label', 'mfn-opts'),
   						'std' => __('Update cart', 'woocommerce'),
   					),

   					array(
   						'id' => 'coupon_code_placeholder',
   						'type' => 'text',
   						'title' => __('Coupon code placeholder', 'mfn-opts'),
   						'std' => __('Coupon code', 'woocommerce'),
   					),

   					array(
   						'id' => 'apply_coupon_label',
   						'edit_tag' => 'td.actions .coupons | button.button',
   						'edit_position' => 'append',
   						'type' => 'text',
   						'title' => __('Apply coupon button label', 'mfn-opts'),
   						'std' => __('Apply coupon', 'woocommerce'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Table head', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_tableshop_tablecartth_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart th',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_tableshop_tablecartth_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart th',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_tableshop_tableth_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table th',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'css_tableshop_tablethead_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table thead',
							'style' => 'border-style',
							'attr_id' => 'border_cart_thead',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_tableshop_tablethead_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table thead',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_cart_thead', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'css_tableshop_tablethead_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table thead',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_cart_thead', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Table body', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_tableshop_tablecarttd_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart td',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields tableshop_tablecarttd_typography',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'id' => 'css_tableshop_tabletbody_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table tbody',
							'style' => 'border-style',
							'attr_id' => 'border_cart_tbody',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_tableshop_tabletbody_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table tbody',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_cart_tbody', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'css_tableshop_tabletbody_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table tbody',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_cart_tbody', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

		  			array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Cells', 'mfn-opts'),
   					),

		  			array(
							'id' => 'css_tableshop_tabletd_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table td',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'css_tableshop_tabletd_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table td',
							'style' => 'border-style',
							'attr_id' => 'border_cart_tbodytd',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_tableshop_tabletd_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table td',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_cart_tbodytd', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'css_tableshop_tabletd_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table td',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_cart_tbodytd', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),





		  			array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Product name', 'mfn-opts'),
   					),


		  			array(
							'id' => 'css_table-namea_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart td.product-name a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_table-namea_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart td.product-name a',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields table-namea_typography',
							'title' => __('Typography', 'mfn-opts'),
						),


						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Product variations', 'mfn-opts'),
   					),


		  			array(
							'id' => 'css_table-namevariation_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart td.product-name .variation',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Label color', 'mfn-opts'),
						),

						array(
							'id' => 'css_table-namevariationdd_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart td.product-name .variation dd',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Value color', 'mfn-opts'),
						),

						array(
							'id' => 'css_table-namevariation_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart td.product-name .variation',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields table-namevariation_typography',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_table-namevariation_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart td.product-name .variation',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Price', 'mfn-opts'),
   					),


		  			array(
							'id' => 'css_table_price_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart td.product-price',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_table_price_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart td.product-price',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields table_price_typography',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Subtotal', 'mfn-opts'),
   					),


		  			array(
							'id' => 'css_table_price_subtotal_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart td.product-subtotal',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_table_price_subtotal_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart td.product-subtotal',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields table_price_subtotal_typography',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Quantity', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_tableshop_inputqty_background',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart .quantity input.qty',
							'style' => 'background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'css_tableshop_inputqty_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart .quantity input.qty',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_tableshop_inputqty_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart .quantity input.qty',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'css_tableshop_aquantity-change_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart .quantity a.quantity-change',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Plus/Minus color', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Remove', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_tableshop_tablecartproduct-removearemovespan_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.shop_table.cart .product-remove a.remove span',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Coupon input', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_coupon_code_background',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .coupon #coupon_code',
							'style' => 'background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'css_coupon_code_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .coupon #coupon_code, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .coupon #coupon_code::placeholder',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_coupon_code_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .coupon #coupon_code',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Button', 'mfn-opts'),
   					),

						array(
							'id' => 'css_button_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_button_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_button_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button',
							'style' => 'border-style',
							'attr_id' => 'border_style_button',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_button_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
							'id' => 'css_button_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'id' => 'css_button_transition',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button',
							'style' => 'transition',
							'type' => 'sliderbar',
							'class' => 'mfn-toggled',
							'title' => __('Transition duration', 'mfn-opts'),
							'param' => array(
								'min' => '0',
								'max' => '3',
								'step' => '0.1',
								'unit' => 's',
							)
						),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#inactive" data-tab="inactive">Inactive</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'css_button_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'css_button_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button',
							'style' => 'background-color',
							'condition' => array( 'id' => 'background_switcher_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_gradient',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_switcher_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'css_button_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'css_button_background_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button:hover, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button:before',
							'style' => 'background',
							'condition' => array( 'id' => 'background_switcher_hover_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_gradient_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button:hover, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button:before',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),


		  			array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-inactive">',
						),

						array(
							'id' => 'css_button_opacity_inactive',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button:disabled',
							'style' => 'opacity',
							'type' => 'sliderbar',
							'class' => 'mfn-toggled',
							'title' => __('Opacity', 'mfn-opts'),
							'param' => array(
								'min' => '0',
								'max' => '1',
								'step' => '0.1',
							),
							'std' => '0.5'
						),

						array(
							'id' => 'css_button_color_inactive',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button:disabled',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_border_color_inactive',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button:disabled',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_inactive',
							'attr_id' => 'background_switcher_inactive_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'css_button_background_inactive',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button:disabled',
							'style' => 'background-color',
							'condition' => array( 'id' => 'background_switcher_inactive_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_gradient_inactive',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_table .actions .button:disabled',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_switcher_inactive_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

					),
   			),

























				// cart totals ----------------------------------------------------

   			'cart_totals' => array(
   				'type' => 'cart_totals',
   				'title' => __('Cart totals', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'cart',
   				'attr' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'type' => 'header',
							'title' => __('Labels', 'mfn-opts'),
						),

						array(
   						'id' => 'cart_totals_heading',
   						'edit_tag' => '.cart_totals | h4',
   						'edit_position' => 'prepend',
   						'type' => 'text',
   						'title' => __('Cart totals heading', 'mfn-opts'),
   						'std' => __('Cart totals', 'woocommerce'),
   					),

   					array(
   						'id' => 'proceed_checkout_label',
   						'edit_tag' => 'td.actions .coupons | button.button',
   						'edit_position' => 'append',
   						'type' => 'text',
   						'title' => __('Proceed to checkout button label', 'mfn-opts'),
   						'std' => __('Proceed to checkout', 'woocommerce'),
   					),

   					array(
   						'id' => 'continue_shopping_string',
   						'edit_tag' => '.cart_totals | a.mfn-woo-cart-link',
   						'edit_position' => 'append',
   						'type' => 'text',
   						'title' => __('Continue shopping link title', 'mfn-opts'),
   						'std' => __('Continue shopping', 'woocommerce'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

		  			array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Heading', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_cart_totalstitle_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart-collaterals .cart_totals .title',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_cart_totalstitle_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart-collaterals .cart_totals .title',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_cart_totalstitle_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart_totals .title',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Table', 'mfn-opts'),
   					),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Heading', 'mfn-opts'),
   					),

						array(
							'id' => 'css_cart_total_tableth_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart-collaterals .cart_totals table.shop_table th',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_cart_total_tableth_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart-collaterals .cart_totals table.shop_table th',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Value', 'mfn-opts'),
   					),

						array(
							'id' => 'css_cart_total_tabletd_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart-collaterals .cart_totals table.shop_table td',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_cart_total_tabletd_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart-collaterals .cart_totals table.shop_table td',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Price', 'mfn-opts'),
   					),

						array(
							'id' => 'css_cart_total_tableorder-totalwoocommerce-Price-amount_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart-collaterals .cart_totals table.shop_table .order-total .woocommerce-Price-amount',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_cart_total_tableorder-totalwoocommerce-Price-amount_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart-collaterals .cart_totals table.shop_table .order-total .woocommerce-Price-amount',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
   						'title' => __('Cells', 'mfn-opts'),
   					),

		  			array(
							'id' => 'css_cart_total_table_td_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart_totals table.shop_table th,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart_totals table.shop_table td',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_cart_total_table_td_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart_totals table.shop_table th,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart_totals table.shop_table td',
							'style' => 'border-style',
							'attr_id' => 'border_cart_total_cells',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_cart_total_table_td_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart_totals table.shop_table th,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart_totals table.shop_table td',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_cart_total_cells', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'css_cart_total_table_td_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart_totals table.shop_table th,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart_totals table.shop_table td',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_cart_total_cells', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'css_cart_total_tablea_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart_totals table.shop_table a',
							'style' => 'color',
							'type' => 'color',
							'title' => __('Links color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'css_cart_total_tablea_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart_totals table.shop_table a:hover',
							'style' => 'color',
							'type' => 'color',
							'title' => __('Links color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Button', 'mfn-opts'),
   					),

						array(
							'id' => 'css_button_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_button_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_button_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button',
							'style' => 'border-style',
							'attr_id' => 'border_style_button',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_button_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
							'id' => 'css_button_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'css_button_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'css_button_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button',
							'style' => 'background-color',
							'condition' => array( 'id' => 'background_switcher_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_gradient',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_switcher_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),


						array(
							'id' => 'css_button_transition',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button',
							'style' => 'transition',
							'type' => 'sliderbar',
							'title' => __('Transition duration', 'mfn-opts'),
							'param' => array(
								'min' => '0',
								'max' => '3',
								'step' => '0.1',
								'unit' => 's',
							)
						),

						array(
							'id' => 'css_button_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'css_button_background_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:hover, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:before',
							'style' => 'background',
							'condition' => array( 'id' => 'background_switcher_hover_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'css_button_gradient_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:hover, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:before',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Continue shopping', 'mfn-opts'),
   					),

						array(
							'id' => 'css_cart_continue_shopping_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart_totals .mfn-woo-cart-link',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_cart_continue_shopping_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart_totals .mfn-woo-cart-link',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

   					array(
							'id' => 'css_cart_continue_shopping_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart_totals .mfn-woo-cart-link',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'css_cart_continue_shopping_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .cart_totals .mfn-woo-cart-link:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

					),
   			),

				// cart cross sells ----------------------------------------------------

   			'cart_cross_sells' => array(
   				'type' => 'cart_cross_sells',
   				'title' => __('Cross sells', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'cart',
   				'attr' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
   						'type' => 'header',
   						'title' => __('Heading', 'mfn-opts'),
   					),

						array(
   						'id' => 'heading',
   						'edit_tag' => '.mfn-cross-sells | .heading',
   						'edit_position' => 'prepend',
   						'type' => 'text',
   						'title' => __('Heading', 'mfn-opts'),
   						'std' => __('You may be interested in…', 'woocommerce'),
   					),

   					array(
							'id' => 'heading_tag',
							'type' 	=> 'switch',
							're_render' => true,
							'title' => __('Heading tag', 'mfn-opts'),
							'options' => array(
								'h1' => 'h1',
								'h2' => 'h2',
								'h3' => 'h3',
								'h4' => 'h4',
								'h5' => 'h5',
								'h6' => 'h6',
								'p' => 'p',
								'span' => 'span',
								'div' => 'div',
							),
							'std' => 'h3',
						),

   					// options

   					array(
   						'type' => 'header',
   						'title' => __('Options', 'mfn-opts'),
   					),

						array(
   						'id' => 'columns',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Columns', 'mfn-opts'),
   						'std' => '4',
   						'after' => 'columns',
   						'param' => 'number',
   						'class' => 'narrow',
   					),

   					array(
   						'id' => 'products',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Limit', 'mfn-opts'),
   						'std' => '4',
   						'after' => 'products',
   						'param' => 'number',
   						'class' => 'narrow',
   					),

						array(
							'id' => 'button',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Add to cart button', 'mfn-opts'),
							'desc' => __('Required for some plugins', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => '0',
						),

						array(
							'id' => 'description',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Description', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => '0'
						),

						array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'span' => 'span',
							],
							'std' => 'h2',
						),

						array(
							'type' => 'header',
							'title' => __('Order', 'mfn-opts'),
						),

						array(
							'id' => 'order',
							'type' => 'order',
							're_render' => true,
							'title' => __('Order', 'mfn-opts'),
							'std' => 'image,title,price,description,button',
						),



						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'title' => __('Item title', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'id' => 'css_cross-sellsheading_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-cross-sells .heading',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'css_cross-sellsheading_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-cross-sells .heading',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_cross-sellsheading_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-cross-sells .heading',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'css_cross-sellsheading_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-cross-sells .heading',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_ulproductsliproduct_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'text-align',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

   					array(
							'id' => 'css_ulproductsliproduct_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_ulproductsliproduct_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'css_ulproductsliproduct_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-style',
							'attr_id' => 'border_style_shop_li',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_ulproductsliproduct_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'css_ulproductsliproduct_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'css_ulproductsliproduct_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'css_ulproductsliproductimage_frame_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-style',
							'attr_id' => 'border_style_shopimg',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_ulproductsliproductimage_frame_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'css_ulproductsliproductimage_frame_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
							'id' => 'css_ulproductsliproductimage_frame_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			// title

						array(
							'title' => __('Title', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'id' => 'css_ulproductsliproducttitle_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_ulproductsliproducttitle_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'css_ulproductsliproducttitle_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Price', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'id' => 'css_ulproductsliproductprice_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_ulproductsliproductprice_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'css_ulproductsliproductprice_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Desc', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'id' => 'css_ulproductsliproductexcerpt_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'css_ulproductsliproductexcerpt_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_ulproductsliproductexcerpt_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Attributes', 'mfn-opts'),
   					),

						array(
							'id' => 'css_variations-wrapper-loop-vrul-vr-optionslia_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'css_variations-wrapper-loop-vrul-vr-optionslia_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a:hover',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color on Hover', 'mfn-opts'),
						),

						array(
							'id' => 'css_variations-wrapper-loop-vrul-vr-optionslia_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Label color', 'mfn-opts'),
						),

		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Sale label', 'mfn-opts'),
   					),

   					array(
							'id' => 'css_ulproductsliproductonsale_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_ulproductsliproductonsale_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_ulproductsliproductonsale_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'padding',
		  			),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
							'id' => 'css_ulproductsliproductbutton_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'padding',
		  			),
		  			array(
							'id' => 'css_ulproductsliproductbutton_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'css_ulproductsliproductbutton_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-style',
							'attr_id' => 'border_style_bsb',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_ulproductsliproductbutton_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
							'id' => 'css_ulproductsliproductbutton_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'css_ulproductsliproductbutton_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_ulproductsliproductbutton_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'css_ulproductsliproductbutton_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'background-color',
							'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'css_ulproductsliproductbutton_gradient',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'css_ulproductsliproductbutton_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_ulproductsliproductbutton_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_hover_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'css_ulproductsliproductbutton_background_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover, .mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:before',
							'style' => 'background',
							'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'css_ulproductsliproductbutton_gradient_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover,.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:before',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'title' => __('Rating', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'id' => 'css_ulproductsliproductstar-rating_display',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating',
							'style' => 'display',
							'attr_id' => 'shop-list-rating',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Visibility', 'mfn-opts'),
							'options' => [
								'' => __('Visible', 'mfn-opts'),
								'none' => __('Hidden', 'mfn-opts'),
							],
							'std' => ''
						),

						array(
							'id' => 'css_ulproductsliproductstar-ratingspan_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating span',
							'style' => 'color',
							'condition' => array( 'id' => 'shop-list-rating', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

					),
   			),




























				// Order steps ----------------------------------------------------

   			'order_steps' => array(
   				'type' => 'order_steps',
   				'title' => __('Order steps', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'order-shared',
   				'attr' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),


   					array(
							'type' => 'header',
							'title' => __('Labels', 'mfn-opts'),
						),

						array(
   						'id' => 'cart_label',
   						'type' => 'text',
   						'edit_tag' => '.mfn-checkout-step-cart | span.mfn-step-label',
   						'edit_position' => 'append',
   						'title' => __('Cart label', 'mfn-opts'),
   						'std' => __('Cart', 'woocommerce'),
   					),

   					array(
   						'id' => 'checkout_label',
   						'type' => 'text',
   						'edit_tag' => '.mfn-checkout-step-checkout | span.mfn-step-label',
   						'edit_position' => 'append',
   						'title' => __('Checkout label', 'mfn-opts'),
   						'std' => __('Checkout', 'woocommerce'),
   					),

   					array(
   						'id' => 'order_label',
   						'type' => 'text',
   						'edit_tag' => '.mfn-checkout-step-order | span.mfn-step-label',
   						'edit_position' => 'append',
   						'title' => __('Order label', 'mfn-opts'),
   						'std' => __('Order', 'woocommerce'),
   					),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'title' => __('Items', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'id' => 'css_order_steps_gap',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps',
							'style' => '--mfn-order-steps-gap',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'title' => __('Number', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'id' => 'css_order_steps_number_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps',
							'style' => '--mfn-order-steps-number-width',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Wrapper size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'css_order_steps_number_font_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li .mfn-step-number',
							'style' => 'font-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Number size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'css_order_steps_number_offset',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li .mfn-step-number',
							'style' => 'margin-right',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Offset', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),








						array(
							'id' => 'css_order_steps_number_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li .mfn-step-number',
							'style' => 'border-style',
							'attr_id' => 'border_order_steps_nr',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_order_steps_number_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li .mfn-step-number',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_order_steps_nr', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
							'id' => 'css_order_steps_number_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li .mfn-step-number',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),




						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'css_order_steps_number_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li .mfn-step-number',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_order_steps_number_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li .mfn-step-number',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_order_steps_number_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li .mfn-step-number',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_order_steps_nr', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'css_order_steps_number_color_active',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li.active .mfn-step-number',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_order_steps_number_background_color_active',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li.active .mfn-step-number',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_order_steps_number_border_color_active',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li.active .mfn-step-number',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_order_steps_nr', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),



						array(
							'title' => __('Label', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'id' => 'css_order_steps_label_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li .mfn-step-label',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'css_order_steps_label_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li .mfn-step-label',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'css_order_steps_label_color_active',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li.active .mfn-step-label',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),


						array(
							'title' => __('Separator', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'id' => 'css_order_steps_separator_opacity',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li:after',
							'style' => 'opacity',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Opacity', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '1',
								'step' => '0.1',
								'unit' => '',
							)
						),

						array(
							'id' => 'css_order_steps_separator_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li:after',
							'style' => 'font-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '50',
								'step' => '1',
								'unit' => 'px',
							)
						),


						array(
							'id' => 'css_order_steps_separator_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-checkout-steps li:after',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),


						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// ALIAS: Blog Heading ----------------------------------------------------

   			'archive_heading' => array(
   				'type' => 'heading',
   				'title' => __('Title', 'mfn-opts'),
   				'cat' => 'archive',
   			),

   			// ALIAS: Blog image ----------------------------------------------------

   			'archive_image' => array(
   				'type' => 'image',
   				'title' => __('Archive image', 'mfn-opts'),
   				'cat' => 'archive',
   			),

   			// ALIAS: Blog readmore ----------------------------------------------------

   			'archive_read_more' => array(
   				'type' => 'button',
   				'title' => __('Read more', 'mfn-opts'),
   				'cat' => 'archive',
   			),

   			// ALIAS: Blog Desc ----------------------------------------------------

   			'archive_content' => array(
   				'type' => 'plain_text',
   				'title' => __('Description', 'mfn-opts'),
   				'cat' => 'archive',
   			),

   			'archive_blog_categories' => array(
   				'type' => 'tag_cloud',
   				'title' => __('Categories', 'mfn-opts'),
   				'cat' => 'blog',
   			),

   			'archive_portfolio_categories' => array(
   				'type' => 'tag_cloud',
   				'title' => __('Categories', 'mfn-opts'),
   				'cat' => 'portfolio',
   			),

   			// ALIAS: Single Post Heading ----------------------------------------------------

   			'post_heading' => array(
   				'type' => 'heading',
   				'title' => __('Post title', 'mfn-opts'),
   				'cat' => 'single-post',
   			),

   			// ALIAS: Single Post Image ----------------------------------------------------

   			'post_image' => array(
   				'type' => 'image',
   				'title' => __('Featured image', 'mfn-opts'),
   				'cat' => 'single-post',
   			),

   			// ALIAS: Single Post Author -----------------------------------------------------

   			'post_author' => array(
   				'type' => 'icon_box_2',
   				'title' => __('Post author', 'mfn-opts'),
   				'cat' => 'single-post',
   			),

   			// ALIAS: Single Post date -------------------------------------------------------

   			'post_date' => array(
   				'type' => 'heading',
   				'title' => __('Post date', 'mfn-opts'),
   				'cat' => 'single-post',
   			),

   			// ALIAS: Single Post related ----------------------------------------------------

   			'post_blog_related' => array(
   				'type' => 'blog',
   				'title' => __('Related posts', 'mfn-opts'),
   				'cat' => 'single-blog-post',
   			),

   			// ALIAS: Single Portfolio related ----------------------------------------------------

   			'post_portfolio_related' => array(
   				'type' => 'portfolio',
   				'title' => __('Related posts', 'mfn-opts'),
   				'cat' => 'single-portfolio-post',
   			),

   			// ALIAS: Single Post categories -------------------------------------------------

   			'post_blog_categories' => array(
   				'type' => 'tag_cloud',
   				'title' => __('Post categories', 'mfn-opts'),
   				'cat' => 'single-blog-post',
   			),

   			// ALIAS: Single Post categories -------------------------------------------------

   			'post_portfolio_categories' => array(
   				'type' => 'tag_cloud',
   				'title' => __('Post categories', 'mfn-opts'),
   				'cat' => 'single-portfolio-post',
   			),

   			// ALIAS: Single Post categories -------------------------------------------------

   			'post_blog_tags' => array(
   				'type' => 'tag_cloud',
   				'title' => __('Post tags', 'mfn-opts'),
   				'cat' => 'single-blog-post',
   			),

   			// ALIAS: Single Post categories -------------------------------------------------

   			'post_excerpt' => array(
   				'type' => 'plain_text',
   				'title' => __('Excerpt', 'mfn-opts'),
   				'cat' => 'single-post',
   			),

   			// ALIAS: Single Post love it -------------------------------------------------

   			'post_love' => array(
   				'type' => 'icon_box_2',
   				'title' => __('Post love', 'mfn-opts'),
   				'cat' => 'single-post',
   			),

   			// Single Post Comments ----------------------------------------------------

   			'post_comments' => array(
   				'type' => 'post_comments',
   				'title' => __('Post comments', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-post',
   				'attr' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'id' => 'info',
							'class' => 'mfn-alert',
							'type' => 'info',
							'title' => __('This element has no attributes. Please check <b>advanced</b> tab for more customisation options.', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'id' => 'info',
							'class' => 'mfn-alert',
							'type' => 'info',
							'title' => __('This element has no attributes. Please check <b>advanced</b> tab for more customisation options.', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

					),
   			),

   			// Single Post Content ----------------------------------------------------

   			'post_content' => array(
   				'type' => 'post_content',
   				'title' => __('Post content', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-post',
   				'attr' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'type' => 'header',
							'title' => __('Content', 'mfn-opts'),
						),

						array(
							'id' => 'content',
							're_render' => true,
							'type' => 'select',
							'title' => __('Source', 'mfn-opts'),
							'options' => array(
								'' => __('Default', 'mfn-opts'),
								'mfn' => __('BeBuilder', 'mfn-opts'),
							),
							'std' => '',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'id' => 'info',
							'class' => 'mfn-alert',
							'type' => 'info',
							'title' => __('This element has no attributes. Please check <b>advanced</b> tab for more customisation options.', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

					),
   			),

   			// Menu ----------------------------------------------------

   			'sidemenu_menu' => array(
   				'type' => 'sidemenu_menu',
   				'title' => __('Menu', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'sidemenu',
   				'attr' => array(
   				//'fields' => array(

						/*array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),*/

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'type' => 'header',
							'title' => __('Menu', 'mfn-opts'),
						),

   					array(
   						'id' => 'tabs',
   						'type' => 'tabs',
   						'title' => __('Menu', 'mfn-opts'),
   						'desc' => __('Add multiple menus easily in tabs. You can add one menu in single tab as well.', 'mfn-opts'),
							'options' => [
								'title' => [
									'input',
									__('Title', 'mfn-opts'),
									__('Menu title', 'mfn-opts'),
								],
								'menu' => [
									'select',
									__('Menu to display', 'mfn-opts'),
									'',
									'menus',
								],
							],
							'std' => [
								0 => [
									'title' => __('Menu 1', 'mfn-opts'),
									'menu' => '',
								]
							],
							'preview' => 'tabs',
							'primary' => 'title', // default
   					),

   					array(
   						'type' => 'header',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu a .menu-icon:display',
							'id' => 'css_sidemenu-menu-a-icon_display',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu a .menu-icon',
							'style' => 'display',
							'attr_id' => 'icon_sm_visibility',
							'type' => 'switch',
							'title' => __('Icon visibility', 'mfn-opts'),
							'options' => array(
								'block' => 'Show',
								'none' 	=> 'Hide',
							),
							'std' => 'block',
						),

   					array(
   						'type' => 'header',
							'title' => __('Submenu', 'mfn-opts'),
						),

   					array(
							'id' => 'submenu',
							'attr_id' => 'submenu',
							're_render' => true,
							'type' => 'switch',
							'title' => __('Submenu', 'mfn-opts'),
							'options' => array(
								'on' => 'Show',
								'off' => 'Hide',
							),
							'std' => 'on',
						),

						array(
							'id' => 'submenu_on',
							'attr_id' => 'submenu_on',
							'condition' => array( 'id' => 'submenu', 'opt' => 'is', 'val' => 'on' ),
							're_render' => true,
							'type' => 'select',
							'title' => __('Submenu visibility', 'mfn-opts'),
							'options' => array(
								'visible' => 'Visible',
								'toggled' => 'Toggled',
								'replace' => 'Replace current',
							),
							'std' => 'visible',
						),

						array(
							'id' => 'submenu_icon_display',
							'condition' => array( 'id' => 'submenu', 'opt' => 'is', 'val' => 'on' ),
							're_render' => true,
							'type' => 'switch',
							'title' => __('Submenu icon visibility', 'mfn-opts'),
							'options' => array(
								'on' => 'Show',
								'off' => 'Hide',
							),
							'std' => 'on',
						),

						array(
							'id' => 'submenu_icon',
							'condition' => array( 'id' => 'submenu', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'icon',
							'title' => __('Submenu icon', 'mfn-opts'),
							'preview' => 'icon',
							'std' => 'fas fa-arrow-down'
						),

						array(
   						'id' => 'submenu_icon_animation',
   						'type' => 'select',
   						'condition' => array( 'id' => 'submenu', 'opt' => 'is', 'val' => 'on' ),
   						'title' => __('Icon Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'rotate' => 'Rotate',
								'zoom' => 'Zoom'
							),
   					),

   					array(
   						'type' => 'header',
							'title' => __('Desc', 'mfn-opts'),
						),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu a .menu-desc:display',
							'id' => 'css_sidemenu-menu-a-desc_display',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu a .menu-desc',
							'style' => 'display',
							'type' => 'switch',
							'title' => __('Desc visibility', 'mfn-opts'),
							'options' => array(
								'block' => 'Show',
								'none' 	=> 'Hide',
							),
							'std' => 'block',
						),



   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

   					array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Menu', 'mfn-opts'),
   					),




   					array(
   						'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper:padding',
							'id' => 'css_menu-wrapper_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper:background-color',
							'id' => 'css_menu-wrapper_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper:border-style',
							'id' => 'css_menu-wrapper_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper',
							'style' => 'border-style',
							'attr_id' => 'border_sidemenu_tabs_content',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper:border-width',
							'id' => 'css_menu-wrapper_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_sidemenu_tabs_content', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper:border-color',
							'id' => 'css_menu-wrapper_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_sidemenu_tabs_content', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper:border-radius',
							'id' => 'css_menu-wrapper_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),





   					array(
   						'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
					),

					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link:justify-content',
							'id' => 'css_ul-sidemenu-menulia-menu-link_justify_content',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link',
							'style' => 'justify-content',
							'type' => 'switch',
							'responsive' => true,
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'' => 'Left',
								'center' => 'Center',
								'flex-end' => 'Right',
							),
							'std' => '',
						),




   					array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link:padding',
							'id' => 'css_ul-sidemenu-menulia-menu-link_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link:margin',
							'id' => 'css_ul-sidemenu-menulia-menu-link_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link:typography',
							'id' => 'css_sidemenu-menulia-menu-link_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link:border-style',
							'id' => 'css_ul-sidemenu-menu-link_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link',
							'style' => 'border-style',
							'attr_id' => 'border_sidemenu_tabs_ulli2',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link:border-width',
							'id' => 'css_ul-sidemenu-menu-link_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_sidemenu_tabs_ulli2', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link:border-radius',
							'id' => 'css_ul-sidemenu-menu-link_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link:color',
							'id' => 'css_ul-sidemenu-menulia-menu-link_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link:background-color',
							'id' => 'css_ul-sidemenu-menu-link_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link:border-color',
							'id' => 'css_ul-sidemenu-menu-link_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_sidemenu_tabs_ulli2', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link|hover:color',
							'id' => 'css_ul-sidemenu-menu-link_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link|hover:background-color',
							'id' => 'css_ul-sidemenu-link_background_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link:hover',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link|hover:border-color',
							'id' => 'css_ul-sidemenu-link_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li a.mfn-menu-link:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_sidemenu_tabs_ulli2', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li.current-menu-item > a.mfn-menu-link:color',
							'id' => 'css_ul-sidemenu-licurrent-menu-itema-menu-link_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li.current-menu-item > a.mfn-menu-link',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li.current-menu-item > a.mfn-menu-link:background-color',
							'id' => 'css_ul-sidemenu-menulicurrent-menu-itema-menu-link_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li.current-menu-item > a.mfn-menu-link',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li.current-menu-item > a.mfn-menu-link:border-color',
							'id' => 'css_ul-sidemenu-menulicurrent-menu-itema-menu-link_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li.current-menu-item > a.mfn-menu-link',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_sidemenu_tabs_ulli2', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),














						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Icon', 'mfn-opts'),
						),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li:--mfn-sidemenu-icon-gap',
							'id' => 'css_sidemenu-menuli_mfn_sidemenu_icon_gap',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li',
							'style' => '--mfn-sidemenu-icon-gap',
							'type' => 'sliderbar',
							//'condition' => array( 'id' => 'icon_visibility', 'opt' => 'is', 'val' => 'block' ),
							'responsive' => true,
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							),
							'std' => '5px'
						),
						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li:--mfn-sidemenu-icon-width',
							'id' => 'css_sidemenu-menuli_sidemenu_icon_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li',
							'style' => '--mfn-sidemenu-icon-width',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),
						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu .menu-icon i:color',
							'id' => 'css_sidemenu-menumenu-iconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu .menu-icon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu a|hover .menu-icon i:color',
							'id' => 'css_sidemenu-menu-a-iconi_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu a:hover .menu-icon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li.current-menu-item > a .menu-icon i:color',
							'id' => 'css_sidemenu-menulicurrent-menu-itemamenu-iconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li.current-menu-item > a .menu-icon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Submenu icon', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li:--mfn-sidemenu-submenu-icon-width',
							'id' => 'css_sidemenu-menuli_sidemenu_submenu_icon_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li',
							'style' => '--mfn-sidemenu-submenu-icon-width',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li:--mfn-sidemenu-submenu-icon-size',
							'id' => 'css_sidemenu-menuli_sidemenu_submenu_icon_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li',
							'style' => '--mfn-sidemenu-submenu-icon-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),


						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li .outer-menu-sub i:color',
							'id' => 'css_sidemenu-menuliouter-menu-subi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li .outer-menu-sub i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li .outer-menu-sub:background-color',
							'id' => 'css_sidemenu-menuliouter-menu-sub_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li .outer-menu-sub',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li|hover > .outer-menu-sub i:color',
							'id' => 'css_sidemenu-menuliouter-menu-subi_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li:hover > .outer-menu-sub i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li|hover > .outer-menu-sub:background-color',
							'id' => 'css_sidemenu-menuliouter-menu-sub_background_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li:hover > .outer-menu-sub',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li.current-menu-item > .outer-menu-sub i:color',
							'id' => 'css_sidemenu-menulicurrent-menu-itemouter-menu-subi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li.current-menu-item > .outer-menu-sub i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li.current-menu-item > .outer-menu-sub:background-color',
							'id' => 'css_-sidemenu-menulicurrent-menu-itemouter-menu-sub_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-menu li.current-menu-item > .outer-menu-sub',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
							'condition' => array( 'id' => 'submenu_on', 'opt' => 'isnt', 'val' => 'replace' ),
							'type' => 'header',
   						'title' => __('Submenu', 'mfn-opts'),
   					),

   					array(
   						'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper li ul:padding',
							'id' => 'css_menu-wrapperliul_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper li ul',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper li ul:background-color',
							'id' => 'css_menu-wrapperliul_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper li ul',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper li ul:border-style',
							'id' => 'css_menu-wrapperliul_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper li ul',
							'style' => 'border-style',
							'attr_id' => 'border_sidemenu_tabs_content',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper li ul:border-width',
							'id' => 'css_menu-wrapperliul_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper li ul',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_sidemenu_tabs_content', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper li ul:border-color',
							'id' => 'css_menu-wrapperliul_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper li ul',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_sidemenu_tabs_content', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper li ul:border-radius',
							'id' => 'css_menu-wrapperliul_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-wrapper li ul',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),




   					array(
   						'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
						),


   					array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link:padding',
							'id' => 'css_ul-sidemenu-menuliullia-menu-link_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link:margin',
							'id' => 'css_ul-sidemenu-menuliullia-menu-link_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link:typography',
							'id' => 'css_sidemenu-menuliullia-menu-link_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link:border-style',
							'id' => 'css_ul-sidemenu-liullia-menu-link_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link',
							'style' => 'border-style',
							'attr_id' => 'border_sidemenu_tabs_ulli',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link:border-width',
							'id' => 'css_ul-sidemenu-liullia-menu-link_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_sidemenu_tabs_ulli', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link:border-radius',
							'id' => 'css_ul-sidemenu-liullia-menu-link_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link:color',
							'id' => 'css_ul-sidemenu-menuliullia-menu-link_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link:background-color',
							'id' => 'css_ul-sidemenu-liullia-menu-link_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link:border-color',
							'id' => 'css_ul-sidemenu-liullia-menu-link_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_sidemenu_tabs_ulli', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link|hover:color',
							'id' => 'css_ul-sidemenu-menuliullia-menu-link_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link|hover:background-color',
							'id' => 'css_ul-sidemenu-menuliullia-menu-linkhover_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link:hover',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link|hover:border-color',
							'id' => 'css_ul-sidemenu-liullia-menu-link_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li a.mfn-menu-link:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_sidemenu_tabs_ulli', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li.current-menu-item > a.mfn-menu-link:color',
							'id' => 'css_ul-sidemenu-menuliullicurrent-menu-itema-menu-link_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li.current-menu-item > a.mfn-menu-link',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li.current-menu-item > a.mfn-menu-link:background-color',
							'id' => 'css_ul-sidemenu-menuliullicurrent-menu-itema-menu-link_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li.current-menu-item > a.mfn-menu-link',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li.current-menu-item > a.mfn-menu-link:border-color',
							'id' => 'css_ul-sidemenu-menuliullicurrent-menu-itema-menu-link_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-sidemenu-menu li ul li.current-menu-item > a.mfn-menu-link',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_sidemenu_tabs_ulli', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),


   					array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Tabs', 'mfn-opts'),
   					),


   					array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'type' => 'subheader',
   						'title' => __('Nav', 'mfn-opts'),
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav:--mfn-sidemenu-menu-tabber-padding',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-nav_mfn_sidemenu_menu_tabber_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav',
							'style' => '--mfn-sidemenu-menu-tabber-padding',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Padding', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							),
							'std' => '5px',
						),
						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav:margin-bottom',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-nav_margin_bottom',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav',
							'style' => 'margin-bottom',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Margin bottom', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							),
							'std' => '5px',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav:--mfn-sidemenu-menu-tabber-bg',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-nav_mfn_sidemenu_menu_tabber_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav',
							'style' => '--mfn-sidemenu-menu-tabber-bg',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav:border-style',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-nav_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav',
							'style' => 'border-style',
							'attr_id' => 'border_sidemenu_tabs_ul',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav:border-width',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-nav_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_sidemenu_tabs_ul', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav:border-color',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-nav_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_sidemenu_tabs_ul', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav:border-radius',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-nav_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



   					array(
   						'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Nav items', 'mfn-opts'),
						),


   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li:--mfn-sidemenu-menu-tabber-tab-spacing',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-navli_mfn_sidemenu_menu_tabber_tab_spacing',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li',
							'style' => '--mfn-sidemenu-menu-tabber-tab-spacing',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							),
							'std' => '5px',
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a:padding',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-navlia_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a:typography',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-navlia_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a:border-style',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-navlia_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a',
							'style' => 'border-style',
							'attr_id' => 'border_sidemenu_tabs_ulli',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a:border-width',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-navlia_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_sidemenu_tabs_ulli', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a:border-radius',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-navlia_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a:color',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-navlia_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a:background-color',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-navlia_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a:border-color',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-navlia_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_sidemenu_tabs_ulli', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a|hover:color',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-navlia_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a|hover:background-color',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-navliahover_background_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a:hover',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a|hover:border-color',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-navlia_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li a:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_sidemenu_tabs_ulli', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li.active a:color',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-navlia_color_active',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li.active a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li.active a:background-color',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-navlia_background_color_active',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li.active a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li.active a:border-color',
							'id' => 'css_menu-tabs-wrapperul-menu-tabs-navlia_border_color_active',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-tabs-wrapper ul.mfn-menu-tabs-nav li.active a',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_sidemenu_tabs_ulli', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
							'type' => 'header',
							'condition' => array( 'id' => 'submenu_on', 'opt' => 'is', 'val' => 'replace' ),
   						'title' => __('Breadcrumbs', 'mfn-opts'),
   					),


   					array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'condition' => array( 'id' => 'submenu_on', 'opt' => 'is', 'val' => 'replace' ),
							'type' => 'subheader',
   						'title' => __('Links', 'mfn-opts'),
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-breadcrumbs a:typography',
							'id' => 'css_sidemenu-breadcrumbsa_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-breadcrumbs a',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-breadcrumbs a:color',
							'id' => 'css_sidemenu-breadcrumbsa_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-breadcrumbs a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-breadcrumbs a|hover:color',
							'id' => 'css_sidemenu-breadcrumbsa_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-breadcrumbs a:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

   					array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'type' => 'subheader',
   						'title' => __('Separator', 'mfn-opts'),
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-breadcrumbs .mfn-sidemenu-breadcrumbs-separator:color',
							'id' => 'css_sidemenu-breadcrumbs-sidemenu-breadcrumbs-separator_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-sidemenu-breadcrumbs .mfn-sidemenu-breadcrumbs-separator',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),



   			// Popup Exit popup exit_popup exit-button ----------------------------------------------------

   			'popup_exit' => array(
   				'type' => 'popup_exit',
   				'title' => __('Exit link', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'popup',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
   						'id' => 'label',
   						'edit_tag' => '.exit-mfn-popup | span.button_label',
   						'edit_position' => 'append',
   						'type' => 'text',
   						'title' => __('Label', 'mfn-opts'),
   						'std' => __('Close popup', 'mfn-opts'),
   					),

						array(
							'id' => 'icon',
							'type' => 'icon',
							'title' => __('Icon', 'mfn-opts'),
							'preview' => 'icon',
							'std' => 'icon-cancel'
						),

						array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
   						'desc' => __('Overrides icon', 'mfn-opts'),
							'preview' => 'image',
   					),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
							'type' => 'header',
   						'title' => __('Link', 'mfn-opts'),
   					),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:text-align',
							'id' => 'css_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner',
							'style' => 'text-align',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'std' => 'left',
						),


						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:padding',
		  				'id' => 'css_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:--mfn-exitbutton-item-size',
							'id' => 'css_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup',
							'style' => '--mfn-exitbutton-item-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:border-style',
							'id' => 'css_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup',
							'style' => 'border-style',
							'attr_id' => 'border_exit_popup',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:border-width',
		  				'id' => 'css_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_exit_popup', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:border-radius',
		  				'id' => 'css_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),






						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:color',
							'id' => 'css_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:background-color',
							'id' => 'css_bg_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:border-color',
							'id' => 'css_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_exit_popup', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup|hover:color',
							'id' => 'css_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup|hover:background-color',
							'id' => 'css_bg_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:hover',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup|hover:border-color',
							'id' => 'css_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_exit_popup', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

   			// Footer Logo ----------------------------------------------------

   			'footer_logo' => array(
   				'type' => 'footer_logo',
   				'title' => __('Logo', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'footer',
   				'attr' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Logo', 'mfn-opts'),
   						'desc' => __('Recommended svg', 'mfn-opts'),
							'std' => mfn_opts_get('logo-img') ? mfn_opts_get('logo-img') : $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
							'id' => 'link',
							'type' => 'text',
							'title' => __('Link', 'mfn-opts'),
							'std' => '/',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'id' => 'info',
							'type' => 'info',
							'class' => 'mfn-alert',
							'title' => __('This element has no attributes. Please check <b>advanced</b> tab for more customisation options.', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

				// Footer Menu ----------------------------------------------------

   			'footer_menu' => array(
   				'type' => 'footer_menu',
   				'title' => __('Menu', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'footer',
   				'attr' => array(
   				//'fields' => array(

						/*array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),*/

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'type' => 'header',
							'title' => __('Menu', 'mfn-opts'),
						),

						array(
   						'id' => 'menu_display',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Menu to display', 'mfn-opts'),
							//'options' => mfna_menu(),
							'js_options' => 'menus',
   					),

   					array(
   						'id' => 'menu_style',
   						'attr_id' => 'menu_style',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Style', 'mfn-opts'),
							'options' => array(
								'vertical' => __('Vertical', 'mfn-opts'),
								'horizontal' => __('Horizontal', 'mfn-opts'),
							),
							'std' => 'vertical'
   					),


   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner ul.mfn-footer-menu-style-vertical:text-align',
							'id' => 'css_mcb-column-innerul-footer-menu--vertical_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner ul.mfn-footer-menu-style-vertical',
							'style' => 'text-align',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'vertical' ),
							'attr_id' => 'menu-items-alignment',
							'type' => 'select',
							'responsive' => true,

							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'' => __('Default', 'mfn-opts'),
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'std' => 'left',
						),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner ul.mfn-footer-menu-style-horizontal:justify-content',
							'id' => 'css_mcb-column-innerul-footer-menu--horizontal_justify_content',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner ul.mfn-footer-menu-style-horizontal',
							'style' => 'justify-content',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'horizontal' ),
							'attr_id' => 'menu-items-alignment',
							'type' => 'select',
							'responsive' => true,

							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Left',
								'center' => 'Center',
								'flex-end' => 'Right',
								'space-between' => 'Space between',
								'space-around' => 'Space around',
								'space-evenly' => 'Space evenly',
							),
							'std' => 'center',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Menu', 'mfn-opts'),
   					),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul a:typography',
							'id' => 'css_ula_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul a',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul a:padding',
							'id' => 'css_ula_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul a',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul a:color',
							'id' => 'css_ula_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul a|hover:color',
							'id' => 'css_ula_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul a:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul .current-menu-item > a:color',
							'id' => 'css_ulcurrent-menu-itema_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul .current-menu-item > a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

					),
   			),

   			// Mega menu Menu ----------------------------------------------------

   			'megamenu_menu' => array(
   				'type' => 'megamenu_menu',
   				'title' => __('Menu', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'megamenu',
   				'attr' => array(
   				//'fields' => array(

						/*array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),*/

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'type' => 'header',
							'title' => __('Menu', 'mfn-opts'),
						),

						array(
   						'id' => 'menu_display',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Menu to display', 'mfn-opts'),
							//'options' => mfna_menu(),
							'js_options' => 'menus',
   					),

   					array(
   						'id' => 'menu_style',
   						'attr_id' => 'menu_style',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Style', 'mfn-opts'),
							'options' => array(
								'vertical' => __('Vertical', 'mfn-opts'),
								'horizontal' => __('Horizontal', 'mfn-opts'),
							),
							'std' => 'vertical'
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu.mfn-mm-menu-horizontal:justify-content',
							'id' => 'css_megamenu-menu-mm-menu-horizontal_justify_content',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu.mfn-mm-menu-horizontal',
							'style' => 'justify-content',
							'attr_id' => 'menu-items-alignment',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'horizontal' ),
							'type' => 'select',
							'responsive' => true,

							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Left',
								'center' => 'Center',
								'flex-end' => 'Right',
								'space-between' => 'Space between',
								'space-around' => 'Space around',
								'space-evenly' => 'Space evenly',
							),
							'std' => 'flex-start',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu.mfn-mm-menu-horizontal > li:flex-grow',
							'id' => 'css_megamenu-menu-mm-menu-horizontalli_flex_grow',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu.mfn-mm-menu-horizontal > li',
							'style' => 'flex-grow',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'horizontal' ),
							'type' => 'select',
							'responsive' => true,

							'title' => __('Fit container', 'mfn-opts'),
							'options' => [
								'unset' => __('Default', 'mfn-opts'),
								'1' => __('Fit', 'mfn-opts'),
							],
						),
						array(
							'id' => 'submenu_on',
							'attr_id' => 'submenu_on',
							're_render' => true,
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'vertical' ),
							'type' => 'switch',
							'title' => __('Submenu visibility', 'mfn-opts'),
							'options' => array(
								'visible' => 'Visible',
								'toggled' => 'Toggled',
							),
							'std' => 'visible',
						),

						array(
							'id' => 'submenu_hori_on',
							're_render' => true,
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'horizontal' ),
							'type' => 'switch',
							'title' => __('Submenu visibility', 'mfn-opts'),
							'options' => array(
								'hover' => 'on Hover',
								'click' => 'on Click',
							),
							'std' => 'hover',
						),

   					array(
   						'type' => 'header',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a .menu-icon:display',
							'id' => 'css_megamenu-icon_display',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a .menu-icon',
							'style' => 'display',
							'attr_id' => 'icon_mm_visibility',
							'type' => 'switch',
							'title' => __('Icon visibility', 'mfn-opts'),
							'options' => array(
								'block' => 'Show',
								'none' 	=> 'Hide',
							),
							'std' => 'block',
						),

						array(
   						'id' => 'icon_align',
   						//'condition' => array( 'id' => 'icon_mm_visibility', 'opt' => 'is', 'val' => 'block' ),
   						'type' => 'switch',
   						'title' => __('Icon align', 'mfn-opts'),
							'options' => array(
								'left' => 'Left',
								'top' => 'Top',
								'right' => 'Right'
							),
							'std' => 'left'
   					),

						array(
   						'id' => 'icon_animation',
   						//'condition' => array( 'id' => 'icon_mm_visibility', 'opt' => 'is', 'val' => 'block' ),
   						'type' => 'select',
   						'title' => __('Icon animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'rotate' => 'Rotate',
								'zoom' => 'Zoom'
							),
   					),

   					array(
   						'type' => 'header',
							'title' => __('Submenu', 'mfn-opts'),
						),

   					array(
							'id' => 'submenu',
							'attr_id' => 'submenu',
							're_render' => true,
							'type' => 'switch',
							'title' => __('Submenu', 'mfn-opts'),
							'options' => array(
								'on' => 'Show',
								'off' => 'Hide',
							),
							'std' => 'on',
						),

						array(
   						'id' => 'submenu_animation',
   						'condition' => array( 'id' => 'submenu', 'opt' => 'is', 'val' => 'on' ),
   						'type' => 'select',
   						'title' => __('Submenu Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'fade-in' => 'Fade In',
								'fade-up' => 'Fade In Up'
							),
   					),

						array(
							'id' => 'submenu_icon',
							'condition' => array( 'id' => 'submenu', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'icon',
							'title' => __('Submenu icon', 'mfn-opts'),
							'preview' => 'icon',
							'std' => 'fas fa-arrow-down'
						),

						array(
   						'id' => 'submenu_icon_animation',
   						'type' => 'select',
   						'condition' => array( 'id' => 'submenu', 'opt' => 'is', 'val' => 'on' ),
   						'title' => __('Icon Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'rotate' => 'Rotate',
								'zoom' => 'Zoom'
							),
   					),

   					array(
   						'type' => 'header',
							'title' => __('Desc', 'mfn-opts'),
						),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a .menu-desc:display',
							'id' => 'css_megamenu-desc_display',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a .menu-desc',
							'style' => 'display',
							'type' => 'switch',
							'title' => __('Desc visibility', 'mfn-opts'),
							'options' => array(
								'block' => 'Show',
								'none' 	=> 'Hide',
							),
							'std' => 'block',
						),

						array(
							'type' => 'header',
							'title' => __('Decoration icon', 'mfn-opts'),
						),

						array(
							'id' => 'decoration_icon',
							'type' => 'icon',
							'title' => __('Decoration icon', 'mfn-opts'),
							'preview' => 'icon',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Menu', 'mfn-opts'),
   					),

   					array(
   						'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a:typography',
							'id' => 'css_megamenu-menua_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a:padding',
							'id' => 'css_megamenu-menua_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a:border-style',
							'id' => 'css_megamenu-menulia_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a',
							'style' => 'border-style',
							'attr_id' => 'border_style_header_mm_menu_link',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a:border-width',
							'id' => 'css_megamenu-menulia_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_header_mm_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a:border-radius',
							'id' => 'css_megamenu-menulia_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a:color',
							'id' => 'css_megamenu-menua_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a:background-color',
							'id' => 'css_megamenu-menua_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a:border-color',
							'id' => 'css_megamenu-menulia_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_mm_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a|hover:color',
							'id' => 'css_megamenu-menua_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.mfn-megamenu-menu li a:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a|hover:background-color',
							'id' => 'css_megamenu-menua_background_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a:hover',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a|hover:border-color',
							'id' => 'css_megamenu-menulia_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_mm_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .current-menu-item > a:color',
							'id' => 'css_megamenu-menucurrent-menu-itema_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .current-menu-item > a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .current-menu-ancestor > a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .current-product_cat-ancestor > a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .current-menu-item > a:background-color',
							'id' => 'css_megamenu-menucurrent-menu-itema_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .current-menu-item > a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .current-menu-ancestor > a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .current-product_cat-ancestor > a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .current-menu-item > li > a:border-color',
							'id' => 'css_megamenu-menucurrent-menu-itemlia_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .current-menu-item > a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .current-menu-ancestor > a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .current-product_cat-ancestor > a',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_mm_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Icon', 'mfn-opts'),
						),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-menu-icon-gap',
							'id' => 'css_megamenu-menuli_menu_icon_gap',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li',
							'style' => '--mfn-megamenu-menu-icon-gap',
							'type' => 'sliderbar',
							//'condition' => array( 'id' => 'icon_visibility', 'opt' => 'is', 'val' => 'block' ),
							'responsive' => true,
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-menu-icon-size',
							'id' => 'css_megamenu-menuli_menu_icon_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li',
							'style' => '--mfn-megamenu-menu-icon-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),


						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .menu-icon > i:color',
							'id' => 'css_megamenu-menumenu-iconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .menu-icon > i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a|hover > .menu-icon > i:color',
							'id' => 'css_megamenu-menuamenu-iconi_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a:hover > .menu-icon > i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li.current-menu-item > a > .menu-icon i:color',
							'id' => 'css_megamenu-menulicurrent-menu-itemamenu-iconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li.current-menu-item > a > .menu-icon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Submenu icon', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-menu-submenu-icon-gap',
							'id' => 'css_megamenu-menuli_menu_submenu_icon_gap',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li',
							'style' => '--mfn-megamenu-menu-submenu-icon-gap',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li .menu-sub i:--mfn-megamenu-submenu-icon-size',
							'id' => 'css_megamenu-menulimenu-subi_megamenu_submenu_icon_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li .menu-sub i',
							'style' => '--mfn-megamenu-submenu-icon-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a .menu-sub i:color',
							'id' => 'css_megamenu-menuliamenu-subi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a .menu-sub i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a|hover .menu-sub i:color',
							'id' => 'css_megamenu-menuliamenu-subi_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a:hover .menu-sub i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li.current-menu-item > a .menu-sub i:color',
							'id' => 'css_megamenu-menulicurrent-menu-itemamenu-subi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li.current-menu-item > a .menu-sub i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'condition' => array( 'id' => 'submenu', 'opt' => 'is', 'val' => 'on' ),
   						'title' => __('Submenu', 'mfn-opts'),
   					),

   					array(
   						'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li > ul:background-color',
							'id' => 'css_megamenu-menuliul_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li > ul',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li > ul:border-style',
							'id' => 'css_megamenu-menuliul_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li > ul',
							'style' => 'border-style',
							'attr_id' => 'border_style_header_submenu',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul:border-width',
							'id' => 'css_megamenu-menuliul_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul:border-color',
							'id' => 'css_megamenu-menuliul_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul:box-shadow',
							'id' => 'css_megamenu-menuliul_box_shadow',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul',
							'style' => 'box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul:--mfn-megamenu-submenu-border-radius',
							'id' => 'css_megamenu-menuliul_megamenu_submenu_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul',
							'style' => '--mfn-megamenu-submenu-border-radius',
							'type' => 'dimensions',
							'title' => __('Border radius', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'version' => 'separated-fields',
						),

   					array(
   						'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul a:typography',
							'id' => 'css_megamenu-menuliula_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul a',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li a:padding',
							'id' => 'css_megamenu-menuliullia_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li a',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul a:color',
							'id' => 'css_megamenu-menuliula_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li a:background-color',
							'id' => 'css_megamenu-menuliullia_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul a|hover:color',
							'id' => 'css_megamenu-menuliula_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul a:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul .current-menu-item > a:color',
							'id' => 'css_megamenu-menuliulcurrent-menu-itema_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul .current-menu-item > a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-submenu-subicon-gap',
							'id' => 'css_megamenu-menuli_submenu_subicon_gap',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li',
							'style' => '--mfn-megamenu-submenu-subicon-gap',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li .menu-icon i:--mfn-megamenu-submenu-subicon-size',
							'id' => 'css_megamenu-menuliullimenu-iconi_megamenu_submenu_subicon_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li .menu-icon i',
							'style' => '--mfn-megamenu-submenu-subicon-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a .menu-sub i:color',
							'id' => 'css_megamenu-menuliamenu-subi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a .menu-sub i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a|hover .menu-sub i:color',
							'id' => 'css_megamenu-menuliamenu-subi_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a:hover .menu-sub i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li.current-menu-item > a .menu-sub i:color',
							'id' => 'css_megamenu-menulicurrent-menu-itemamenu-subi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li.current-menu-item > a .menu-sub i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Submenu icon', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li .menu-sub i:--mfn-megamenu-submenu-submenu-icon-size',
							'id' => 'css_megamenu-menuliullimenu-subi_megamenu_submenu_submenu_icon_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li .menu-sub i',
							'style' => '--mfn-megamenu-submenu-submenu-icon-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul > li > a .menu-sub i:color',
							'id' => 'css_megamenu-menuliulliamenu-subi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul > li > a .menu-sub i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul > li > a|hover .menu-sub i:color',
							'id' => 'css_megamenu-menuliulliamenu-subi_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul > li > a:hover .menu-sub i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul > li.current-menu-item > a .menu-sub i:color',
							'id' => 'css_megamenu-menuliullicurrent-menu-itemamenu-subi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul > li.current-menu-item > a .menu-sub i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'header',
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Decoration icon', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li a .decoration-icon i:color',
							'id' => 'css_megamenu-menuliadecoration-iconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li a .decoration-icon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li|hover > a > .decoration-icon i:color',
							'id' => 'css_megamenu-menuliadecoration-iconi_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li:hover > a > .decoration-icon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li.current-menu-item > a .decoration-icon i:color',
							'id' => 'css_megamenu-menulicurrent-menu-itemadecoration-iconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li.current-menu-item > a .decoration-icon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li a .decoration-icon i:font-size',
							'id' => 'css_megamenu-menuliadecoration-iconi_font_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li a .decoration-icon i',
							'style' => 'font-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),



						array(
							'type' => 'html',
							'html' => '</div>',
						),

					),
   			),

   			// Logo ----------------------------------------------------

   			'header_logo' => array(
   				'type' => 'header_logo',
   				'title' => __('Logo', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'header',
   				'attr' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
   						'id' => 'image',
   						'type' => 'upload',
   						'dynamic_data' => 'featured_image',
   						'title' => __('Logo', 'mfn-opts'),
   						'desc' => __('Recommended svg', 'mfn-opts'),
							'std' => mfn_opts_get('logo-img') ? mfn_opts_get('logo-img') : $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
							'id' => 'link',
							'type' => 'text',
							'title' => __('Link', 'mfn-opts'),
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .logo-wrapper:align-items',
							'id' => 'css_logo_align',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .logo-wrapper',
   						'style' => 'align-items',
							'type' => 'switch',
							'responsive' => true,
							'class' => 'mfn-toggled',
							'title' => __('Vertical align', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Top',
								'center' => 'Center',
								'flex-end' => 'Bottom',
							),
							'std' => 'center',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

			// Menu ----------------------------------------------------

   			'header_menu' => array(
   				'type' => 'header_menu',
   				'title' => __('Menu', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'header',
   				'attr' => array(
   				//'fields' => array(

						/*array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),*/

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'type' => 'header',
							'title' => __('Menu', 'mfn-opts'),
						),

						array(
   						'id' => 'menu_display',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Menu to display', 'mfn-opts'),
							//'options' => mfna_menu(),
							'js_options' => 'menus',
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu:justify-content',
							'id' => 'css_header_menu_justify',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu',
							'style' => 'justify-content',
							'attr_id' => 'menu-items-alignment',
							'type' => 'select',
							'responsive' => true,

							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Left',
								'center' => 'Center',
								'flex-end' => 'Right',
								'space-between' => 'Space between',
								'space-around' => 'Space around',
								'space-evenly' => 'Space evenly',
							),
							'std' => 'flex-end',
						),
						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:flex-grow',
							'id' => 'css_menu-li_flex_grow',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li',
							'style' => 'flex-grow',
							'condition' => array( 'id' => 'menu-items-alignment', 'opt' => 'is', 'val' => array('space-between', 'space-around', 'space-evenly') ),
							'type' => 'select',
							'responsive' => true,

							'title' => __('Fit container', 'mfn-opts'),
							'options' => [
								'unset' => __('Default', 'mfn-opts'),
								'1' => __('Fit', 'mfn-opts'),
							],
						),

   					array(
   						'id' => 'animation',
   						'attr_id' => 'header_menu_animation',
   						'type' => 'select',
   						'title' => __('Item Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'text-line-bottom' => __('Text line bottom', 'mfn-opts'),
								'text-toggle-line-bottom' => __('Text toggle line bottom', 'mfn-opts'),
								'toggle-line-bottom' => __('Toggle line bottom', 'mfn-opts'),
								'toggle-line-top' => __('Toggle line top', 'mfn-opts'),
								'text-bg-line' => __('Text bg line', 'mfn-opts'),
								'bg-left' => __('Bg left', 'mfn-opts'),
							),
   					),

   					array(
   						'id' => 'separator',
   						'attr_id' => 'menu_separator',
   						'type' => 'switch',
   						'title' => __('Separator', 'mfn-opts'),
							'options' => array(
								'off' => 'Off',
								'on' => 'On'
							),
							'std' => 'off'
   					),

   					array(
   						'id' => 'submenu_display',
   						'type' => 'switch',
   						'title' => __('Display submenu on', 'mfn-opts'),
							'options' => array(
								'hover' => 'Hover',
								'click' => 'Click'
							),
							'std' => 'hover'
   					),

   					array(
   						'id' => 'submenu_icon_display',
   						'attr_id' => 'submenu_icon_display',
   						'type' => 'switch',
   						'title' => __('Submenu Icon', 'mfn-opts'),
							'options' => array(
								'off' => 'Off',
								'on' => 'On'
							),
							'std' => 'on'
   					),

   					array(
							'id' => 'submenu_icon',
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'icon',
							'title' => __('Submenu icon', 'mfn-opts'),
							'preview' => 'icon',
							'std' => 'fas fa-arrow-down'
						),

   					array(
   						'type' => 'header',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
   						'id' => 'icon_align',
   						'type' => 'switch',
   						'title' => __('Icon align', 'mfn-opts'),
							'options' => array(
								'left' => 'Left',
								'top' => 'Top',
								'right' => 'Right'
							),
							'std' => 'left'
   					),

						array(
   						'id' => 'icon_animation',
   						'type' => 'select',
   						'title' => __('Icon animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'rotate' => 'Rotate',
								'zoom' => 'Zoom'
							),
   					),

						array(
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'title' => __('Submenu', 'mfn-opts'),
						),

   					array(
							'id' => 'submenu_subicon',
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'icon',
							'title' => __('Submenu icon', 'mfn-opts'),
							'preview' => 'icon',
							'std' => 'fas fa-arrow-right'
						),

						array(
   						'id' => 'submenu_icon_animation',
   						'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
   						'type' => 'select',
   						'title' => __('Icon Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'rotate' => 'Rotate',
								'zoom' => 'Zoom'
							),
   					),

   					array(
   						'id' => 'submenu_animation',
   						'type' => 'select',
   						'title' => __('Submenu Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'fade-in' => 'Fade In',
								'fade-up' => 'Fade In Up'
							),
   					),

   					array(
							'id' => 'submenu_fold_to_right',
							'type' => 'switch',
							'title' => __('Submenu fold last two items to left', 'mfn-opts'),
							'options' => array(
								0 => __('Disable', 'mfn-opts'),
								1 => __('Enable', 'mfn-opts'),
							),
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Menu', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-gap',
							'id' => 'css_menu-li_header_menu_gap',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li',
							'style' => '--mfn-header-menu-gap',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:padding',
							'id' => 'css_menu-link_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:typography',
							'id' => 'css_menu-link_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:border-style',
							'id' => 'css_menu-link_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link',
							'style' => 'border-style',
							'attr_id' => 'border_style_header_menu_link',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:border-width',
							'id' => 'css_menu-link_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:border-radius',
							'id' => 'css_menu-link_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:color',
							'id' => 'css_menu-link_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:background-color',
							'id' => 'css_menu-link_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:border-color',
							'id' => 'css_menu-link_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:box-shadow',
							'id' => 'css_menu-link_box_shadow',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link',
							'style' => 'box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li|hover > a.mfn-menu-link:color',
							'id' => 'css_menu-link_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:hover > a.mfn-menu-link',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li|hover > a.mfn-menu-link:background-color',
							'id' => 'css_menu-lihovera-menu-link_background_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:hover > a.mfn-menu-link',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li|hover > a.mfn-menu-link:border-color',
							'id' => 'css_menu-lihovera-menu-link_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:hover > a.mfn-menu-link',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li|hover > a.mfn-menu-link:box-shadow',
							'id' => 'css_menu-lihovera-menu-link_box_shadow_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:hover > a.mfn-menu-link',
							'style' => 'box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item > a.mfn-menu-link:color',
							'old_id2' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link:color',
							'id' => 'css_menulicurrent-menu-itema-menu-link_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li.current-menu-item > a.mfn-menu-link, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li.current-menu-ancestor > a.mfn-menu-link, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li.current-product_cat-ancestor > a.mfn-menu-link',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item > a.mfn-menu-link:background-color',
							'old_id2' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link:background-color',
							'id' => 'css_menulicurrent-menu-itema-menu-link_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li.current-menu-item > a.mfn-menu-link, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li.current-menu-ancestor > a.mfn-menu-link, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li.current-product_cat-ancestor > a.mfn-menu-link',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item > a.mfn-menu-link:border-color',
							'id' => 'css_menulicurrent-menu-itema-menu-link_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li.current-menu-item > a.mfn-menu-link, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li.current-menu-ancestor > a.mfn-menu-link, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li.current-product_cat-ancestor > a.mfn-menu-link',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item > a.mfn-menu-link:box-shadow',
							'id' => 'css_menulicurrent-menu-itema-menu-link_box_shadow',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li.current-menu-item > a.mfn-menu-link, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li.current-menu-ancestor > a.mfn-menu-link, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li.current-product_cat-ancestor > a.mfn-menu-link',
							'style' => 'box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-icon-gap',
							'id' => 'css_menu-li_header_menu_icon_gap',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li',
							'style' => '--mfn-header-menu-icon-gap',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-icon-size',
							'id' => 'css_menu-li_header_menu_icon_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li',
							'style' => '--mfn-header-menu-icon-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu .mfn-menu-item-icon > i:color',
							'id' => 'css_menu-menu-item-iconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu .mfn-menu-item-icon > i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu a.mfn-menu-link|hover > .mfn-menu-item-icon > i:color',
							'id' => 'css_menua-menu-linkhover-menu-item-iconi_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu a.mfn-menu-link:hover > .mfn-menu-item-icon > i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link > .mfn-menu-item-icon i:color',
							'id' => 'css_menulicurrent-menu-link-menu-item-iconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link > .mfn-menu-item-icon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Submenu icon', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-submenu-icon-gap',
							'id' => 'css_menu-li_header_menu_submenu_icon_gap',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li',
							'style' => '--mfn-header-menu-submenu-icon-gap',
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li .mfn-menu-subicon i:--mfn-header-submenu-icon-size',
							'id' => 'css_menu-li-menu-subiconi_header_submenu_icon_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li .mfn-menu-subicon i',
							'style' => '--mfn-header-submenu-icon-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),
						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link .mfn-menu-subicon i:color',
							'id' => 'css_menu-link-menu-subiconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link .mfn-menu-subicon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link|hover .mfn-menu-subicon i:color',
							'id' => 'css_menu-linkhover-menu-subiconi_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:hover .mfn-menu-subicon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link .mfn-menu-subicon i:color',
							'id' => 'css_menulicurrent-menu-link-menu-subiconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link .mfn-menu-subicon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),



						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Submenu', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li > ul.mfn-submenu:width',
							'id' => 'css_menu-liul-submenu_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li > ul.mfn-submenu',
							'style' => 'width',
							'type' => 'text',
							'class' => 'mfn-toggled',
							'responsive' => true,
							'default_unit' => 'px',
							'title' => __('Width', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li > ul.mfn-submenu:background-color',
							'id' => 'css_menu-liul-submenu_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li > ul.mfn-submenu',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li > ul.mfn-submenu:border-style',
							'id' => 'css_menu-liul-submenu_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li > ul.mfn-submenu',
							'style' => 'border-style',
							'attr_id' => 'border_style_header_submenu',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu:border-width',
							'id' => 'css_menu-liul-submenu_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu:border-color',
							'id' => 'css_menu-liul-submenu_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu:box-shadow',
							'id' => 'css_menu-liul-submenu_box_shadow',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu',
							'style' => 'box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu:--mfn-header-submenu-border-radius',
							'id' => 'css_menu-liul-submenu_header_submenu_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu',
							'style' => '--mfn-header-submenu-border-radius',
							'type' => 'dimensions',
							'title' => __('Border radius', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'version' => 'separated-fields',
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:padding',
							'id' => 'css_menu-liul-submenu_menu-link_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),




		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:border-style',
							'id' => 'css_menu-liul-submenu_menu-link_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link',
							'style' => 'border-style',
							'attr_id' => 'border_style_header_submenu_links',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:border-width',
							'id' => 'css_menu-liul-submenu_menu-link_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_header_submenu_links', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:border-color',
							'id' => 'css_menu-liul-submenu_menu-link_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_submenu_links', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),







		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:typography',
							'id' => 'css_menu-liul-submenu_menu-link_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:color',
							'id' => 'css_submenu_item_color',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link',
   						'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:background-color',
							'id' => 'css_submenu_item_bg',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link',
   						'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link|hover:color',
							'id' => 'css_submenu_item_color_hover',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:hover',
   						'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:hover:background-color',
							'id' => 'css_submenu_item_bg_hover',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:hover',
   						'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.current-menu-item.mfn-menu-li > a.mfn-menu-link:color',
							'id' => 'css_submenu_item_color_active',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.current-menu-item.mfn-menu-li > a.mfn-menu-link',
   						'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.current-menu-item.mfn-menu-li > a.mfn-menu-link:background-color',
							'id' => 'css_submenu_item_bg_active',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.current-menu-item.mfn-menu-li > a.mfn-menu-link',
   						'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li:--mfn-header-submenu-subicon-gap',
							'id' => 'css_menu-liul-submenu_menu-li_header_submenu_subicon_gap',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li',
							'style' => '--mfn-header-submenu-subicon-gap',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li:--mfn-header-submenu-subicon-size',
							'id' => 'css_menu-liul-submenu_menu-li_header_submenu_subicon_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li',
							'style' => '--mfn-header-submenu-subicon-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li .mfn-menu-item-icon > i:color',
							'id' => 'css_menu-liul-submenu_menu-li-menu-item-iconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li .mfn-menu-item-icon > i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:border-color',
							'id' => 'css_menu-liul-submenu_menu-link_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li|hover > a.mfn-menu-link > .mfn-menu-item-icon > i:color',
							'id' => 'css_menu-liul-submenu_menu-lihovera-menu-link-menu-item-iconi_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li:hover > a.mfn-menu-link > .mfn-menu-item-icon > i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li|hover > a.mfn-menu-link:border-color',
							'id' => 'css_menu-liul-submenu_menu-lihovera-menu-link_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li:hover > a.mfn-menu-link',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link > .mfn-menu-item-icon i:color',
							'id' => 'css_menu-liul-submenulicurrent-menu-link-menu-item-iconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link > .mfn-menu-item-icon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link:border-color',
							'id' => 'css_menu-liul-submenulicurrent-menu-link_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Submenu icon', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li .mfn-menu-sub-subicon i:--mfn-header-submenu-submenu-icon-size',
							'id' => 'css_menu-liul-submenu_menu-li-menu-sub-subiconi_header_submenu_submenu_icon_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li .mfn-menu-sub-subicon i',
							'style' => '--mfn-header-submenu-submenu-icon-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu > li.mfn-menu-li > a.mfn-menu-link .mfn-menu-sub-subicon i:color',
							'id' => 'css_menu-liul-submenu_menu-link-menu-sub-subiconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu > li.mfn-menu-li > a.mfn-menu-link .mfn-menu-sub-subicon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu > li.mfn-menu-li > a.mfn-menu-link|hover .mfn-menu-sub-subicon i:color',
							'id' => 'css_menu-liul-submenu_menu-linkhover-menu-sub-subiconi_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu > li.mfn-menu-li > a.mfn-menu-link:hover .mfn-menu-sub-subicon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link .mfn-menu-sub-subicon i:color',
							'id' => 'css_menu-liul-submenulicurrent-menu-link-menu-sub-subiconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link .mfn-menu-sub-subicon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'condition' => array( 'id' => 'menu_separator', 'opt' => 'is', 'val' => 'on' ),
							'title' => __('Separator', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-sep',
							'id' => 'css_menu-li_header_menu_sep',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li',
							'style' => '--mfn-header-menu-sep',
							'condition' => array( 'id' => 'menu_separator', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'condition' => array( 'id' => 'header_menu_animation', 'opt' => 'isnt', 'val' => '' ),
							'title' => __('Animation', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-animation-color',
							'id' => 'css_menu-li_header_menu_animation_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li',
							'style' => '--mfn-header-menu-animation-color',
							'condition' => array( 'id' => 'header_menu_animation', 'opt' => 'isnt', 'val' => '' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-animation-height',
							'id' => 'css_menu-li_header_menu_animation_height',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li',
							'style' => '--mfn-header-menu-animation-height',
							'type' => 'sliderbar',
							'condition' => array( 'id' => 'header_menu_animation', 'opt' => 'is', 'val' => array('text-line-bottom', 'text-toggle-line-bottom', 'toggle-line-bottom', 'toggle-line-top') ),
							'title' => __('Height', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '1',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Dropdown pointer', 'mfn-opts'),
						),

						array(
   						'id' => 'dropdown_pointer',
   						'attr_id' => 'dropdown_pointer',
   						'type' => 'switch',
   						'class' => 'mfn-toggled',
   						'title' => __('Visibility', 'mfn-opts'),
							'options' => array(
								'' => 'Hide',
								'1' => 'Show',
							),
							'std' => ''
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-submenu-dropdown-size',
							'id' => 'css_menu-li_header_submenu_dropdown_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li',
							'style' => '--mfn-header-submenu-dropdown-size',
							'type' => 'sliderbar',
							'condition' => array( 'id' => 'dropdown_pointer', 'opt' => 'is', 'val' => '1' ),
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '1',
								'max' => '40',
								'step' => '1',
								'unit' => 'px',
							)
						),

   					array(
   						'id' => 'dropdown_alignment',
   						'condition' => array( 'id' => 'dropdown_pointer', 'opt' => 'is', 'val' => '1' ),
   						'type' => 'switch',
   						'class' => 'mfn-toggled',
   						'title' => __('Icon align', 'mfn-opts'),
							'options' => array(
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'std' => 'left'
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-submenu-dropdown-offset',
							'id' => 'css_menu-li_header_submenu_dropdown_offset',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li',
							'style' => '--mfn-header-submenu-dropdown-offset',
							'type' => 'sliderbar',
							'condition' => array( 'id' => 'dropdown_pointer', 'opt' => 'is', 'val' => '1' ),
							'title' => __('Offset', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '1',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-submenu-dropdown-color',
							'id' => 'css_menu-li_header_submenu_dropdown_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li',
							'style' => '--mfn-header-submenu-dropdown-color',
							'condition' => array( 'id' => 'dropdown_pointer', 'opt' => 'is', 'val' => '1' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),


				// Header menu burger ----------------------------------------------------

   			'header_burger' => array(
   				'type' => 'header_burger',
   				'title' => __('Menu burger', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'header',
   				'attr' => array(
   				//'fields' => array(

						/*array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),*/

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						// icon

						array(
							'type' => 'header',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'icon',
							'attr_id' => 'header_icon_font',
							'type' => 'icon',
							'title' => __('Icon', 'mfn-opts'),
							'preview' => 'icon',
						),

						array(
							'id' => 'image',
							'type' => 'upload',
							'title' => __('Image', 'mfn-opts'),
							'desc' => __('Image instead of an icon', 'mfn-opts'),
							'preview' => 'image',
						),

						array(
							'id' => 'desc',
							'type' => 'text',
							'edit_tag' => '.mfn-header-menu-burger | div.desc-wrapper',
   						'edit_position' => 'append',
							'title' => __('Desc', 'mfn-opts'),
						),

						array(
							'id' => 'link_title',
							'type' => 'text',
							'title' => __('Link title', 'mfn-opts'),
						),

						// sidebar

						array(
							'type' => 'header',
							'title' => __('Nav', 'mfn-opts'),
						),

						array(
   						'id' => 'sidebar_type',
   						'attr_id' => 'sidebar_type',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Nav type', 'mfn-opts'),
							'js_options' => 'sidemenus',
							'opt_append' => array(
								'classic' => __('Classic menu', 'mfn-opts'),
							),
							'std' => '0'
   					),

   					array(
							'type' => 'subheader',
							'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => array('0', 'classic') ),
							'class' => 'mfn-builder-subheader',
							'title' => __('Menu', 'mfn-opts'),
						),

						array(
   						'id' => 'menu_display',
   						'type' => 'select',
   						'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => array('0', 'classic') ),
   						're_render' => true,
   						'title' => __('Menu to display', 'mfn-opts'),
							'js_options' => 'menus',
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-tmpl-menu-sidebar-wrapper:align-items',
							'id' => 'css_menu-sidebar-wrapper_align_items',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-tmpl-menu-sidebar-wrapper',
							'style' => 'align-items',
							'type' => 'select',
							'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => '0' ),
							'title' => __('Vertical align', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Top',
								'center' => 'Center',
								'flex-end' => 'Bottom',
							),
							'std' => 'center'
						),

   					array(
   						'id' => 'menu_pos',
   						'type' => 'select',
   						'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => '0' ),
   						're_render' => true,
   						'title' => __('Sidebar position', 'mfn-opts'),
							'options' => array(
								'left' => __('Left', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							),
							'std' => 'right'
   					),

   					array(
   						'id' => 'animation',
   						'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => array('0', 'classic') ),
   						'attr_id' => 'header_menu_animation',
   						'type' => 'select',
   						'title' => __('Item Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'text-line-bottom' => __('Text line bottom', 'mfn-opts'),
								'text-toggle-line-bottom' => __('Text toggle line bottom', 'mfn-opts'),
								'toggle-line-bottom' => __('Toggle line bottom', 'mfn-opts'),
								'toggle-line-top' => __('Toggle line top', 'mfn-opts'),
								'text-bg-line' => __('Text bg line', 'mfn-opts'),
								'bg-left' => __('Bg left', 'mfn-opts'),
							),
   					),

   					array(
   						'id' => 'submenu_icon_display',
   						'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => array('0', 'classic') ),
   						'attr_id' => 'submenu_icon_display',
   						'type' => 'switch',
   						'title' => __('Submenu Icon', 'mfn-opts'),
							'options' => array(
								'off' => 'Off',
								'on' => 'On'
							),
							'std' => 'on'
   					),

   					array(
   						'id' => 'submenu_animation',
   						//'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
   						'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => array('0', 'classic') ),
   						'type' => 'select',
   						'title' => __('Submenu Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'fade-in' => 'Fade In',
								'fade-up' => 'Fade In Up'
							),
   					),

   					array(
							'id' => 'submenu_icon',
							//'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => array('0', 'classic') ),
							'type' => 'icon',
							'title' => __('Submenu icon', 'mfn-opts'),
							'preview' => 'icon',
							'std' => 'fas fa-arrow-down'
						),

						array(
   						'id' => 'menu_icon_align',
   						'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => array('0', 'classic') ),
   						'attr_id' => 'menu_icon_align',
   						'type' => 'switch',
   						'title' => __('Icon align', 'mfn-opts'),
							'options' => array(
								'left' => 'Left',
								'top' => 'Top',
								'right' => 'Right'
							),
							'std' => 'left'
   					),

						array(
   						'id' => 'icon_animation',
   						'type' => 'select',
   						'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => array('0', 'classic') ),
   						'title' => __('Icon animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'rotate' => 'Rotate',
								'zoom' => 'Zoom'
							),
   					),

						array(
   						'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => array('0', 'classic') ),
   						//'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader',
							'title' => __('Submenu', 'mfn-opts'),
						),

   					array(
							'id' => 'submenu_subicon',
							'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => array('0', 'classic') ),
							//'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'icon',
							'title' => __('Submenu icon', 'mfn-opts'),
							'preview' => 'icon',
							'std' => 'fas fa-arrow-right'
						),

						array(
   						'id' => 'submenu_icon_animation',
   						'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => array('0', 'classic') ),
   						//'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
   						'type' => 'select',
   						'title' => __('Icon Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'rotate' => 'Rotate',
								'zoom' => 'Zoom'
							),
   					),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Burger wrapper', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu-burger:padding',
							'id' => 'css_menu-burger_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu-burger',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu-burger:border-style',
							'id' => 'css_menu-burger_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu-burger',
							'style' => 'border-style',
							'attr_id' => 'border_header_burger_wrapper',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu-burger:border-width',
							'id' => 'css_menu-burger_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu-burger',
							'style' => 'border-width',
							'condition' => array( 'id' => 'border_header_burger_wrapper', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'dimensions',
							'title' => __('Border width', 'mfn-opts'),
							'class' => 'mfn-toggled',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu-burger:border-radius',
							'id' => 'css_menu-burger_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu-burger',
							'style' => 'border-radius',
							'type' => 'dimensions',
							'title' => __('Border radius', 'mfn-opts'),
							'class' => 'mfn-toggled',
						),






						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu-burger:background-color',
							'id' => 'css_menu-burger_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu-burger',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu-burger:border-color',
							'id' => 'css_menu-burger_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu-burger',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_header_burger_wrapper', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'css_menu-burger_background_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu-burger:hover',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'css_menu-burger_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu-burger:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_header_burger_wrapper', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),






						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'icon_position',
							'type' => 'switch',
							'title' => __('Icon position', 'mfn-opts'),
							'options' => array(
								'top' => __('Top', 'mfn-opts'),
								'bottom' => __('Bottom', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							),
							'std' => 'top',
							'responsive' => true,
							'class' => 'mfn-toggled',
						),

						array(
							'id' => 'icon_align',
							'type' => 'switch',
							'condition' => array( 'id' => 'header-icon-desc', 'opt' => 'isnt', 'val' => '' ),
							'title' => __('Icon alignment', 'mfn-opts'),
							'options' => array(
								'start' => __('Start', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'end' => __('End', 'mfn-opts'),
							),
							'std' => 'center',
							'responsive' => true,
							'class' => 'mfn-toggled',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:--mfn-header-menu-icon-size',
							'id' => 'css_icon-boxicon_icon_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper',
							'style' => '--mfn-header-menu-icon-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:width',
							'id' => 'css_icon-boxicon-wrapper_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper',
							'style' => 'width',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:height',
							'id' => 'css_icon-boxicon-wrapper_height',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper',
							'style' => 'height',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Height', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),
						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:margin',
							'id' => 'css_icon-boxicon-wrapper_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:padding',
							'id' => 'css_icon-boxicon-wrapper_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:background-color',
							'id' => 'css_icon-wrapper_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:border-style',
							'id' => 'css_icon-wrapper_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper',
							'style' => 'border-style',
							'attr_id' => 'border_style_header_icon',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:border-color',
							'id' => 'css_icon-wrapper_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:border-width',
							'id' => 'css_icon-wrapper_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper',
							'style' => 'border-width',
							'condition' => array( 'id' => 'border_style_header_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'dimensions',
							'title' => __('Border width', 'mfn-opts'),
							'class' => 'mfn-toggled',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:border-radius',
							'id' => 'css_icon-boxicon-wrapper_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper',
							'style' => 'border-radius',
							'type' => 'dimensions',
							'title' => __('Border radius', 'mfn-opts'),
							'class' => 'mfn-toggled',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper i:color',
							'id' => 'css_icon-wrapperi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Icon color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .icon-wrapper:background-color',
							'id' => 'css_icon-boxicon-wrapper_background_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box:hover .icon-wrapper',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .icon-wrapper:border-color',
							'id' => 'css_icon-boxicon-wrapper_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box:hover .icon-wrapper',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .icon-wrapper i:color',
							'id' => 'css_icon-boxicon-wrapperi_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box:hover .icon-wrapper i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Icon color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Desc', 'mfn-opts'),
						),

						array(
		  				'id' => 'header_icon_desc_visibility',
		  				'iconinfo' => 'https://support.muffingroup.com/video-tutorials/section-responsive-visibility/',
		  				'type' => 'switch',
		  				'invert' => true,
		  				'version' => 'multiple',
		  				'class' => 'mfn-toggled',
		  				'title' => __('Responsive visibility', 'mfn-opts'),
		  				'options' => array(
		  					'hide-desktop' => __('Hide on Desktop', 'mfn-opts'),
		  					'hide-laptop' => __('Hide on Laptop', 'mfn-opts'),
		  					'hide-tablet' => __('Hide on Tablet', 'mfn-opts'),
		  					'hide-mobile' => __('Hide on Mobile', 'mfn-opts'),
		  				),
		  				'active_tooltip' => array(
		  					'hide-desktop' => __('Show on Desktop', 'mfn-opts'),
		  					'hide-laptop' => __('Show on Laptop', 'mfn-opts'),
		  					'hide-tablet' => __('Show on Tablet', 'mfn-opts'),
		  					'hide-mobile' => __('Show on Mobile', 'mfn-opts'),
		  				),
		  				'visual_options' => array(
		  					'hide-desktop' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M4.94,5H17.06a.93.93,0,0,1,.94.91v7.18a.93.93,0,0,1-.94.91H4.94A.93.93,0,0,1,4,13.09V5.91A.93.93,0,0,1,4.94,5Z"/><path class="cls-1" d="M7,17h8"/><path class="cls-2" d="M13,15.51a1.58,1.58,0,0,0,.7,1.26L14,17H8l.3-.23A1.58,1.58,0,0,0,9,15.51V14h4Z"/></svg>',			// 960 +
		  					'hide-laptop' => '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"viewBox="0 0 22 22" style="enable-background:new 0 0 22 22;" xml:space="preserve"> <style type="text/css"> .st0{fill:none;stroke:currentColor;stroke-width:1.5;stroke-linecap:round;stroke-linejoin:round;} </style> <path class="st0" d="M5,15V6.9C5,6.4,5.4,5.9,5.9,6h10.1c0.5,0,0.9,0.4,0.9,0.9V15"/> <path class="st0" d="M4,17h14"/> </svg>',		// 768 - 959
		  					'hide-tablet' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}</style></defs><path class="cls-1" d="M7,15.83V7.17A1.21,1.21,0,0,1,8.25,6h5.5A1.21,1.21,0,0,1,15,7.17v8.66A1.21,1.21,0,0,1,13.75,17H8.25A1.21,1.21,0,0,1,7,15.83Z"/></svg>',		// 768 - 959
		  					'hide-mobile' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M8,15.82V8.18A1.08,1.08,0,0,1,8.94,7h4.12A1.08,1.08,0,0,1,14,8.18v7.64A1.08,1.08,0,0,1,13.06,17H8.94A1.08,1.08,0,0,1,8,15.82Z"/><circle class="cls-2" cx="11" cy="14" r="1"/></svg>',			// - 768
		  				),
		  			),

		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc-wrapper:typography',
							'id' => 'css_desc-wrapper_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc-wrapper',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .desc-wrapper:color',
							'id' => 'css_icon-boxdesc-wrapper_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .desc-wrapper',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .desc-wrapper:color',
							'id' => 'css_icon-boxdesc-wrapper_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box:hover .desc-wrapper',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'header',
							'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => '0,classic' ),
							'class' => 'toggled_header',
							'title' => __('Menu wrapper', 'mfn-opts'),
						),


						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:--mfn-header-menu-sidebar-width',
							'id' => 'css_menu-sidebar_header_menu_sidebar_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar',
							'style' => '--mfn-header-menu-sidebar-width',
							'type' => 'sliderbar',
							'responsive' => true,
							'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => '0' ),
							'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '100',
								'max' => '1920',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-tmpl-menu-sidebar-wrapper:padding',
							'id' => 'css_menu-sidebar-wrapper_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-tmpl-menu-sidebar-wrapper',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'id' => 'background_switcher',
							'attr_id' => 'bg_menu-tmpl-sidebar',
							'type' => 'switch',
							'class' => 'mfn-toggled mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-color',
							'id' => 'css_menu-sidebar_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar',
							'style' => 'background-color',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:gradient',
							'id' => 'css_menu-sidebar_gradient',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
		  			),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-image',
							'id' => 'css_menu-sidebar_background_image',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar',
							'style' => 'background-image',
		  				'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
		  				'type' => 'upload',
		  				'title' => __('Image', 'mfn-opts'),
		  				'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-repeat',
							'id' => 'css_menu-sidebar_background_repeat',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar',
							'style' => 'background-repeat',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'select',
							'responsive' => true,
							'class' => 'mfn-toggled',
							'title' => __('Repeat', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'repeat' => __('Repeat', 'mfn-opts'),
								'no-repeat' => __('No repeat', 'mfn-opts'),
								'repeat-x' => __('Repeat X', 'mfn-opts'),
								'repeat-y' => __('Repeat Y', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-position',
							'id' => 'css_menu-sidebar_background_position',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar',
							'style' => 'background-position',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'select',
							'responsive' => true,
							'class' => 'mfn-toggled',
							'title' => __('Position', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'center' => __('Center Center', 'mfn-opts'),
								'center left' => __('Center Left', 'mfn-opts'),
								'center right' => __('Center Right', 'mfn-opts'),
								'top left' => __('Top Left', 'mfn-opts'),
								'top right' => __('Top Right', 'mfn-opts'),
								'top center' => __('Top Center', 'mfn-opts'),
								'bottom left' => __('Bottom Left', 'mfn-opts'),
								'bottom right' => __('Bottom Right', 'mfn-opts'),
								'bottom center' => __('Bottom Center', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-attachment',
							'id' => 'css_menu-sidebar_background_attachment',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar',
							'style' => 'background-attachment',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'select',
							'responsive' => true,
							'class' => 'mfn-toggled',
							'title' => __('Attachment', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'scroll' => __('Scroll', 'mfn-opts'),
								'fixed' => __('Fixed', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-size',
							'id' => 'css_menu-sidebar_background_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar',
							'style' => 'background-size',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'select',
							'responsive' => true,
							'class' => 'mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'options' => mfna_bg_size()
						),
						array(
							'type' => 'subheader',
							'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => '0' ),
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Close', 'mfn-opts'),
						),

						array(
							'id' => 'sidebar-menu-close-icon-position',
							'type' => 'switch',
							'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => '0' ),
							'class' => 'mfn-toggled',
							'title' => __('Position', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),










						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-close-icon:font-size',
							'id' => 'css_menu-sidebar-close-icon_font_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-close-icon',
							'style' => 'font-size',
							'type' => 'sliderbar',
							'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => '0' ),
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '40',
								'step' => '1',
								'unit' => 'px',
							),
							'std' => '20px'
						),












						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu-toggle .icon:color',
							'id' => 'css_menu_-toggleicon_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu-toggle .icon',
							'style' => 'color',
							'type' => 'color',
							'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => '0' ),
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Content overlay', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement.mfn-header-tmpl-menu-active|before:display',
							'id' => 'css_menu-activebefore_display',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement.mfn-header-tmpl-menu-active:before',
							'style' => 'display',
							'type' => 'switch',
							'title' => __('Visibility', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'options' => [
								'' => __('Hidden', 'mfn-opts'),
								'block' => __('Visible', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement.mfn-header-tmpl-menu-active|before:background-color',
							'id' => 'css_menu-activebefore_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement.mfn-header-tmpl-menu-active:before',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => array('0', 'classic') ),
							'class' => 'toggled_header',
							'title' => __('Menu', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
						),

						array(
							'id' => 'items_align',
							'condition' => array( 'id' => 'menu_icon_align', 'opt' => 'isnt', 'val' => 'top' ),
							'type' => 'switch',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							),
							'std' => 'top',
							'responsive' => true,
							'class' => 'mfn-toggled',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-gap',
							'id' => 'css_menu_li_header_menu_gap',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li',
							'style' => '--mfn-header-menu-gap',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),
						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:padding',
							'id' => 'css_menu_lia_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:typography',
							'id' => 'css_menu_lia_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:border-style',
							'id' => 'css_menu_lia_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a',
							'style' => 'border-style',
							'attr_id' => 'border_style_header_menu_link',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:border-width',
							'id' => 'css_menu_lia_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:border-radius',
							'id' => 'css_menu_lia_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:color',
							'id' => 'css_menu_lia_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:background-color',
							'id' => 'css_menu_lia_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:border-color',
							'id' => 'css_menu_lia_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:box-shadow',
							'id' => 'css_menu_lia_box_shadow',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a',
							'style' => 'box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li|hover > a:color',
							'id' => 'css_menu_lia_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:hover > a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li|hover > a:background-color',
							'id' => 'css_menu_lihovera_background_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:hover > a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li|hover > a:border-color',
							'id' => 'css_menu_lihovera_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:hover > a',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li|hover > a:box-shadow',
							'id' => 'css_menu_lihovera_box_shadow_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:hover > a',
							'style' => 'box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a:color',
							'id' => 'css_menu_licurrent-menu-itema_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a:background-color',
							'id' => 'css_menu_licurrent-menu-itema_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a:border-color',
							'id' => 'css_menu_licurrent-menu-itema_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a:box-shadow',
							'id' => 'css_menu_licurrent-menu-itema_box_shadow',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a',
							'style' => 'box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Animation', 'mfn-opts'),
							'condition' => array( 'id' => 'header_menu_animation', 'opt' => 'isnt', 'val' => '' ),
						),


						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-li > .mfn-menu-link:--mfn-header-menu-animation-color',
							'id' => 'css_menu-li-menu-link_header_menu_animation_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-li > .mfn-menu-link',
							'style' => '--mfn-header-menu-animation-color',
							'condition' => array( 'id' => 'header_menu_animation', 'opt' => 'isnt', 'val' => '' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-icon-gap',
							'id' => 'css_menu_li_header_menu_icon_gap',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li',
							'style' => '--mfn-header-menu-icon-gap',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-icon-size',
							'id' => 'css_menu_li_header_menu_icon_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li',
							'style' => '--mfn-header-menu-icon-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu .menu-icon > i:color',
							'id' => 'css_menu-iconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu .menu-icon > i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu a|hover > .menu-icon > i:color',
							'id' => 'css_menu_ahovermenu-iconi_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu a:hover > .menu-icon > i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a > .menu-icon i:color',
							'id' => 'css_menu_licurrent-menu-itemamenu-iconi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a > .menu-icon i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Submenu icon', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-submenu-icon-gap',
							'id' => 'css_menu_li_header_menu_submenu_icon_gap',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li',
							'style' => '--mfn-header-menu-submenu-icon-gap',
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .menu-sub i:--mfn-header-submenu-icon-size',
							'id' => 'css_menu_limenu-subi_header_submenu_icon_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .menu-sub i',
							'style' => '--mfn-header-submenu-icon-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a .menu-sub i:color',
							'id' => 'css_menu_liamenu-subi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a .menu-sub i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a|hover .menu-sub i:color',
							'id' => 'css_menu_liahovermenu-subi_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:hover .menu-sub i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a .menu-sub i:color',
							'id' => 'css_menu_licurrent-menu-itemamenu-subi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a .menu-sub i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => '0,classic' ),
							'title' => __('Submenu', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li a:justify-content',
							'id' => 'css_menu_li-submenulia_justify_content',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li a',
							'style' => 'justify-content',
							'type' => 'switch',
							'responsive' => true,
							'class' => 'mfn-toggled',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'flex-start' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'flex-end' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:background-color',
							'id' => 'css_menu_li-submenu_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:padding',
							'id' => 'css_menu_li-submenu_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),




		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:margin',
							'id' => 'css_menu_li-submenu_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),





		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:typography',
							'id' => 'css_menu_li-submenu_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:border-style',
							'id' => 'css_menu_li-submenu_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu',
							'style' => 'border-style',
							'attr_id' => 'border_style_header_submenu_link',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:border-width',
							'id' => 'css_menu_li-submenu_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_header_submenu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:border-color',
							'id' => 'css_menu_li-submenu_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_submenu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:border-radius',
							'id' => 'css_menu_li-submenu_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li a:color',
							'id' => 'css_menu_li-submenulia_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li a:background-color',
							'id' => 'css_menu_li-submenulia_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li|hover > a:color',
							'id' => 'css_menu_li-submenulihovera_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li:hover > a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li|hover > a:background-color',
							'id' => 'css_menu_li-submenulihovera_background_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li:hover > a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li.current-menu-item > a:color',
							'id' => 'css_menu_li-submenulicurrent-menu-itema_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li.current-menu-item > a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li.current-menu-item > a:background-color',
							'id' => 'css_menu_li-submenulicurrent-menu-itema_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li.current-menu-item > a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						// advanced here

   				),
   			),

				// Header icon ----------------------------------------------------

   			'header_icon' => array(
   				'type' => 'header_icon',
   				'title' => __('Icon', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'header',
   				'attr' => array(
   				//'fields' => array(

						/*array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),*/

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						// icon

						array(
							'type' => 'header',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'type',
							'attr_id' => 'header_icon_type',
							're_render' => true,
							'type' => 'select',
							'title' => __('Icon type', 'mfn-opts'),
							'options' => array(
								'tel' => 'Phone',
								'mail' => 'E-mail',
								'search' => 'Search',
								'default' => 'Custom',
								'cart' => 'Shop cart',
								'account' => 'My account',
								'wishlist' => 'Wishlist',
							),
							'desc' => __('For icons: Shop cart, My account and Wishlist, woocommerce plugin is required', 'mfn-opts'),
							'std' => 'tel',
						),

						array(
							'id' => 'icon',
							'attr_id' => 'header_icon_font',
							'type' => 'icon',
							'title' => __('Icon', 'mfn-opts'),
							'preview' => 'icon',
						),

						array(
							'id' => 'image',
							'type' => 'upload',
							'dynamic_data' => 'featured_image',
							'title' => __('Image', 'mfn-opts'),
							'desc' => __('Image instead of an icon', 'mfn-opts'),
							'preview' => 'image',
						),

						// link

						array(
							'type' => 'header',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => 'tel,mail,default,cart,wishlist,search' ),
							'title' => __('Additional', 'mfn-opts'),
						),

						array(
							'id' => 'desc',
							'attr_id' => 'header-icon-desc',
							'type' => 'text',
							'edit_tag' => '.mfn-header-icon-box | div.desc-wrapper',
   						'edit_position' => 'append',
   						'dynamic_data' => 'title',
							'title' => __('Desc', 'mfn-opts'),
						),

						array(
							'id' => 'cart_total',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => 'cart' ),
							'type' => 'switch',
							're_render' => true,
							'title' => __('Cart total ', 'mfn-opts'),
							'options' => array(
								'0' => 'Hide',
								'1' => 'Show',
							),
							'std' => '1',
						),

						array(
							'id' => 'count',
							'attr_id' => 'header_icon_count',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => array('wishlist', 'cart') ),
							'type' => 'switch',
							're_render' => true,
							'title' => __('Icon count', 'mfn-opts'),
							'options' => array(
								'0' => 'Hide',
								'1' => 'Show',
							),
							'std' => '1',
						),

						array(
							'id' => 'count_if_zero',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => array('wishlist', 'cart') ),
							'type' => 'switch',
							're_render' => true,
							'title' => __('Icon count if 0', 'mfn-opts'),
							'options' => array(
								'1' => 'Hide',
								'' => 'Show',
							),
							'std' => '',
						),

						array(
							'id' => 'link',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => 'tel,mail,default' ),
							'type' => 'text',
							'title' => __('Link', 'mfn-opts'),
						),

						array(
							'id' => 'target',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => 'tel,mail,default' ),
							'type' => 'select',
							'title' => __('Target', 'mfn-opts'),
							'options' => array(
								0 => __('Default | _self', 'mfn-opts'),
								1 => __('New tab or window | _blank', 'mfn-opts'),
							),
						),

						array(
							'id' => 'link_title',
							'type' => 'text',
							'title' => __('Link title', 'mfn-opts'),
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'icon_position',
							//'condition' => array( 'id' => 'header-icon-desc', 'opt' => 'isnt', 'val' => '' ),
							'type' => 'switch',
							'title' => __('Icon position', 'mfn-opts'),
							'desc' => __('Work with desc only', 'mfn-opts'),
							'options' => array(
								'top' => __('Top', 'mfn-opts'),
								'bottom' => __('Bottom', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							),
							'std' => 'top',
							'responsive' => true,
							'class' => 'mfn-toggled',
						),
						array(
							'id' => 'icon_align',
							'type' => 'switch',
							'condition' => array( 'id' => 'header-icon-desc', 'opt' => 'isnt', 'val' => '' ),
							'title' => __('Icon alignment', 'mfn-opts'),
							'options' => array(
								'start' => __('Start', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'end' => __('End', 'mfn-opts'),
							),
							'std' => 'center',
							'responsive' => true,
							'class' => 'mfn-toggled',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:--mfn-header-menu-icon-size',
							'id' => 'css_icon-boxicon_icon_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper',
							'style' => '--mfn-header-menu-icon-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),
						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:width',
							'id' => 'css_icon-boxicon-wrapper_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper',
							'style' => 'width',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),


						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:height',
							'id' => 'css_icon-boxicon-wrapper_height',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper',
							'style' => 'height',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Height', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:margin',
							'id' => 'css_icon-boxicon-wrapper_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:padding',
							'id' => 'css_icon-boxicon-wrapper_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:background-color',
							'id' => 'css_icon-wrapper_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:border-style',
							'id' => 'css_icon-wrapper_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper',
							'style' => 'border-style',
							'attr_id' => 'border_style_header_icon',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:border-color',
							'id' => 'css_icon-wrapper_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:border-width',
							'id' => 'css_icon-wrapper_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper',
							'style' => 'border-width',
							'condition' => array( 'id' => 'border_style_header_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'dimensions',
							'title' => __('Border width', 'mfn-opts'),
							'class' => 'mfn-toggled',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:border-radius',
							'id' => 'css_icon-boxicon-wrapper_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper',
							'style' => 'border-radius',
							'type' => 'dimensions',
							'title' => __('Border radius', 'mfn-opts'),
							'class' => 'mfn-toggled',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:--mfn-header-icon-color',
							'id' => 'css_icon-wrapper_header_icon_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper',
							'style' => '--mfn-header-icon-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Icon color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .icon-wrapper:background-color',
							'id' => 'css_icon-boxicon-wrapper_background_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box:hover .icon-wrapper',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .icon-wrapper:border-color',
							'id' => 'css_icon-boxicon-wrapper_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box:hover .icon-wrapper',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .icon-wrapper:--mfn-header-icon-color',
							'id' => 'css_icon-boxicon-wrapper_header_icon_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box:hover .icon-wrapper',
							'style' => '--mfn-header-icon-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Icon color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
							'condition' => array( 'id' => 'header_icon_count', 'opt' => 'is', 'val' => '1' ),
							'title' => __('Icon count', 'mfn-opts'),
						),

						array(
							'id' => 'icon_count_posv',
							'attr_id' => 'icon_count_posv',
							'condition' => array( 'id' => 'header_icon_count', 'opt' => 'is', 'val' => '1' ),
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Vertical offset', 'mfn-opts'),
							'options' => array(
								'0' => __('Top', 'mfn-opts'),
								'1' => __('Bottom', 'mfn-opts'),
							),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:top',
							'id' => 'css_icon_count_top',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count',
   						'style' => 'top',
							'condition' => array( 'id' => 'icon_count_posv', 'opt' => 'is', 'val' => '0' ),
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Top', 'mfn-opts'),
							'class' => 'mfn-toggled header-icon-vert-count',
							'param' => array(
								'min' => '-50',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							),
							'std' => '-9px'
						),
						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:bottom',
							'id' => 'css_icon_count_bottom',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count',
   						'style' => 'bottom',
							'condition' => array( 'id' => 'icon_count_posv', 'opt' => 'is', 'val' => '1' ),
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Bottom', 'mfn-opts'),
							'class' => 'mfn-toggled header-icon-vert-count',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'icon_count_posh',
							'attr_id' => 'icon_count_posh',
							'condition' => array( 'id' => 'header_icon_count', 'opt' => 'is', 'val' => '1' ),
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Horizontal offset', 'mfn-opts'),
							'options' => array(
								'0' => __('Left', 'mfn-opts'),
								'1' => __('Right', 'mfn-opts'),
							),
							'std' => '1'
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:right',
							'id' => 'css_icon_count_right',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count',
   						'style' => 'right',
							'condition' => array( 'id' => 'icon_count_posh', 'opt' => 'is', 'val' => '1' ),
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Right', 'mfn-opts'),
							'class' => 'mfn-toggled header-icon-hori-count',
							'param' => array(
								'min' => '-50',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							),
							'std' => '-11px'
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:left',
							'id' => 'css_icon_count_left',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count',
   						'style' => 'left',
							'condition' => array( 'id' => 'icon_count_posh', 'opt' => 'is', 'val' => '0' ),
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Left', 'mfn-opts'),
							'class' => 'mfn-toggled header-icon-hori-count',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:color',
							'id' => 'css_icon_count_color',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count',
   						'style' => 'color',
							'condition' => array( 'id' => 'header_icon_count', 'opt' => 'is', 'val' => '1' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:background-color',
							'id' => 'css_icon_count_bg',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count',
   						'style' => 'background-color',
							'condition' => array( 'id' => 'header_icon_count', 'opt' => 'is', 'val' => '1' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:typography',
							'id' => 'css_icon_count_typography',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count',
   						'style' => 'typography',
   						'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Desc', 'mfn-opts'),
						),

						array(
		  				'id' => 'header_icon_desc_visibility',
		  				'iconinfo' => 'https://support.muffingroup.com/video-tutorials/section-responsive-visibility/',
		  				'type' => 'switch',
		  				'invert' => true,
		  				'version' => 'multiple',
		  				'class' => 'mfn-toggled',
		  				'title' => __('Responsive visibility', 'mfn-opts'),
		  				'options' => array(
		  					'hide-desktop' => __('Hide on Desktop', 'mfn-opts'),
		  					'hide-laptop' => __('Hide on Laptop', 'mfn-opts'),
		  					'hide-tablet' => __('Hide on Tablet', 'mfn-opts'),
		  					'hide-mobile' => __('Hide on Mobile', 'mfn-opts'),
		  				),
		  				'active_tooltip' => array(
		  					'hide-desktop' => __('Show on Desktop', 'mfn-opts'),
		  					'hide-laptop' => __('Show on Laptop', 'mfn-opts'),
		  					'hide-tablet' => __('Show on Tablet', 'mfn-opts'),
		  					'hide-mobile' => __('Show on Mobile', 'mfn-opts'),
		  				),
		  				'visual_options' => array(
		  					'hide-desktop' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M4.94,5H17.06a.93.93,0,0,1,.94.91v7.18a.93.93,0,0,1-.94.91H4.94A.93.93,0,0,1,4,13.09V5.91A.93.93,0,0,1,4.94,5Z"/><path class="cls-1" d="M7,17h8"/><path class="cls-2" d="M13,15.51a1.58,1.58,0,0,0,.7,1.26L14,17H8l.3-.23A1.58,1.58,0,0,0,9,15.51V14h4Z"/></svg>',			// 960 +
		  					'hide-laptop' => '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"viewBox="0 0 22 22" style="enable-background:new 0 0 22 22;" xml:space="preserve"> <style type="text/css"> .st0{fill:none;stroke:currentColor;stroke-width:1.5;stroke-linecap:round;stroke-linejoin:round;} </style> <path class="st0" d="M5,15V6.9C5,6.4,5.4,5.9,5.9,6h10.1c0.5,0,0.9,0.4,0.9,0.9V15"/> <path class="st0" d="M4,17h14"/> </svg>',		// 768 - 959
		  					'hide-tablet' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}</style></defs><path class="cls-1" d="M7,15.83V7.17A1.21,1.21,0,0,1,8.25,6h5.5A1.21,1.21,0,0,1,15,7.17v8.66A1.21,1.21,0,0,1,13.75,17H8.25A1.21,1.21,0,0,1,7,15.83Z"/></svg>',		// 768 - 959
		  					'hide-mobile' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M8,15.82V8.18A1.08,1.08,0,0,1,8.94,7h4.12A1.08,1.08,0,0,1,14,8.18v7.64A1.08,1.08,0,0,1,13.06,17H8.94A1.08,1.08,0,0,1,8,15.82Z"/><circle class="cls-2" cx="11" cy="14" r="1"/></svg>',			// - 768
		  				),
		  			),

		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc-wrapper:typography',
							'id' => 'css_desc-wrapper_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc-wrapper',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .desc-wrapper:color',
							'id' => 'css_icon-boxdesc-wrapper_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .desc-wrapper',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .desc-wrapper:color',
							'id' => 'css_icon-boxdesc-wrapper_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box:hover .desc-wrapper',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),






















						array(
							'type' => 'header',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => 'search' ),
							'class' => 'toggled_header',
							'title' => __('Search results', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box:background-color',
							'id' => 'css_live-search-box_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box:border-style',
							'id' => 'css_live-search-box_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box',
							'style' => 'border-style',
							'attr_id' => 'border_live-search_results',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box:border-width',
							'id' => 'css_live-search-box_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box',
							'style' => 'border-width',
							'condition' => array( 'id' => 'border_live-search_results', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'dimensions',
							'title' => __('Border width', 'mfn-opts'),
							'class' => 'mfn-toggled',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box:border-color',
							'id' => 'css_live-search-box_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box',
							'style' => 'border-color',
							'type' => 'color',
							'condition' => array( 'id' => 'border_live-search_results', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Label', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-heading:color',
							'id' => 'css_live-search-box-live-search-heading_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-heading',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-heading:typography',
							'id' => 'css_live-search-box-live-search-heading_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-heading',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-heading:opacity',
							'id' => 'css_live-search-box-live-search-heading_opacity',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-heading',
							'style' => 'opacity',
							'type' => 'sliderbar',
							'class' => 'mfn-toggled',
							'title' => __('Opacity', 'mfn-opts'),
							'param' => array(
								'min' => '0',
								'max' => '1',
								'step' => '0.1',
							),
							'std' => '0.6'
						),


						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-texts:color',
							'id' => 'css_live-search-box-live-search-texts_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-texts',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box li a:color',
							'id' => 'css_live-search-boxlia_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box li a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-texts span.mfn-ls-price:color',
							'id' => 'css_live-search-box-live-search-textsspan-ls-price_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-texts span.mfn-ls-price',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Price color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-texts:typography',
							'id' => 'css_live-search-box-live-search-texts_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-texts',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-texts p:typography',
							'id' => 'css_live-search-box-live-search-textsp_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-texts p',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Desc typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-texts span.mfn-ls-price:typography',
							'id' => 'css_live-search-box-live-search-textsspan-ls-price_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-live-search-box .mfn-live-search-texts span.mfn-ls-price',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Price typography', 'mfn-opts'),
						),


						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

			// Header search ----------------------------------------------------

   			'header_search' => array(
   				'type' => 'header_search',
   				'title' => __('Search field', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'header',
   				'attr' => array(
   				//'fields' => array(

						/*array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),*/

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'type' => 'header',
							'title' => __('Input', 'mfn-opts'),
						),

						array(
							'id' => 'placeholder',
							'type' => 'text',
							'title' => __('Placeholder', 'mfn-opts'),
							'std' => __('Enter your search', 'betheme'),
						),

						array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Input', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:typography',
							'id' => 'css_forminputfield_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input:border-style',
							'id' => 'css_forminput_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input',
							'style' => 'border-style',
							'attr_id' => 'border_style_header_search',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:border-width',
							'id' => 'css_forminputfield_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field',
							'style' => 'border-width',
							'condition' => array( 'id' => 'border_style_header_search', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'dimensions',
							'title' => __('Border width', 'mfn-opts'),
							'class' => 'mfn-toggled',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:border-radius',
							'id' => 'css_forminputfield_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field',
							'style' => 'border-radius',
							'type' => 'dimensions',
							'title' => __('Border radius', 'mfn-opts'),
							'class' => 'mfn-toggled',
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:box-shadow',
							'id' => 'css_forminputfield_box_shadow',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field',
							'style' => 'box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:height',
							'id' => 'css_forminputfield_height',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field',
							'style' => 'height',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Height', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '15',
								'max' => '80',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:font-size',
							'id' => 'css_forminputfield_font_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field',
							'style' => 'font-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Font size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '5',
								'max' => '70',
								'step' => '1',
								'unit' => 'px',
							)
						),
						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:padding',
							'id' => 'css_forminputfield_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:--mfn-header-search-color',
							'id' => 'css_forminputfield_header_search_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field',
							'style' => '--mfn-header-search-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:background-color',
							'id' => 'css_forminputfield_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:border-color',
							'id' => 'css_forminputfield_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_search', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field|focus:--mfn-header-search-color',
							'id' => 'css_forminputfield_header_search_color_focus',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:focus',
							'style' => '--mfn-header-search-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field|focus:background-color',
							'id' => 'css_forminputfield_background_color_focus',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:focus',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field|focus:border-color',
							'id' => 'css_forminputfield_border_color_focus',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:focus',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_header_search', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .search_wrapper:--mfn-header-search-icon-color',
							'id' => 'css_search_wrapper_header_search_icon_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .search_wrapper',
							'style' => '--mfn-header-search-icon-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .search_wrapper:--mfn-header-search-icon-size',
							'id' => 'css_search_wrapper_header_search_icon_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .search_wrapper',
							'style' => '--mfn-header-search-icon-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),


						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .search_wrapper .icon_search:left',
							'id' => 'css_search_wrappericon_search_left',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .search_wrapper .icon_search',
							'style' => 'left',
							'type' => 'sliderbar',
							'responsive' => true,
							'title' => __('Left offset', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '50',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

				// Header Promo Bar ----------------------------------------------------

   			'header_promo_bar' => array(
   				'type' => 'header_promo_bar',
   				'title' => __('Promo bar', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'header',
   				'attr' => array(
   				//'fields' => array(

						/*array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),*/

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
   						'id' => 'tabs',
   						'type' => 'tabs',
   						'title' => __('Slides', 'mfn-opts'),
							'options' => [
								'title' => [
									'textarea',
									__('Content', 'mfn-opts'),
									'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
							],
							'std' => [
								0 => [
									'title' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
							],
							'preview' => 'tabs',
							'primary' => 'title', // default
   					),

   					array(
   						'id' => 'slider_speed',
   						're_render' => true,
   						'type' => 'text',
   						'title' => __('Autoplay speed', 'mfn-opts'),
   						'std' => '3',
   						'after' => 's',
   						'param' => 'number',
   						'class' => 'narrow',
							'preview' => 'number',
   					),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:typography',
							'id' => 'css_mcb-column-inner_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:text-align',
							'id' => 'css_mcb-column-inner_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),
						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:color',
							'id' => 'css_mcb-column-inner_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled main-color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a:color',
							'id' => 'css_mcb-column-innera_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled main-color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a|hover:color',
							'id' => 'css_mcb-column-innera_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled main-color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

				// Shop Products ----------------------------------------------------

   			'shop_products' => array(
   				'type' => 'shop_products',
   				'title' => __('Shop products', 'mfn-opts'),
   				'desc' => __('List of products from woocommerce', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'shop-archive',
   				'attr' => array(
   				//'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
   						'id' => 'products',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Products per page', 'mfn-opts'),
   						'std' => '12',
   						'after' => 'products',
   						'param' => 'number',
   						'class' => 'narrow',
							'preview' => 'number',
   					),

   					array(
   						'id' => 'layout',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Columns', 'mfn-opts'),
							'options' => array(
								'grid col-2' => __('Grid, 2 columns', 'mfn-opts'),
								'grid' => __('Grid, 3 columns', 'mfn-opts'),
								'grid col-4' => __('Grid, 4 columns', 'mfn-opts'),
								'masonry' => __('Masonry, 3 columns', 'mfn-opts'),
								'list' => __('List', 'mfn-opts'),
							),
   						'std' => 'grid',
   					),

   					array(
   						'id' => 'ordering',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Order', 'mfn-opts'),
							'options' => array(
								'' => __('Default', 'mfn-opts'),
								'menu_order' => __('Menu order', 'mfn-opts'),
								'popularity' => __('Sales', 'mfn-opts'),
								'rating' => __('Average rating', 'mfn-opts'),
								'date' => __('Most recent', 'mfn-opts'),
								'price' => __('Lowest price', 'mfn-opts'),
								'price-desc' => __('Highest price', 'mfn-opts'),
							),
   						'std' => '',
   					),

						// options

   					array(
   						'type' => 'header',
   						'title' => __('Options', 'mfn-opts'),
   					),

						array(
							'id' => 'description',
							're_render' => true,
							'type' => 'switch',
							'title' => __('Description', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
                'list' => __('List layout only', 'mfn-opts'),
							),
							'std' => '0'
						),

						array(
							'id' => 'button',
							're_render' => true,
							'type' => 'switch',
							'title' => __('Add to cart button', 'mfn-opts'),
							'desc' => __('Required for some plugins', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
                'list' => __('List layout only', 'mfn-opts'),
							),
							'std' => '0',
						),

						array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'span' => 'span',
							],
							'std' => 'h2',
						),

						array(
							'id' => 'equal_heights',
							'attr_id' => 'equal_heights',
							're_render' => true,
							'type' => 'switch',
							'title' => __('Products List Standardization', 'mfn-opts'),
							'options' => [
								'0' => __('Default', 'mfn-opts'),
								'1' => __('Equal heights', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'equal_heights_last_el_class',
							'condition' => array( 'id' => 'equal_heights', 'opt' => 'is', 'val' => '1' ),
							'type' => 'select',
							're_render' => true,
							'title' => __('Align to the bottom from', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'image' => __('Image', 'mfn-opts'),
								'title' => __('Title', 'mfn-opts'),
								'price' => __('Price', 'mfn-opts'),
								'variations' => __('Variations', 'mfn-opts'),
								'description' => __('Description', 'mfn-opts'),
								'button' => __('Button', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
   						'id' => 'load_more',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Infinite Load More', 'mfn-opts'),
   						'options' => array(
								'' => __('Disable', 'mfn-opts'),
   							'1' => __('Enable', 'mfn-opts'),
   						),
							'std' => '',
   					),


						array(
   						'type' => 'header',
   						'title' => __('Filters', 'mfn-opts'),
   					),

						array(
							'id' => 'shop-list-active-filters',
							'type' => 'switch',
							'class' => 'shop-products-filters-switcher',
							'title' => __('Active filters', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => mfn_opts_get('shop-list-active-filters'),
						),

						array(
							'id' => 'shop-list-perpage',
							'type' => 'switch',
							'class' => 'shop-products-filters-switcher',
							'title' => __('Products per page', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => mfn_opts_get('shop-list-perpage'),
						),

						array(
							'id' => 'shop-list-layout',
							'class' => 'shop-products-filters-switcher',
							'type' => 'switch',
							'title' => __('Layout switch', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => mfn_opts_get('shop-list-layout'),
						),

						array(
							'id' => 'shop-list-sorting',
							'class' => 'shop-products-filters-switcher',
							'type' => 'switch',
							'title' => __('List sorting', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => mfn_opts_get('shop-list-sorting'),
						),

						array(
							'id' => 'shop-list-results-count',
							'class' => 'shop-products-filters-switcher',
							'type' => 'switch',
							'title' => __('Results count', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => mfn_opts_get('shop-list-results-count'),
						),


						// order

						array(
							'type' => 'header',
							'title' => __('Order', 'mfn-opts'),
						),

						array(
							'id' => 'order',
							'type' => 'order',
							're_render' => true,
							'title' => __('Order', 'mfn-opts'),
							'std' => 'image,title,price,description,button',
						),

						// HTML style

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

   					// HTML end: style

   					array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:text-align',
							'id' => 'css_product_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'text-align',
							'type' => 'switch',
							'responsive' => true,
							'class' => 'mfn-toggled',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:background-color',
							'id' => 'css_product_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:padding',
							'id' => 'css_product_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-style',
							'id' => 'css_product_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-style',
							'attr_id' => 'border_style_shop_li',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-color',
							'id' => 'css_product_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-width',
							'id' => 'css_product_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-radius',
							'id' => 'css_product_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-style',
							'id' => 'css_product_image_frame_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-style',
							'attr_id' => 'border_style_shopimg',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-color',
							'id' => 'css_product_image_frame_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-width',
							'id' => 'css_product_image_frame_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-radius',
							'id' => 'css_product_image_frame_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_product_image_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),


		  			array(
							'id' => 'css_product_image_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .mfn-li-product-row-image',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			// title

						array(
							'title' => __('Title', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:color',
							'id' => 'css_product_title_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:margin',
							'id' => 'css_product_title_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:typography',
							'id' => 'css_product_title_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Price', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:color',
							'id' => 'css_product_price_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_del_price_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price del',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Strike price color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:margin',
							'id' => 'css_product_price_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:typography',
							'id' => 'css_product_price_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Desc', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:margin',
							'id' => 'css_product_excerpt_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:typography',
							'id' => 'css_products_excerpt_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:color',
							'id' => 'css_product_excerpt_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Attributes', 'mfn-opts'),
   					),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a:border-color',
							'id' => 'css_variations-wrapper-loop-vrul-vr-optionslia_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a|hover:border-color',
							'id' => 'css_variations-wrapper-loop-vrul-vr-optionsliahover_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a:hover',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color on Hover', 'mfn-opts'),
						),




























						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Badge', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_product_onsale_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'border-style',
							'attr_id' => 'border_style_badge',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_product_onsale_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_product_onsale_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
   						'id' => 'css_product_onsale_align',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges',
   						'style' => 'align-items',
							'responsive' => true,
							'class' => 'mfn-toggled',
   						'type' => 'switch',
   						'title' => __('Alignment', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'flex-start' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'flex-end' => __('Right', 'mfn-opts'),
   						),
   						'std' => ''
   					),

   					array(
							'id' => 'product_badge_onsale_position',
							'attr_id' => 'product_badge_onsale_position',
							'type' => 'switch',
							'class' => 'mfn-toggled archive_badge_onsale_position',
							'title' => __('Position X', 'mfn-opts'),
							'options' => array(
		  					'' => __('Left', 'mfn-opts'),
		  					'right' => __('Right', 'mfn-opts'),
		  				),
		  				'std' => '',
						),

						array(
							'id' => 'css_product_onsale_offset_left',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges-left li.product .mfn-product-badges',
							'style' => 'left',
		  				'type' => 'sliderbar',
		  				'condition' => array( 'id' => 'product_badge_onsale_position', 'opt' => 'is', 'val' => '' ),
		  				'title' => __('Offset left', 'mfn-opts'),
							'responsive' => true,
							'default_unit' => 'px',
							'class' => 'narrow mfn-toggled',
							'param' => array(
								'unit' => 'px',
								'min' => '-100',
								'max' => '300',
								'step' => '1',
							),
		  			),

		  			array(
							'id' => 'css_product_onsale_offset_right',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges-right li.product .mfn-product-badges',
							'style' => 'right',
		  				'type' => 'sliderbar',
		  				'condition' => array( 'id' => 'product_badge_onsale_position', 'opt' => 'is', 'val' => 'right' ),
		  				'title' => __('Offset right', 'mfn-opts'),
							'responsive' => true,
							'default_unit' => 'px',
							'class' => 'narrow mfn-toggled',
							'param' => array(
								'unit' => 'px',
								'min' => '-100',
								'max' => '300',
								'step' => '1',
							),
		  			),

		  			array(
							'id' => 'css_product_onsale_offset_top',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges',
							'style' => 'top',
		  				'type' => 'sliderbar',
		  				'title' => __('Offset top', 'mfn-opts'),
							'responsive' => true,
							'default_unit' => 'px',
							'class' => 'narrow mfn-toggled',
							'param' => array(
								'unit' => 'px',
								'min' => '-100',
								'max' => '300',
								'step' => '1',
							),
		  			),

		  			array(
							'id' => 'css_product_onsale_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled mfn-onsale-label',
							'title' => __('Default label (Sale)', 'mfn-opts'),
						),

		  			array(
							'id' => 'css_product_onsale_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'border-color',
							'type' => 'color',
							'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Label (New)', 'mfn-opts'),
						),

		  			array(
							'id' => 'css_product_onsale_new_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.mfn-new-badge.onsale',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_new_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.mfn-new-badge.onsale',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_new_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.mfn-new-badge.onsale',
							'style' => 'border-color',
							'type' => 'color',
							'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Extra label', 'mfn-opts'),
						),

		  			array(
							'id' => 'css_product_onsale_extra_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale.onsale-extra-label',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_extra_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale.onsale-extra-label',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_extra_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale.onsale-extra-label',
							'style' => 'border-color',
							'type' => 'color',
							'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),
































						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:padding',
							'id' => 'css_product_button_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:typography',
							'id' => 'css_product_button_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-style',
							'id' => 'css_product_button_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-style',
							'attr_id' => 'border_style_bsb',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-width',
							'id' => 'css_product_button_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-radius',
							'id' => 'css_product_button_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:color',
							'id' => 'css_product_button_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-color',
							'id' => 'css_product_button_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:background-color',
							'id' => 'css_product_button_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'background-color',
							'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:gradient',
							'id' => 'css_product_button_gradient',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:color',
							'id' => 'css_product_button_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:border-color',
							'id' => 'css_product_button_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_hover_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:background',
							'id' => 'css_product_button_background_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover, .mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:before',
							'style' => 'background',
							'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:gradient',
							'id' => 'css_product_button_gradient_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),


						array(
							'title' => __('List options container', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),


						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters:background-color',
							'id' => 'css_shop-filters_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters:margin',
							'id' => 'css_shop-filters_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters:padding',
							'id' => 'css_shop-filters_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters:border-style',
							'id' => 'css_shop-filters_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters',
							'style' => 'border-style',
							'attr_id' => 'border_style_shop_filters',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters:border-width',
							'id' => 'css_shop-filters_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_shop_filters', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters:border-color',
							'id' => 'css_shop-filters_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_shop_filters', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters:border-radius',
							'id' => 'css_shop-filters_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


						array(
							'title' => __('Result count', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-result-count:typography',
							'id' => 'css_woocommerce-result-count_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-result-count',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-result-count:color',
							'id' => 'css_woocommerce-result-count_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-result-count',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Sorting', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:typography',
							'id' => 'css_shop-filterswoocommerce-orderingselect_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:color',
							'id' => 'css_shop-filterswoocommerce-orderingselect_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:background',
							'id' => 'css_shop-filterswoocommerce-orderingselect_background',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select',
							'style' => 'background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:padding',
							'id' => 'css_shop-filterswoocommerce-orderingselect_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:border-style',
							'id' => 'css_shop-filterswoocommerce-orderingselect_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select',
							'style' => 'border-style',
							'attr_id' => 'border_style_shop_order',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:border-width',
							'id' => 'css_shop-filterswoocommerce-orderingselect_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_shop_order', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:border-color',
							'id' => 'css_shop-filterswoocommerce-orderingselect_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_shop_order', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:border-radius',
							'id' => 'css_shop-filterswoocommerce-orderingselect_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'title' => __('List options', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .mfn-woo-list-options form.mfn-before-products-list-form:typography',
							'id' => 'css_shop-filters-woo-list-optionsform-before-products-list-form_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .mfn-woo-list-options form.mfn-before-products-list-form',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .mfn-woo-list-options form.mfn-before-products-list-form:color',
							'id' => 'css_shop-filters-woo-list-optionsform-before-products-list-form_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .mfn-woo-list-options form.mfn-before-products-list-form',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Layout options', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .mfn-woo-list-options ul li svg:width',
							'id' => 'css_shop-filters-woo-list-optionsullisvg_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .mfn-woo-list-options ul li svg',
							'style' => 'width',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'title' => __('Size', 'mfn-opts'),
							'responsive' => true,
							'class' => 'narrow mfn-toggled',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '200',
								'step' => '1',
							),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters a.open-filters svg .path, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .mfn-woo-list-options ul li:--mfn-woo-icon-option',
							'id' => 'css_layout_options_color',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters a.open-filters svg .path, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .mfn-woo-list-options ul li',
   						'style' => '--mfn-woo-icon-option',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Rating', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating:display',
							'id' => 'css_product_star-rating_display',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating',
							'style' => 'display',
							'attr_id' => 'shop-list-rating',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Visibility', 'mfn-opts'),
							'options' => [
								'' => __('Visible', 'mfn-opts'),
								'none' => __('Hidden', 'mfn-opts'),
							],
							'std' => ''
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating span:color',
							'id' => 'css_product_star-ratingspan_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating span',
							'style' => 'color',
							'condition' => array( 'id' => 'shop-list-rating', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Filters switcher', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters a.open-filters:typography',
							'id' => 'css_shop-filtersaopen-filters_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters a.open-filters',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters a.open-filters:color',
							'id' => 'css_shop-filtersaopen-filters_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters a.open-filters',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters a.open-filters svg:width',
							'id' => 'css_shop-filtersaopen-filterssvg_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters a.open-filters svg',
							'style' => 'width',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'title' => __('Icon size', 'mfn-opts'),
							'responsive' => true,
							'class' => 'narrow mfn-toggled',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '200',
								'step' => '1',
							),
						),


						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Shop Title ----------------------------------------------------

   			'shop_title' => array(
   				'type' => 'shop_title',
   				'title' => __('Shop title', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'shop-archive',
   				'attr' => array(
   				//'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

   					array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
                'h1' => 'h1',
                'h2' => 'h2',
                'h3' => 'h3',
                'h4' => 'h4',
                'h5' => 'h5',
                'h6' => 'h6',
                'p' => 'p',
                'p.lead' => 'p.lead',
                'span' => 'span',
							],
							'std' => 'h1',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						// title

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Title', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .page-title:text-align',
							'id' => 'css_page-title_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .page-title',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .page-title:typography',
							'id' => 'css_page-title_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .page-title',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .page-title:color',
							'id' => 'css_page-title_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .page-title',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),


				// ALIAS: category description ----------------------------------------------------

   			'shop_cat_desc' => array(
   				'type' => 'plain_text',
   				'title' => __('Category Description', 'mfn-opts'),
   				'cat' => 'shop-archive',
   			),

   			// ALIAS: category top description ----------------------------------------------------

   			'shop_cat_top_desc' => array(
   				'type' => 'plain_text',
   				'title' => __('Category <br>Top Content', 'mfn-opts'),
   				'cat' => 'shop-archive',
   			),

   			// ALIAS: category bottom description ----------------------------------------------------

   			'shop_cat_bottom_desc' => array(
   				'type' => 'plain_text',
   				'title' => __('Category <br>Bottom Content', 'mfn-opts'),
   				'cat' => 'shop-archive',
   			),












   			// Alert ----------------------------------------------------

   			'woo_alert' => array(
   				'type' => 'woo_alert',
   				'title' => __('Alert', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'woocommerce',
   				'attr' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'id' => 'info',
							'class' => 'mfn-alert',
   						'type' => 'info',
   						'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),


						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
							'id' => 'css_alert_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .alert',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_alert_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .alert',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#success" data-tab="success">Success</a></li><li><a href="#error" data-tab="error">Error</a></li></ul><div class="mfn-sft mfn-sft-success">',
						),

						array(
							'id' => 'css_alert_success_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .alert.alert_success',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_alert_success_link_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .alert.alert_success a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'id' => 'css_alert_success_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .alert.alert_success',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_alert_success_close_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .alert.alert_success a .icon',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Close icon color', 'mfn-opts'),
						),

						array(
							'id' => 'css_alert_success_icon_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .alert.alert_success .path',
							'style' => 'stroke',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Icon color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-error">',
						),

						array(
							'id' => 'css_alert_error_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .alert.alert_error',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_alert_error_link_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .alert.alert_error a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'id' => 'css_alert_error_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .alert.alert_error',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_alert_error_close_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .alert.alert_error a .icon',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Close icon color', 'mfn-opts'),
						),

						array(
							'id' => 'css_alert_error_icon_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .alert.alert_error .path',
							'style' => 'stroke',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Icon color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),



   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),









   			// Product Title ----------------------------------------------------

   			'product_title' => array(
   				'type' => 'product_title',
   				'title' => __('Product title', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'attr' => array(
   				//'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

   					array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
                'h1' => 'h1',
                'h2' => 'h2',
                'h3' => 'h3',
                'h4' => 'h4',
                'h5' => 'h5',
                'h6' => 'h6',
                'p' => 'p',
                'p.lead' => 'p.lead',
                'span' => 'span',
							],
							'std' => 'h1',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						// title

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Title', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:text-align',
							'id' => 'css_title_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:typography',
							'id' => 'css_title_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:color',
							'id' => 'css_title_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product images ----------------------------------------------------

   			'product_images' => array(
   				'type' => 'product_images',
   				'title' => __('Product images', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'attr' => array(
   				//'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						// options

   					array(
   						'type' => 'header',
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'zoom',
   						'type' => 'switch',
   						'title' => __('Zoom effect', 'mfn-opts'),
							'options' => array(
								'0' => __('Disable', 'mfn-opts'),
								'1' => __('Enable', 'mfn-opts'),
							),
   						'std' => '1',
   					),

   					array(
   						'type' => 'header',
   						'title' => __('Arrows', 'mfn-opts'),
   					),

   					array(
   						'id' => 'thumbnail_arrows',
   						'attr_id' => 'thumbnail_arrows',
   						'type' => 'switch',
   						'title' => __('Arrows', 'mfn-opts'),
   						'desc' => __('Works with thumbnail horizontal styles', 'mfn-opts'),
							'options' => array(
								'' => __('Disable', 'mfn-opts'),
								'1' => __('Enable', 'mfn-opts'),
							),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						// image

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-has-gallery .flex-viewport, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-hasnt-gallery .woocommerce-product-gallery__image:background-color',
							'id' => 'css_image_bg',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-has-gallery .flex-viewport, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-hasnt-gallery .woocommerce-product-gallery__image',
   						'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-has-gallery .flex-viewport, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-hasnt-gallery .woocommerce-product-gallery__image:border-style',
							'id' => 'css_image_border_style',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-has-gallery .flex-viewport, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-hasnt-gallery .woocommerce-product-gallery__image',
   						'style' => 'border-style',
							'attr_id' => 'border_style_prodimg',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-has-gallery .flex-viewport, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-hasnt-gallery .woocommerce-product-gallery__image:border-color',
							'id' => 'css_image_border_color',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-has-gallery .flex-viewport, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-hasnt-gallery .woocommerce-product-gallery__image',
   						'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_prodimg', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-has-gallery .flex-viewport, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-hasnt-gallery .woocommerce-product-gallery__image:border-width',
		  				'id' => 'css_image_border_width',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-has-gallery .flex-viewport, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-hasnt-gallery .woocommerce-product-gallery__image',
   						'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_prodimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-has-gallery .flex-viewport, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-hasnt-gallery .woocommerce-product-gallery__image:border-radius',
		  				'id' => 'css_image_border_radius',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-has-gallery .flex-viewport, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-hasnt-gallery .woocommerce-product-gallery__image',
   						'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						// thumbnails

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Thumbnails', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li img:background-color',
							'id' => 'css_flex-control-thumbsliimg_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li img',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),


						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li:border-style',
							'id' => 'css_flex-control-thumbsli_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li',
							'style' => 'border-style',
							'attr_id' => 'border_style_prodthumbs',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li:border-color',
							'id' => 'css_flex-control-thumbsli_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_prodthumbs', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li:border-width',
							'id' => 'css_flex-control-thumbsli_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_prodthumbs', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li:border-radius',
							'id' => 'css_flex-control-thumbsli_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
							'condition' => array( 'id' => 'thumbnail_arrows', 'opt' => 'is', 'val' => '1' ),
							'title' => __('Arrows', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:--mfn-swiper-arrow-size',
							'id' => 'css____mfn_swiper_arrow_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement',
							'style' => '--mfn-swiper-arrow-size',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'title' => __('Size', 'mfn-opts'),
							'responsive' => true,
							'class' => 'narrow mfn-toggled',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '200',
								'step' => '1',
							),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-gallery:--mfn-swiper-arrow-offset',
							'id' => 'css_woocommerce-product-gallery_swiper_arrow_offset',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-gallery',
							'style' => '--mfn-swiper-arrow-offset',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'title' => __('Offset', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '200',
								'step' => '1',
							),
						),



						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow i:color',
							'id' => 'css_swiper-arrowi_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow|hover i:color',
							'id' => 'css_swiper-arrowi_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:hover i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),


						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Badge', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges span.onsale',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_product_onsale_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges span.onsale',
							'style' => 'border-style',
							'attr_id' => 'border_style_badge',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_product_onsale_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges span.onsale',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_product_onsale_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges span.onsale',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
   						'id' => 'css_product_onsale_align',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges',
   						'style' => 'align-items',
							'responsive' => true,
							'class' => 'mfn-toggled',
   						'type' => 'switch',
   						'title' => __('Alignment', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'flex-start' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'flex-end' => __('Right', 'mfn-opts'),
   						),
   						'std' => ''
   					),

   					array(
							'id' => 'product_badge_onsale_position',
							'attr_id' => 'product_badge_onsale_position',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Position X', 'mfn-opts'),
							'options' => array(
		  					'' => __('Left', 'mfn-opts'),
		  					'right' => __('Right', 'mfn-opts'),
		  				),
		  				'std' => '',
						),

						array(
							'id' => 'css_product_onsale_offset_left',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges-left .mfn-product-badges',
							'style' => 'left',
		  				'type' => 'sliderbar',
		  				'condition' => array( 'id' => 'product_badge_onsale_position', 'opt' => 'is', 'val' => '' ),
		  				'title' => __('Offset left', 'mfn-opts'),
							'responsive' => true,
							'default_unit' => 'px',
							'class' => 'narrow mfn-toggled',
							'param' => array(
								'unit' => 'px',
								'min' => '-100',
								'max' => '300',
								'step' => '1',
							),
		  			),

		  			array(
							'id' => 'css_product_onsale_offset_right',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges-right .mfn-product-badges',
							'style' => 'right',
		  				'type' => 'sliderbar',
		  				'condition' => array( 'id' => 'product_badge_onsale_position', 'opt' => 'is', 'val' => 'right' ),
		  				'title' => __('Offset right', 'mfn-opts'),
							'responsive' => true,
							'default_unit' => 'px',
							'class' => 'narrow mfn-toggled',
							'param' => array(
								'unit' => 'px',
								'min' => '-100',
								'max' => '300',
								'step' => '1',
							),
		  			),

		  			array(
							'id' => 'css_product_onsale_offset_top',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges',
							'style' => 'top',
		  				'type' => 'sliderbar',
		  				'title' => __('Offset top', 'mfn-opts'),
							'responsive' => true,
							'default_unit' => 'px',
							'class' => 'narrow mfn-toggled',
							'param' => array(
								'unit' => 'px',
								'min' => '-100',
								'max' => '300',
								'step' => '1',
							),
		  			),

		  			array(
							'id' => 'css_product_onsale_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges span.onsale',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled mfn-onsale-label',
							'title' => __('Default label (Sale)', 'mfn-opts'),
						),

		  			array(
							'id' => 'css_product_onsale_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges span.onsale',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges span.onsale',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges span.onsale',
							'style' => 'border-color',
							'type' => 'color',
							'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Label (New)', 'mfn-opts'),
						),

		  			array(
							'id' => 'css_product_onsale_new_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges span.mfn-new-badge.onsale',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_new_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges span.mfn-new-badge.onsale',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_new_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges span.mfn-new-badge.onsale',
							'style' => 'border-color',
							'type' => 'color',
							'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),


						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Extra label', 'mfn-opts'),
						),

		  			array(
							'id' => 'css_product_onsale_extra_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges span.onsale.onsale-extra-label',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_extra_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges span.onsale.onsale-extra-label',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_extra_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges span.onsale.onsale-extra-label',
							'style' => 'border-color',
							'type' => 'color',
							'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),


   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product price ----------------------------------------------------

   			'product_price' => array(
   				'type' => 'product_price',
   				'title' => __('Product price', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'attr' => array(
   				//'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'id' => 'info',
							'class' => 'mfn-alert',
   						'type' => 'info',
   						'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Price', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price:text-align',
							'id' => 'css_price_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price:typography',
							'id' => 'css_price_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price:color',
							'id' => 'css_price_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Old price', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price > del:typography',
							'id' => 'css_price_del_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price > del',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price > del:color',
							'id' => 'css_pricedel_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price > del',
							'style' => 'color',
							'type' => 'color',
							'class' => 'sales-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
							'desc' => __('Old price on sale', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product add to cart ----------------------------------------------------

   			'product_cart_button' => array(
   				'type' => 'product_cart_button',
   				'title' => __('Add to cart', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'attr' => array(
   				//'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'id' => 'cart_button_text',
							'type' => 'text',
							'title' => __('Button text', 'mfn-opts'),
							'std' => __('Add to cart', 'woocommerce'),
						),

						array(
							'id' => 'style',
							'type' => 'switch',
							'responsive' => true,
							'title' => __('Layout', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'inline' => __('Inline', 'mfn-opts'),
								'wrap' => __('Wrap', 'mfn-opts'),
							],
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Attributes', 'mfn-opts'),
   					),

   					array(
							'id' => 'variations-label',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Label position', 'mfn-opts'),
							'options' => [
								'' => __('Inline', 'mfn-opts'),
								'top' => __('Top', 'mfn-opts'),
							],
						),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr label:color',
							'id' => 'css_variations-wrapper-vrlabel_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr label',
							'style' => 'color',
							'type' => 'color',
							'class' => 'sales-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr label:typography',
							'id' => 'css_woocommerce_variations-wrapper-vrlabel_typography',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr label',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),



   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr:border-color',
							'id' => 'css_variations-wrapper-vr_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Line separator', 'mfn-opts'),
						),


   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),


   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr ul.mfn-vr-options li a:border-color',
							'id' => 'css_variations-wrapper-vrul-vr-optionslia_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr ul.mfn-vr-options li a',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'css_variations-wrapper-vrul-vr-optionslia_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr ul.mfn-vr-options li a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_variations-wrapper-vrul-vr-optionslia_bg_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr ul.mfn-vr-options li a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),



						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr ul.mfn-vr-options li a|hover:border-color',
							'id' => 'css_variations-wrapper-vrul-vr-optionsliahover_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr ul.mfn-vr-options li a:hover',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'css_variations-wrapper-vrul-vr-optionslia_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr ul.mfn-vr-options li a:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_variations-wrapper-vrul-vr-optionslia_bg_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr ul.mfn-vr-options li a:hover',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),


						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),


						array(
							'id' => 'css_variations-wrapper-vrul-vr-optionslia_border_color_active',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr ul.mfn-vr-options li.active a',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'css_variations-wrapper-vrul-vr-optionslia_color_active',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr ul.mfn-vr-options li.active a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_variations-wrapper-vrul-vr-optionslia_bg_color_active',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr ul.mfn-vr-options li.active a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),



						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:padding',
							'id' => 'css_woocommerce-product-add-to-cartbutton_padding',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:typography',
							'id' => 'css_woocommerce-product-add-to-cartbutton_typography',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:border-style',
							'id' => 'css_woocommerce-product-add-to-cartbutton_border_style',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button',
							'style' => 'border-style',
							'attr_id' => 'border_style_bsb',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:border-width',
							'id' => 'css_woocommerce-product-add-to-cartbutton_border_width',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


						array(
		  				'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:border-radius',
							'id' => 'css_woocommerce_product-add-to-cartbutton_border_radius',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:color',
							'id' => 'css_woocommerce-product-add-to-cartbutton_color',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:border-color',
							'id' => 'css_woocommerce-product-add-to-cartbutton_border_color',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:background-color',
							'id' => 'css_woocommerce_product-add-to-cartbutton_background_color',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button',
							'style' => 'background-color',
							'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:gradient',
							'id' => 'css_woocommerce-product-add-to-cartbutton_gradient',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button|hover:color',
							'id' => 'css_woocommerce-product-add-to-cartbutton_color_hover',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button|hover:border-color',
							'id' => 'css_woocommerce_product-add-to-cartbuttonhover_border_color_hover',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_hover_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button|hover:background',
							'id' => 'css_woocommerce_product-add-to-cartbuttonhover_background_hover',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:hover, .woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:before',
							'style' => 'background',
							'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button|hover:gradient',
							'id' => 'css_woocommerce_product-add-to-cartbuttonhover_gradient_hover',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:hover',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Quantity', 'mfn-opts'),
   					),

   					array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .quantity input.qty:background',
							'id' => 'css_woocommerce_quantityinputqty_background',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .quantity input.qty',
							'style' => 'background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .quantity input.qty:color',
							'id' => 'css_woocommerce_quantityinputqty_color',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .quantity input.qty',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .quantity input.qty:border-color',
							'id' => 'css_woocommerce_quantityinputqty_border_color',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .quantity input.qty',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .quantity a.quantity-change:color',
							'id' => 'css_woocommerce_quantityaquantity-change_color',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .quantity a.quantity-change',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Plus/Minus color', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Variation', 'mfn-opts'),
   					),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Price', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-variation-price:margin',
							'id' => 'css_woocommerce-variation-price_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-variation-price',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-variation-price .price:color',
							'id' => 'css_woocommerce-variation-priceprice_color',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-variation-price .price',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-variation-price .price:typography',
							'id' => 'css_woocommerce_oocommerce-variation-priceprice_typography',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-variation-price .price',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Product breadcrumbs ----------------------------------------------------

   			'product_breadcrumbs' => array(
   				'type' => 'product_breadcrumbs',
   				'title' => __('Breadcrumbs', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'attr' => array(
   				//'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'type' => 'header',
							'title' => __('Custom', 'mfn-opts'),
						),

						array(
							'id' => 'breadcrumb_delimiter',
							'type' => 'text',
							're_render' => true,
							'title' => __('Delimiter', 'mfn-opts'),
							'std' => '/',
						),

						array(
							'id' => 'breadcrumb_home',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Home page', 'mfn-opts'),
							'options' => [
								'0' => 'No',
								'1' => 'Include',
							],
							'std' => '1',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),


						array(
							'title' => __('Breadcrumbs', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb:text-align',
							'id' => 'css_woocommerce-breadcrumb_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),


						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb:typography',
							'id' => 'css_woocommerce-breadcrumb_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb:color',
							'id' => 'css_woocommerce-breadcrumb_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Delimiter', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb span:color',
							'id' => 'css_woocommerce-breadcrumbspan_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb span',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb span:opacity',
							'id' => 'css_woocommerce-breadcrumbspan_opacity',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb span',
							'style' => 'opacity',
							'type' => 'sliderbar',
							'class' => 'mfn-toggled',
							'title' => __('Opacity', 'mfn-opts'),
							'param' => array(
								'min' => '0',
								'max' => '1',
								'step' => '0.1',
							),
							'std' => '0.2'
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Product reviews ----------------------------------------------------

   			'product_reviews' => array(
   				'type' => 'product_reviews',
   				'title' => __('Product reviews', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'attr' => array(
   				//'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'id' => 'info',
							'class' => 'mfn-alert',
   						'type' => 'info',
   						'title' => __('This item can only be used once per page (including product tab reviews)', 'mfn-opts'),
   					),

						array(
							'id' => 'info',
							'class' => 'mfn-alert',
   						'type' => 'info',
   						'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'title' => __('Title', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-Reviews-title:text-align',
							'id' => 'css_woocommerce-Reviews-title_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-Reviews-title',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),


						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-Reviews-title:typography',
							'id' => 'css_reviews-title_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-Reviews-title',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-Reviews-title:color',
							'id' => 'css_woocommerce-Reviews-title_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-Reviews-title',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Container', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text:background-color',
							'id' => 'css_reviews_comment-text_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text p.meta .woocommerce-review__author:color',
							'id' => 'css_reviews_comment-textpmetawoocommerce-review__author_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text p.meta .woocommerce-review__author',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Author name color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text p.meta .woocommerce-review__published-date,.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text p.meta .woocommerce-review__dash:color',
							'id' => 'css_date_color',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text p.meta .woocommerce-review__published-date,.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text p.meta .woocommerce-review__dash',
   						'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Date color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text .description:color',
							'id' => 'css_reviews_comment-textdescription_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text .description',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Comment color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text p.meta:border-color',
							'id' => 'css_reviews_comment-textpmeta_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text p.meta',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Line color', 'mfn-opts'),
						),

						array(
							'title' => __('Stars', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .star-rating span,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .comment-form-rating p.stars a|before:color',
							'id' => 'css_star-ratingspancomment-form-ratingpstarsabefore_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .star-rating span,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .comment-form-rating p.stars a:before',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Form title', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #respond .comment-reply-title:typography',
							'id' => 'css_respondcomment-reply-title_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement #respond .comment-reply-title',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #respond .comment-reply-title:color',
							'id' => 'css_comment-reply-title_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement #respond .comment-reply-title',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Your rating', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #review_form_wrapper .comment-form label:color',
							'id' => 'css_reviews_form_wrappercomment-formlabel_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #review_form_wrapper .comment-form label',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Label', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .comment-form-rating p.stars a:color',
							'id' => 'css_comment-form-ratingpstarsa_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .comment-form-rating p.stars a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Number', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .comment-form-rating p.stars a:background-color',
							'id' => 'css_comment-form-ratingpstarsa_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .comment-form-rating p.stars a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Textarea', 'mfn-opts'),
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #review_form_wrapper .comment-form .comment-form-comment textarea:color',
							'id' => 'css_reviews_form_comment_textarea_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #review_form_wrapper .comment-form .comment-form-comment textarea',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #review_form_wrapper .comment-form .comment-form-comment textarea,.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #review_form_wrapper .comment-form .comment-form-comment textarea|focus:background-color',
							'id' => 'css_textarea_bg',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #review_form_wrapper .comment-form .comment-form-comment textarea,.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #review_form_wrapper .comment-form .comment-form-comment textarea:focus',
   						'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #review_form_wrapper .comment-form .comment-form-comment textarea:border-color',
							'id' => 'css_reviews_form_comment_textarea_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #review_form_wrapper .comment-form .comment-form-comment textarea',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:padding',
							'id' => 'css_woocommerce_review_form_input_padding',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input',
							'style' => 'padding',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:typography',
							'id' => 'css_woocommerce_review_form_input_typography',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:border-style',
							'id' => 'css_woocommerce_review_form_input_border_style',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input',
							'style' => 'border-style',
							'attr_id' => 'border_style_prodrev',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:border-width',
							'id' => 'css_woocommerce_review_form_input_border_width',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_prodrev', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


						array(
		  				'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:border-radius',
							'id' => 'css_woocommerce_review_form_input_border_radius',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:color',
							'id' => 'css_woocommerce_review_form_input_color',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:border-color',
							'id' => 'css_woocommerce_review_form_input_border_color',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_prodrev', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:background-color',
							'id' => 'css_woocommerce_review_form_input_background_color',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input',
							'style' => 'background-color',
							'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:gradient',
							'id' => 'css_woocommerce_review_form_input_gradient',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input|hover:color',
							'id' => 'css_woocommerce_review_form_inputhover_color_hover',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input|hover:border-color',
							'id' => 'css_woocommerce_review_form_inputhover_border_color_hover',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_prodrev', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_hover_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input|hover:background',
							'id' => 'css_woocommerce_review_form_inputhover_background_hover',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:hover',
							'style' => 'background',
							'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input|hover:gradient',
							'id' => 'css_woocommerce_review_form_inputhover_gradient_hover',
							'selector' => '.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:hover',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product rating ----------------------------------------------------

   			'product_rating' => array(
   				'type' => 'product_rating',
   				'title' => __('Product rating', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'attr' => array(
   				//'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'id' => 'info',
							'class' => 'mfn-alert',
   						'type' => 'info',
   						'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'title' => __('Rating', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-review-link:color',
							'id' => 'css_woocommerce-review-link_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-review-link',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .star-rating span:color',
							'id' => 'css_star-ratingspan_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .star-rating span',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Active stars color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .star-rating|before:color',
							'id' => 'css_star-ratingbefore_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .star-rating:before',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Inactive stars color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-rating:text-align',
							'id' => 'css_woocommerce-product-rating_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-rating',
							'style' => 'text-align',
							'class' => 'mfn-toggled',
							'responsive' => true,
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),


   			// Product stock ----------------------------------------------------

   			'product_stock' => array(
   				'type' => 'product_stock',
   				'title' => __('Product stock', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'attr' => array(
   				//'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'id' => 'info',
							'class' => 'mfn-alert',
   						'type' => 'info',
   						'title' => __('To display stock, please enable stock management at product level and set its quantity. This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'title' => __('Product stock', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stock:text-align',
							'id' => 'css_stock_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stock',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),
						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stock:typography',
							'id' => 'css_stock_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stock',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stock.in-stock:color',
							'id' => 'css_stockin-stock_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stock.in-stock',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('In stock color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stock.out-of-stock:color',
							'id' => 'css_stockout-of-stock_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stock.out-of-stock',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Out of stock color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product meta ----------------------------------------------------

   			'product_meta' => array(
   				'type' => 'product_meta',
   				'title' => __('Product meta', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'attr' => array(
   				//'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'type' => 'header',
							'title' => __('Options', 'mfn-opts'),
						),

						array(
							'id' => 'layout',
							'attr_id' => 'prod_meta_layout',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Layout', 'mfn-opts'),
							'options' => [
								'inline' => __('Inline', 'mfn-opts'),
								'stacked' => __('Stacked', 'mfn-opts'),
								'table' => __('Table', 'mfn-opts'),
							],
							'std' => 'inline',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'title' => __('Container', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta th, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta td:text-align',
							'id' => 'css_text_align',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta th, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta td',
   						'style' => 'text-align',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta .stacked-meta li:border-color',
							'id' => 'css_product_metastacked-metali_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta .stacked-meta li',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Stacked line color', 'mfn-opts'),
						),

						array(
							'title' => __('Label', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.tagged_as,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.posted_in,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.stacked-meta-title,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .table-meta th:typography',
							'id' => 'css_product_meta_typography',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.tagged_as,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.posted_in,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.stacked-meta-title,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .table-meta th',
   						'style' => 'typography',
   						'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.tagged_as,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.posted_in,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.stacked-meta-title,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .table-meta th:color',
							'id' => 'css_product_meta_color',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.tagged_as,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.posted_in,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.stacked-meta-title,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .table-meta th',
   						'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Value', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .table-meta td,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .table-meta td,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .table-meta td a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta .stacked-categories span.stacked-meta-value a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.posted_in a:color',
							'id' => 'css_product_meta_links_color',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .table-meta td,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .table-meta td,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .table-meta td a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta .stacked-categories span.stacked-meta-value a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.posted_in a',
   						'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Links color', 'mfn-opts'),
						),

						array(
							'title' => __('Tags', 'mfn-opts'),
							'condition' => array( 'id' => 'prod_meta_layout', 'opt' => 'isnt', 'val' => 'table' ),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta .stacked-meta li.stacked-tags .stacked-meta-value a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .tagged_as a:color',
							'id' => 'css_tags_color',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta .stacked-meta li.stacked-tags .stacked-meta-value a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .tagged_as a',
   						'style' => 'color',
							'condition' => array( 'id' => 'prod_meta_layout', 'opt' => 'isnt', 'val' => 'table' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta .stacked-meta li.stacked-tags .stacked-meta-value a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .tagged_as a:background',
							'id' => 'css_tags_bg',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta .stacked-meta li.stacked-tags .stacked-meta-value a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .tagged_as a',
   						'style' => 'background',
							'condition' => array( 'id' => 'prod_meta_layout', 'opt' => 'isnt', 'val' => 'table' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'title' => __('SKU', 'mfn-opts'),
							'condition' => array( 'id' => 'prod_meta_layout', 'opt' => 'isnt', 'val' => 'table' ),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stacked-sku .stacked-meta-value,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta .sku_wrapper:color',
							'id' => 'css_sku_color',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stacked-sku .stacked-meta-value,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta .sku_wrapper',
   						'style' => 'color',
							'condition' => array( 'id' => 'prod_meta_layout', 'opt' => 'isnt', 'val' => 'table' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stacked-sku .stacked-meta-value,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta .sku_wrapper:background',
							'id' => 'css_sku_bg',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stacked-sku .stacked-meta-value,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta .sku_wrapper',
   						'style' => 'background',
							'condition' => array( 'id' => 'prod_meta_layout', 'opt' => 'isnt', 'val' => 'table' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stacked-sku .stacked-meta-value,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta .sku_wrapper:border-color',
							'id' => 'css_sku_border_color',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stacked-sku .stacked-meta-value,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta .sku_wrapper',
   						'style' => 'border-color',
							'condition' => array( 'id' => 'prod_meta_layout', 'opt' => 'isnt', 'val' => 'table' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product short_description ----------------------------------------------------

   			'product_short_description' => array(
   				'type' => 'product_short_description',
   				'title' => __('Short description', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'attr' => array(
   				//'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'id' => 'info',
							'class' => 'mfn-alert',
   						'type' => 'info',
   						'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'title' => __('Description', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-details__short-description:text-align',
							'id' => 'css_woocommerce-product-details_short-description_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-details__short-description',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-details__short-description:typography',
							'id' => 'css_woocommerce-product-details_short-description_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-details__short-description',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-details__short-description:color',
							'id' => 'css_woocommerce-product-details__short-description_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-details__short-description',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product tabs ----------------------------------------------------

   			'product_tabs' => array(
   				'type' => 'product_tabs',
   				'title' => __('Product tabs', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'attr' => array(
   				//'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'type' => 'header',
							'title' => __('Navigation', 'mfn-opts'),
						),

						array(
							'id' => 'nav',
							'attr_id' => 'nav',
							'type' => 'select',
							'title' => __('Position', 'mfn-opts'),
							'options' => [
								'' => __('Top', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs.mfn-woocommerce-tabs-nav-top .mfn-woocommerce-tabs-nav:justify-content',
							'id' => 'css_woocommerce-tabs-nav-top-woocommerce-tabs-nav_justify_content',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs.mfn-woocommerce-tabs-nav-top .mfn-woocommerce-tabs-nav',
							'style' => 'justify-content',
							'type' => 'select',
							'condition' => array( 'id' => 'nav', 'opt' => 'is', 'val' => '' ),
							'title' => __('Align', 'mfn-opts'),
							'options' => [
								'' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'flex-end' => __('Right', 'mfn-opts'),
								'space-around' => __('Space around', 'mfn-opts'),
								'space-between' => __('Space between', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Navigation', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav:background-color',
							'id' => 'css_woocommerce-tabs-nav_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav:padding',
							'id' => 'css_woocommerce-tabs-nav_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav:margin',
							'id' => 'css_woocommerce-tabs-nav_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav:border-style',
							'id' => 'css_woocommerce-tabs-nav_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav',
							'style' => 'border-style',
							'attr_id' => 'border_tabs_nav_ul',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav:border-color',
							'id' => 'css_woocommerce-tabs-nav_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_tabs_nav_ul', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav:border-width',
							'id' => 'css_woocommerce-tabs-nav_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_tabs_nav_ul', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav:border-radius',
							'id' => 'css_woocommerce-tabs-nav_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Nav items', 'mfn-opts'),
						),

		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a:padding',
							'id' => 'css_woocommerce-tabs-navlia_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li:margin',
							'id' => 'css_woocommerce-tabs-navli_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a:typography',
							'id' => 'css_woocommerce-tabs-navlia_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a:border-style',
							'id' => 'css_woocommerce-tabs-navlia_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a',
							'style' => 'border-style',
							'attr_id' => 'border_tabs_nav_ul_li',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a:border-width',
							'id' => 'css_woocommerce-tabs-navlia_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_tabs_nav_ul_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a:border-radius',
							'id' => 'css_woocommerce-tabs-navlia_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),




		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a:color',
							'id' => 'css_woocommerce-tabs-navlia_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a:background-color',
							'id' => 'css_woocommerce-tabs-navlia_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a:border-color',
							'id' => 'css_woocommerce-tabs-navlia_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_tabs_nav_ul_li', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a|hover:color',
							'id' => 'css_woocommerce-tabs-navlia_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a|hover:background-color',
							'id' => 'css_woocommerce-tabs-navliahover_background_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a:hover',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a|hover:border-color',
							'id' => 'css_woocommerce-tabs-navliahover_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li a:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_tabs_nav_ul_li', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li.active a:color',
							'id' => 'css_woocommerce-tabs-navlia_color_active',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li.active a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li.active a:background-color',
							'id' => 'css_woocommerce-tabs-navlia_background_color_active',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li.active a',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li.active a:border-color',
							'id' => 'css_woocommerce-tabs-navlia_border_color_active',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav li.active a',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_tabs_nav_ul_li', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),



						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Content', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-content:background-color',
							'id' => 'css_woocommerce-tabs-content_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-content',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-content:padding',
							'id' => 'css_woocommerce-tabs-content_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-content',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-content:border-style',
							'id' => 'css_woocommerce-tabs-content_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-content',
							'style' => 'border-style',
							'attr_id' => 'border_tabs_content',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-content:border-width',
							'id' => 'css_woocommerce-tabs-content_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-content',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_tabs_content', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-content:border-color',
							'id' => 'css_woocommerce-tabs-content_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-content',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_tabs_content', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-content:border-radius',
							'id' => 'css_woocommerce-tabs-content_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-tabs .mfn-woocommerce-tabs-content',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Product content ----------------------------------------------------

   			'product_content' => array(
   				'type' => 'product_content',
   				'title' => __('Product content', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'attr' => array(
   				//'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'type' => 'header',
							'title' => __('Content', 'mfn-opts'),
						),

						array(
							'id' => 'content',
							're_render' => true,
							'type' => 'select',
							'title' => __('Source', 'mfn-opts'),
							'options' => array(
								'' => __('Default (BeBuilder)', 'mfn-opts'),
								'standard' => __('Product description', 'mfn-opts'),
							),
							'std' => '',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'id' => 'info',
							'class' => 'mfn-alert',
							'type' => 'info',
							'title' => __('This element has no attributes. Please check <b>advanced</b> tab for more customisation options.', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Product additional information ----------------------------------------------------

   			'product_additional_information' => array(
   				'type' => 'product_additional_information',
   				'title' => __('Additional information', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'attr' => array(
   				//'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'type' => 'header',
							'title' => __('Options', 'mfn-opts'),
						),

						array(
							'id' => 'title',
							'attr_id' => 'title',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Title', 'mfn-opts'),
							'options' => [
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							],
							'std' => '1',
						),

						array(
							'id' => 'title_tag',
							'condition' => array( 'id' => 'title', 'opt' => 'is', 'val' => '1' ),
							'type' 	=> 'switch',
							're_render' => true,
							'title' => __('Title tag', 'mfn-opts'),
							'options' => array(
                'h1' => 'h1',
                'h2' => 'h2',
                'h3' => 'h3',
                'h4' => 'h4',
                'h5' => 'h5',
                'h6' => 'h6',
                'p' => 'p',
                'p.lead' => 'p.lead',
                'span' => 'span',
							),
							'std' => 'h3',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'title' => __('Item title', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
   						'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:text-align',
							'id' => 'css_title_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title',
							'style' => 'text-align',
   						'type' => 'switch',
   						'class' => 'mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:color',
							'id' => 'css_title_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:margin',
							'id' => 'css_title_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:typography',
							'id' => 'css_title_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Content', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes th, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes td:text-align',
							'id' => 'css_woocommerce-product-attributesthwoocommerce-product-attributestd_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes th, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes td',
							'style' => 'text-align',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes th:color',
							'id' => 'css_woocommerce-product-attributesth_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes th',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Label color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes td,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes td a:color',
							'id' => 'css_woocommerce-product-attributestdwoocommerce-product-attributestda_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes td,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes td a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Value color', 'mfn-opts'),
						),

						array(
							'title' => __('Line', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.woocommerce-product-attributes td span|before:background',
							'id' => 'css_tablewoocommerce-product-attributestdspanbefore_background',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.woocommerce-product-attributes td span:before',
							'style' => 'background',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						// HTML end: style

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Product related ----------------------------------------------------

   			'product_related' => array(
   				'type' => 'product_related',
   				'title' => __('Product related', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'attr' => array(
   				//'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'id' => 'heading_tag',
							'type' 	=> 'switch',
							're_render' => true,
							'title' => __('Heading tag', 'mfn-opts'),
							'options' => array(
                'h1' => 'h1',
                'h2' => 'h2',
                'h3' => 'h3',
                'h4' => 'h4',
                'h5' => 'h5',
                'h6' => 'h6',
                'p' => 'p',
                'p.lead' => 'p.lead',
                'span' => 'span',
							),
							'std' => 'h3',
						),

						array(
   						'id' => 'products',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Products per page', 'mfn-opts'),
   						'std' => '4',
   						'after' => 'products',
   						'param' => 'number',
   						'class' => 'narrow',
   					),

						array(
   						'id' => 'columns',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Columns', 'mfn-opts'),
   						'std' => '4',
   						'after' => 'columns',
   						'param' => 'number',
   						'class' => 'narrow',
   					),

						// options

   					array(
   						'type' => 'header',
   						'title' => __('Options', 'mfn-opts'),
   					),

						array(
							'id' => 'button',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Add to cart button', 'mfn-opts'),
							'desc' => __('Required for some plugins', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => '0',
						),

						array(
							'id' => 'description',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Description', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => '0'
						),

						array(
							'type' => 'header',
							'title' => __('Order', 'mfn-opts'),
						),

						array(
							'id' => 'order',
							'type' => 'order',
							're_render' => true,
							'title' => __('Order', 'mfn-opts'),
							'std' => 'image,title,price,description,button',
						),

						array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'span' => 'span',
							],
							'std' => 'h2',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'title' => __('Item title', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'id' => 'css_relatedtitle_display',
							'attr_id' => 'css_relatedtitle_display',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title',
							'style' => 'display',
							'type' => 'switch',
							'title' => __('Visibility', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'none' => __('Hidden', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title:text-align',
							'id' => 'css_relatedtitle_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'condition' => array( 'id' => 'css_relatedtitle_display', 'opt' => 'is', 'val' => '' ),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title:color',
							'id' => 'css_relatedtitle_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title',
							'style' => 'color',
							'type' => 'color',
							'condition' => array( 'id' => 'css_relatedtitle_display', 'opt' => 'is', 'val' => '' ),
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title:margin',
							'id' => 'css_relatedtitle_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title',
							'style' => 'margin',
							'condition' => array( 'id' => 'css_relatedtitle_display', 'opt' => 'is', 'val' => '' ),
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title:typography',
							'id' => 'css_relatedtitle_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title',
							'style' => 'typography',
							'responsive' => true,
							'condition' => array( 'id' => 'css_relatedtitle_display', 'opt' => 'is', 'val' => '' ),
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:text-align',
							'id' => 'css_product_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'text-align',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:background-color',
							'id' => 'css_product_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:padding',
							'id' => 'css_product_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-style',
							'id' => 'css_product_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-style',
							'attr_id' => 'border_style_shop_li',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-color',
							'id' => 'css_product_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-width',
							'id' => 'css_product_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-radius',
							'id' => 'css_product_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-style',
							'id' => 'css_product_image_frame_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-style',
							'attr_id' => 'border_style_shopimg',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-color',
							'id' => 'css_product_image_frame_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-width',
							'id' => 'css_product_image_frame_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-radius',
							'id' => 'css_product_image_frame_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_product_image_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),


		  			array(
							'id' => 'css_product_image_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .mfn-li-product-row-image',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			// title

						array(
							'title' => __('Title', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:color',
							'id' => 'css_product_title_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:margin',
							'id' => 'css_product_title_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:typography',
							'id' => 'css_product_title_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Price', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:color',
							'id' => 'css_product_price_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:margin',
							'id' => 'css_product_price_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:typography',
							'id' => 'css_product_price_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Desc', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:margin',
							'id' => 'css_product_excerpt_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:typography',
							'id' => 'css_product_excerpt_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:color',
							'id' => 'css_product_excerpt_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Attributes', 'mfn-opts'),
   					),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a:border-color',
							'id' => 'css_variations-wrapper-loop-vrul-vr-optionslia_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a|hover:border-color',
							'id' => 'css_variations-wrapper-loop-vrul-vr-optionsliahover_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a:hover',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color on Hover', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a:color',
							'id' => 'css_variations-wrapper-loop-vrul-vr-optionslia_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Label color', 'mfn-opts'),
						),







		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Badge', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_product_onsale_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'border-style',
							'attr_id' => 'border_style_badge',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_product_onsale_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_product_onsale_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
   						'id' => 'css_product_onsale_align',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges',
   						'style' => 'align-items',
							'responsive' => true,
							'class' => 'mfn-toggled',
   						'type' => 'switch',
   						'title' => __('Alignment', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'flex-start' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'flex-end' => __('Right', 'mfn-opts'),
   						),
   						'std' => ''
   					),

   					array(
							'id' => 'product_badge_onsale_position',
							'attr_id' => 'product_badge_onsale_position',
							'type' => 'switch',
							'class' => 'mfn-toggled archive_badge_onsale_position',
							'title' => __('Position X', 'mfn-opts'),
							'options' => array(
		  					'' => __('Left', 'mfn-opts'),
		  					'right' => __('Right', 'mfn-opts'),
		  				),
		  				'std' => '',
						),

						array(
							'id' => 'css_product_onsale_offset_left',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges-left li.product .mfn-product-badges',
							'style' => 'left',
		  				'type' => 'sliderbar',
		  				'condition' => array( 'id' => 'product_badge_onsale_position', 'opt' => 'is', 'val' => '' ),
		  				'title' => __('Offset left', 'mfn-opts'),
							'responsive' => true,
							'default_unit' => 'px',
							'class' => 'narrow mfn-toggled',
							'param' => array(
								'unit' => 'px',
								'min' => '-100',
								'max' => '300',
								'step' => '1',
							),
		  			),

		  			array(
							'id' => 'css_product_onsale_offset_right',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges-right li.product .mfn-product-badges',
							'style' => 'right',
		  				'type' => 'sliderbar',
		  				'condition' => array( 'id' => 'product_badge_onsale_position', 'opt' => 'is', 'val' => 'right' ),
		  				'title' => __('Offset right', 'mfn-opts'),
							'responsive' => true,
							'default_unit' => 'px',
							'class' => 'narrow mfn-toggled',
							'param' => array(
								'unit' => 'px',
								'min' => '-100',
								'max' => '300',
								'step' => '1',
							),
		  			),

		  			array(
							'id' => 'css_product_onsale_offset_top',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges',
							'style' => 'top',
		  				'type' => 'sliderbar',
		  				'title' => __('Offset top', 'mfn-opts'),
							'responsive' => true,
							'default_unit' => 'px',
							'class' => 'narrow mfn-toggled',
							'param' => array(
								'unit' => 'px',
								'min' => '-100',
								'max' => '300',
								'step' => '1',
							),
		  			),

		  			array(
							'id' => 'css_product_onsale_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled mfn-onsale-label',
							'title' => __('Default label (Sale)', 'mfn-opts'),
						),

		  			array(
							'id' => 'css_product_onsale_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'border-color',
							'type' => 'color',
							'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Label (New)', 'mfn-opts'),
						),

		  			array(
							'id' => 'css_product_onsale_new_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.mfn-new-badge.onsale',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_new_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.mfn-new-badge.onsale',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_new_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.mfn-new-badge.onsale',
							'style' => 'border-color',
							'type' => 'color',
							'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),


						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Extra label', 'mfn-opts'),
						),

		  			array(
							'id' => 'css_product_onsale_extra_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale.onsale-extra-label',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_extra_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale.onsale-extra-label',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_extra_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale.onsale-extra-label',
							'style' => 'border-color',
							'type' => 'color',
							'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),







						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:padding',
							'id' => 'css_product_button_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:typography',
							'id' => 'css_products_button_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-style',
							'id' => 'css_product_button_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-style',
							'attr_id' => 'border_style_bsb',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-width',
							'id' => 'css_product_button_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-radius',
							'id' => 'css_product_button_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:color',
							'id' => 'css_product_button_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-color',
							'id' => 'css_product_button_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:background-color',
							'id' => 'css_product_button_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'background-color',
							'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:gradient',
							'id' => 'css_product_button_gradient',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:color',
							'id' => 'css_product_button_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:border-color',
							'id' => 'css_product_button_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_hover_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:background',
							'id' => 'css_product_button_background_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover, .mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:before',
							'style' => 'background',
							'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:gradient',
							'id' => 'css_product_button_gradient_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'title' => __('Rating', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating:display',
							'id' => 'css_product_star-rating_display',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating',
							'style' => 'display',
							'attr_id' => 'shop-list-rating',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Visibility', 'mfn-opts'),
							'options' => [
								'' => __('Visible', 'mfn-opts'),
								'none' => __('Hidden', 'mfn-opts'),
							],
							'std' => ''
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating span:color',
							'id' => 'css_product_star-ratingspan_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating span',
							'style' => 'color',
							'condition' => array( 'id' => 'shop-list-rating', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product upsells ----------------------------------------------------

   			'product_upsells' => array(
   				'type' => 'product_upsells',
   				'title' => __('Product upsells', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'attr' => array(
   				//'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
							'id' => 'heading_tag',
							'type' 	=> 'switch',
							're_render' => true,
							'title' => __('Heading tag', 'mfn-opts'),
							'options' => array(
                'h1' => 'h1',
                'h2' => 'h2',
                'h3' => 'h3',
                'h4' => 'h4',
                'h5' => 'h5',
                'h6' => 'h6',
                'p' => 'p',
                'p.lead' => 'p.lead',
                'span' => 'span',
							),
							'std' => 'h3',
						),

						array(
   						'id' => 'products',
   						're_render' => true,
   						'type' => 'text',
   						'title' => __('Products per page', 'mfn-opts'),
   						'std' => '4',
   						'after' => 'products',
   						'param' => 'number',
   						'class' => 'narrow',
   					),

						array(
   						'id' => 'columns',
   						're_render' => true,
   						'type' => 'text',
   						'title' => __('Columns', 'mfn-opts'),
   						'std' => '4',
   						'after' => 'columns',
   						'param' => 'number',
   						'class' => 'narrow',
   					),

						// options

   					array(
   						'type' => 'header',
   						'title' => __('Options', 'mfn-opts'),
   					),

						array(
							'id' => 'button',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Add to cart button', 'mfn-opts'),
							'desc' => __('Required for some plugins', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => '0',
						),

						array(
							'id' => 'description',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Description', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => '0'
						),

						array(
							'type' => 'header',
							'title' => __('Order', 'mfn-opts'),
						),

						array(
							'id' => 'order',
							'type' => 'order',
							're_render' => true,
							'title' => __('Order', 'mfn-opts'),
							'std' => 'image,title,price,description,button',
						),

						array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'span' => 'span',
							],
							'std' => 'h2',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'title' => __('Item title', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title:text-align',
							'id' => 'css_upsellstitle_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title',
							'style' => 'text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'responsive' => true,
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),
						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title:color',
							'id' => 'css_upsellstitle_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title:margin',
							'id' => 'css_upsellstitle_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title:typography',
							'id' => 'css_upsellstitle_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:text-align',
							'id' => 'css_product_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'text-align',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:background-color',
							'id' => 'css_product_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:padding',
							'id' => 'css_product_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-style',
							'id' => 'css_product_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-style',
							'attr_id' => 'border_style_shop_li',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-color',
							'id' => 'css_product_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-width',
							'id' => 'css_product_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-radius',
							'id' => 'css_product_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-style',
							'id' => 'css_product_image_frame_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-style',
							'attr_id' => 'border_style_shopimg',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-color',
							'id' => 'css_product_image_frame_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-width',
							'id' => 'css_product_image_frame_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-radius',
							'id' => 'css_product_image_frame_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_product_image_bg',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),


		  			array(
							'id' => 'css_product_image_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .mfn-li-product-row-image',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			// title

						array(
							'title' => __('Title', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:color',
							'id' => 'css_product_title_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:margin',
							'id' => 'css_product_title_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:typography',
							'id' => 'css_product_title_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Price', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:color',
							'id' => 'css_product_price_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:margin',
							'id' => 'css_product_price_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:typography',
							'id' => 'css_product_price_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Desc', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:margin',
							'id' => 'css_product_excerpt_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:typography',
							'id' => 'css_product_excerpt_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:color',
							'id' => 'css_product_excerpt_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Attributes', 'mfn-opts'),
   					),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a:border-color',
							'id' => 'css_variations-wrapper-loop-vrul-vr-optionslia_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a|hover:border-color',
							'id' => 'css_variations-wrapper-loop-vrul-vr-optionsliahover_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a:hover',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color on Hover', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a:color',
							'id' => 'css_variations-wrapper-loop-vrul-vr-optionslia_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a',
							'style' => 'color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Label color', 'mfn-opts'),
						),

		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Badge', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_product_onsale_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'border-style',
							'attr_id' => 'border_style_badge',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'css_product_onsale_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
							'id' => 'css_product_onsale_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),

		  			array(
   						'id' => 'css_product_onsale_align',
   						'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges',
   						'style' => 'align-items',
							'responsive' => true,
							'class' => 'mfn-toggled',
   						'type' => 'switch',
   						'title' => __('Alignment', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'flex-start' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'flex-end' => __('Right', 'mfn-opts'),
   						),
   						'std' => ''
   					),

   					array(
							'id' => 'product_badge_onsale_position',
							'attr_id' => 'product_badge_onsale_position',
							'type' => 'switch',
							'class' => 'mfn-toggled archive_badge_onsale_position',
							'title' => __('Position X', 'mfn-opts'),
							'options' => array(
		  					'' => __('Left', 'mfn-opts'),
		  					'right' => __('Right', 'mfn-opts'),
		  				),
		  				'std' => '',
						),

						array(
							'id' => 'css_product_onsale_offset_left',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges-left li.product .mfn-product-badges',
							'style' => 'left',
		  				'type' => 'sliderbar',
		  				'condition' => array( 'id' => 'product_badge_onsale_position', 'opt' => 'is', 'val' => '' ),
		  				'title' => __('Offset left', 'mfn-opts'),
							'responsive' => true,
							'default_unit' => 'px',
							'class' => 'narrow mfn-toggled',
							'param' => array(
								'unit' => 'px',
								'min' => '-100',
								'max' => '300',
								'step' => '1',
							),
		  			),

		  			array(
							'id' => 'css_product_onsale_offset_right',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-badges-right li.product .mfn-product-badges',
							'style' => 'right',
		  				'type' => 'sliderbar',
		  				'condition' => array( 'id' => 'product_badge_onsale_position', 'opt' => 'is', 'val' => 'right' ),
		  				'title' => __('Offset right', 'mfn-opts'),
							'responsive' => true,
							'default_unit' => 'px',
							'class' => 'narrow mfn-toggled',
							'param' => array(
								'unit' => 'px',
								'min' => '-100',
								'max' => '300',
								'step' => '1',
							),
		  			),

		  			array(
							'id' => 'css_product_onsale_offset_top',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges',
							'style' => 'top',
		  				'type' => 'sliderbar',
		  				'title' => __('Offset top', 'mfn-opts'),
							'responsive' => true,
							'default_unit' => 'px',
							'class' => 'narrow mfn-toggled',
							'param' => array(
								'unit' => 'px',
								'min' => '-100',
								'max' => '300',
								'step' => '1',
							),
		  			),

		  			array(
							'id' => 'css_product_onsale_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled mfn-onsale-label',
							'title' => __('Default label (Sale)', 'mfn-opts'),
						),

		  			array(
							'id' => 'css_product_onsale_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale',
							'style' => 'border-color',
							'type' => 'color',
							'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Label (New)', 'mfn-opts'),
						),

		  			array(
							'id' => 'css_product_onsale_new_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.mfn-new-badge.onsale',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_new_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.mfn-new-badge.onsale',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_new_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.mfn-new-badge.onsale',
							'style' => 'border-color',
							'type' => 'color',
							'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),


						array(
							'type' => 'subheader',
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Extra label', 'mfn-opts'),
						),

		  			array(
							'id' => 'css_product_onsale_extra_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale.onsale-extra-label',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_extra_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale.onsale-extra-label',
							'style' => 'background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'css_product_onsale_extra_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .products li.product .mfn-product-badges span.onsale.onsale-extra-label',
							'style' => 'border-color',
							'type' => 'color',
							'condition' => array( 'id' => 'border_style_badge', 'opt' => 'isnt', 'val' => 'none' ),
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),



						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:padding',
							'id' => 'css_product_button_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:typography',
							'id' => 'css_products_button_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-style',
							'id' => 'css_product_button_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-style',
							'attr_id' => 'border_style_bsb',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-width',
							'id' => 'css_product_button_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-radius',
							'id' => 'css_product_button_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:color',
							'id' => 'css_product_button_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-color',
							'id' => 'css_product_button_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:background-color',
							'id' => 'css_product_button_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'background-color',
							'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:gradient',
							'id' => 'css_product_button_gradient',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:color',
							'id' => 'css_product_button_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:border-color',
							'id' => 'css_product_button_border_color_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_hover_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history mfn-disable-reset-value',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:background',
							'id' => 'css_product_button_background_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover, .mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:before',
							'style' => 'background',
							'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:gradient',
							'id' => 'css_product_button_gradient_hover',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:hover',
							'style' => 'gradient',
		  				'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'title' => __('Rating', 'mfn-opts'),
							'type' => 'header',
							'class' => 'toggled_header',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating:display',
							'id' => 'css_product_star-rating_display',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating',
							'style' => 'display',
							'attr_id' => 'shop-list-rating',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Visibility', 'mfn-opts'),
							'options' => [
								'' => __('Visible', 'mfn-opts'),
								'none' => __('Hidden', 'mfn-opts'),
							],
							'std' => ''
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating span:color',
							'id' => 'css_product_star-ratingspan_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating span',
							'style' => 'color',
							'condition' => array( 'id' => 'shop-list-rating', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			/* END WOO */

				// Divider NEW ------------------------------------------------------

				'divider_2' => array(
   				'type' => 'divider_2',
   				'title' => '&bull; '. __('Divider', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'other',
   				'attr' => array(
   				//'fields' => array(

						/*array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),*/

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render mfn-class-editor-card-visible modalbox-card-content">',
						),

						array(
							'id' => 'type',
							'attr_id' => 'divider-2-type',
							'type' => 'select',
							'class' => 'mfn-class-editor-form-row-visible',
							'title' => __('Type', 'mfn-opts'),
							're_render' => true,
							'options' => array(
								'' => 'Empty',

								'#optgroup-border' => 'Border',
									'border-solid' => 'Solid',
									'border-dotted' => 'Dotted',
									'border-dashed' => 'Dashed',
									'border-double' => 'Double',
									// if new added please update conditions below
								'#optgroup-border-end' => '',

								'#optgroup-pattern' => 'Pattern',
									'pattern-star' => 'Star',
									'pattern-triangle' => 'Triangle',
									'pattern-plus' => 'Plus',
									'pattern-tree' => 'Tree',
									'pattern-heart' => 'Heart',
									'pattern-question' => 'Question',
									'pattern-gear' => 'Gear',
									'pattern-parquet' => 'Parquet',
									'pattern-sun' => 'Sun',
									'pattern-fence' => 'Fence',
									'pattern-flower' => 'Flower',
									// if new added please update conditions below
								'#optgroup-pattern-end' => '',

								'#optgroup-lines' => 'Lines',
									'pattern-line-wave' => 'Waves',
									'pattern-line-zigzag' => 'Zig Zag',
									'pattern-line-zigzag2' => 'Zig Zag 2',
									'pattern-line-hearts' => 'Hearts',
									'pattern-line-triangles' => 'Triangles',
									'pattern-line-circles' => 'Circles',
									'pattern-line-circles2' => 'Circles 2',
									'pattern-line-circles3' => 'Circles 3',
									'pattern-line-stars' => 'Stars',
									'pattern-line-rhombus' => 'Rhombus',
									'pattern-line-figures' => 'Figures',
									'pattern-line-loopline' => 'Loopline',
									// if new added please update conditions below
								'#optgroup-lines-end' => '',

							),
							'std' => ''
						),

						array(
							'id' => 'align',
							'type' => 'switch',
							'class' => 'mfn-class-editor-form-row-visible',
							'title' => __('Alignment', 'mfn-opts'),
							'responsive' => true,
							'options' => array(
								'start' => __('Start', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'end' => __('End', 'mfn-opts'),
							),
							'std' => 'center',
						),

						// gap

						array(
							'type' => 'header',
							'class' => 'mfn-class-editor-form-row-visible',
							'title' => __('Gap', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-gap-top',
							'id' => 'css_divider_gap_top',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner',
							'style' => '--mfn-divider-gap-top',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'title' => __('Gap top', 'mfn-opts'),
							'responsive' => true,
							'class' => 'narrow mfn-class-editor-form-row-visible',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '200',
								'step' => '1',
							),
							'std' => '20px',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-gap-bottom',
							'id' => 'css_divider_gap_bottom',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner',
							'style' => '--mfn-divider-gap-bottom',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'title' => __('Gap bottom', 'mfn-opts'),
							'responsive' => true,
							'class' => 'narrow mfn-class-editor-form-row-visible',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '200',
								'step' => '1',
							),
							'std' => '20px',
						),
						// addon

						array(
							'type' => 'header',
							'title' => __('Addon', 'mfn-opts'),
						),

						array(
							'id' => 'addon',
							'attr_id' => 'divider-2-addon',
							'type' => 'select',
							'class' => 'mfn-class-editor-form-row-visible',
							'title' => __('Addon', 'mfn-opts'),
							're_render' => true,
							'options' => array(
								'' => 'None',
								'label' => 'Label',
								'image' => 'Image',
								'icon' => 'Icon',
							),
							'std' => ''
						),

						array(
							'id' => 'label',
							'type' => 'text',
							'class' => 'mfn-class-editor-form-row-visible',
							'title' => __('Label', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'label' ),
							're_render' => true,
							'std' => ''
						),

						array(
							'id' => 'image',
							'type' => 'upload',
							'class' => 'mfn-class-editor-form-row-visible',
							'title' => __('Image', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'image' ),
							're_render' => true,
							'std' => ''
						),

						array(
							'id' => 'icon',
							'type' => 'icon',
							'class' => 'mfn-class-editor-form-row-visible',
							'title' => __('Icon', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'icon' ),
							're_render' => true,
							'std' => ''
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style">',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:width',
							'id' => 'css_divider-inner_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner',
							'style' => 'width',
							'type' => 'text',
							'default_unit' => 'px',
							'title' => __('Width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled narrow',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Divider', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-type', 'opt' => 'isnt', 'val' => '' ),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-height',
							'id' => 'css_divider_height',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner',
							'style' => '--mfn-divider-height',
							'type' => 'sliderbar',
							'title' => __('Pattern height', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-type', 'opt' => 'is', 'val' => 'pattern-star,pattern-triangle,pattern-plus,pattern-tree,pattern-heart,pattern-question,pattern-gear,pattern-parquet,pattern-sun,pattern-fence,pattern-flower,pattern-line-wave,pattern-line-zigzag,pattern-line-zigzag2,pattern-line-hearts,pattern-line-triangles,pattern-line-circles,pattern-line-circles2,pattern-line-circles3,pattern-line-stars,pattern-line-rhombus,pattern-line-figures,pattern-line-loopline' ),
							'responsive' => true,
							'class' => 'mfn-toggled narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '100',
								'step' => '1',
							),
						),
						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-pattern-color',
							'id' => 'css_divider_pattern_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner',
							'style' => '--mfn-divider-pattern-color',
							'type' => 'color',
							'title' => __('Pattern color', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-type', 'opt' => 'is', 'val' => 'pattern-star,pattern-triangle,pattern-plus,pattern-tree,pattern-heart,pattern-question,pattern-gear,pattern-parquet,pattern-sun,pattern-fence,pattern-flower,pattern-line-wave,pattern-line-zigzag,pattern-line-zigzag2,pattern-line-hearts,pattern-line-triangles,pattern-line-circles,pattern-line-circles2,pattern-line-circles3,pattern-line-stars,pattern-line-rhombus,pattern-line-figures,pattern-line-loopline' ),
							'class' => 'mfn-toggled',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-border-width',
							'id' => 'css_divider_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner',
							'style' => '--mfn-divider-border-width',
							'type' => 'sliderbar',
							'title' => __('Border width', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-type', 'opt' => 'is', 'val' => 'border-solid,border-dotted,border-dashed,border-double' ),
							'class' => 'mfn-toggled narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '20',
								'step' => '1',
							),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-border-color',
							'id' => 'css_divider_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner',
							'style' => '--mfn-divider-border-color',
							'type' => 'color',
							'title' => __('Border color', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-type', 'opt' => 'is', 'val' => 'border-solid,border-dotted,border-dashed,border-double' ),
							'class' => 'mfn-toggled',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'title' => __('Addon', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'isnt', 'val' => '' ),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-spacing',
							'id' => 'css_divider_spacing',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner',
							'style' => '--mfn-divider-spacing',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'responsive' => true,
							'class' => 'mfn-toggled narrow sliderbar-units',
							'title' => __('Spacing', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0, 'max' => 10, 'step' => 0.1),
								'rem' => array('min' => 0, 'max' => 10, 'step' => 0.1),
								'vw' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
							),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-icon i:font-size',
							'id' => 'css_divider-innerdivider-iconi_font_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-icon i',
							'style' => 'font-size',
							'type' => 'sliderbar',
							'title' => __('Icon size', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'icon' ),
							'responsive' => true,
							'class' => 'mfn-toggled narrow sliderbar-units',
							'units' => array(
								'px' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0, 'max' => 10, 'step' => 0.1),
								'rem' => array('min' => 0, 'max' => 10, 'step' => 0.1),
								'vw' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
							),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-icon-color',
							'id' => 'css_divider_icon_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner',
							'style' => '--mfn-divider-icon-color',
							'type' => 'color',
							'title' => __('Icon color', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'icon' ),
							'class' => 'mfn-toggled',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-image img:height',
							'id' => 'css_divider-innerdivider-imageimg_height',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-image img',
							'style' => 'height',
							'type' => 'sliderbar',
							'title' => __('Image height', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'image' ),
							'responsive' => true,
							'class' => 'mfn-toggled narrow sliderbar-units',
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-label:color',
							'id' => 'css_divider-innerdivider-label_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-label',
							'style' => 'color',
							'type' => 'color',
							'title' => __('Text color', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'label' ),
							'class' => 'mfn-toggled',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-label:typography',
							'id' => 'css_divider-innerdivider-label_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-label',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'title' => __('Typography', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'label' ),
							'class' => 'mfn-toggled toggle_fields',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-addon:background-color',
							'id' => 'css_divider-innerdivider-addon_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-addon',
							'style' => 'background-color',
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
							'class' => 'mfn-toggled',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-label:padding',
							'id' => 'css_divider-innerdivider-label_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-label',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'label' ),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-addon-width',
							'id' => 'css_divider_addon_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner',
							'style' => '--mfn-divider-addon-width',
							'type' => 'sliderbar',
							'title' => __('Width', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'isnt', 'val' => 'label' ),
							'responsive' => true,
							'class' => 'mfn-toggled narrow sliderbar-units',
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							),
						),
						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-addon-height',
							'id' => 'css_divider_addon_height',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner',
							'style' => '--mfn-divider-addon-height',
							'type' => 'sliderbar',
							'title' => __('Height', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'isnt', 'val' => 'label' ),
							'responsive' => true,
							'class' => 'mfn-toggled narrow sliderbar-units',
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-addon:border-style',
							'id' => 'css_divider-innerdivider-addon_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-addon',
							'style' => 'border-style',
							'attr_id' => 'divider-2-addon-border',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-addon:border-color',
							'id' => 'css_divider-innerdivider-addon_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-addon',
							'style' => 'border-color',
							'condition' => array( 'id' => 'divider-2-addon-border', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-addon:border-width',
							'id' => 'css_divider-innerdivider-addon_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-addon',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'divider-2-addon-border', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'class' => 'mfn-toggled',
		  			),


						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-addon:border-radius',
							'id' => 'css_divider-innerdivider-addon_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-addon',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

					),
				),

				// Divider Basic -------------------------------------------------------

   			'divider' => array(
   				'type' => 'divider',
   				'title' => '&bull; '. __('Divider Basic', 'mfn-opts'),
   				// 'title' => '&bull; '. __('Divider', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'other',
   				'attr' => array(
   				//'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

   					array(
   						'id' => 'height',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Height', 'mfn-opts'),
							'param' => 'number',
							'class' => 'narrow',
							'after' => 'px',
   					),

   					array(
   						'id' => 'style',
							'attr_id' => 'divider_style',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'default' => __('Default', 'mfn-opts'),
   							'dots' => __('Dots', 'mfn-opts'),
   							'zigzag' => __('ZigZag', 'mfn-opts'),
   						),
							'std' => 'default',
   					),

   					array(
   						'id' => 'line',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Line', 'mfn-opts'),
							'condition' => array( 'id' => 'divider_style', 'opt' => 'is', 'val' => 'default' ),
   						'options' => array(
								'' => __('No line', 'mfn-opts'),
   							'default' => __('Default', 'mfn-opts'),
   							'narrow' => __('Narrow', 'mfn-opts'),
   							'wide' => __('Wide', 'mfn-opts'),
   						),
							'std' => '',
   					),

   					array(
   						'id' => 'color',
   						'type' => 'color',
   						're_render' => true,
   						'title' => __('Color', 'mfn-opts'),
							'alpha' => true,
   					),

   					array(
   						'id' => 'themecolor',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Theme color', 'mfn-opts'),
   						'desc' => __('Overwrites color selected above', 'mfn-opts'),
   						'options' => array(
   							0 => __('No', 'mfn-opts'),
   							1 => __('Yes', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// deprecated

						array(
							'type' => 'header',
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Placeholder ----------------------------------------------------

   			'placeholder' => array(
   				'type' => 'placeholder',
   				'title' => '&bull; '. __('Placeholder', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'other',
   				'attr' => array(
   				//'fields' => array(

   					array(
   						'id' => 'info',
   						'class' => 'mfn-alert',
   						'type' => 'info',
   						'title' => __('This item has no attributes.', 'mfn-opts'),
   					),

   				),
   			),

   			// Spacer ------------------------------------------------------

   			'spacer' => array(
   				'type' => 'spacer',
   				'title' => __('Spacer', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'attr' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content mfn-class-editor-card-visible">',
						),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:height',
							'id' => 'css_mcb-column-inner_height',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner',
							'style' => 'height',
							'type' => 'sliderbar',
							'responsive' => true,
							'class' => 'sliderbar-units mfn-class-editor-form-row-visible',
							'title' => __('Height', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 1000, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'vh' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),

   			),

   			// Accordion  -----------------------------------------------------

   			'accordion' => array(
   				'type' => 'accordion',
   				'title' => __('Accordion', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'blocks',
   				'attr' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
   						'id' => 'info-key',
   						'class' => 'mfn-alert',
   						'type' => 'info',
   						'title' => __('Try the new Toggle element with unlimited customization options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.accordion | .heading',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
   						'dynamic_data' => 'title',
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
							'id' => 'title_tag',
							'type' 	=> 'switch',
							're_render' => true,
							'title' => __('Title tag', 'mfn-opts'),
							'options' => array(
                'h1' => 'h1',
                'h2' => 'h2',
                'h3' => 'h3',
                'h4' => 'h4',
                'h5' => 'h5',
                'h6' => 'h6',
                'p' => 'p',
                'p.lead' => 'p.lead',
                'span' => 'span',
							),
							'std' => 'h4',
						),

						// tabs

						array(
							'type' => 'header',
   						'title' => __('Tabs', 'mfn-opts'),
   					),

   					array(
   						'id' => 'tabs',
   						'type' => 'tabs',
   						'title' => __('Accordion', 'mfn-opts'),
   						'desc' => __('<b>JavaScript</b> content like Google Maps and some plugins shortcodes do <b>not work</b> in tabs', 'mfn-opts'),
							'options' => [
								'title' => [
									'input',
									__('Title', 'mfn-opts'),
									__('Sample tab', 'mfn-opts'),
								],
								'content' => [
									'textarea',
									__('Content', 'mfn-opts'),
									'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
							],
							'std' => [
								0 => [
									'title' => __('This is the 1st item', 'mfn-opts'),
									'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
								1 => [
									'title' => __('This is the 2nd item', 'mfn-opts'),
									'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
							],
							'preview' => 'tabs',
							'primary' => 'title', // default
   					),

   					array(
   						'type' => 'header',
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
   						'id' => 'icon_active',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						// options

						array(
							'type' => 'header',
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'open1st',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Open first', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default', 'mfn-opts'),
   							1 => __('Open first', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
   						'id' => 'openAll',
   						're_render' => true,
   						'type' => 'switch',
							'title' => __('Open all', 'mfn-opts'),
   						'options' => array(
								0 => __('Default', 'mfn-opts'),
   							1 => __('Open all', 'mfn-opts'),
							),
							'std' => 0,
   					),

   					array(
   						'id' => 'style',
   						'type' => 'switch',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'accordion' => __('Accordion', 'mfn-opts'),
   							'toggle' => __('Toggle', 'mfn-opts'),
   						),
							'std' => 'accordion',
   					),

						// deprecated

						array(
							'type' => 'header',
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .heading:color',
							'id' => 'css_accordionheading_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .heading',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .heading:margin',
							'id' => 'css_accordionheading_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .heading',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .heading:typography',
							'id' => 'css_accordionheading_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .heading',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Title bar', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:color',
							'id' => 'css_questiontitle_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:background',
							'id' => 'css_question_title_background',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title',
							'style' => 'background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active .title:color',
							'id' => 'css_question_activetitle_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active .title',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active .title:background',
							'id' => 'css_question_activetitle_background',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active .title',
							'style' => 'background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:margin',
							'id' => 'css_question_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:padding',
							'id' => 'css_questiontitle_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title|before:border-style',
							'id' => 'css_question_titlebefore_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:before',
							'style' => 'border-style',
							'attr_id' => 'border_style_accq',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title|before:border-color',
							'id' => 'css_question_titlebefore_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:before',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_accq', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-width',
							'id' => 'css_question_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_accq', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-radius',
							'id' => 'css_question_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:typography',
							'id' => 'css_question_title_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:box-shadow',
							'id' => 'css_question_title_box_shadow',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title',
							'style' => 'box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Title bar icon', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title i:color',
							'id' => 'css_questiontitlei_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active .title i:color',
							'id' => 'css_question_activetitlei_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active .title i',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title i:font-size',
							'id' => 'css_question_titlei_font_size',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title i',
							'style' => 'font-size',
							'type' => 'sliderbar',
							'responsive' => true,
							'class' => 'mfn-toggled sliderbar-units',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:color',
							'id' => 'css_questionanswer_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:background',
							'id' => 'css_question_answer_background',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer',
							'style' => 'background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:padding',
							'id' => 'css_questionanswer_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:typography',
							'id' => 'css_question_answer_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
							'themeoptions' => 'style:simple',
   						'title' => __('Question line', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'themeoptions' => 'style:simple',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-color',
							'id' => 'css_question_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question',
							'style' => 'border-color',
							'type' => 'color',
							'themeoptions' => 'style:simple',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'themeoptions' => 'style:simple',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active|after:background-color',
							'id' => 'css_question_activeafter_background_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active:after',
							'style' => 'background-color',
							'type' => 'color',
							'themeoptions' => 'style:simple',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'themeoptions' => 'style:simple',
							'html' => '</div></div>',
						),


						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Article box  ---------------------------------------------------

   			'article_box' => array(
   				'type' => 'article_box',
   				'title' => __('Article box', 'mfn-opts'),
   				'size' => '1/3',
   				'tablet_size' => '1/3',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'attr' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content">',
						),

						array(
   						'id' => 'image',
   						'dynamic_data' => 'featured_image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
   						'desc' => __('Recommended image width <b>384px - 960px</b> depending on size of the item', 'mfn-opts'),
							'std' => $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'slogan',
   						'type' => 'text',
   						'dynamic_data' => 'title',
   						'edit_tag' => '.desc_wrapper | p',
   						'edit_tagchild' => 'span',
   						'edit_position' => 'prepend',
   						'title' => __('Slogan', 'mfn-opts'),
   						'desc' => __('Allowed HTML tags: span, strong, b, em, i, u', 'mfn-opts'),
							'std' => __('This is the slogan', 'mfn-opts'),
							'preview' => 'subtitle',
   					),

   					array(
   						'id' => 'title',
   						'type' => 'text',
						'dynamic_data' => 'title',
   						'edit_tag' => '.desc_wrapper | .title',
   						'edit_position' => 'append',
   						'title' => __('Title', 'mfn-opts'),
   						'desc' => __('Allowed HTML tags: span, strong, b, em, i, u', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
							'id' => 'title_tag',
							'type' 	=> 'switch',
							're_render' => true,
							'title' => __('Title tag', 'mfn-opts'),
							'options' => array(
                'h1' => 'h1',
                'h2' => 'h2',
                'h3' => 'h3',
                'h4' => 'h4',
                'h5' => 'h5',
                'h6' => 'h6',
                'p' => 'p',
                'p.lead' => 'p.lead',
                'span' => 'span',
							),
							'std' => 'h4',
						),

   					// link

   					array(
   						'type' => 'header',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'dynamic_data' => 'permalink',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

            array(
							'id' => 'link_title',
							'type' => 'text',
							'dynamic_data' => 'title',
							'title' => __('Link title', 'mfn-opts'),
						),

						// deprecated

						array(
							'type' => 'header',
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render">',
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-style',
							'id' => 'css_article_boxphoto_wrapperimg_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img',
							'style' => 'border-style',
							'attr_id' => 'border_style_abimg',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-color',
							'id' => 'css_article_boxphoto_wrapperimg_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_abimg', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-width',
							'id' => 'css_article_boxphoto_wrapperimg_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_abimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-radius',
							'id' => 'css_article_boxphoto_wrapperimg_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_wrapper:margin',
							'id' => 'css_photo_wrapper_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_wrapper',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
		  				'type' => 'header',
		  				'class' => 'toggled_header',
   						'title' => __('Desc', 'mfn-opts'),
   					),

   					array(
   						'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:text-align',
							'id' => 'css_desc_wrapper_text_align',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper',
							'style' => 'text-align',
							'responsive' => true,
   						'type' => 'switch',
   						'class' => 'mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),


   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:background',
							'id' => 'css_desc_wrapper_background',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper',
							'style' => 'background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-style',
							'id' => 'css_article_boxdesc_wrapper_border_style',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper',
							'style' => 'border-style',
							'attr_id' => 'border_style_desc',
							'class' => 'mfn-toggled',
							'type' => 'select',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-color',
							'id' => 'css_article_boxdesc_wrapper_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper',
							'style' => 'border-color',
							'condition' => array( 'id' => 'border_style_desc', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-width',
							'id' => 'css_article_boxdesc_wrapper_border_width',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper',
							'style' => 'border-width',
		  				'condition' => array( 'id' => 'border_style_desc', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-radius',
							'id' => 'css_article_boxdesc_wrapper_border_radius',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper',
							'style' => 'border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:padding',
							'id' => 'css_desc_wrapper_padding',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper',
							'style' => 'padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),


		  			array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:margin',
							'id' => 'css_desc_wrapper_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper .title:color',
							'id' => 'css_desc_wrappertitle_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper .title',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper .title:margin',
							'id' => 'css_desc_wrappertitle_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper .title',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper .title:typography',
							'id' => 'css_desc_wrappertitle_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper .title',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Slogan', 'mfn-opts'),
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:color',
							'id' => 'css_desc_wrapperp_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p',
							'style' => 'color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:border-color',
							'id' => 'css_desc_wrapperp_border_color',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p',
							'style' => 'border-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'desc' => __('Works only with <b>classic style</b>', 'mfn-opts'),
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:margin',
							'id' => 'css_desc_wrapperp_margin',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p',
							'style' => 'margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => true,
							'class' => 'mfn-toggled',
		  			),



		  			array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:typography',
							'id' => 'css_desc_wrapperp_typography',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p',
							'style' => 'typography',
							'responsive' => true,
							'type' => 'typography_vb',
							'label_tools' => true,
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


						array(
							'type' => 'header',
							'class' => 'toggled_header',
   						'title' => __('Decoration', 'mfn-opts'),
   					),

   					array(
							'old_id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:--mfn-article-box-decoration',
							'id' => 'css_desc_wrapper_mfn_article_box_decoration',
							'selector' => '.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper',
							'style' => '--mfn-article-box-decoration',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

				// Banner Box  ---------------------------------------------------

   			'banner_box' => array(
   				'type' => 'banner_box',
   				'title' => __('Banner box', 'mfn-opts'),
   				'preview' => true, // instant preview
   				'size' => '1/3',
   				'tablet_size' => '1/3',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'attr' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render mfn-class-editor-card-visible modalbox-card-content">',
						),

						array(
							'type' => 'header',
							'class' => 'mfn-class-editor-form-row-visible',
   						'title' => __('Box', 'mfn-opts'),
   					),

   					array(
   						'id' =