<?php
/**
 * Deprecated Attribute Mapping for Preset Conversion.
 *
 * This class handles attribute mappings for deprecated settings that have been
 * removed from module UIs but still need to be included in preset conversion
 * for backwards compatibility.
 *
 * @package Divi
 * @since ??
 */

namespace ET\Builder\Packages\Conversion;

/**
 * Class DeprecatedAttributeMapping
 *
 * Manages deprecated attribute mappings for modules that need them for preset conversion.
 */
class DeprecatedAttributeMapping {

	/**
	 * Get deprecated attribute mappings for a specific module.
	 *
	 * @since ??
	 *
	 * @param string $module_name The module name (e.g., 'divi/sidebar').
	 *
	 * @return array Array of deprecated attribute mappings for the module.
	 */
	public static function get_deprecated_attrs_for_module( $module_name ) {
		$module_attribute_types = self::_get_module_attribute_types();
		$attribute_definitions  = self::_get_attribute_definitions();

		$deprecated_attrs = [];

		// Get the deprecated attribute types for this module.
		$attribute_types = $module_attribute_types[ $module_name ] ?? [];

		// Build the deprecated attributes array from the attribute type definitions.
		foreach ( $attribute_types as $attribute_type ) {
			if ( isset( $attribute_definitions[ $attribute_type ] ) ) {
				$deprecated_attrs = array_merge( $deprecated_attrs, $attribute_definitions[ $attribute_type ] );
			}
		}

		return $deprecated_attrs;
	}

	/**
	 * Check if a module has deprecated attributes.
	 *
	 * @since ??
	 *
	 * @param string $module_name The module name (e.g., 'divi/sidebar').
	 *
	 * @return bool True if the module has deprecated attributes, false otherwise.
	 */
	public static function has_deprecated_attrs( $module_name ) {
		$module_attribute_types = self::_get_module_attribute_types();

		return isset( $module_attribute_types[ $module_name ] );
	}

	/**
	 * Get mapping of modules to their deprecated attribute types.
	 *
	 * @since ??
	 *
	 * @return array Array mapping module names to their deprecated attribute types.
	 */
	private static function _get_module_attribute_types() {
		return [
			'divi/audio'                  => [ 'htmlAttributes' ],
			'divi/counters'               => [ 'htmlAttributes' ],
			'divi/blurb'                  => [ 'htmlAttributes', 'imageIconAlt' ],
			'divi/button'                 => [ 'htmlAttributes' ],
			'divi/circle-counter'         => [ 'htmlAttributes' ],
			'divi/code'                   => [ 'htmlAttributes' ],
			'divi/column'                 => [ 'htmlAttributes' ],
			'divi/comments'               => [ 'htmlAttributes' ],
			'divi/contact-form'           => [ 'htmlAttributes' ],
			'divi/countdown-timer'        => [ 'htmlAttributes' ],
			'divi/cta'                    => [ 'htmlAttributes' ],
			'divi/divider'                => [ 'htmlAttributes' ],
			'divi/fullwidth-menu'         => [ 'htmlAttributes', 'logoAlt' ],
			'divi/fullwidth-post-content' => [ 'htmlAttributes' ],
			'divi/fullwidth-post-slider'  => [ 'htmlAttributes' ],
			'divi/fullwidth-post-title'   => [ 'htmlAttributes' ],
			'divi/gallery'                => [ 'htmlAttributes' ],
			'divi/heading'                => [ 'htmlAttributes' ],
			'divi/icon'                   => [ 'htmlAttributes' ],
			'divi/image'                  => [ 'htmlAttributes', 'imageAlt', 'imageTitleText' ],
			'divi/login'                  => [ 'htmlAttributes' ],
			'divi/menu'                   => [ 'htmlAttributes', 'logoAlt' ],
			'divi/number-counter'         => [ 'htmlAttributes' ],
			'divi/post-content'           => [ 'htmlAttributes' ],
			'divi/post-slider'            => [ 'htmlAttributes' ],
			'divi/post-title'             => [ 'htmlAttributes' ],
			'divi/pricing-tables'         => [ 'htmlAttributes' ],
			'divi/pricing-tables-item'    => [ 'htmlAttributes' ],
			'divi/search'                 => [ 'htmlAttributes' ],
			'divi/section'                => [ 'htmlAttributes' ],
			'divi/sidebar'                => [ 'htmlAttributes' ],
			'divi/signup'                 => [ 'htmlAttributes' ],
			'divi/team-member'            => [ 'htmlAttributes' ],
			'divi/slide'                  => [ 'htmlAttributes', 'imageAlt' ],
			'divi/fullwidth-image'        => [ 'htmlAttributes', 'imageAlt' ],
			'divi/fullwidth-header'       => [ 'htmlAttributes', 'logoAlt', 'imageAlt' ],
		];
	}

	/**
	 * Get attribute definitions organized by attribute type.
	 *
	 * @since ??
	 *
	 * @return array Array of attribute definitions organized by attribute type.
	 */
	private static function _get_attribute_definitions() {
		return [
			'htmlAttributes' => self::_get_html_attributes_definition(),
			'imageIconAlt'   => self::_get_image_icon_alt_definition(),
			'imageAlt'       => self::_get_image_alt_definition(),
			'imageTitleText' => self::_get_image_title_text_definition(),
			'logoAlt'        => self::_get_logo_alt_definition(),
		];
	}

	/**
	 * Get htmlAttributes deprecated attribute definition.
	 *
	 * Many modules have deprecated htmlAttributes from the UI but still
	 * need them for preset conversion.
	 *
	 * @since ??
	 *
	 * @return array Array of htmlAttributes deprecated attribute mappings.
	 */
	private static function _get_html_attributes_definition() {
		return [
			'module.advanced.htmlAttributes__id'    => [
				'attrName' => 'module.advanced.htmlAttributes',
				'preset'   => 'content',
				'subName'  => 'id',
			],
			'module.advanced.htmlAttributes__class' => [
				'attrName' => 'module.advanced.htmlAttributes',
				'preset'   => [ 'html' ],
				'subName'  => 'class',
			],
		];
	}

	/**
	 * Get imageIconAlt deprecated attribute definition.
	 *
	 * Used by Blurb module for imageIcon.innerContent__alt attribute.
	 *
	 * @since ??
	 *
	 * @return array Array of imageIconAlt deprecated attribute mappings.
	 */
	private static function _get_image_icon_alt_definition() {
		return [
			'imageIcon.innerContent__alt' => [
				'attrName' => 'imageIcon.innerContent',
				'preset'   => [ 'html' ],
				'subName'  => 'alt',
			],
		];
	}

	/**
	 * Get imageAlt deprecated attribute definition.
	 *
	 * Used by modules with image elements for image.innerContent__alt attribute.
	 *
	 * @since ??
	 *
	 * @return array Array of imageAlt deprecated attribute mappings.
	 */
	private static function _get_image_alt_definition() {
		return [
			'image.innerContent__alt' => [
				'attrName' => 'image.innerContent',
				'preset'   => [ 'html' ],
				'subName'  => 'alt',
			],
		];
	}

	/**
	 * Get imageTitleText deprecated attribute definition.
	 *
	 * Used by modules with image elements for image.innerContent__titleText attribute.
	 *
	 * @since ??
	 *
	 * @return array Array of imageTitleText deprecated attribute mappings.
	 */
	private static function _get_image_title_text_definition() {
		return [
			'image.innerContent__titleText' => [
				'attrName' => 'image.innerContent',
				'preset'   => [ 'html' ],
				'subName'  => 'titleText',
			],
		];
	}

	/**
	 * Get logoAlt deprecated attribute definition.
	 *
	 * Used by modules with logo elements for logo.innerContent__alt attribute.
	 *
	 * @since ??
	 *
	 * @return array Array of logoAlt deprecated attribute mappings.
	 */
	private static function _get_logo_alt_definition() {
		return [
			'logo.innerContent__alt' => [
				'attrName' => 'logo.innerContent',
				'preset'   => [ 'html' ],
				'subName'  => 'alt',
			],
		];
	}
}
