<?php
/**
 * Template part for displaying posts in grid layout
 *
 * @package Eduma
 */

defined( 'ABSPATH' ) || exit;

$columns  = absint( thim_blog_grid_column() );
$arr_size = array( '270', '150' ); // Default size

switch ( $columns ) {
	case 2:
		$arr_size = array( '570', '300' );
		break;
	case 3:
		$arr_size = array( '370', '220' );
		break;
}

$post_link = has_post_format( 'link' ) && thim_meta( 'thim_link_url' ) && thim_meta( 'thim_link_text' )
	? array(
		'url'   => esc_url( thim_meta( 'thim_link_url' ) ),
		'title' => esc_html( thim_meta( 'thim_link_text' ) ),
	)
	: array(
		'url'   => esc_url( get_permalink() ),
		'title' => esc_html( get_the_title() ),
	);
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'blog-grid-' . $columns ); ?>>
	<div class="content-inner">

		<?php do_action( 'thim_entry_top', 'full' ); ?>

		<div class="entry-content">
			<?php
			if ( get_theme_mod( 'thim_show_author', true ) ) : ?>
				<div class="author">
					<?php
					echo get_avatar( get_the_author_meta( 'ID' ), 40 );
					printf(
						'<span class="vcard author author_name"><a href="%1$s">%2$s</a></span>',
						esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
						esc_html( get_the_author() )
					);
					?>
				</div>
			<?php endif; ?>

			<header class="entry-header">
				<div class="entry-contain">
					<?php
					printf(
						'<h2 class="entry-title"><a href="%1$s" rel="bookmark">%2$s</a></h2>',
						esc_url( $post_link['url'] ),
						wp_kses_post( $post_link['title'] )
					);
					thim_entry_meta();
					?>
				</div>
			</header>

			<div class="entry-grid-meta">
				<?php if ( get_theme_mod( 'thim_show_date', true ) ) : ?>
					<div class="date">
						<i class="edu-calendar" aria-hidden="true"></i>
						<time datetime="<?php echo esc_attr( get_the_date( 'c' ) ); ?>">
							<?php echo esc_html( get_the_date( get_option( 'date_format' ) ) ); ?>
						</time>
					</div>
				<?php endif; ?>

				<?php if ( get_theme_mod( 'thim_show_comment', true ) ) :
					$comments = wp_count_comments( get_the_ID() );
					?>
					<div class="comments">
						<i class="edu-comment" aria-hidden="true"></i>
						<span class="comment-count">
							<?php echo esc_html( $comments->total_comments ); ?>
						</span>
					</div>
				<?php endif; ?>
			</div>

			<div class="entry-summary">
				<?php the_excerpt(); ?>
			</div>

			<div class="readmore">
				<a href="<?php echo esc_url( get_permalink() ); ?>" class="read-more">
					<span class="screen-reader-text">
						<?php
						/* translators: %s: Post title */
						printf( esc_html__( 'Read more about %s', 'eduma' ), get_the_title() );
						?>
					</span>
					<?php esc_html_e( 'Read More', 'eduma' ); ?>
				</a>
			</div>
		</div>
	</div>
</article><!-- #post-## -->
