document.addEventListener( 'DOMContentLoaded', function() {
	let addToCart = document.querySelector( '.btn-add-package-to-cart.lp-button' );
	if ( addToCart ) {
		addToCart.addEventListener( 'click', function(e){
			e.preventDefault();
			this.classList.add( 'loading' );
			let packageForm = this.closest('form'); 
			let packageID = packageForm.querySelector('input[name="package-id"]');
			// console.log(packageID);
			if ( packageID ) {
				let formData = new FormData();
				formData.append( 'action', `lp_wc_add_package_to_cart` );
				formData.append( 'package_id', packageID.value );
				formData.append( 'nonce', localize_lp_woo_js.nonce );
				fetch( localize_lp_woo_js.url_ajax, {
					method: 'POST',
					body: formData,
				} ) // wrapped
					.then( ( res ) => res.text() )
					.then( ( data ) => {
						data = JSON.parse( data );
						// console.log( data );
						// const { data, status, message } = data;
						if ( data.status === 'error' ) {
							throw new Error( data.message || 'Error' );
						}
						// console.log( data  );
						packageForm.innerHTML = '';
						packageForm.insertAdjacentHTML( 'beforebegin', data.data.button_view_cart );
					} )
					.catch( ( err ) => console.log( err ) );
			}
		} );	
	}
	
});