<?php
use LearnPress\Upsell\Package\Package;
// use LP_Addon_Upsell_Preload;
defined( 'ABSPATH' ) || exit();
/**
 *
 */
class LP_Wc_Upsell {

	/**
	 * @var null
	 */
	private static $_instance = null;

	/**
	 * @var string
	 */
	// public static $wc_product_meta_key_lp_package = '_lp_wc_package_assigned';

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}
	protected function __construct() {
		$this->hooks();
	}
	/**
	 * add hooks here
	 */
	protected function hooks() {
		add_filter( 'lp/upsell/single-package/header/right/sections', array( $this, 'btn_package_buy_now' ) );
		add_filter( 'learn-press/admin/upsell-settings/general', array( $this, 'add_lp_upsell_settings' ) );
		add_filter( 'woocommerce_cart_item_quantity', array( $this, 'disable_quantity_box' ), 10, 3 );
		add_action( 'wp_enqueue_scripts', array( $this, 'load_assets' ) );
		if ( $this->is_by_package_via_product() ) {
			add_filter( 'woocommerce_product_data_tabs', array( $this, 'lp_package_data_tabs' ), 12, 1 );
			add_action( 'woocommerce_product_data_panels', array( $this, 'lp_package_product_panels' ) );
			add_action( 'woocommerce_process_product_meta', array( $this, 'save_package_data' ), 10, 1 );
			add_filter( 'woocommerce_product_tabs', array( $this, 'view_package_by_product' ), 100, 1 );
			add_filter( 'woocommerce_add_to_cart_quantity', array( $this, 'set_quantity' ), 10, 2 );
		} else {
			add_filter( 'woocommerce_json_search_found_products', array( $this, 'wc_json_search_found_products_and_package' ) );
			add_filter( 'woocommerce_get_order_item_classname', array( $this, 'get_classname_lp_wc_order' ), 10, 3 );

			add_action( 'woocommerce_checkout_create_order_line_item', array( $this, 'order_item_line' ), 10, 4 );
			add_filter( 'woocommerce_product_class', array( $this, 'product_class' ), 10, 4 );
		}

		add_filter( 'learnpress/lp-wc-order-items/before-create-lp-order', array( $this, 'add_package_item_to_order' ), 10, 4 );
		// add_action( 'admin_head', array( $this, 'wcpp_custom_style' ) );
	}

	public function load_assets() {
		$version_asset = LP_ADDON_WOO_PAYMENT_VER;
		if ( LP_Debug::is_debug() ) {
			$version_asset = LP_Assets::$_version_assets;
		}
		wp_register_script(
			'lp-wc-upsell',
			plugins_url( '/', LP_ADDON_WOO_PAYMENT_FILE ) . 'assets/add-package-to-cart' . LP_Assets::$_min_assets . '.js',
			array(),
			$version_asset,
			true
		);
	}

	public function add_lp_upsell_settings( $settings ) {
		if ( ! empty( $settings ) ) {
			$section_name    = array(
				'type'  => 'title',
				'title' => esc_html__( 'LP Woo payment', 'learnpress-woo-payment' ),
			);
			$buy_via_product = array(
				'title'   => esc_html__( 'Buy package via Product', 'learnpress-woo-payment' ),
				'id'      => 'buy_package_via_woo_product',
				'default' => 'no',
				'type'    => 'checkbox',
				'desc'    => esc_html__(
					'If enable system will access assign package to product, and user must buy package via product',
					'learnpress-woo-payment'
				),
			);
			$end_section     = array(
				'type' => 'sectionend',
			);

			$settings[] = $section_name;
			$settings[] = $buy_via_product;
			$settings[] = $end_section;
		}
		return $settings;
	}

	public function is_by_package_via_product(): bool {
		return 'yes' === LP_Settings::get_option( 'buy_package_via_woo_product', 'no' );
	}
	public function btn_package_buy_now( $sections ) {
		$package_id = get_the_ID();
		if ( ! $package_id ) {
			return $sections;
		}
		$package = new Package( absint( $package_id ) );
		if ( ! $package ) {
			return $sections;
		}
		$current_user            = learn_press_get_current_user();
		$sections['add-to-cart'] = array();
		if ( $this->is_by_package_via_product() ) {
			$notice = LP_Addon_Woo_Payment_Preload::$addon->get_template( 'package-notice', array( 'package_id' => $package_id ) );

			$sections['add-to-cart'][] = $notice;
		} else {
			$add_to_cart_btn = LP_Addon_Woo_Payment_Preload::$addon->get_template( 'add-package-to-cart', compact( 'package', 'current_user' ) );
			$sections       += array( 'lp-woo-add-to-cart' => array( $add_to_cart_btn ) );
		}

		return $sections;
	}
	public function lp_package_data_tabs( array $tabs ): array {
		$tabs['lp_package_data'] = array(
			'label'  => __( 'LP Packages', 'learnpress-woo-payment' ),
			'target' => 'lp_package_product_data',
		);
		return $tabs;
	}
	public function lp_package_product_panels() {
		global $post;

		echo '<div id="lp_package_product_data" class="panel woocommerce_options_panel hidden">';
		foreach ( $this->metabox() as $key => $object ) {
			$object->id = $key;
			echo $object->output( $post->ID );
		}
		echo '</div>';
	}

	public function metabox() {
		global $post;

		$lp_db                    = LP_Database::getInstance();
		$filter                   = new LP_Post_Type_Filter();
		$filter->collection       = $lp_db->tb_posts;
		$filter->collection_alias = 'p';
		$filter->only_fields      = array( 'ID', 'post_title' );
		$filter->where[]          = $lp_db->wpdb->prepare( 'AND p.post_type=%s', LP_PACKAGE_CPT );
		$filter->limit            = -1;
		$result                   = $lp_db->execute( $filter );
		// // $package_query  = LP_Course::get_courses( $filter );
		$package = array();
		if ( ! empty( $result ) ) {
			foreach ( $result as $row ) {
				$package[ $row->ID ] = $row->post_title;
			}
		}
		$product = wc_get_product( $post->ID );
		if ( ! $product ) {
			return;
		}
		$value = $product->get_meta( LP_WOO_PRODUCT_PACKAGE_KEY ) ?? '';
		return array(
			LP_WOO_PRODUCT_PACKAGE_KEY => new LP_Meta_Box_Select_Field(
				__( 'Assign package to this product', 'learnpress-woo-payment' ),
				'',
				'',
				array(
					'options'  => $package,
					'multiple' => false,
					'value'    => $value,
				)
			),
		);
	}
	public function save_package_data( $product_id ) {

		if ( ! isset( $_POST[ LP_WOO_PRODUCT_PACKAGE_KEY ] ) ) {
			return;
		}
		$product = wc_get_product( $product_id );
		if ( ! $product ) {
			return;
		}
		$package_data = ! empty( $_POST[ LP_WOO_PRODUCT_PACKAGE_KEY ] ) ? LP_Helper::sanitize_params_submitted( $_POST[ LP_WOO_PRODUCT_PACKAGE_KEY ] ) : '';
		$product->update_meta_data( LP_WOO_PRODUCT_PACKAGE_KEY, $package_data );
		$product->save_meta_data();
	}

	/**
	 * Get classname WC_Order_Item_LP_Package
	 *
	 * @throws Exception
	 */
	public function get_classname_lp_wc_order( $classname, $item_type, $id ) {
		if ( in_array( $item_type, array( 'line_item', 'product' ) ) ) {
			$lp_package_id = wc_get_order_item_meta( $id, '_lp_package_id' );
			if ( $lp_package_id && LP_PACKAGE_CPT === get_post_type( $lp_package_id ) ) {
				$classname = 'WC_Order_Item_LP_Package';
			}
		}

		return $classname;
	}

	/**
	 * For on WC Coupon data
	 *
	 * @param $products
	 *
	 * @return mixed
	 */
	public function wc_json_search_found_products_and_package( $products ) {

		$term = wc_clean( empty( $term ) ? stripslashes( $_GET['term'] ) : $term );

		$lp_db                    = LP_Database::getInstance();
		$filter                   = new LP_Post_Type_Filter();
		$filter->collection       = $lp_db->tb_posts;
		$filter->collection_alias = 'p';
		$filter->only_fields      = array( 'ID', 'post_title' );
		$filter->where[]          = $lp_db->wpdb->prepare( 'AND p.post_type=%s', LP_PACKAGE_CPT );
		$filter->where[]          = $lp_db->wpdb->prepare( 'AND p.post_status=%s', 'publish' );
		$filter->where[]          = $lp_db->wpdb->prepare( 'AND post_title LIKE %s', '%' . $wpdb->esc_like( $term ) . '%' );
		$filter->limit            = -1;
		$result                   = $lp_db->execute( $filter );
		if ( ! empty( $result ) ) {
			foreach ( $result as $row ) {
				$products[ $row->ID ] = $row->post_title . ' (' . __( 'Package', 'learnpress-woo-payment' ) . ' #' . $row->ID . ')';
			}
		}
		return $products;
	}

	public function order_item_line( $item, $cart_item_key, $values, $order ) {
		if ( LP_PACKAGE_CPT === get_post_type( $values['product_id'] ) ) {
			$item->add_meta_data( '_lp_package_id', $values['product_id'], true );
		}
	}

	/**
	 * Get the product class name.
	 *
	 * @param string
	 * @param string
	 * @param string
	 * @param int
	 *
	 * @return string
	 */
	public function product_class( $classname, $product_type, $post_type, $product_id ): string {
		if ( LP_PACKAGE_CPT === get_post_type( $product_id ) ) {
			$classname = 'WC_Product_LP_Package';
		}
		return $classname;
	}

	/**
	 * Disable select quantity product has post_type 'lp_course'
	 *
	 * @param string $product_quantity
	 * @param string $cart_item_key
	 * @param array  $cart_item
	 *
	 * @return string
	 */
	public function disable_quantity_box( string $product_quantity, string $cart_item_key, array $cart_item ): string {
		$product_id       = $cart_item['product_id'] ?? 0;
		$quantity_disable = false;
		if ( get_class( $cart_item['data'] ) === 'WC_Product_LP_Package' ) {
			$quantity_disable = true;
		} elseif ( $this->is_by_package_via_product() ) {
			$product    = wc_get_product( $product_id );
			$package_id = $product->get_meta( LP_WOO_PRODUCT_PACKAGE_KEY ) ?? '';
			if ( ! empty( $package_id ) ) {
				$quantity_disable = true;
			}
		}

		if ( $quantity_disable ) {
			$product_quantity = sprintf(
				'<span style="text-align: center; display: block">%s</span>',
				$cart_item['quantity']
			);
		}

		return $product_quantity;
	}
	/**
	 * Add tabs show package in product page
	 */
	public function view_package_by_product( $tabs ) {
		global $post;

		$product = wc_get_product( $post->ID );
		if ( ! $product ) {
			return $tabs;
		}
		$package = $product->get_meta( LP_WOO_PRODUCT_PACKAGE_KEY ) ?? '';

		if ( ! empty( $package ) ) {
			$tabs['_lp_package_data'] = array(
				'title'    => __( 'Package', 'learnpress-woo-payment' ),
				'priority' => 100,
				'callback' => array( $this, 'lp_package_content_tabs' ),
			);
		}

		return $tabs;
	}
	/**
	 * view package by product callback
	 */
	public function lp_package_content_tabs() {
		global $post;
		wp_enqueue_style( 'lp-woo-css' );
		$product = wc_get_product( $post->ID );
		if ( ! $product ) {
			return $tabs;
		}
		$package_id = $product->get_meta( LP_WOO_PRODUCT_PACKAGE_KEY ) ?? '';
		if ( $package_id ) {
			echo '<ul class="list-courses-assign-product">';
			echo '<li> <a href=' . get_permalink( $package_id ) . '>' . get_the_title( $package_id ) . '</a></li>';
			echo '</ul>';
		}
	}
	/**
	 * Product has courses only add one time to cart
	 *
	 * @param int $quantity
	 * @param int $product_id
	 * @return int
	 * @since 4.1.1
	 */
	public function set_quantity( int $quantity, int $product_id ): int {
		// $product_has_courses = get_post_meta( $product_id, self::$meta_key_lp_woo_courses_assigned, true );
		$product    = wc_get_product( $product_id );
		$package_id = $product->get_meta( LP_WOO_PRODUCT_PACKAGE_KEY ) ?? '';

		if ( ! empty( $package_id ) ) {
			$message  = __( 'Product which has package is only added one time.', 'learnpress-woo-payment' );
			$cart     = WC()->cart;
			$cart_key = $cart->generate_cart_id( $product_id );

			if ( array_key_exists( $cart_key, $cart->cart_contents ) ) {
				$quantity = 0;

				wc_add_notice( $message );
			} elseif ( $quantity > 1 ) {
				wc_add_notice( $message );

				$quantity = 1;
			}
		}

		return $quantity;
	}

	/**
	 * Adds a package item to order.
	 *
	 * @param      array  $lp_order_items  The pointer to a order items
	 * @param      array  $wc_order        The wc order
	 * @since      4.1.1
	 * @return     array  hook to insert LP package to LP order
	 */
	public function add_package_item_to_order( $lp_order_items, $wc_order, $order_total, $order_subtotal ) {
		$wc_items                = $wc_order->get_items();
		$buy_package_via_product = $this->is_by_package_via_product();

		// $buy_course_via_product = LP_Gateway_Woo::is_by_courses_via_product();
		foreach ( $wc_items as $item ) {
			$item_id = $item->get_product_id();
			if ( $buy_package_via_product ) {
				$product    = $item->get_product();
				$package_id = $product->get_meta( LP_WOO_PRODUCT_PACKAGE_KEY );
				if ( ! $package_id ) {
					continue;
				}
				$package = new Package( absint( $package_id ) );
				if ( ! $package ) {
					continue;
				}
				$order_total                  += floatval( $package->get_price() );
				$order_subtotal               += floatval( $package->get_price() );
				$lp_order_items[ $package_id ] = array(
					'item_type'      => LP_PACKAGE_CPT,
					'item_id'        => $package_id,
					'order_subtotal' => $order_subtotal,
					'order_total'    => $order_total,
				);
			} else {
				$item_type = get_post_type( $item_id );
				if ( $item_type === LP_PACKAGE_CPT ) {
					$order_total               += $item->get_total();
					$order_subtotal            += $item->get_subtotal();
					$lp_order_items[ $item_id ] = array(
						'item_type'      => LP_PACKAGE_CPT,
						'item_id'        => $item_id,
						'order_subtotal' => $order_subtotal,
						'order_total'    => $order_total,
					);
				}
			}
		}

		return $lp_order_items;
	}
}
