<?php
/**
 * Template for displaying add-to-cart button
 */

defined( 'ABSPATH' ) || exit();
if ( ! isset( $package ) ) {
	return;
}
if ( ! isset( $current_user ) ) {
	return;
}
$course_list = $package->get_course_list();
wp_enqueue_style( 'learnpress' );
if ( empty( $course_list ) ) {
	learn_press_display_message( __( 'Package is unavailable.', 'learnpress-woo-payment' ), 'warning' );
	return;
}
$can_purchase = true;
foreach ( $course_list as $key => $course_id ) {
	$can_purchase_course = $current_user->can_purchase_course( $course_id );
	if ( $current_user->has_purchased_course( $course_id ) || $current_user->has_enrolled_course( $course_id ) ) {
		$can_purchase = true;
	} elseif ( is_wp_error( $can_purchase_course ) ) {
		$can_purchase = false;
		learn_press_display_message( get_the_title( $course_id ) . ': ' . $can_purchase_course->get_error_message(), 'warning' );
	}
}
if ( ! $can_purchase ) {
	return;
}

$is_added_to_cart = LP_WC_Hooks::instance()->is_added_in_cart( $package->get_id() );
wp_enqueue_style( 'lp-woo-css' );
wp_enqueue_style( 'font-awesome-5-all' );

wp_enqueue_script( 'lp-wc-upsell' );
wp_enqueue_script( 'lp-woo-payment-js' );
?>

<?php do_action( 'learn-press/before-add-package-to-cart-form' ); ?>

<div class="wrap-btn-add-course-to-cart">
	<?php if ( ! $is_added_to_cart ) : ?>
	<form name="form-add-package-to-cart" method="post">

		<?php do_action( 'learn-press/before-add-package-to-cart-button' ); ?>

		<input type="hidden" name="package-id" value="<?php echo esc_attr( $package->get_id() ); ?>"/>

		<button class="lp-button btn-add-package-to-cart" type="button">
			<?php _e( 'Add to cart', 'learnpress-woo-payment' ); ?>
		</button>

		<?php do_action( 'learn-press/after-add-package-to-cart-button' ); ?>

	</form>
	<?php else : ?>
		<?php
		$course = true;
		LP_Addon_Woo_Payment_Preload::$addon->get_template( 'view-cart', compact( 'course', 'is_added_to_cart' ) );
		?>
	<?php endif; ?>
</div>

<?php do_action( 'learn-press/after-add-package-to-cart-form' ); ?>
