jQuery(document).ready(function() {

	/* Color Picker */
	if( jQuery().wpColorPicker ){
		jQuery('.wmvp-color-picker').wpColorPicker();
	}

	/* The manual type  */
	jQuery('#wmvp-add-videos-manual').click( function() {

		jQuery('body').addClass('wmvp-newlist');
		jQuery('#wmvp-list-type').val('manual');
		jQuery('#wmvp-list-type-section').hide();
		jQuery('#wmvp-list-type-manual').slideDown();
		jQuery('#wmvp-list-type-customizations').fadeIn();

		return false;
	});

	/* Add an Automatic Playlist */
	jQuery('.wmvp-add-videos-type:not(#wmvp-add-videos-manual)').click( function() {

		// Pro is active
		if( wmvp_js.is_pro ){
			var theProvider = jQuery(this).data('provider');
			var theType     = jQuery(this).data('type');

			jQuery('body').addClass('wmvp-newlist');
			jQuery('#wmvp-list-type').val( 'automatic' );
			jQuery('#wmvp-list-type-section').hide();
			jQuery('#wmvp-list-type-automatic').slideDown().attr( 'data-'+ theProvider +'-type', theType );
			jQuery('#wmvp-list-type-customizations').slideDown();
			jQuery('#wmvp-provider-item input[value="'+ theProvider +'"]').attr('checked', 'checked');
			jQuery('#wmvp-'+ theProvider +'-type option[value="'+ theType +'"]').attr('selected', 'selected');
		}

		// Pro not active
		else{
			jQuery('#wmvp-popup-upgrade-title').html( jQuery(this).data('upgrade') );
			jQuery('#wmvp-popup-upgrade-image').attr( 'src', jQuery(this).data('image') );
			jQuery('#wmvp-popup-upgrade-caption').html( jQuery(this).data('caption') );
			jQuery('#wmvp-page-overlay').css({'display': 'flex'});
		}

		return false;
	});

	/* Close Options popup with esc  */
	jQuery(document).keyup(function(event){
		if ( event.which == '27' ){
			jQuery('#wmvp-page-overlay').hide();
		}
	});

	jQuery(document).on('click', '#wmvp-overlay-close', function(){
		jQuery('#wmvp-page-overlay').hide();
	});

	// Delete Video
	jQuery(document).on('click', '.wmvp-icon-delete', function(){
		jQuery(this).closest('li').addClass('wmvp-state-removed').fadeOut(function() {
			jQuery(this).remove();
			wmvp_Js_Counter--;

			console.log( wmvp_Js_Counter );
		});
	});


	// Activate License
	jQuery( '#wmvp-license-activate' ).click(function(e){
		var $wmvpActivateButton = jQuery( this ),
				$wmvpLoader         = $wmvpActivateButton.parent().find('.wmvp-loader'),
				$wmvpErrorMessage   = $wmvpActivateButton.parent().find('.wmvp-notice').hide(),
				$wmvpLicenseKey     = jQuery('#license_key'),
		    wmvpLicenseKeyValue = $wmvpLicenseKey.val();

		if( ! wmvpLicenseKeyValue ){
			$wmvpErrorMessage.html( 'Please enter a valid license Key.' ).show();
			return false;
		}

		// Ajax Call
		jQuery.ajax({
			url : wmvp_js.ajaxurl,
			type: 'post',
			data: {
				action   : 'wmvp_activate_license',
				security : wmvp_js.security,
				key      : wmvpLicenseKeyValue,
			},
			beforeSend: function(){
				$wmvpLoader.addClass('wmvp-is-loading');
				$wmvpLicenseKey.attr( 'disabled', 'disabled' );
				$wmvpActivateButton.attr( 'disabled', 'disabled' );
			},
			success: function( data ){
				if( typeof data == 'object' && data.success == false ){
					$wmvpErrorMessage.html( data.data[0].message ).show();
				}
				else{
					$wmvpLoader.hide();
					$wmvpActivateButton.hide();
					$wmvpActivateButton.after( data );
				}
			},
			error: function( data ){
				if( typeof data == 'object' && data.statusText !== false ){
					$wmvpErrorMessage.html( data.statusText ).show();
				}
			},
			complete: function( xhr, status ){
				$wmvpLoader.removeClass('wmvp-is-loading');
				$wmvpLicenseKey.removeAttr('disabled');
				$wmvpActivateButton.removeAttr('disabled');
			}
		});

		e.preventDefault();
		return false;
	});


	// Activate the YouTube API Key
	jQuery( '#wmvp-youtube-api-key' ).click(function(e){
		var $wmvpActivateButton = jQuery( this ),
		    $wmvpLoader         = $wmvpActivateButton.parent().find('.wmvp-loader'),
				$wmvpErrorMessage   = $wmvpActivateButton.parent().find('.wmvp-notice').hide(),
				$wmvpApiKey         = jQuery('#youtube_api_key'),
		    wmvpApiKeyValue     = $wmvpApiKey.val();

		if( ! wmvpApiKeyValue ){
			$wmvpErrorMessage.html( 'Please enter a valid API Key.' ).show();
			return false;
		}

		// Ajax Call
		jQuery.ajax({
			url : wmvp_js.ajaxurl,
			type: 'post',
			data: {
				action   : 'wmvp_activate_youtube_key',
				security : wmvp_js.security,
				key      : wmvpApiKeyValue,
			},
			beforeSend: function(){
				$wmvpLoader.addClass('wmvp-is-loading');
				$wmvpApiKey.attr( 'disabled', 'disabled' );
				$wmvpActivateButton.attr( 'disabled', 'disabled' );
			},
			success: function( data ){
				if( typeof data == 'object' && data.success == false ){
					$wmvpErrorMessage.html( data.data[0].message ).show();
				}
				else{
					$wmvpLoader.hide();
					$wmvpActivateButton.after( data );
				}
			},
			error: function( data ){
				if( typeof data == 'object' && data.statusText !== false ){
					$wmvpErrorMessage.html( data.statusText ).show();
				}
			},
			complete: function( xhr, status ){
				$wmvpLoader.removeClass('wmvp-is-loading');
				$wmvpApiKey.removeAttr('disabled');
				$wmvpActivateButton.removeAttr('disabled');
			}
		});

		e.preventDefault();
		return false;
	});

	// Youtube Playlist Type
	jQuery('#wmvp-youtube-type').change(function() {
		jQuery('#wmvp-list-type-automatic').attr( 'data-youtube-type', jQuery(this).val() );
	})

	jQuery('.wmvp-youtube-reset-videos').click(function(e){
		jQuery('#wmvp-settings-automatic').fadeOut('fast', function() {
			jQuery('#wmvp-list-type-automatic').removeClass('wmvp-is-configured')
			jQuery('#wmvp-settings-automatic').fadeIn('fast');
			jQuery('#wmvp-youtube-id').val('')
		});

		jQuery('#wmvp-videos-items-automatic').html('');
		return false;
	});

	// Disable button
	jQuery(document).on('change', '.wmvp-disable-video input', function(){
		if( jQuery(this).is(':checked') ){
			jQuery(this).closest('.wmvp-single-video').addClass('wmvp-is-disabled');
		}
		else{
			jQuery(this).closest('.wmvp-single-video').removeClass('wmvp-is-disabled');
		}
	})

	//-----
	jQuery( '#wmvp-youtube-fetch-videos' ).click(function(e){

		var $wmvpFetchButton   = jQuery( this ),
		    $wmvpLoader        = jQuery('#wmvp-automatic-loader'),
		    $wmvpAutomaticList = jQuery('#wmvp-videos-items-automatic'),
				$wmvpErrorMessage  = jQuery('#wmvp-api-error').hide(),
		    wmvpProvider       = jQuery('#wmvp-provider-item input:checked').val(),
		    wmvpYoutubeID      = jQuery('#wmvp-youtube-id').val(),
		    wmvpYoutubeType    = jQuery('#wmvp-youtube-type').val();

		if( ! wmvpYoutubeType || ! wmvpYoutubeID || ! wmvpProvider ){
			$wmvpErrorMessage.html( 'Please select Type and fill the ID.' ).show();
			return false;
		}

		// Ajax Call
		jQuery.ajax({
			url : wmvp_js.ajaxurl,
			type: 'post',
			data: {
				action   : 'wmvp_fetch_youtube_videos',
				security : wmvp_js.security,
				id       : wmvpYoutubeID,
				type     : wmvpYoutubeType,
			},
			beforeSend: function(){

				// Add the loading spinner
				$wmvpLoader.addClass('wmvp-is-loading');

				jQuery('#wmvp-youtube-id, #wmvp-youtube-type, #wmvp-provider-item input').attr( 'disabled', 'disabled' );
				$wmvpFetchButton.attr( 'disabled', 'disabled' );

			},
			success: function( data ){
				
				if( typeof data == 'object' && data.success == false ){
					$wmvpErrorMessage.html( data.data[0].message ).show();
				}
				else{
					jQuery( data ).each(function(){
						// Check if the item is already exists
						if( ! document.getElementById( jQuery(this).attr('id') ) ){ 
							$wmvpAutomaticList.prepend( jQuery(this) );
						}
					});
					
					/*
					$wmvpAutomaticList.html( jQuery( data ).hide() );
					var $i = 0;
					$wmvpAutomaticList.find('li').each(function(){
						if( $i < 25 )	$i++; // Disable the animation after first 25 items
						jQuery(this).addClass( 'wmvp-animate-slideInUp' ).attr('style', 'animation-delay: '+ $i/7 +'s' ).show();
					});
					*/
					/*
					var $i = 0;
					jQuery( data ).each(function(){
						if( ! document.getElementById( jQuery(this).attr('id') ) ){ // Check if the item is already exists
							if( $i < 25 )	$i++; // Disable the animation after first 25 items
							$wmvpAutomaticList.prepend( jQuery(this).addClass( 'wmvp-animate-slideInUp' ).attr('style', 'animation-delay: '+ $i/9 +'s' ).show() );
						}
					});
					*/
				}
				
			},
			error: function( data ){

			},
			complete: function( xhr, status ){

				// Remove the loading spinner
				$wmvpLoader.removeClass('wmvp-is-loading');

				// Reactivate disabled inputs
				jQuery('#wmvp-youtube-id, #wmvp-youtube-type, #wmvp-provider-item input').removeAttr('disabled');
				$wmvpFetchButton.removeAttr('disabled');
				
				// 
				if( typeof xhr.responseJSON == 'object' && xhr.responseJSON.success == false ){
					// error
				}
				else{
				
					// Update The Sortable List
					jQuery( '.wmvp-videos-items-sortable' ).sortable({ placeholder: 'wmvp-sortable-placeholder' });

					if( status == 'success' ){
						jQuery('#wmvp-settings-automatic').fadeOut('fast', function() {

							jQuery( '#wmvp-provider-item .wmvp-self-value').html( wmvpProvider );
							jQuery( '#wmvp-youtube-type-item .wmvp-self-value').html( wmvpYoutubeType );
							jQuery( '#wmvp-youtube-id-item .wmvp-self-value').html( wmvpYoutubeID );

							jQuery('#wmvp-list-type-automatic').addClass('wmvp-is-configured')
							jQuery('#wmvp-settings-automatic').fadeIn('fast');
						});
					}
				}

			}

		});

		e.preventDefault();
		return false;
	});

});