<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Add New Playlist Modal
 */
add_action( 'WMVP/Playlist_Screen/New', 'wmvp_upgrade_pro_modal', 5 );
function wmvp_upgrade_pro_modal(){

	?>
	<div id="wmvp-page-overlay">
		<div class="wmvp-popup-block">

			<a href="#" id="wmvp-overlay-close"><span class="dashicons dashicons-no-alt"></span></a>

			<div class="wmvp-popup-block-head">					
				<div class="wmvp-popup-block-head-child">
					<h2 id="wmvp-popup-upgrade-title"></h2>
					<p id="wmvp-popup-upgrade-caption"></p>
				</div>
				<div class="wmvp-popup-block-head-child">
					<img id="wmvp-popup-upgrade-image" sec="<?php echo esc_attr( WMVP_PLUGIN_URL ) ?>/includes/admin/assets/images/blank.png" />
				</div>
			</div>

			<h3><?php esc_html_e( 'And get much more!', 'wm-video-playlists' ); ?></h3>
			<?php wmvp_pro_features_list(); ?>
			<a class="wmvp-button wmvp-button-pro button button-primary" target="_blank" href="<?php echo esc_url( wmvp_go_pro( array( 'utm_medium' => 'add-modal' ) ) ) ?>">🍉 <?php esc_html_e( 'Upgrade to PRO', 'wm-video-playlists' ) ?></a>
		</div><!-- .wmvp-popup-block -->
	</div><!-- #wmvp-page-overlay -->
	<?php
}


/**
 * Settings Page Sidebar
 */
add_action( 'WMVP/Settings/Sidebar', 'wmvp_settings_sidebar_upgrade' );
function wmvp_settings_sidebar_upgrade(){
	?>
	<div class="wmvp-upgrade-to-pro">
		<div class="wmvp-upgrade-to-pro-head">
			<img src="<?php echo esc_attr( WMVP_PLUGIN_URL ) ?>/includes/admin/assets/images/go-pro.gif" width="110" height="75" alt="<?php esc_html_e( 'Unlock Extra Features with PRO', 'wm-video-playlists' ) ?>" />
			<h2><?php esc_html_e( 'Unlock Extra Features with PRO', 'wm-video-playlists' ) ?></h2>
		</div>

		<?php wmvp_pro_features_list(); ?>

		<a class="wmvp-button wmvp-button-pro button button-primary" target="_blank" href="<?php echo esc_url( wmvp_go_pro( array( 'utm_medium' => 'add-modal' ) ) ) ?>">🍉 <?php esc_html_e( 'Upgrade to PRO', 'wm-video-playlists' ) ?></a>
	</div><!-- .wmvp-upgrade-to-pro -->
	<?php
}


/**
 * Pro Features List
 */
function wmvp_pro_features_list(){

	$features_list = array(
		esc_html__( 'Automatically fetch videos from a YouTube playlist.', 'wm-video-playlists' ),
		esc_html__( 'Automatically fetch videos from a YouTube channel.', 'wm-video-playlists' ),
		esc_html__( 'Automatically fetch videos from a YouTube search.', 'wm-video-playlists' ),
		esc_html__( 'Light and dark mode styles.', 'wm-video-playlists' ),
		esc_html__( 'Multiple layout options.', 'wm-video-playlists' ),
		esc_html__( 'Multiple player shadow options.', 'wm-video-playlists' ),
		esc_html__( 'Smart dynamic player shadow.', 'wm-video-playlists' ),
		esc_html__( 'Rounded thumbnail image option.', 'wm-video-playlists' ),
		esc_html__( 'Circular thumbnail image option.', 'wm-video-playlists' ),
		esc_html__( 'Trim long video titles.', 'wm-video-playlists' ),
		esc_html__( 'Set custom colors for the player.', 'wm-video-playlists' ),
		esc_html__( 'WordPress widget support.', 'wm-video-playlists' ),
		esc_html__( 'Extend the playlist shortcode for additional customizations.', 'wm-video-playlists' ),
		esc_html__( 'Customize single players individually.', 'wm-video-playlists' ),
		esc_html__( 'Vimeo support (coming soon).', 'wm-video-playlists' ),
		esc_html__( 'Pro support.', 'wm-video-playlists' ),
		esc_html__( '14-day money-back guarantee.', 'wm-video-playlists' ),
		esc_html__( 'And much more!', 'wm-video-playlists' ),
	);
	?>
	<ul class="wmvp-pro-features-list">
		<?php 
			foreach( $features_list as $feature ){
				echo '<li><span class="dashicons dashicons-yes"></span> '. $feature .'</li>';
			}
		?>
	</ul>
	<?php
}




