<?php

/**
 * JNews Tiktok - Customizer Option
 */
$options = array();

$tiktok_feed_show_active_callback = array(
	'setting'  => 'jnews_option[tiktok_feed_enable]',
	'operator' => '!=',
	'value'    => 'hide',
);

$footer_tiktok_feed_refresh = array(
	'selector'        => '.jeg_footer_tiktok_wrapper',
	'render_callback' => function () {
		do_action( 'jnews_render_tiktok_feed_footer' );
	},
);

$options[] = array(
	'id'      => 'jnews_tiktok_feed_section',
	'type'    => 'jnews-header',
	'section' => 'jnews_tiktok_feed_section',
	'label'   => esc_html__( 'Tiktok Feed', 'jnews-tiktok' ),
);

//see iQ4nWlII
$tiktok_setting     = get_option( 'jnews_option[jnews_tiktok]', array() );
$tiktok_cached      = get_option( 'jnews_tiktok_cached_data', array() );
if ( is_array( $tiktok_cached ) && ! empty( $tiktok_cached )  ) {
	$user_data = $tiktok_cached['user'];
	$tiktok_label       = sprintf( __( 'Connected as %s', 'jnews-tiktok' ), $user_data['display_name'] );
	$tiktok_description = sprintf( __( 'This token is valid until %1$s. Connect another account by clicking this <a class="%2$s" href="%3$s" target="_blank">link</a>.', 'jnews-tiktok' ), date( 'F d, Y H:i:s', (int) $tiktok_cached['time'] + (int) $tiktok_setting['expires_in'] ), 'jnews_tiktok_access_token instagram', get_admin_url() . 'widgets.php' );

	$options[] = array(
		'id'          => 'jnews_tiktok_token_alert',
		'type'        => 'jnews-alert',
		'default'     => 'info',
		'section'     => 'jnews_tiktok_feed_section',
		'label'       => $tiktok_label,
		'description' => $tiktok_description,
	);

	$options[] = array(
		'id'          => 'jnews_footer_tiktok_alert',
		'type'        => 'jnews-alert',
		'default'     => 'info',
		'section'     => 'jnews_tiktok_feed_section',
		'label'       => esc_html__( 'Footer Tiktok Compatibility', 'jnews-tiktok' ),
		'description' => wp_kses( __( 'Footer Tiktok only compatible with <strong>Footer Type 5</strong> and <strong>Footer Type 6</strong>.', 'jnews-tiktok' ), wp_kses_allowed_html() ),
	);

	$options[] = array(
		'id'              => 'jnews_option[tiktok_feed_enable]',
		'option_type'     => 'option',
		'transport'       => 'postMessage',
		'default'         => 'hide',
		'type'            => 'jnews-select',
		'section'         => 'jnews_tiktok_feed_section',
		'label'           => esc_html__( 'Enable Tiktok Feed', 'jnews-tiktok' ),
		'description'     => esc_html__( 'Show the Tiktok feed only on header, footer or both.', 'jnews-tiktok' ),
		'multiple'        => 1,
		'choices'         => array(
			'show' => esc_attr__( 'Show', 'jnews-tiktok' ),
			'hide' => esc_attr__( 'Hide ', 'jnews-tiktok' ),
		),
		'partial_refresh' => array(
			'jnews_footer_tiktok_enable' => $footer_tiktok_feed_refresh,
		),
	);

	$options[] = array(
		'id'              => 'jnews_option[footer_tiktok_row]',
		'option_type'     => 'option',
		'transport'       => 'postMessage',
		'default'         => 1,
		'type'            => 'jnews-slider',
		'section'         => 'jnews_tiktok_feed_section',
		'label'           => esc_html__( 'Number Of Rows', 'jnews-tiktok' ),
		'description'     => esc_html__( 'Number of rows for footer Tiktok feed.', 'jnews-tiktok' ),
		'choices'         => array(
			'min'  => '1',
			'max'  => '2',
			'step' => '1',
		),
		'active_callback' => array(
			$tiktok_feed_show_active_callback,
		),
		'partial_refresh' => array(
			'jnews_footer_tiktok_row' => $footer_tiktok_feed_refresh,
		),
	);

	$options[] = array(
		'id'              => 'jnews_option[footer_tiktok_column]',
		'option_type'     => 'option',
		'transport'       => 'postMessage',
		'default'         => 8,
		'type'            => 'jnews-slider',
		'section'         => 'jnews_tiktok_feed_section',
		'label'           => esc_html__( 'Number Of Columns', 'jnews-tiktok' ),
		'description'     => esc_html__( 'Number of Tiktok feed columns.', 'jnews-tiktok' ),
		'choices'         => array(
			'min'  => '5',
			'max'  => '10',
			'step' => '1',
		),
		'active_callback' => array(
			$tiktok_feed_show_active_callback,
		),
		'partial_refresh' => array(
			'jnews_footer_tiktok_column' => $footer_tiktok_feed_refresh,
		),
	);

	$options[] = array(
		'id'              => 'jnews_option[footer_tiktok_sort_type]',
		'option_type'     => 'option',
		'transport'       => 'postMessage',
		'default'         => 'most_recent',
		'type'            => 'jnews-select',
		'section'         => 'jnews_tiktok_feed_section',
		'label'           => esc_html__( 'Sort Feed Type', 'jnews-tiktok' ),
		'description'     => esc_html__( 'Sort the Tiktok feed in a set order.', 'jnews-tiktok' ),
		'multiple'        => 1,
		'choices'         => array(
			'most_recent'   => esc_attr__( 'Most Recent', 'jnews-tiktok' ),
			'least_recent'  => esc_attr__( 'Least Recent', 'jnews-tiktok' ),
			'most_like'     => esc_attr__( 'Most Liked', 'jnews-tiktok' ),
			'least_like'    => esc_attr__( 'Least Liked', 'jnews-tiktok' ),
			'most_comment'  => esc_attr__( 'Most Commented ', 'jnews-tiktok' ),
			'least_comment' => esc_attr__( 'Least Commented ', 'jnews-tiktok' ),
		),
		'active_callback' => array(
			$tiktok_feed_show_active_callback,
		),
		'partial_refresh' => array(
			'jnews_footer_tiktok_sort_type' => $footer_tiktok_feed_refresh,
		),
	);

	$options[] = array(
		'id'              => 'jnews_option[footer_tiktok_hover_style]',
		'option_type'     => 'option',
		'transport'       => 'postMessage',
		'default'         => 'zoom',
		'type'            => 'jnews-select',
		'section'         => 'jnews_tiktok_feed_section',
		'label'           => esc_html__( 'Hover Style', 'jnews-tiktok' ),
		'description'     => esc_html__( 'Choose hover effect style.', 'jnews-tiktok' ),
		'multiple'        => 1,
		'choices'         => array(
			'normal'      => esc_attr__( 'Normal', 'jnews-tiktok' ),
			'icon'        => esc_attr__( 'Show Icon', 'jnews-tiktok' ),
			'like'        => esc_attr__( 'Show Like Count', 'jnews-tiktok' ),
			'comment'     => esc_attr__( 'Show Comment Count', 'jnews-tiktok' ),
			'zoom'        => esc_attr__( 'Zoom', 'jnews-tiktok' ),
			'zoom-rotate' => esc_html__( 'Zoom Rotate', 'jnews-tiktok' ),
			' '           => esc_attr__( 'No Effect', 'jnews-tiktok' ),
		),
		'active_callback' => array(
			$tiktok_feed_show_active_callback,
		),
		'partial_refresh' => array(
			'jnews_footer_tiktok_hover_style' => $footer_tiktok_feed_refresh,
		),
	);

	$options[] = array(
		'id'              => 'jnews_option[footer_tiktok_view_button]',
		'option_type'     => 'option',
		'transport'       => 'postMessage',
		'type'            => 'jnews-text',
		'default'         => '',
		'section'         => 'jnews_tiktok_feed_section',
		'label'           => esc_html__( 'View Button Text', 'jnews-tiktok' ),
		'description'     => esc_html__( 'Leave empty if you wont show it.', 'jnews-tiktok' ),
		'active_callback' => array(
			$tiktok_feed_show_active_callback,
		),
		'partial_refresh' => array(
			'jnews_footer_tiktok_view_button' => $footer_tiktok_feed_refresh,
		),
	);

	$options[] = array(
		'id'              => 'jnews_option[footer_tiktok_layout]',
		'option_type'     => 'option',
		'transport'       => 'postMessage',
		'type'            => 'jnews-select',
		'section'         => 'jnews_tiktok_feed_section',
		'label'           => esc_html__( 'Layout type', 'jnews-tiktok' ),
		'description'     => esc_html__( 'Choose layout type.', 'jnews-tiktok' ),
		'choices'         => array(
			'rectangle' => esc_attr__( 'Rectangle', 'jnews-tiktok' ),
			'square'    => esc_attr__( 'Square', 'jnews-tiktok' ),
		),
		'active_callback' => array(
			$tiktok_feed_show_active_callback,
		),
		'partial_refresh' => array(
			'jnews_footer_tiktok_layout' => $footer_tiktok_feed_refresh,
		),
	);

	$options[] = array(
		'id'              => 'jnews_option[footer_tiktok_cover]',
		'option_type'     => 'option',
		'transport'       => 'postMessage',
		'type'            => 'jnews-select',
		'section'         => 'jnews_tiktok_feed_section',
		'label'           => esc_html__( 'Cover type', 'jnews-tiktok' ),
		'description'     => esc_html__( 'Choose cover type.', 'jnews-tiktok' ),
		'choices'         => array(
			'cover'   => esc_attr__( 'Cover', 'jnews-tiktok' ),
			'origin'  => esc_attr__( 'Origin', 'jnews-tiktok' ),
			'play'    => esc_attr__( 'Play', 'jnews-tiktok' ),
			'dynamic' => esc_attr__( 'Dynamic', 'jnews-tiktok' ),
		),
		'active_callback' => array(
			$tiktok_feed_show_active_callback,
		),
		'partial_refresh' => array(
			'jnews_footer_tiktok_cover' => $footer_tiktok_feed_refresh,
		),
	);

	$options[] = array(
		'id'              => 'jnews_option[footer_tiktok_open]',
		'option_type'     => 'option',
		'transport'       => 'postMessage',
		'type'            => 'jnews-toggle',
		'section'         => 'jnews_tiktok_feed_section',
		'label'           => esc_html__( 'Open New Tab', 'jnews-tiktok' ),
		'active_callback' => array(
			$tiktok_feed_show_active_callback,
		),
		'partial_refresh' => array(
			'jnews_footer_tiktok_open' => $footer_tiktok_feed_refresh,
		),
	);
} else {
	$tiktok_label       = esc_html__( 'Connect Tiktok Account', 'jnews-tiktok' );
	$tiktok_description = sprintf( __( 'Connect your Tiktok account by clicking this <a class="%1$s" href="%2$s" target="_blank">link</a> and refer to next page URL.', 'jnews-tiktok' ), 'jnews_tiktok_access_token tiktok', get_admin_url() . 'widgets.php' );

	$options[] = array(
		'id'          => 'jnews_tiktok_token_alert',
		'type'        => 'jnews-alert',
		'default'     => 'info',
		'section'     => 'jnews_tiktok_feed_section',
		'label'       => $tiktok_label,
		'description' => $tiktok_description,
	);
	
	$options[] = array(
		'id'          => 'jnews_footer_tiktok_alert',
		'type'        => 'jnews-alert',
		'default'     => 'info',
		'section'     => 'jnews_tiktok_feed_section',
		'label'       => esc_html__( 'Footer Tiktok Compatibility', 'jnews-tiktok' ),
		'description' => wp_kses( __( 'Footer Tiktok only compatible with <strong>Footer Type 5</strong> and <strong>Footer Type 6</strong>.', 'jnews-tiktok' ), wp_kses_allowed_html() ),
	);
	
}

return $options;
